	NAME	CCTABS
	INCLUDE	PAGESIZE.INC
	TITLE	.CCTABS -Character Control character tables 
DATA 	SEGMENT	PUBLIC BYTE

	PUBLIC	EBCDIC,ATDSC,PRABLE

; First byte of table (Null) controls character used to 'SHOW COLUMNS'

; Revised 19 December 82 wcl3 - Improved status line translations
;                               &entirely replaced ATDSC table
;          7 June     83 wcl3 - Added APL character table
;	  26 July     83 wcl3 - Revised APL table to include TEXT stuff

EBCDIC	DB	02EH,020H,020H,020H,020H,020H,020H,020H	; 00 - 07
	DB	03EH,03CH,05BH,05DH,029H,028H,07DH,07BH	; 08 - 0F

	DB	020H,03DH,027H,022H,02FH,05CH,0B3H,07CH	; 10 - 17
	DB	03FH,021H,024H,09BH,09CH,09DH,09EH,00FH	; 18 - 1F

	DB	030H,031H,032H,033H,034H,035H,036H,037H	; 20 - 27
	DB	038H,039H,0E1H,015H,023H,040H,025H,05FH	; 28 - 2F

	DB	026H,02DH,02EH,02CH,03AH,02BH,0AAH,0C4H	; 30 - 37
	DB	0F8H,020H,05EH,07EH,022H,060H,027H,087H	; 38 - 3F

	DB	085H,08AH,08DH,095H,097H,061H,06FH,098H ; 40 - 47
	DB	085H,08AH,082H,08DH,095H,097H,081H,087H	; 48 - 4F

	DB	084H,089H,08BH,094H,081H,083H,088H,08CH	; 50 - 57
	DB	093H,096H,0A0H,082H,0A1H,0A2H,0A3H,0A4H	; 58 - 5F

	DB	041H,045H,049H,04FH,055H,041H,04FH,059H	; 60 - 67
	DB	04AH,045H,045H,049H,04FH,055H,059H,053H	; 68 - 6F

	DB	08EH,045H,049H,099H,09AH,041H,045H,049H	; 70 - 77
	DB	04FH,055H,041H,090H,049H,04FH,055H,0A5H	; 78 - 7F

	DB	061H,062H,063H,064H,065H,066H,067H,068H	; 80 - 87
	DB	069H,06AH,06BH,06CH,06DH,06EH,06FH,070H	; 88 - 8F

	DB	071H,072H,073H,074H,075H,076H,077H,078H	; 90 - 97
	DB	079H,07AH,091H,0EDH,086H,087H,03BH,02AH	; 98 - 9F

	DB	041H,042H,043H,044H,045H,046H,047H,048H	; A0 - A7
	DB	049H,04AH,04BH,04CH,04DH,04EH,04FH,050H	; A8 - AF

	DB	051H,052H,053H,054H,055H,056H,057H,058H	; B0 - B7
	DB	059H,05AH,091H,0EDH,08FH,080H,03BH,02AH	; B8 - BF

	DB	16 DUP(020H)				; Blank up attributes

	DB	050H,053H,061H,07FH,062H,036H,03EH,009H ; D0 - D7
	DB	01AH,00AH,018H,001H,042H,009H,03FH,0DBH	; D8 - DF

	DB	16 DUP(020H)				; 

	DB	0C5H,0C4H,07AH,05FH,028H,029H,058H,007H	; F0 - F7
	DB	01BH,008H,04BH,079H,034H,041H,04DH,002H	; F8 - FF

;	CHARST 1 (apl) Character translation table
;
;       Character numbers refer to offsets within standard STSC inc. 
;       APL*PLUS character set (P)ROM.
;
;	Quoted characters represent 'Poor Fit' approximations of text mode
;	characters not availible in the APL character set implementation.
;	Characters denoted "-" are unimplemented as defined in the IBM
;	3274/76 coax protocol manual.

	DB	16 DUP(020H)				; Three rows of blank
	DB	16 DUP(020H)				;
	DB	16 DUP(020H)				;

	DB	"-",45,"-","-",179,221,222,223,220,219,"-","-",0,0,0,0
	DB	0,24,243,141,143,26,149,14,11,249,6,253,239,252,230,91
	DB	242,248,224,238,226,251,23,146,92,246,236,145,231,93,134,179
	DB	125,97,98,99,100,101,102,103,104,105,"1",0,"-","(","+",197
	DB	123,106,107,108,109,110,111,112,113,114,"2","-",0,")","-",219
	DB	241,248,115,116,117,118,119,120,121,122,"3",192,218,195,180,"-"
	DB	"0","1","2","3","4","5","6","7","8","9","n",217,191,194,158,"-"
	DB	0,"-",25,5,233,152,19,15,244,245,234,229,94,250,232,237
	DB	0,0,21,33,0,0,31,30,193,196,151,166,0,126,235,167

	DB	16 DUP(020H)				; Null out attributes
	DB	"P","S", 14 DUP(020H)			; Some status specials
	DB	16 DUP(020H)			
	DB	"A","a",".",">","0", 11 DUP(020H)

;	ATDSC - Attribute display codes for displayed attributes
;	        contains EBCDIC codes for attributes 0C0H-0FFH
;               Attribute codes are translated to 'ASCII' format
;               upper & lower case characters

	PUBLIC	ATDSC
ATDSC	LABEL	BYTE

	DB	02DH,0A0H,0A1H,0A2H,0A3H,0A4H,0A5H,0A6H,0A7H,0A8H,0A9H
	DB	0AAH,0ABH,0ACH,0ADH,0AEH,0AFH,0B0H,0B1H,0B2H,0B3H,0B4H
	DB	0B5H,0B6H,0B7H,0B8H,0B9H,00AH,015H,00BH,03AH,02FH
	DB	03DH,080H,081H,082H,083H,084H,085H,086H,087H,088H,089H
	DB	08AH,08BH,08CH,08DH,08EH,08FH,090H,091H,092H,093H,094H
	DB	095H,096H,097H,098H,099H,00FH,017H,00EH,03BH,009H
	PAGE
; This table is used to convert IBM PC display codes to entirely ASCII
; printable characters.  APL, status line, and foreign symbols are
; converted to something (not neccessarily distinct or useful...).

PRABLE	DB	' fFhdcs..oOMFQES'	; Convert non-printables to print
	DB	'<>^!PS-^^v><L-^v'	;
	DB	' !"#$%&',"'",'()*+,-./';
	DB	'0123456789:;<=>?'	;
	DB	'@ABCDEFGHIJKLMNO'	;
	DB	'PQRSTUVWXYZ[\]^_'	;
	DB	'`abcdefghijklmno'	;
	DB	'pqrstuvwxyz{|}~_'	;

	DB	'CueaaaaceeeiiiAA'	; Out of normal ASCII bounds
	DB	'EAFooouuyOUcLYPf'	;
	DB	'AIOUNnAO?--24!<>'	;
	DB	'.:".............'	; Give up on line drawing...
	DB	'................'	;
	DB	'................'	;
	DB	'IBYPEouTooOsiOEi'	;
	DB	'=+><{}/=...rN2. '	;

DATA	ENDS

	END
