   	NAME	E78
	INCLUDE	PAGESIZE.INC
	INCLUDE	SKFLAG.INC
	TITLE	.E78 - 3278 emulator startup module
CODE	SEGMENT	PUBLIC
	ASSUME	CS:CODE,DS:DATA
	EXTRN	INIT:NEAR,	KXFER:NEAR,	UPDLIN:NEAR,	GSSTAT:NEAR
	EXTRN	CPOS:NEAR,	CTYPE:NEAR,	UPDATE:NEAR,	EXKCHK:NEAR
	EXTRN	EXIT:NEAR,	TEST:NEAR,	WAITK:NEAR,	ALARM:NEAR
	EXTRN	RBUF:BYTE,	SCRNFX:NEAR,	LPEN:NEAR,      BANDEL:NEAR
	EXTRN	ENADIS:BYTE

	IF	SKFLAG
	EXTRN	KYBDSET:NEAR,	KYBDGET:NEAR,
	ENDIF

DATA	SEGMENT	PUBLIC		; Force DATA to load behind CODE
	INCLUDE	PUBLICS.EQU	
	EXTRN	BGLIN:BYTE,	SLVERR:BYTE,	OSTACK:WORD,	CURSOR:WORD
	EXTRN	INITMOD:BYTE,	BKBSVR:DWORD
	IF	SKFLAG
	EXTRN	KYBDDSL:WORD,	RESQIK:BYTE
	ENDIF
DATA	ENDS

CSTACK	SEGMENT	STACK 'DGROUP'	; General data stack
	DW	256 DUP(0)	; A lot of space
	PUBLIC	INSP		;
INSP	LABEL	WORD		; Initial stack pointer value
CSTACK	ENDS

MEMTOP	SEGMENT	PUBLIC 'DGROUP'	; Empty segment at top of memory
MEMTOP	ENDS

E78	PROC	FAR
	JMP	E78BEG

	PUBLIC	CUSTSW		; GENX changes this from '$' to '\bel' to
				; make customized message appear
	PUBLIC  CPRT
	PUBLIC  CPRT2
CPRT	DB	13,10
	DB	"IRMA PROM resident microcode is a copyrighted property of"
	DB	13,10
	DB	"Digital Communications Associates, Inc. and contains "
	DB	13,10,"proprietary and confidential information. "
	DB	13,10,"Copyright 1982, 1983, 1984, 1985, 1986 all rights reserved."
	DB	13,10
; Additional banner patch area.
CPRT2   DB      "                                                        ",13,10
	DB	"IRMA and Decision Support Interface are trademarks of"
	DB	13,10
	DB	"Digital Communications Associates, Inc. Atlanta, Georgia."
	DB	13,10,13,10
	IF	SKFLAG
	DB	"SK78 Terminal Emulator Revision 1.49 November 19, 1986"
	ELSE
	DB	"E78 Terminal Emulator Revision 1.49 - November 19, 1986"
	ENDIF
	DB	13,10

; The following area is assumed to be 60 characters in length by E78.GEN
; It is used to log customization date & time.  The message should not
; contain the '$' character.

CUSTSW	DB	"$*** USER CUSTOMIZED VERSION ***                            "
;                123456789.123456789.123456789.123456789.123456789.123456789.
	DB	13,10
	DB	"$"

E78BEG:	PUSH	DS		; Make a DOS return word
	XOR	AX,AX		;
	PUSH	AX		;

	PUSH	DS		; Save the pointer to header
	PUSH	ES		; 

	MOV	AX,DS		; Save more of the header pointers
	MOV	ES,AX		;

	CALL	COPYRT		; Display our copyright for all the world

	CALL	E78I		; To the terminals!

	POP	ES		; Restore the header again

	MOV	AX,DATA		; Set up segment for outbound tests
	MOV	DS,AX		;

	CMP	SLVERR,SE$RR	; Are we becoming resident?
	JNZ	E78XT		; No, regular exit

	MOV	SLVERR,0	; Don't do it again.

	MOV	BX,MEMTOP	; Compute code, stack & data space
	SUB	BX,CODE		; As a relative, not absolute
	ADD	BX,10H		; Paragraphs in program header
	MOV	CL,4		; As a number of paragraphs
	SHL	BX,CL		;

	MOV	AL,RBUF		; Add resident buffers to memory size
	XOR	AH,AH
	MOV	DX,4096		; Assume 4K byte screen save buffers
	CMP	INITMOD,2	; But check for IRMAvision MOD 3, 4, or 5
	JLE	E787		; Jump, we only needed 4K buffers
	MOV	DX,8192		; MOD 3, 4, or 5 active, use 8K buffers
E787:	MUL	DX		; Calculate needed memory
	JO	OVFL
	JC	OVFL		; Error if buffers need more than 64K
	MOV	DX,AX		; Get memory size of buffers in DX
	ADD	DX,BX		; Add to code and data size
	JZ	OVFL		; Error if this is over 64K
	JNC	E78BR		; No overflow is hunky dory

OVFL:	CLI				; No Interrupts here
	MOV	AX,WORD PTR BKBSVR[0]	; Previous I/O driver vector
	MOV	BX,WORD PTR BKBSVR[2]	;
	MOV	WORD PTR ES:[(22*4)+0],AX
	MOV	WORD PTR ES:[(22*4)+2],BX
	STI				; Interrupts ok again

	CALL	REMERR		; Resident memory error
	JMP	E78XT		; And do a normal exit

E78BR:	POP	DS		; Restore program header segment

	MOV	ES:BYTE PTR [1],27H ; Change exit vector to resident vector

	RET			; Return through program header

E78XT:	POP	DS		; Remove un-needed register
	RET

E78	ENDP
	PAGE
	PUBLIC	E78I
E78I	PROC	NEAR
	PUSHF			; No screen reversals for this guy
	STI			; Allow interrupts again
	PUSH	AX		;
	PUSH	BX		;
	PUSH	CX		;
	PUSH	DX		;
	PUSH	SI		;
	PUSH	DI		;
	PUSH	BP		; 
	PUSH	ES		;
	PUSH	DS		;

	CLD			; All strings forward!

	CALL	INIT		; Setup terminal type and control tables
	JNC	E78I1		; Jump if no error during init
	CALL	WAITK		; Wait for entry condition to be released
	JMP	SHORT E78I9	; Exit, Initialization error ocurred
	int	3
E78I1:	CALL	TEST		; Test IRMA slave
	CMP	SLVERR,0	; Is all well?
	JNZ	ERROR		; No, abandon ship

	CALL	WAITK		; Wait for entry condition to be released

	IF	SKFLAG

	CALL	KEYSWAP		; Swap keyboard profiles

	ENDIF

E78I0:	CALL	GSSTAT		; Update the current status
	CALL	KXFER		; Take care of any keyboard business
	CALL	LPEN		; Pick a peck of pens
	CALL	UPDATE		; Update DISPLAY
	CALL	CPOS		; Position the cursor
	CALL	CTYPE		; And set the cursor type
	CALL	SCRNFX		; Force screen active area to be visible
	CALL	ALARM		; Do whatever it is that alarms do

ERROR:	CALL	EXKCHK		; Check for exit reason
	JNC	E78I0		; No exit yet, do it some more.

EGZIT	LABEL	NEAR

	IF	SKFLAG

	CMP	RESQIK,1	; Don't flip profile back if RESQIK is set
	JE	SKSWP

	CALL	KEYSWAP		; flip keyboard profile back

SKSWP	LABEL	NEAR
	ENDIF

	CALL	EXIT		; Clean up screen etc.

E78I9:	POP	DS		;
	POP	ES		;
	POP	BP		;
	POP	DI		;
	POP	SI		;
	POP	DX		;
	POP	CX		;
	POP	BX		;
	POP	AX		;
	POPF			;
	RET			; Exit 

E78I	ENDP
	PAGE

	IF	SKFLAG

;   KEYSWAP switches KYBDDRV.SYS profiles if this option is enabled
;      This routine assumes that KYBDINIT has been called from INIT

KEYSWAP	PROC	NEAR		; Switch key profiles if allowed
	MOV	AX,KYBDDSL	;
	CMP	AX,-1		;
	JZ	KEYSWX		; No swap allowed or requested

	PUSH	KYBDDSL		; Save new request

	CALL	KYBDGET		; Get current profile
	MOV	KYBDDSL,AX	;

	CALL	KYBDSET		; Set to number on top of stack
	POP	AX		; Drop KYBDDSL off stack

KEYSWX:	RET			; End of switcher

KEYSWAP	ENDP
	PAGE

	ENDIF

COPYRT	PROC	NEAR
	MOV	SI,OFFSET CPRT

CPLP:	MOV	AH,15		; Get current video & page info
	INT	10H		; BIOS video call

	MOV	AL,CS:[SI]	; Get one character
	CMP	AL,'$'		; This may be the end...
	JZ	CPX		; 

	PUSH	SI		;
	MOV	AH,14		; Print char on console
	INT	10H		; DOS system call
	POP	SI		;

	INC	SI		; Next byte please...
	JMP	CPLP		; Again.

CPX:	CALL	BANDEL		; Delay for banner.  Same # for PC or AT.
	RET

REMERR	LABEL	NEAR		; Resident memory error message
	MOV	SI,OFFSET RESM	;
	JMP	CPLP		; Use the copyright message code
COPYRT	ENDP
	PAGE

RESM	DB	"Too many screen MEMORYs in use to make E78 resident."
	DB	13,10
	DB	13,10
	DB	"***** E78 IS NOT RESIDENT -- Use fewer MEMORYs *****"
	DB	13,10
	DB	"$"

CODE	ENDS

	END	E78
