	NAME	KYBDDATA
	INCLUDE	PAGESIZE.INC
	INCLUDE	SKFLAG.INC
	TITLE	.KYBDDATA - KEYBOARD DATA TABLES FOR BIOS routine replacement
	INCLUDE PUBLICS.EQU

CODE	SEGMENT	PUBLIC	BYTE
	ASSUME CS:CODE

	IFE	SKFLAG


	EXTRN	CSHIFT:NEAR, CNUSHF:NEAR, CCTRL:NEAR, CALT:NEAR, CCAPS:NEAR
	EXTRN	CNUM:NEAR, CSCRL:NEAR, CINS:NEAR
	EXTRN	SUPERK:NEAR, SBRK:NEAR, SHOLD:NEAR, SREST:NEAR, SPRNT:NEAR

	ENDIF

CODE	ENDS

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA

	IFE SKFLAG

	PUBLIC	KEYNORM, KEYSHFT, KEYALT,  KEYCTRL, KEYLOCK, KEYTAB
	PUBLIC	EKYNORM, EKYSHFT, EKYALT,  EKYCTRL, EKEYTAB
	PUBLIC	KYPRECD, KYASHF,  KYC,     KYS
	PUBLIC	KYCSHFA, KYCSHFB, KYCCTLA, KYCCTLB, KYCJTAB, SUPKEY
	PUBLIC	KYCALTA, KYCALTB, KYCCAPA, KYCCAPB, KYSJTAB
	PUBLIC	KYCNUMA, KYCNUMB, KYCSCLA, KYCSCLB, TRESPAS
	PUBLIC	KYSSUPR, KYSBRK,  KYSHOLD, KYSREST, KEYPASS, KEYBUF
	PUBLIC	  EKYC,    E1TAB,   KB_TEST_SW	

	ENDIF

	PUBLIC	OKBSRV,	OI24V, OKBVEC, KFLG, SSFLG, KB_LED_STAT, KB_MISC_STAT

	EXTRN	LSADDR:WORD,	RESFLG:BYTE
	EXTRN	ATFLAG:BYTE,	ALTMOD2:BYTE,	ERICKEY:BYTE

;******************************************************************************
;*			  R E V I S I O N    H I S T O R Y				   *
;******************************************************************************
;*									      *
;*	1.32	Added a jump which checked to see if an exit for the PC/AT    *
;*		needed to be performed.  The instigation of this was the	  *
;*		fact that the print screen function no longer worked.	  *
;*									      *
;*	1.41	3-1-85	Ericsson PC added. kbd				      *
;*		3-28-85  Olivetti Deluxe keyb.				  *
;*									      *
;*	1.43	SKDRIVER interface added to allow for IRMAKEY		      *
;*		(All changes marked [sk] )				      *
;*									      *
;*	1.44	Added disk write recovery handler INT 24 replacement.	      *
;*									      *
;*	1.48	Added support for the new Enhanced Keyboard		      *
;*									      *
;******************************************************************************

; System defined equates

KBDATA		EQU	60H		; Keyboard data port
KBCTL		EQU	61H		; Keyboard/speaker control port
KBD_STATUS	EQU	64H
ICTL		EQU	20H		; Interrupt control port

BIOSSEG	EQU	40H			; BIOS local data segment

BIOSRFG  EQU	72H			; BIOS RESET flag bytes (2)
BIOSBRK  EQU	71H			; BIOS BREAK flag byte
BIOSKFLG EQU	17H			; BIOS shift state flags
BIOSSFLG EQU	18H			; BIOS internal key flags

; Local variables

OKBVEC	DD	0			; Original keyboard vector
OKBSRV	DD	0			; Keyboard I/O call vector
OI24V	DD	0			; Orig. Int 24h vector

SUPKEY	DB	0			; Set to indicate SUPERKEY pressed! 

; KFLG contains bits used to compute current shift status and keyboard state.
;   The lower nybble in this byte is assumed to correspond to the nybbles
;   in the KEYLOCK table (KYL record).	This byte is also assumed to match
;   the format of the BIOS byte KB_FLG.

KFLG	DB	 0 			; Current shift key states

 KFLGNU	EQU	 1H			; Numbers shift key
 KFLGSH	EQU	 2H			; Shift key pressed
 KFLGCT	EQU	 4H			; Control key
 KFLGAL	EQU	 8H			; Alternate key pressed

 KFLGSC	EQU	10H			; Scroll lock key activated
 KFLGNL	EQU	20H			; Numeric lock key activated
 KFLGCL	EQU	40H			; Caps lock key activated
 KFLGIN	EQU	80H			; Insert state

; SSFLG contains bits used to manage Shift States such as CAPS LOCK and INS.
;   This byte is assumed to match BIOS byte KB_FLAG_1.

SSFLG	DB	 0 			; Shift status flags

 SFLGHH	EQU	 8H			; Hold state
 SFLGSC	EQU	KFLGSC			; Scroll lock down
 SFLGNL	EQU	KFLGNL			; Numeric lock down
 SFLGCL	EQU	KFLGCL			; Caps lock down
 SFLGIN	EQU	KFLGIN			; Insert key down

; KB_LED_STAT contains bits used to the keyboard LEDs also there is other
;   support information for the AT BIOS keyboard support.

KB_LED_STAT	DB	0		; LED status byte

 LED_BITS	EQU	07H		; All three LEDs turned on
;			01H		; Scroll Lock LED
;			02H		; Num Lock LED
;			04H		; Caps Lock LED
 KB_ACK_REC	EQU	10H		; Keyboard Acknowledge Received Flag
 KB_RESEND	EQU	20H		; Resend Received Flag
 UPDATE_IN_PROG	EQU	40H	    ; LEDs Update in Progress
 KBD_ERROR_FLAG	EQU	80H		; Keyboard Transmit Error Occured Flag

; KB_MISC_STAT contains bits used by the Enhanced keyboard in a PC/XT or PC/AT
;   as well as status flags used by the new keyboard protocol.

KB_MISC_STAT	DB	0		; Enhanced Keyboard Misc Byte

 LAST_WAS_E0	EQU	01H		; The Last Key Scan Code was an E0
 LAST_WAS_E1	EQU	02H		; The Last Key Scan Code was an E1
 R_CTRL_MADE	EQU	04H		; Right Ctrl Shift Make Code Received
 R_ALT_MADE	EQU	08H		; Right Alt Shift Make Code Received
 ALT_GRAPH	EQU	08H		; Alt (Graphics) Key Make Received
 KYBD_EXTD	EQU	10H		; Enhanced Keyboard Installed
 NUM_LOCK_ON	EQU	20H		; Set the Num Lock if Extd KBD & READID
 FIRST_ID_BYTE	EQU	40H		; First Byte of a Read ID was Received
 READ_ID_ACTIVE	EQU	80H		; Read ID is in Progress

; KB_TEST_SW contains bits used to make decisions in the code with the new
;    enhanced keyboard.  

KB_TEST_SW	DB	0		; Byte to make code decisions from bits

 XTD_SHF_SW	EQU	01H		; Check for the E0 AA sequence to eat 
					;	  the AA and the next 2A which will
					;	  follow.


RESEND_REQ	EQU	0FEH
ACK_KBD		EQU	0FAH
DISABLE_KBD	EQU	0ADH
ENABLE_KBD	EQU	0AEH
KBD_ENABLE_CMD	EQU	0F4H
SET_RESET_CMD	EQU	0EDH
KFLG_LED_BITS	EQU	70H
KBD_BUF_FULL	EQU	02H

END_OF_INTERRUPT	EQU	20H
RETRY_COUNT		EQU	03H

	IFE SKFLAG

; KEYBUF contains keystrokes not yet accepted by application program

KEYBSZ	EQU	16*2			; Size of ring in keystrokes (16)
KEYBUF	DW	0			; Input pointer - Keyboard buffer
	DW	0			; Output pointer
	DW	KEYBSZ			; Ring size info
	DB	KEYBSZ DUP(0)		; Data area

; Shift/Ctrl/Alt key combination precedence table
; 
; The following assignment statements must match the order of keyboard
; tables following the KEYTAB label.  All entrys in the KEYTAB table
; must consist of exactly 128 two byte entrys.	All 16 shift states
; may be accomodated by enlarging KEYTAB table.
;
; This table is indexed by the lower four bits from KFLG which indicate 
; current shift status as noted below:
;
;   ALPHA SHIFT:  1  LSB   (KFLGSH)
;   NUM   SHIFT:  2	   (KFLGNU)
;   CTRL  SHIFT:  4	   (KFLGCT)
;   ALT   SHFIT:  8  MSB   (KFLGAL)

PRNORM=	0				; Normal keyboard entry
PRSHFT=	1				; Shifted entry
PRALT=	2				; Alternate
PRCTRL=	3				; Control

KYPRECD	LABEL	BYTE			; Shift key precedence table
	DB	PRNORM			; 0000
	DB	PRSHFT			; 0001 SHIFT
	DB	PRSHFT			; 0010	  NUM
	DB	PRSHFT			; 0011 SHIFT NUM
	DB	PRCTRL			; 0100	      CTRL
	DB	PRCTRL			; 0101 SHIFT     CTRL
	DB	PRCTRL			; 0110	  NUM CTRL
	DB	PRCTRL			; 0111 SHIFT NUM CTRL
	DB	PRALT			; 1000		  ALT
	DB	PRALT			; 1001 SHIFT	  ALT
	DB	PRALT			; 1010	 NUM	  ALT
	DB	PRALT			; 1011 SHIFT NUM	  ALT
	DB	PRALT			; 1100	     CTRL ALT
	DB	PRALT			; 1101 SHIFT     CTRL ALT
	DB	PRALT			; 1110	 NUM CTRL ALT
	DB	PRALT			; 1111 SHIFT NUM CTRL ALT

; Shift/Ctrl/Alt key selection table

SHIFTKEYS=	 8			; Number of shift key entrys in table

KYC	LABEL	BYTE			; General table entry

KYCSHFA	DB	42			; Alpha shift keys
KYCSHFB	DB	 0			;

KYCNSHA	DB	54			; Numbers shift (Right shift key)
KYCNSHB	DB	 0			; (Default tables treat this as
					;	  normal Alpha shift...)

KYCCTLA	DB	29			; Control key
KYCCTLB	DB	 0			; No secondary control key...

KYCALTA	DB	56			; ALT key
KYCALTB	DB	 0			;

KYCCAPA	DB	58			; Caps Lock
KYCCAPB	DB	 0			;

KYCNUMA	DB	69			; Num Lock
KYCNUMB	DB	 0			;

KYCSCLA	DB	70			; Scroll Lock
KYCSCLB	DB	 0			;

KYCINSA	DB	82			; Insert mode
KYCINSB	DB	 0			;

; Extended Shift/Ctrl/Alt key selection table included to make GENX easy

ESHFTKEYS=	 8			; Number of shift key entrys in table

EKYC	LABEL	BYTE			; General table entry

	DB	42			; Alpha shift keys
	DB	 0			;

	DB	54			; Numbers shift (Right shift key)
	DB	 0			; (Default tables treat this as
					;	  normal Alpha shift...)

	DB	29			; Control key
	DB	 0			; No secondary control key...

	DB	56			; ALT key
	DB	 0			;

	DB	58			; Caps Lock
	DB	 0			;

	DB	69			; Num Lock
	DB	 0			;

	DB	70			; Scroll Lock
	DB	 0			;

	DB	82			; Insert mode
	DB	 0			;

KYCJTAB	LABEL	WORD			; Vector table for shift processes
	DW	OFFSET CODE:CSHIFT	; Alpha shift 
	DW	OFFSET CODE:CNUSHF	; Numeric shift
	DW	OFFSET CODE:CCTRL	; Control shift
	DW	OFFSET CODE:CALT	; Alternate shift
	DW	OFFSET CODE:CCAPS	; Caps lock
	DW	OFFSET CODE:CNUM	; Numeric lock
	DW	OFFSET CODE:CSCRL	; Scroll lock
	DW	OFFSET CODE:CINS	; Insert mode

; KYASHF provides a mechanism of aliasing the ALPHA shift key.	This
;   allows compatibility with existing PC applications if the shift
;   key is aliased to the NUMBERS SHIFT key.  If a new (separate)
;   NUMBERS SHIFT key is defined KYASHF should be set to ZERO to indicate
;   no alias availible

KYASHF	DB	KFLGNU			; Aliases of SHIFT key

; BREAK/HOLD/RESET/PRINT - Special key code templates 

SCT	RECORD	SCAT:8=0,SCKEY:8=0

SPECKEYS=	5			; Count of special key templates

KYS	LABEL	WORD			; General table entry
KYSSUPR	SCT	<KFLGAL,1>		; ALT-ESC superkey
KYSBRK	SCT	<KFLGCT,70>		; CTRL-BREAK
KYSHOLD	SCT	<KFLGCT,69>		; CTRL-NUM LOCK
KYSREST	SCT	<KFLGCT+KFLGAL,83>	; CTRL-ALT-DEL
KYSPRNT	SCT	<KFLGSH,55>		; SHFT-PRTSC

KYSJTAB	LABEL	WORD			; Vector table for special key code
	DW	OFFSET CODE:SUPERK	; Super-keyboard passthrough
	DW	OFFSET CODE:SBRK	; Break
	DW	OFFSET CODE:SHOLD	; Hold <machine lock>
	DW	OFFSET CODE:SREST	; Reset
	DW	OFFSET CODE:SPRNT	; Print screen

; KEYLOCK table defines the shift key action when the NUM LOCK and CAPS LOCK
;   keys are activated.  When a lock is active the appropriate nybble is
;   XOR'ed with the shift key status before the key code is looked up in
;   KEYTAB.  The upper nybble contains the CAPS LOCK information, the lower
;   nybble the NUM LOCK information.  If both CAPS & NUM locks are active 
;   the upper and lower nybbles are OR'ed together before being merged with
;   shift status from KFLG.

PAGE
KEYLOCK	LABEL	BYTE			; Lock control bytes

KYL	RECORD	CPL:4=0,ALT:4=0		; Numeric & alpha locks
;	LOCK:  NUM,ALPHA
	KYL	<0,0>			;	0   No such key
	KYL	<0,0>			;	1   ESC
	KYL	<0,0>			;	2 1
	KYL	<0,0>			;	2 2
	KYL	<0,0>			;	4 3
	KYL	<0,0>			;	5 4 
	KYL	<0,0>   		;  6 5 
	KYL	<0,0>			;	7 6 
  	KYL	<0,0>			;  8 7 
	KYL	<0,0>			;	9 8 
	KYL	<0,0>			; 10 9 
	KYL	<0,0>			; 11 0 
	KYL	<0,0>			; 12 - 
	KYL	<0,0>			; 13 = 
	KYL	<0,0>			; 14   Backspace
	KYL	<0,0>			; 15   Horizontal tab
	KYL	<0,KFLGSH>		; 16 Q
	KYL	<0,KFLGSH>		; 17 W
	KYL	<0,KFLGSH>		; 18 E
	KYL	<0,KFLGSH>		; 19 R
	KYL	<0,KFLGSH>		; 20 T
	KYL	<0,KFLGSH>		; 21 Y
	KYL	<0,KFLGSH>		; 22 U
	KYL	<0,KFLGSH>		; 23 I
	KYL	<0,KFLGSH>		; 24 O
	KYL	<0,KFLGSH>		; 25 P
	KYL	<0,0>			; 26 [
	KYL	<0,0>			; 27 ]
	KYL	<0,0>			; 28   Carriage return
	KYL	<0,0>			; **   Control key
	KYL	<0,KFLGSH>		; 30 A
	KYL	<0,KFLGSH>		; 31 S
	KYL	<0,KFLGSH>		; 32 D
	KYL	<0,KFLGSH>		; 33 F
	KYL	<0,KFLGSH>		; 34 G
	KYL	<0,KFLGSH>		; 35 H
	KYL	<0,KFLGSH>		; 36 J
	KYL	<0,KFLGSH>		; 37 K
	KYL	<0,KFLGSH>		; 38 L
	KYL	<0,0>			; 39 ;
	KYL	<0,0>			; 40 '
	KYL	<0,0>			; 41 `
	KYL	<0,0>			; **   Left shift
	KYL	<0,0>			; 43 \
	KYL	<0,KFLGSH>		; 44 Z
	KYL	<0,KFLGSH>		; 45 X
	KYL	<0,KFLGSH>		; 46 C
	KYL	<0,KFLGSH>		; 47 V
	KYL	<0,KFLGSH>		; 48 B
	KYL	<0,KFLGSH>		; 49 N
	KYL	<0,KFLGSH>		; 50 M
	KYL	<0,0>			; 51 ,
	KYL	<0,0>			; 52 . 
	KYL	<0,0>			; 53 /
	KYL	<0,0>			; **   Right shift
	KYL	<0,0>			; 55 * (on PrtSc key)
	KYL	<0,0>			; **   ALT
	KYL	<0,0>			; 57   Space
	KYL	<0,0>			; 58   CAPS LOCK
	KYL	<0,0>			; 59   F1
	KYL	<0,0>			; 60   F2
	KYL	<0,0>			; 61   F3
	KYL	<0,0>			; 62   F4
	KYL	<0,0>			; 63   F5
	KYL	<0,0>			; 64   F6
	KYL	<0,0>			; 65   F7
	KYL	<0,0>			; 66   F8
	KYL	<0,0>			; 67   F9
	KYL	<0,0>			; 68   F10
	KYL	<0,0>			; **   NUM LOCK
	KYL	<0,0>			; **   SCROLL LOCK
	KYL	<KFLGSH,0>		; 71 7 (on numeric pad)
	KYL	<KFLGSH,0>		; 72 8
	KYL	<KFLGSH,0>		; 73 9
	KYL	<0,0>			; 74 -
	KYL	<KFLGSH,0>		; 75 4
	KYL	<KFLGSH,0>		; 76 5
	KYL	<KFLGSH,0>		; 77 6
	KYL	<0,0>			; 78 +
	KYL	<KFLGSH,0>		; 79 1
	KYL	<KFLGSH,0>		; 80 2
	KYL	<KFLGSH,0>		; 81 3
	KYL	<KFLGSH,0>		; 82 0
	KYL	<KFLGSH,0>		; 83 .

	DB	44 DUP(0)		;      Fill remainder of table

KEYPASS	DB	"Passing keys through to  STANDARD  keyboard handler. ",0
TRESPAS	DB	"Key pass-through not allowed from resident emulator. ",0
	PAGE
;
; KEYTAB contains one entry per each of 128 possible key scan codes for
;   each of 4 shift states currently allowed.  Each section of KEYTAB must
;   contain exactly 128 words (256 bytes) to preserve alignment throughout
;   the table.	An entry of zero is assumed to be a 'DEAD' key and enters
;   no code into the keyboard input buffer.  Non-zero key codes are entered
;   directly into the key ring with out interpretation.

KEYTAB	LABEL	WORD			; Main keyboard table entry (local)
KEYNORM	LABEL	BYTE			; Normal (unshifted) keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	 27			;  1 ESC
	DW	"1"			;  2 1
	DW	"2"			;  3 2
	DW	"3"			;  4 3
	DW	"4"			;  5 4
	DW	"5"			;  6 5
	DW	"6"			;  7 6
	DW	"7"			;  8 7
	DW	"8"			;  9 8
	DW	"9"			; 10 9
	DW	"0"			; 11 0
	DW	"-"			; 12 -
	DW	"="			; 13 =
	DW	  8			; 14 Backspace
	DW	  9			; 15 Horizontal tab
	DW	"q"			; 16 q
	DW	"w"			; 17 w
	DW	"e"			; 18 e
	DW	"r"			; 19 r
	DW	"t"			; 20 t
	DW	"y"			; 21 y
	DW	"u"			; 22 u
	DW	"i"			; 23 i
	DW	"o"			; 24 o
	DW	"p"			; 25 p
	DW	"["			; 26 [
	DW	"]"			; 27 ]
	DW	 13			; 28 Carriage return
	DW	  0			; ** Control key
	DW	"a"			; 30 a
	DW	"s"			; 31 s
	DW	"d"			; 32 d
	DW	"f"			; 33 f
	DW	"g"			; 34 g
	DW	"h"			; 35 h
	DW	"j"			; 36 j
	DW	"k"			; 37 k
	DW	"l"			; 38 l
	DW	";"			; 39 ;
	DW	"'"			; 40 ' Single quote
	DW	"`"			; 41 ` Accent
	DW	  0			; ** Left shift
	DW	"\"			; 43 \
	DW	"z"			; 44 z
	DW	"x"			; 45 x
	DW	"c"			; 46 c
	DW	"v"			; 47 v
	DW	"b"			; 48 b
	DW	"n"			; 49 n
	DW	"m"			; 50 m
	DW	","			; 51 , Comma
	DW	"."			; 52 . Period
	DW	"/"			; 53 /
	DW	  0			; ** Right shift
	DW	"*"			; 55 * (on PrtSc key)
	DW	  0			; ** Alt 
	DW	" "			; 57 Space
	DW	  0			; ** Caps lock
	DW	59*256			; 59 F1
	DW	60*256			; 60 F2
	DW	61*256			; 61 F3
	DW	62*256			; 62 F4
	DW	63*256			; 63 F5
	DW	64*256			; 64 F6
	DW	65*256			; 65 F7
	DW	66*256			; 66 F8
	DW	67*256			; 67 F9
	DW	68*256			; 68 F10
	DW	  0			; 69 ** Num lock
	DW	  0			; 70 ** Scroll lock
	DW	71*256			; 71 HOME
	DW	72*256			; 72 UP ARROW
	DW	73*256			; 73 PAGE UP
	DW	"-"			; 74 - (on numeric pad)
	DW	75*256			; 75 LEFT ARROW
	DW	  0			; 76 Dead key!
	DW	77*256			; 77 RIGHT ARROW
	DW	"+"			; 78 + (on numeric pad)
	DW	79*256			; 79 END
	DW	80*256			; 80 DOWN ARROW
	DW	81*256			; 81 PAGE DOWN
	DW	82*256			; 82 INSERT
	DW	83*256			; 83 DELETE
	DW	   0			 ; 84 
	DW	   0			 ; 85
	DW	   0			 ; 86 
	DW	   0			 ; 87 New F11 Key
	DW	   0			 ; 88 New F12 Key
 	DW	39 DUP(0)		;      Fill remainder of table
	PAGE

KEYSHFT	LABEL	BYTE			; SHIFTED keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	 27			;  1 ESC
	DW	"!"			;  2 !
	DW	"@"			;  3 @
	DW	"#"			;  4 #
	DW	"$"			;  5 $
	DW	"%"			;  6 %
	DW	"^"			;  7 ^
	DW	"&"			;  8 &
	DW	"*"			;  9 *
	DW	"("			; 10 (
	DW	")"			; 11 )
	DW	"_"			; 12 _ Underscore
	DW	"+"			; 13 +
	DW	  8			; 14 Backspace
	DW	15*256			; 15 Back tab
	DW	"Q"			; 16 Q
	DW	"W"			; 17 W
	DW	"E"			; 18 E
	DW	"R"			; 19 R
	DW	"T"			; 20 T
	DW	"Y"			; 21 Y
	DW	"U"			; 22 U
	DW	"I"			; 23 I
	DW	"O"			; 24 O
	DW	"P"			; 25 P
	DW	"{"			; 26 {
	DW	"}"			; 27 }
	DW	 13			; 28 Carriage return
	DW	  0			; ** Control key
	DW	"A"			; 30 A
	DW	"S"			; 31 S
	DW	"D"			; 32 D
	DW	"F"			; 33 F
	DW	"G"			; 34 G
	DW	"H"			; 35 H
	DW	"J"			; 36 J
	DW	"K"			; 37 K
	DW	"L"			; 38 L
	DW	":"			; 39 ;
	DW	'"'			; 40 " Double quote
	DW	"~"			; 41 ~ Tilde
	DW	  0			; ** Left shift
	DW	7CH			; 43	Split vertical bar
	DW	"Z"			; 44 Z
	DW	"X"			; 45 X
	DW	"C"			; 46 C
	DW	"V"			; 47 V
	DW	"B"			; 48 B
	DW	"N"			; 49 N
	DW	"M"			; 50 M
	DW	"<"			; 51 < Less than
	DW	">"			; 52 > Greater than
	DW	"?"			; 53 ?
	DW	  0			; ** Right shift
	DW	  0			; ** Print screen function
	DW	  0			; ** Alt 
	DW	" "			; 57 Space
	DW	  0			; ** Caps lock
	DW	84*256			; 59 F1
	DW	85*256			; 60 F2
	DW	86*256			; 61 F3
	DW	87*256			; 62 F4
	DW	88*256			; 63 F5
	DW	89*256			; 64 F6
	DW	90*256			; 65 F7
	DW	91*256			; 66 F8
	DW	92*256			; 67 F9
	DW	93*256			; 68 F10
	DW	  0			; ** Num lock
	DW	  0			; ** Scroll lock
	DW	"7"			; 71 7 Numeric pad numbers
	DW	"8"			; 72 8 
	DW	"9"			; 73 9 
	DW	"-"			; 74 - 
	DW	"4"			; 75 4 
	DW	"5"			; 76 5 
	DW	"6"			; 77 6 
	DW	"+"			; 78 + 
	DW	"1"			; 79 1 
	DW	"2"			; 80 2 
	DW	"3"			; 81 3 
	DW	"0"			; 82 0 
	DW	"."			; 83 .
	DW	   0			 ; 84 
	DW	   0			 ; 85
	DW	   0			 ; 86 
	DW	   0			 ; 87 New F11 Key
	DW	   0			 ; 88 New F12 Key
 	DW	39 DUP(0)		;      Fill remainder of table

	PAGE

KEYALT	LABEL	BYTE			; Alternate keyboard entrys

	DW	  0			;  0 Key zero (no such key?)
	DW	  0			;  1 
	DW	120*256			;  3 1
	DW	121*256			;  3 2
	DW	122*256			;  4 3
	DW	123*256			;  5 4
	DW	124*256			;  6 5
	DW	125*256			;  7 6
	DW	126*256			;  8 7
	DW	127*256			;  9 8
	DW	128*256			; 10 9
	DW	129*256			; 11 0
	DW	130*256			; 12 -
	DW	131*256			; 13 =
	DW	 14*256			; 14 APL ON/OFF
	DW	 69*256			; 15 ALT TAB
	DW	 16*256			; 16 q
	DW	 17*256			; 17 w
	DW	 18*256			; 18 e
	DW	 19*256			; 19 r
	DW	 20*256			; 20 t
	DW	 21*256			; 21 y
	DW	 22*256			; 22 u
	DW	 23*256			; 23 i
	DW	 24*256			; 24 o
	DW	 25*256			; 25 p
	DW	 26*256			; 26 [
	DW	 27*256			; 27 ]
	DW	   0			; 28 
	DW	   0			; ** Control key
	DW	 30*256			; 30 a
	DW	 31*256			; 31 s
	DW	 32*256			; 32 d
	DW	 33*256			; 33 f
	DW	 34*256			; 34 g
	DW	 35*256			; 35 h
	DW	 36*256			; 36 j
	DW	 37*256			; 37 k
	DW	 38*256			; 38 l
	DW	 39*256			; 39 ;
	DW	 40*256			; 40 '
	DW	 41*256			; 41 `
	DW	   0			; ** Left shift
	DW	   0			; 43 
	DW	 44*256			; 44 z
	DW	 45*256			; 45 x
	DW	 46*256			; 46 c
	DW	 47*256			; 47 v
	DW	 48*256			; 48 b
	DW	 49*256			; 49 n
	DW	 50*256			; 50 m
	DW	 51*256			; 51 ,
	DW	 52*256			; 52 .
	DW	 53*256			; 53 /
	DW	   0			; ** Right shift
	DW	   0			; 55 
	DW	   0			; ** Alt 
	DW	" "			; 57 Space
	DW	   0			; ** Caps lock
	DW	104*256			; 59 F1
	DW	105*256			; 60 F2
	DW	106*256			; 61 F3
	DW	107*256			; 62 F4
	DW	108*256			; 63 F5
	DW	109*256			; 64 F6
	DW	110*256			; 65 F7
	DW	111*256			; 66 F8
	DW	112*256			; 67 F9
	DW	113*256			; 68 F10
	DW	  0			; 69 ** Num lock    
	DW	  0			; 70 ** Scroll lock 
	DW	  0			; 71 HOME		
	DW	159*256			; 72 UP ARROW	  
	DW	  0			; 73 PgUp	      
	DW	  0			; 74 -	      
	DW	  0			; 75 LEFT ARROW     
	DW	  0			; 76			
	DW	  0			; 77 RIGHT ARROW    
	DW	  0			; 78 +	      
	DW	  0			; 79 End		
	DW	  0			; 80 DOWN ARROW     
	DW	  0			; 81 PgDn	      
	DW	  0			; 82			
	DW	  160*256		; 83		     
	DW	   0			 ; 84 
	DW	   0			 ; 85
	DW	   0			 ; 86 
	DW	   0			 ; 87 New F11 Key
	DW	   0			 ; 88 New F12 Key
 	DW	39 DUP(0)		;      Fill remainder of table

	PAGE

KEYCTRL	LABEL	BYTE			; CONTROL keyboard entrys

	DW	  0			; 0  No such key	
	DW	 27			; 1  ESC
	DW	140*256			; 2  1
	DW	141*256			; 3  2
	DW	142*256			; 4  3
	DW	143*256			; 5  4
	DW	144*256			; 6  5
	DW	145*256			; 7  6
	DW	146*256			; 8  7
	DW	147*256			; 9  8
	DW	148*256			; 10 9
	DW	149*256			; 11 0
	DW	150*256			; 12 -
	DW	151*256			; 13 =
	DW	127			; 14 DEL
	DW	0			; 15 
	DW	 17+128			; 16 Q CTRL-alpha like normal w/ 'parity'
	DW	 23+128			; 17 W
	DW	  5+128			; 18 E
	DW	 18+128			; 19 R
	DW	 20+128			; 20 T
	DW	 25+128			; 21 Y
	DW	 21+128			; 22 U
	DW	  9+128			; 23 I
	DW	 15+128			; 24 O
	DW	 10+128			; 25 P
	DW	 27+128			; 26 [
	DW	 29+128			; 27 ]
	DW	 10			; 29 CR
	DW	  0			; 30 ** CTRL
	DW	  1+128			; 31 A
	DW	 19+128			; 32 S
	DW	  4+128			; 33 D
	DW	  6+128			; 34 F
	DW	  7+128			; 35 G
	DW	  8+128			; 36 H
	DW	 10+128			; 37 J
	DW	 11+128			; 38 K
	DW	 12+128			; 39 L
	DW	  0			; 40 ;
	DW	  0 			; 41 '
	DW	  0			; 42 `
	DW	  0			; 43 ** Left shift
	DW	 28+128			; 44 \
	DW	 26+128			; 45 Z
	DW	 24+128			; 46 X
	DW	  3+128			; 47 C
	DW	 22+128			; 48 V
	DW	  2+128			; 49 B
	DW	 14+128			; 50 N
	DW	 13+128			; 51 M
	DW	  0			; 52 ,
	DW	  0			; 53 .
	DW	  0			; 54 /
	DW	  0			; 55 ** Right shift
	DW	114*256			; 56 PrtSc
	DW	  0			; 57 ** Alt
	DW	 " "			; 58 Space
	DW	  0			; 59 ** Caps lock
	DW	 94*256			; 60 F1
	DW	 95*256			; 61 F2
	DW	 96*256			; 62 F3
	DW	 97*256			; 63 F4
	DW	 98*256			; 64 F5
	DW	 99*256			; 65 F6
	DW  	100*256			; 66 F7
	DW	101*256			; 67 F8
	DW	102*256			; 68 F9
	DW	103*256			; 69 F10
	DW	  0			; 70 ** Num lock
	DW	  0			; 71 ** Scroll lock
	DW	119*256			; 72 HOME
	DW	 13*256			; 73 UP ARROW
	DW	  0			; 74 PgUp
	DW	  0			; 75 -
	DW	115*256			; 76 LEFT ARROW
	DW	  0			; 77 
	DW	116*256			; 78 RIGHT ARROW
	DW	  0			; 79 +
	DW	117*256			; 80 End
	DW	 12*256			; 81 DOWN ARROW
	DW	  118*256		; 82 PgDn
	DW	  0			; 83
	DW	   0			 ; 84 
	DW	   0			 ; 85
	DW	   0			 ; 86 
	DW	   0			 ; 87 New F11 Key
	DW	   0			 ; 88 New F12 Key
 	DW	39 DUP(0)		;      Fill remainder of table


PAGE
;
; EKEYTAB is the table used when a scan code is preceded by an E0 code. Like
;   KEYTAB, EKEYTAB contains one entry per each of 128 possible key scan codes
;   for each of 4 shift states currently allowed.  Each section of EKEYTAB
;   must contain exactly 128 words (256 bytes) to preserve alignment throughout
;   the table.	An entry of zero is assumed to be a 'DEAD' key and enters
;   no code into the keyboard input buffer.  Non-zero key codes are entered
;   directly into the key ring with out interpretation.

EKEYTAB	LABEL	WORD			; Main keyboard table entry (local)
EKYNORM	LABEL	BYTE			; Normal (unshifted) keyboard entrys

	DW	0			; 0  
	DW	0			; 1  
	DW	0    			; 2  
	DW	0    			; 3  
	DW	0    			; 4  
	DW	0    			; 5  
	DW	0    			; 6  
	DW	0    			; 7  
	DW	0    			; 8  
	DW	0    			; 9  
	DW	0    			; 10 
	DW	0    			; 11 
	DW	0    			; 12 
	DW	0    			; 13 
	DW	0			; 14 
	DW	0			; 15 
	DW	0    			; 16 
	DW	0			; 17 
	DW	0   			; 18 
	DW	0   			; 19 
	DW	0      			; 20 
	DW	0      			; 21 
	DW	0      			; 22 
	DW	0      			; 23 
	DW	0      			; 24 
	DW	0      			; 25 
	DW	0      			; 26 
	DW	0      			; 27 
	DW	13			; 28 Keypad Enter Key position
	DW	0      			; 29 Right Ctrl Key position
	DW	0      	       		; 30 
	DW	0      	       		; 31 
	DW	0      	       		; 32 
	DW	0      	       		; 33 
	DW	0      	       		; 34 
	DW	0      	       		; 35 
	DW	0			; 36 
	DW	0 		 	; 37 
	DW	0			; 38 
	DW	0			; 39 
	DW	0			; 40 
	DW	0 		 	; 41 
	DW	0			; 42 
	DW	0			; 43 
	DW	0			; 44 
	DW	0	       		; 45 
	DW	0	       		; 46 
	DW	0	       		; 47 
	DW	0	       		; 48 
	DW	0	       		; 49 
	DW	0	       		; 50 
	DW	0	       		; 51 
	DW	0			; 52 
	DW	"/"			; 53 "/" on Keypad
	DW	0			; 54 
	DW	0			; 55	* Key on the Enhanced Keyboard
	DW	0    			; 56 
	DW	0			; 57 
	DW	0			; 58 
	DW	0			; 59 
	DW	0   			; 60 
	DW	0   			; 61 
	DW	0   			; 62 
	DW	0   			; 63 
	DW	0   			; 64 
	DW	0   			; 65 
	DW  	0  			; 66 
	DW	0  			; 67 
	DW	0  			; 68 
	DW	0      			; 69 
	DW	0      			; 70 
	DW	71*256			; 71 Enhanced Home Key position
	DW	72*256			; 72 Enhanced Up Arrow position
	DW	73*256			; 73 Enhanced Page Up position
	DW	0			; 74 
	DW	75*256			; 75 Enhanced Left Arrow position
	DW	76*256	       		; 76 
	DW	77*256	       		; 77 Enhanced Right Arrow position
	DW	0    			; 78 
	DW	79*256			; 79 Enhanced End Key position
	DW	80*256			; 80 Enhanced Down Arrow position
	DW	81*256			; 81 Enhanced Page Down position
	DW	82*256 	 		; 82 Enhanced Insert key position
	DW	83*256			; 83 Enhanced Delete Key position
	DW	0			; 84 
	DW	0			; 85
	DW	0			; 86 
	DW	0			; 87 
	DW	0			; 88 
 	DW	39 DUP(0)		;      Fill remainder of table
PAGE
EKYSHFT LABEL	BYTE			; Shifted Keyboard Entries

	DW	0			; 0  
	DW	0			; 1  
	DW	0    			; 2  
	DW	0    			; 3  
	DW	0    			; 4  
	DW	0    			; 5  
	DW	0    			; 6  
	DW	0    			; 7  
	DW	0    			; 8  
	DW	0    			; 9  
	DW	0    			; 10 
	DW	0    			; 11 
	DW	0    			; 12 
	DW	0    			; 13 
	DW	0			; 14 
	DW	0			; 15 
	DW	0    			; 16 
	DW	0			; 17 
	DW	0   			; 18 
	DW	0   			; 19 
	DW	0      			; 20 
	DW	0      			; 21 
	DW	0      			; 22 
	DW	0      			; 23 
	DW	0      			; 24 
	DW	0      			; 25 
	DW	0      			; 26 
	DW	0      			; 27 
	DW	0      			; 28 
	DW	0      			; 29 
	DW	0      			; 30 
	DW	0      			; 31 
	DW	0      			; 32 
	DW	0      			; 33 
	DW	0      			; 34 
	DW	0      			; 35 
	DW	0			; 36 
	DW	0 		 	; 37 
	DW	0			; 38 
	DW	0			; 39 
	DW	0			; 40 
	DW	0 		 	; 41 
	DW	0			; 42 
	DW	0			; 43 
	DW	0			; 44 
	DW	0	     		; 45 
	DW	0	     		; 46 
	DW	0	     		; 47 
	DW	0	     		; 48 
	DW	0	     		; 49 
	DW	0	     		; 50 
	DW	0	     		; 51 
	DW	0			; 52 
	DW	0			; 53 
	DW	0			; 54 
	DW	0			; 55 Shift of Print Screen Key
	DW	0    			; 56 
	DW	0			; 57 
	DW	0			; 58 
	DW	0			; 59 
	DW	0   			; 60 
	DW	0   			; 61 
	DW	0   			; 62 
	DW	0   			; 63 
	DW	0   			; 64 
	DW	0   			; 65 
	DW  	0			; 66 
	DW	0  			; 67 
	DW	0  			; 68 
	DW	0  			; 69 
	DW	0			; 70 
	DW	71*256			; 71 Shift of Enhanced Home Key position
	DW	72*256			; 72 Shift of Enhanced Up Arrow position
	DW	73*256			; 73 Shift of Enhanced Page Up position
	DW	0			; 74 
	DW	75*256			; 75 Shift of Enhanced Left Arrow position
	DW	76*256	       		; 76 
	DW	77*256	       		; 77 Shift of Enhanced Right Arrow position
	DW	0    			; 78 
	DW	79*256			; 79 Shift of Enhanced End Key position
	DW	80*256			; 80 Shift of Enhanced Down Arrow position
	DW	81*256			; 81 Shift of Enhanced Page Down position
	DW	82*256 	 		; 82 Shift of Enhanced Insert key position
	DW	83*256			; 83 Shift of Enhanced Delete Key position
	DW	0			; 84 
	DW	0			; 85
	DW	0			; 86 
	DW	0			; 87 
	DW	0			; 88 
 	DW	39 DUP(0)		;      Fill remainder of table
PAGE
EKYALT	LABEL	BYTE			; Alternate keyboard entrys

	DW	  0			; 0  
	DW	  0			; 1  
	DW	  0    			; 2  
	DW	  0    			; 3  
	DW	  0    			; 4  
	DW	  0    			; 5  
	DW	  0    			; 6  
	DW	  0    			; 7  
	DW	  0    			; 8  
	DW	  0    			; 9  
	DW	  0    			; 10 
	DW	  0    			; 11 
	DW	  0    			; 12 
	DW	  0    			; 13 
	DW	  0			; 14 
	DW	  0			; 15 
	DW	  0    			; 16 
	DW	  0			; 17 
	DW	  0   			; 18 
	DW	  0   			; 19 
	DW	  0      		; 20 
	DW	  0      		; 21 
	DW	  0      		; 22 
	DW	  0      		; 23 
	DW	  0      		; 24 
	DW	  0      		; 25 
	DW	  0      		; 26
	DW	  0      		; 27 
	DW	  0      		; 28 
	DW	  0      		; 29 
	DW	  0      		; 30 
	DW	  0      		; 31 
	DW	  0      		; 32 
	DW	  0      		; 33 
	DW	  0      		; 34 
	DW	  0      		; 35 
	DW	  0			; 36 
	DW	  0 		 	; 37 
	DW	  0			; 38 
	DW	  0			; 39 
	DW	  0			; 40 
	DW	  0 		 	; 41 
	DW	  0			; 42 
	DW	  0			; 43 
	DW	  0			; 44 
	DW	  0	     	; 45 
	DW	  0	     	; 46 
	DW	  0	     	; 47 
	DW	  0	     	; 48 
	DW	  0	     	; 49 
	DW	  0	     	; 50 
	DW	  0	     	; 51 
	DW	  0			; 52 
	DW	  0			; 53 
	DW	  0			; 54 
	DW	  0			; 55 
	DW	  0    			; 56 
	DW	  0			; 57 
	DW	  0			; 58 
	DW	  0			; 59 
	DW	  0   			; 60 
	DW	  0   			; 61 
	DW	  0   			; 62 
	DW	  0   			; 63 
	DW	  0   			; 64 
	DW	  0   			; 65 
	DW        0                     ; 66 
	DW	  0  			; 67 
	DW	  0  			; 68 
	DW	  0  			; 69 
	DW	  0			; 70 
	DW	  0			; 71 
	DW	  0    			; 72 
	DW	  159*256		; 73 Alt of Enhanced Up Arrow Key
	DW	  0			; 74 
	DW	  0			; 75 Alt of Enhanced Left Arrow Key
	DW	  0    			; 76 
	DW	  0			; 77 Alt of Enhanced Right Arrow Key
	DW	  0    			; 78 
	DW	  0			; 79 Alt of Enhanced End Key
	DW	  0    			; 80 
	DW	  0    			; 81 
	DW	  0      		; 82 
	DW	  160*256		; 83 Alt of Enhanced Del Key
	DW	  0			; 84 
	DW	  0			; 85
	DW	  0			; 86 
	DW	  0			; 87 
	DW	  0			; 88 
 	DW	39 DUP(0)		;      Fill remainder of table
PAGE
EKYCTRL	LABEL	BYTE			; CONTROL keyboard entrys

	DW	  0			; 0  
	DW	  0			; 1  
	DW	  0    			; 2  
	DW	  0    			; 3  
	DW	  0    			; 4  
	DW	  0    			; 5  
	DW	  0    			; 6  
	DW	  0    			; 7  
	DW	  0    			; 8  
	DW	  0    			; 9  
	DW	  0    			; 10 
	DW	  0    			; 11 
	DW	  0    			; 12 
	DW	  0    			; 13 
	DW	  0			; 14 
	DW	  0			; 15 
	DW	  0    			; 16 
	DW	  0			; 17 
	DW	  0   			; 18 
	DW	  0   			; 19 
	DW	  0      		; 20 
	DW	  0      		; 21 
	DW	  0      		; 22 
	DW	  0      		; 23 
	DW	  0      		; 24 
	DW	  0      		; 25 
	DW	  0      		; 26 
	DW	  0      		; 27 
	DW	  0      		; 28 
	DW	  0      		; 29 
	DW	  0      		; 30 
	DW	  0      		; 31 
	DW	  0      		; 32 
	DW	  0      		; 33 
	DW	  0      		; 34 
	DW	  0      		; 35 
	DW	  0			; 36 
	DW	  0 		 	; 37 
	DW	  0			; 38 
	DW	  0			; 39 
	DW	  0			; 40 
	DW	  0 		 	; 41 
	DW	  0			; 42 
	DW	  0			; 43 
	DW	  0			; 44 
	DW	  0			; 45 
	DW	  0			; 46 
	DW	  0			; 47 
	DW	  0			; 48 
	DW	  0			; 49 
	DW	  0			; 50 
	DW	  0			; 51 
	DW	  0			; 52 
	DW	  0			; 53 
	DW	  0			; 54 
	DW	  114*256		; 55 Control of the Print screen Key
	DW	  0      		; 56 
	DW	  0			; 57 
	DW	  0			; 58 
	DW	  0			; 59 
	DW	  0   			; 60 
	DW	  0   			; 61 
	DW	  0   			; 62 
	DW	  0   			; 63 
	DW	  0   			; 64 
	DW	  0   			; 65 
	DW  	  0  			; 66 
	DW	  0  			; 67 
	DW	  0  			; 68 
	DW	  0  			; 69 
	DW	  0			; 70 
	DW	  119*256		; 71 Ctrl of Enhanced Home Key
	DW	  13*256  		; 72 Ctrl of Enhanced Up Arrow Key
	DW	  0			; 73 
	DW	  0			; 74 
	DW	  115*256		; 75 Ctrl of Enhanced Left Arrow Key
	DW	  0			; 76 
	DW	  116*256		; 77 Ctrl of Enhanced Right Arrow Key
	DW	  0			; 78 
	DW	  117*256		; 79 Ctrl of Enhanced End Key
	DW	  12*256		; 80 Ctrl of Enhanced Down Arrow Key
	DW	  118*256		; 81 Ctrl of Enhanced Page Down Key
	DW	  0     		; 82 
	DW	  0			; 83
	DW	  0			; 84 
	DW	  0			; 85
	DW	  0			; 86 
	DW	  0			; 87 
	DW	  0			; 88 
 	DW	39 DUP(0)		;      Fill remainder of table

PAGE
E1TAB	LABEL	BYTE
	DW	0			; 0	Pause Key 
	DW	0			; 1 	Shift of Pause Key
	DW	0			; 2	Alternate of Pause Key
	DW	0			; 3 	Control of Pause Key (Not possible)

	ENDIF

DATA	ENDS
	END
