		NAME	KYBDSWS
		PAGE	63,110
		TITLE	.KYBDSWS - Switch current key profile

DATA		SEGMENT	BYTE PUBLIC   	; Local private data
		ASSUME	DS:DATA

REPLY		LABEL	BYTE		; Keyboard reply overwrite setup data

NUMBERS		LABEL	WORD		; Numbers list from DCAKYBD
DSEG		DW	0		; DGROUP of DCAKYBD
KEYTAB		DW	0		; OFFSET DGROUP:KEYTAB
SKMODE		DW	0		; OFFSET DGROUP:SKMODE
KEYBASE		DW	0		; OFFSET DGROUP:KEYBASE
NUMBERS_LENGTH	EQU	($-NUMBERS)/2	; Number of numbers to fetch

DEVNAM		DB	"EXTKYBD",0	; Device control file name

ENQUIRE		DB	"[*]"		; Enquiry text string
ENQUIRE_LENGTH	EQU	$-ENQUIRE	; Length of string to write

REPLY_FILL	DB	40-($-REPLY) DUP (0) ; Make sure 40 bytes available
REPLY_LENGTH	EQU	$-REPLY		; Length of string to read

TABLE_LENGTH	EQU	2560		; Length of key table entry

DATA		ENDS
		PAGE

CODE		SEGMENT	BYTE PUBLIC 
		ASSUME	CS:CODE

; KYBDINIT - Setup IRMAKEY pointers.  All general registers except BP assumed
; destroyed.  This call must be made once AND ONLY ONCE before using other
; KYBDaccess routines.
;
; C Calling sequence:
;
;	errcod = kybdinit();
;
; ASM Calling sequence:
;
;	CALL	KYBDINIT		; Setup keyboard control variables
;	TEST	AX,AX			; Check for error code
;	JNZ	SOME_ERROR		; Some DOS Error code in AX
;
; KYBDINIT returns:
;
;	Error:	AX = DOS Error Number
;	Ok:	AX = 0

		PUBLIC	KYBDINIT	; Init IRMAKEY KYBD control variables		
KYBDINIT	PROC	NEAR		; 
		PUSH	BP		;
		PUSH	DS		;

		MOV	AX,DATA		; Get to local data segment
		MOV	DS,AX		;

		MOV	DX,OFFSET DATA:DEVNAM
		MOV	AX,03D02H	; 
		INT	21H		; Open DCAKYBD for read & write
		JC	KEY_ERROR	; Open failed...

		MOV	BX,AX		; BX contains file handle

		MOV	DX,OFFSET DATA:ENQUIRE
		MOV	CX,ENQUIRE_LENGTH
		MOV	AX,04000H	;
		INT	21H		; Write ENQUIRE string to driver
		JC	ACT_ERROR	; Write error, close & exit

		MOV	DX,OFFSET DATA:REPLY
		MOV	CX,REPLY_LENGTH-1 ; Make sure room on end for NULL
		MOV	AX,03F00H	;
		INT	21H		; Read response string from driver
		JC	ACT_ERROR	; Read error, close & exit

		MOV	SI,AX		; Number of characters read
		MOV	REPLY[SI],0	; Null terminate buffer

		MOV	AX,03E00H	;
		INT	21H		; Close DCAKYBD file

		MOV	SI,0		; Start with first of reply

		CMP	REPLY[SI],"["	; Is this fitting?
		JNZ	FMT_ERROR	;
		INC	SI		;

		CMP	REPLY[SI],"*"	; [*nnn,nnn,nnn,nnn]
		JNZ	FMT_ERROR	;
		INC	SI		;		

		MOV	CX,NUMBERS_LENGTH
		MOV	DI,0		; Offset into NUMBERS list		

NXT_NUMBER:	CALL	GETNUM		; Fetch a number from REPLY
		MOV	NUMBERS[DI],AX	;
		ADD	DI,2		; Point to next number space
		LOOP	NXT_NUMBER	; Until all numbers eaten.
		
		XOR	AX,AX		; No error number

INIT_EXIT:	POP	DS		; Restore special registers
		POP	BP		;
		RET			; And return to user

ACT_ERROR:	PUSH	AX		; Save error code
		MOV	AX,03E00H	; Error while driver open
		INT	21H		; Attempt to close driver
		POP	AX		; Restore error code

KEY_ERROR:	MOV	DSEG,0		; Turn off any hope of KYBDaccess...
		JMP	INIT_EXIT	; Return with error flag set

FMT_ERROR:	MOV	AX,11		; DOS Invalid Format error code
		JMP	KEY_ERROR	; Means DCAKYBD speaking in tongues

KYBDINIT	ENDP
		PAGE

; KYBDGET - Get current key profile number (0..9) into AX.  
; All general registers except BP assumed destroyed.
;
; C Calling sequence:
;
;	errcod = kybdget();
;
; ASM Calling sequence:
;
;	CALL	KYBDGET		; Get current keyboard table number
;	CMP	AX,-1		; Test for error code
;	JZ	SOME_ERROR	;
;
; KYBDGET returns:
;
; 	Error:	AX = -1		(KYBDINIT not called or errored out...)
;	Ok:	AX = 0..9	Key profile number (0 == USASTD)

		PUBLIC	KYBDGET		;
KYBDGET		PROC	NEAR		; Get current key table into AX
		PUSH	DS		;
		PUSH	ES		;

		MOV	AX,DATA		; Get the local data area
		MOV	DS,AX		; DS Local data area
		MOV	AX,DSEG		;
		MOV	ES,AX		; ES DCAKYBD driver data area

		TEST	AX,AX		; Zero is a no-such keyboard!
		MOV	AX,-1		; Potential error return code
		JZ	KYBDGET_EXIT	; Nothing to do...

		MOV	SI,KEYBASE	; Get current key pointer
		MOV	AX,ES:[SI]	; Peek directly into driver
								       
KYBDGET_EXIT:	POP	ES		; Restore users segment
		POP	DS		;
		RET			; Back to user w/ table in AX

KYBDGET		ENDP
		PAGE

; KYBDSET - Set IRMAKEY KYBD profile number.  Number is on top of stack 
; before call.  All general registers except BP assumed destroyed.
;
; C Calling sequence:
;
;	errcod = kybdset(keyno);
;
; ASM Calling sequence:
;
;	MOV	BP,SP		; Save current frame pointer
;	PUSH	NEWKEY		; Push new key table number
;	CALL	KYBDSET		; Select new key table
;	MOV	SP,BP		; Restore stack frame
;	CMP	AX,-1		; Test for error code
;	JZ	SOME_ERROR	; Something is wrong...
;
; KYBDSET returns:
;
;	Error:	AX = -1		(KYBDINIT not called or errored out, or table
;				 number out of range (0 <= n <= 9))
;	Ok:	AX = 0		Table selected w/o error

		PUBLIC	KYBDSET		; Select new key table number
KYBDSET		PROC	NEAR		;
		PUSH	BP		; Save old frame pointer
		MOV	BP,SP		;
					; [BP+0] = Old Frame
		PUSH	DS		;    +2	   Return address
		PUSH	ES		;    +4    Selection
		
		MOV	AX,DATA		; Setup segments
		MOV	DS,AX		;
		MOV	AX,DSEG		;
		MOV	ES,AX		;

		TEST	AX,AX		; Is this pointing at something real?
		JZ	SELECT_EXIT	; No, get the heck out of Dodge...

		MOV	AX,[BP+4]	; Get selection number off stack
		MOV	SI,KEYTAB	; Get base of key table
		MOV	DX,0		; Start with zero table count

SELECT_SCAN:	TEST	AX,AX		; Does SI point to selected table?
		JZ	SELECT		; Yes, we are here...

		ADD	SI,TABLE_LENGTH	; Point at next table
		CMP	BYTE PTR ES:[SI],0
		JZ	SELECT_ERROR	; Ran out of tables!

		INC	DX		; Count up current tables
		DEC	AX		; Count off one scanned table
		JMP	SELECT_SCAN	; Scan until table found

SELECT:		MOV	DI,KEYBASE	; Address of key table pointer
		MOV	ES:[DI],DX	; Set pointer in driver
		JMP	SELECT_EXIT	; AX = 0 is no error.
		
SELECT_ERROR:	MOV	AX,-1		; No such table!

SELECT_EXIT:	POP	ES		;
		POP	DS		;
		POP	BP		;
		RET			;

KYBDSET		ENDP
		PAGE

; GETNUM - Internal procedure to fetch decimal number from REPLY buffer 
; into AX

GETNUM		PROC	NEAR		; Fetch number from REPLY[SI] into AX
		XOR	AX,AX		; Clear number accumulator
		MOV	BH,AH		; Copy a zero

GETNUM_NEXT:	MOV	BL,REPLY[SI]	; Get a character from REPLY
		TEST	BL,BL		; NULL is stand in place terminator
		JZ	GETNUM_DONE	;

		AND	BL,NOT 80H	; Remove possible parity bit
		SUB	BL,"0"		; Should be greater or equal
		JC	GETNUM_STOP	; Underflow (Carry) if less

		CMP	BL,10		; Should now be 0-9
		JNC	GETNUM_STOP	; > 9 is non-numeric

		MOV	DX,10		; Make room for a new digit
		MUL	DX		;
		ADD	AX,BX		; Add new digit

		INC	SI		; Point to next digit
		JMP	GETNUM_NEXT	; And do it again

GETNUM_STOP:	INC	SI		; Skip over separator
GETNUM_DONE:	RET			;

GETNUM		ENDP

CODE		ENDS

		END
