	NAME	MKATTR
	INCLUDE	PAGESIZE.INC
	TITLE	.MKATTR - Make ATTRIBUTE for AX
;
; MKATTR - procedure to decode and convert the data read from the IRMA
; interface, in 3270 format, into PC display attributes and EBCDIC chars.
;
; On entry: AH == Extended attribute (EFA or ECA).
;	    AL == attribute or character from IRMA.
;	    BL == current line number being displayed.
;
; On exit:  AL == EBCDIC <space> if an attribute was encountered and E78
;		  is not in "Display Attribute" mode.
;		 OR
;		  EBCDIC representation of attribute if E78 is in "Display
;		  Attribute" mode.
;		 OR
;		  EBCDIC display code if the Status line is being displayed.
;		 OR
;		  EBCDIC character as read from the IRMA interface.
;	     AH == PC screen attribute to use when displaying char.
;	     BH == character set number (0 == normal, 1 == APL)
; 
; Called by: UPDLIN, ?
;
; Routines called: ATCALC
;
; Globals changed: NOATRS, ATRSAV, CHARST, PRVATR
;
; Globals accessed: DISLIN, MONB26, FKEY2, ATDSC, FKEY3
;
; Registers used (and not saved): AX, BH, CH, DH
;
; History:
;   Date    Version    By     Comments
; 01/23/85   1.40      jsc	Added changes for IRMAvision and documentation
; 02/01/85   1.40      jsc	Optimized parts of the code
; 04/27/85   1.42      cmb	added in flag bytes to be changed by genx
; 03/12/86   1.47.101  KSA      Corrected the EAB problem (MEGACALC)
;
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	COLORS:BYTE,	MONOFLG:BYTE,	PRVATR:BYTE,	ATDSC:BYTE
	EXTRN	ATTRIB:BYTE,	ATRSAV:BYTE,	AUXST:BYTE,	FKEY1:BYTE
	EXTRN	FKEY2:BYTE,	FKEY3:BYTE,	CHARST:BYTE,	NONEVR:BYTE
	EXTRN	NOATRS:BYTE,	MONB26:BYTE,	DISLIN:BYTE,	DISAPL:BYTE
	EXTRN	DISEAB:BYTE,	STLNAT:BYTE,	HORZBAR:BYTE	
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE

	PUBLIC	MKATTR
MKATTR	PROC	NEAR

	CMP	DISAPL,1	; If APL character, Is APL disabled ??
	JNE	NOAPL		; Jump if not disabled

	AND	AH,0FEH		; Reset APL bit (to zero) in EAB

NOAPL:	CMP	BL,0		; Is this the Status line?
	JE	DISGO		; Yes, ignore attributes and Display it
	CMP	AL,0C0H		; New attribute?
	JC	MK0		; No, jump

NEWAT:				; Yes, process
	MOV	NOATRS,1	; Set attribute found flag
	MOV	ATRSAV[BX+1],AL	; Save incoming attribute for future ref.

	CALL	ATCALC		; Build the new attribute 
	MOV	CHARST,DH	; Save the selected character set away
	MOV	PRVATR[BX+1],CH	; Save it for future reference
;				; Treat as non-displayed character
NONDIS:	MOV	AH,PRVATR	; Basic screen attribute
	MOV	BH,0		; Always default character set
	
	CMP	FKEY2,1		; Are attributes displayed?
	JNZ	NODAAT		; No

DAATS:	CMP	AL,0C0H		; Is this an attribute?
	JC	NODAAT		; No, convert to space

	SUB	AL,0C0H		; Remove attribute offset
	XOR	AH,AH		; Make as a byte pointer into ATDSC
	XCHG	BX,AX		;
	MOV	BL,ATDSC[BX]	; Get the EBCDIC representation
	XCHG	AX,BX		;

	MOV	BH,0		; Select default character set
	MOV	AH,PRVATR	; Get the default attribute

	JMP	SHORT MKEXIT	; Exit

MK0:	TEST	AUXST,M$DINH	; Is the display inhibited?
	JNZ	NONDIS		; Yes, turn off all except status line

DISGO:	CMP	DISEAB,1	; Is EAB disabled
	JE	NOVER	
	TEST	AH,11111111B	; EAB override attempt?
	JZ	NOVER		; No, jump

EABOVR:	PUSH	AX		; Yes, save the character for later
	MOV	AL,ATRSAV[BX+1]	; Get current running attribute
	
	CALL	ATCALC		; Calculate the new attribute
	MOV	BH,DH		; Put character set selection in place

	POP	AX		; Restore the character
	MOV	AH,CH		; And restore the attribute
	JMP	SHORT OVERT	; OVEr ride ReTurn through normal path

NOVER:	MOV	AH,PRVATR[BX+1]	; Get normal line attributes
	MOV	BH,CHARST	; Character set number...

	CMP	BL,0		; Is this the status line?
	JNE	OVERT		; No, do not force attribute

	MOV	AH,STLNAT	; Default white line

OVERT:	CMP	AH,0		; Is this a non display special?
	JZ	NONDIS		; Yes, process special so cursor displays Ok

	CMP	AL,0		; Is this an unprotected null?
	JNZ	MKEXIT		; No - exit

CHNULL:	CMP	FKEY3,1		; Is DIsplay NonProtected on?
	JNZ	NODAAT		; No.

	CMP	BL,0		; Is this the status line?
	JZ	NODAAT		; Yes, do not disturb

	PUSH	BX		;
	XOR	BH,BH		; Just in case funny character set on the way
	TEST	ATRSAV[BX+1],20H; Is this protected
	POP	BX		;
	JZ	CHN1		; No, pass Np null through for dot

NODAAT:	MOV	AL,10H		; EBCDIC space
CHN1:	MOV	BH,0		; Select Standard character set

MKEXIT:	CMP	MONB26,0	; Is underscore appropriate on last line of
	JE	MK9		; display to fake horizontal bar? No, jump
	MOV	CH,DISLIN	; Yes - then are we on last display line?
	DEC	CH
	CMP	BL,CH
	JNE	MK9		; No - exit
	TEST	AH,1		; See if Bit 0 is set
	JZ	MK9		; No - this is non-display or reverse video attr

	CMP	HORZBAR,1	; Is the horizontal bar disabled
	JE	MK91		; Jump if yes

	AND	AH,11111001B	; Force Monochrome Underline Attribute
MK9:	RET			; Normal exit

MK91:	AND	AH,11111111B	; Horizontal bar is disabled
	RET



MKATTR	ENDP
	PAGE
;
; ATCALC - procedure to determine the PC display attribute from the current
; attribute and Extended attribute through a table lookup technique.
;
; NOTE: To prohibit display of 'non-display' fields under all circumstances 
; set byte NONEVR in module PUBLICS to non-zero.
;
; On entry: AH == Extended attribute (EFA or ECA).
;	    AL == attribute or character from IRMA.
;	    BL == current line number.
;
; On exit:  AH == same as above
;	    AL == same as above
;	    CH == PC display attribute from table
;	    DH == character set number (0 == normal, 1 == APL)
; 
; Called by: MKATTR, UPDRST, ?
;
; Routines called: None
;
; Globals changed: None
;
; Globals accessed: CHARST, MONOFLG, FKEY1, FKEY2, COLORS, NONEVR
;
; Registers used (and not saved): CX, DX
;
; History:
;   Date    Version    By     Comments
; 01/23/85   1.40      jsc	Added changes for IRMAvision & Optimized
;				parts of the code.
; 02/01/85   1.40      jsc	Optimized code
;
	PUBLIC	ATCALC		; Used by UPDRST if large screen scan needed
ATCALC	PROC	NEAR 		; Compute new attribute
	MOV	DH,CHARST	; Select the default character set
	PUSH	AX		; Save the attributes

	MOV	CH,AL		; Test for non-display special case
	AND	CH,1100B	; Non-displayed case
	XOR	CH,1100B	; CH will be zero if non-display
	JNZ	DISNON		; Jump if NOT the non-display special case

	CMP	FKEY2,1		; Are attributes displayed?
	JNZ	ATCX		; No, exit
	CMP	NONEVR,0	; Are we allowed to breach security?
	JNZ	ATCX		; No, exit
				; Yes, just for now, display non-display 
DISNON:
				; AL = 11paidxt
				; AH = mmcccxxx
	MOV	DH,0		; Default character set selection
	MOV	DL,AH		; Get a copy of the EAB
	AND	DL,111B		; Strip out the character set select bits
	CMP	DL,001B		; This is the magic APL character set #
	JNZ	NOAPL1		; Not apl, force it to default


	MOV	DH,1		; Select APL character generator

NOAPL1:	MOV	CH,AH		; Make a copy of the EAB
	OR	CH,03FH		; CH = mm111111
	AND	AL,CH		; AL = mmpaidxt
	AND	AL,0F8H		; AL = mmpai000

	MOV	CL,3		; Move the color bits down
	SHR	AH,CL		; AH = 000mmccc
	AND	AH,7		; AH = 00000ccc
	OR	AL,AH		; AL = mmpaiccc 

	MOV	AH,FKEY1	; Display mode
	CMP	MONOFLG,MF$C	; Is this a color adapter
	JZ	LOOKUP		; Yes, skip the monochrome fixup

	MOV	CL,3		; Remove the color information
	SHR	AL,CL		; AL = 000mmpai
	MOV	AH,3		; This is the mode just beyond the colors

LOOKUP:	XCHG	BX,AX		; Move attribute index into indexable reg
	MOV	CH,COLORS[BX]	; Get the new attribute character
	XCHG	BX,AX		; Restore line counter

ATCX:	POP	AX		; Restore IBM style attribute chars
	RET			;

ATCALC	ENDP
CODE	ENDS
	END
