		NAME	SKIFACE
		PAGE	63,110
		TITLE	.SKIFACE - SK keyboard Interface code
DATA		SEGMENT	PUBLIC
		ASSUME	DS:DATA

COMMENT		|			; [sk] SKII doesn't use this

		.XLIST
		INCLUDE	PUBLICS.EQU

		EXTRN	SLVERR:BYTE	; E78 Error byte

SKPROFILE	DB	"SK78.SK",0	; Key profile name

SKREVNO		EQU	110H		; Keyboard file revision number

CIKBSRV		STRUC                   ; INT 16H process header
DGOXSTATE	DW	0  		; DGROUP Offset of XSTATE
DGOXLATE	DW	0               ; DGROUP Offset of XLATE
XGSEG		DW	0		; DGROUP Segment
XGREVNO		DW	0               ; Macro process rev number
XGNAME		DB	33 DUP(0)       ; Macro description
XGTAG		DB	 9 DUP(0)       ; Driver description (BTAG)
CIKBSRV		ENDS

CIKBINT		STRUC			; INT 09H process header
DGOSKMODE	DW	0 		; DGROUP Offset of SKMODE
DGOKEYTAB	DW	0  		; DGROUP Offset of KEYTAB
KBSEG		DW	0		; DGROUP Segment
KBREVNO		DW	0		; Key process rev number
KINAME		DB	33 DUP(0)	; Key layout description
KITAG		DB	 9 DUP(0)	; Driver description (BTAG)
CIKBINT		ENDS
		PAGE

KBSRV		CIKBSRV	<> 		; Macro process header local copy
AIKBSRV		LABEL	BYTE

KBINT		CIKBINT	<>		; Layout process header local copy
AIKBINT		LABEL	BYTE

BTAG		DB	"IRMAKEY"	; Driver name check
BTAG_LEN	EQU	$-BTAG		; Length of check name

SKHANDLE	DW	0		; Load file handle

XLATE		DB	4096 DUP(0)	; Key macro storage

KEYTAB		LABEL	BYTE 		; Key layout storage
		.XLIST
		INCLUDE	KEYTAB.INC
		.LIST			; Loaded from KEYTAB.INC

		|			; [sk] End of dropped data

DATA		ENDS
		PAGE

CODE		SEGMENT	PUBLIC		; E78 standard code segment
		ASSUME	CS:CODE

COMMENT		|			; [sk] SKII doesn't use this

; Fetch interrupt process header
;
; AL - Interrupt vector number
; CX - Length of header
; DI - Pointer to local header end label
;
; All general registers assumed destroyed...

HFETCH		PROC	NEAR		; Fetch Int header # AL
 		PUSH	ES		;
		XOR	BX,BX		;
		MOV	ES,BX		; Point at interrupt vec page
		SHL	AL,1		;
		SHL	AL,1		; *4
		XOR	AH,AH		;
		MOV	BX,AX		; ES:BX points at interrupt
		LES	SI,DWORD PTR ES:[BX]

HFETCH_0:	DEC	SI		; Source pointer
		DEC	DI		; Destination pointer

		MOV	AL,ES:[SI]	; Get a byte
		MOV	[DI],AL		; Put a byte
		LOOP	HFETCH_0	;

		POP	ES		; Return tromped segment
		RET

HFETCH		ENDP
		PAGE

; Exchange local keyboard profile with active key profile.

 		PUBLIC	SKIFACE 	; Exchange key layouts
SKIFACE		PROC	NEAR

		PUSH	AX		; Save all used registers
		PUSH	BX
		PUSH	CX
		PUSH	SI
		PUSH	DI

		MOV	DI,OFFSET DATA:AIKBSRV
		MOV	CX,TYPE KBSRV	; Fetch KBSRV macro header
		MOV	AL,16H 		;
		CALL	HFETCH

		MOV	DI,OFFSET DATA:AIKBINT
		MOV	CX,TYPE KBINT	; Fetch KBINT layout header
		MOV	AL,9H		;
		CALL	HFETCH

		MOV	CX,BTAG_LEN	; Check to see if IRMAKEY type
		MOV	BX,0		; Index into header strings

SKIFACE_0:	MOV	AL,BTAG[BX]	; Get desired value
		CMP	AL,BYTE PTR KBINT.KITAG[BX]
		JNZ	SKIFACE_1	; Jump if layout not right type
		CMP	AL,BYTE PTR KBSRV.XGTAG[BX]
		JNZ	SKIFACE_1	; Jump if macro not right type

		INC	BX 		; Try another character
		LOOP	SKIFACE_0	; Until all characters checked
		JMP	SHORT SKIFACE_2	; Jump to continue key exchange

SKIFACE_1:	MOV	SLVERR,SKERR0	; Incorrect IRMAKEY driver or
		JMP	SKIFACE_EXIT	; driver not loaded...

SKIFACE_1A:	MOV	SLVERR,SKERR1	; Incorrect IRMAKEY driver
		JMP	SKIFACE_EXIT	; revision level

SKIFACE_2:	CMP	KBINT.KBREVNO,SKREVNO
		JNZ	SKIFACE_1A	; Jump to error if bad layout rev

		CMP	KBSRV.XGREVNO,SKREVNO
		JNZ	SKIFACE_1A	; Jump to error if bad macro rev

		PUSH	ES

		MOV	AX,KBINT.KBSEG 	; Exchange key layout table
		MOV	ES,AX		; ES points to KBINT data segment
		MOV	DI,KBINT.DGOKEYTAB
		MOV	SI,OFFSET DATA:KEYTAB
		MOV	CX,(128*11)	; 128 eleven byte entrys

SKIFACE_3:	MOV	AL,ES:[DI]	; Exchange one byte
		MOV	AH,[SI]
		MOV	ES:[DI],AH
		MOV	[SI],AL

		INC	SI		; Point to next bytes
		INC	DI
		LOOP	SKIFACE_3

		MOV	AX,KBSRV.XGSEG	; Exchange XLATE table
		MOV	ES,AX           ; ES points to KBSRV data segment
		MOV	DI,KBSRV.DGOXLATE
		MOV	SI,OFFSET DATA:XLATE
		MOV	CX,(2048*2)	; 2048 two byte characters

SKIFACE_4:	MOV	AL,ES:[DI]	; Exchange one byte
		MOV	AH,[SI]
		MOV	ES:[DI],AH
		MOV	[SI],AL

		INC	SI		; Point to next bytes
		INC	DI
		LOOP	SKIFACE_4

		POP	ES		; Restore local ES

SKIFACE_EXIT:	POP	DI		; Restore general registers
		POP	SI
		POP	CX
		POP	BX
		POP	AX

		RET

SKIFACE		ENDP
		PAGE

; Load a key profile into local arrays from name at DI

		PUBLIC	SKPRELOAD	;
SKPRELOAD	PROC	NEAR		; Load keyboard from file DS:DI
		PUSH	AX		; Do not desturb
		PUSH	BX		;
		PUSH	CX		;
		PUSH	DX		;

		MOV	AX,03D00H	; Open file for reading
		INT	21H		; DOS 2 open
		JC	LOADERR		; File not available

		MOV	SKHANDLE,AX	; Save file handle

		MOV	AX,04200H	; lseek from beginning of file
		MOV	BX,SKHANDLE	;
		MOV	CX,0		; File offset 128
		MOV	DX,128		;
		INT	21H		;
		JC	LOADERR		; Something rotten in PRELOAD

		MOV	AX,03F00H	; Read file
		MOV	BX,SKHANDLE	;
		MOV	DX,OFFSET KEYTAB;
		MOV	CX,(128*11)	;
		INT	21H		;
		JC	LOADERR		;

		MOV	AX,04200H	; lseek from beginning of file
		MOV	BX,SKHANDLE	;
		MOV	CX,0		; File offset 2048
		MOV	DX,2048		;
		INT	21H		;
		JC	LOADERR		; Something rotten in PRELOAD

		MOV	AX,03F00H	; Read file
		MOV	BX,SKHANDLE	;
		MOV	DX,OFFSET XLATE	;
		MOV	CX,(2048*2)	;
		INT	21H		;
		JC	LOADERR		;

		MOV	AX,03E00H	; Close the file
		MOV	BX,SKHANDLE	;
		INT	21H		;

		XOR	AX,AX		; No error.

LOAD_OK:	POP	DX		;
		POP	CX		;
		POP	BX		;
		POP	AX		;

		RET			; Return w/ carry set

LOADERR:	MOV	SLVERR,SKERRP	; Profile problem
		JMP	LOAD_OK		; But then normal exit

SKPRELOAD	ENDP
		PAGE

; Load local key profile from standard place

		PUBLIC	SKINIT
SKINIT		PROC	NEAR

		MOV	DX,OFFSET SKPROFILE
		JMP	SKPRELOAD

SKINIT		ENDP

		|			; End of dropped code

		PUBLIC	SKINIT, SKPRELOAD, SKIFACE

SKINIT		LABEL	NEAR
SKPRELOAD	LABEL	NEAR
SKIFACE		LABEL	NEAR

DUMMY		PROC	NEAR
		RET	
DUMMY		ENDP

CODE		ENDS

		END
