	NAME	BEEP
  	INCLUDE PAGESIZE.INC
	TITLE	.BEEP - BEEP, CLICK, and terminal ALARM 
DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU
	EXTRN	AUXST:BYTE
DATA	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE

	PUBLIC	BEEP
BEEP	PROC	NEAR
	MOV	AX,14*256+7	; ASCII bell and TTY output request
	MOV	BX, 0*256+7	; Good color and page for sound...?
	INT	10H		; BIOS video call
	RET			;
BEEP	ENDP
	PAGE
	PUBLIC	CLICK
CLICK	PROC	NEAR
	PUSHF				;
	PUSH	AX			; Save the temps
	PUSH	CX

	TEST	AUXST,M$CLIK		; Is this supposed to be noisey
	JZ	CLX			; No, skip it.

	MOV	AL,10110110B		; Timer 2, LSB, MSB, BINARY
	OUT	43H,AL			; Timer mode register
	MOV	AX,53H*20		; 500 Hz tone
	OUT	42H,AL			;  LSB
	MOV	AL,AH			;
	OUT	42H,AL			;  MSB

	IN	AL,61H			; Get current state
	MOV	AH,AL			; Save so it can be restored
	AND	AH,0FCH			; With the timer/beeper off.

	MOV	CX,2000			; A nice time constant

	OR	AL,3			; Add in the timer gate and enable
	OUT	61H,AL			; B L E E P...

XYZZY:	LOOP	XYZZY			; A short time delay

	MOV	AL,AH			; Restore previous state
	OUT	61H,AL			;

CLX:	POP	CX			;
	POP	AX			;
	POPF				;

	RET				;

CLICK	ENDP

	PUBLIC	TWOCLICK		; Double the fun!
TWOCLICK PROC	NEAR		
	PUSH	CX
	CALL	CLICK		
	MOV	CX,5000
TWCL:	LOOP	TWCL
	CALL	CLICK
	POP	CX
	RET

TWOCLICK ENDP
	PAGE
	PUBLIC	ALARM
ALARM	PROC	NEAR
	TEST	AUXST,M$ALRM	; Is the alarm on?
	JZ	AL0		; No, be quiet.

	CALL	BEEP

AL0:	RET

ALARM	ENDP

CODE	ENDS

	END
