	NAME	RESIDENT
	TITLE	.RESIDENT -  Resident manager, RESMAN and KFAKE
	INCLUDE	PAGESIZE.INC
	INCLUDE	SKFLAG.INC

DATA	SEGMENT	PUBLIC BYTE
	ASSUME	DS:DATA
	INCLUDE	PUBLICS.EQU

;  3-12-86	Added support for selectable "HOT KEY"
;  1-31-86      Added support for EGA mult char sets
; 10-21-85	Install ENABLE/DISABLE Emulator Request function
;  7-28-85       Made it save the INT 16 vector and not destroy it
;  5-22-85	Added in support for SKDRIVER
; Note: OKBSRV is in module KEYBOARD not PUBLICS.
;  3-1-85	EMU2 label moved

	EXTRN	RESFLG:BYTE,	LAST:WORD,	SLVERR:BYTE,	PREFLG:BYTE
	EXTRN	OKBD:DWORD,	OKBSRV:DWORD,	MEMTAB:BYTE,	OSTACK:WORD
	EXTRN	A_INT16:BYTE,	A4SCANC:BYTE,	NORESDNT:BYTE,	BKBSVR:DWORD
	EXTRN	ENADIS:BYTE,	SAVE_AREA:DWORD, IBMEGA:BYTE,	DYNAMIC_SA:DWORD
	EXTRN	CHAR_SEL:BYTE,	EMULSW:BYTE,	HOTKEY:BYTE

JMPADR	DD	0		; address of old INT10
	IF	SKFLAG
RESLOCK	DB	0
	ENDIF

DATA	ENDS

CSTACK	SEGMENT	STACK 'DGROUP'
	EXTRN	INSP:WORD
CSTACK	ENDS

CODE	SEGMENT	PUBLIC BYTE
	ASSUME	CS:CODE
	EXTRN	INKEY:NEAR,	BIOSKY:NEAR,	EXIT:NEAR,	E78I:NEAR
	EXTRN	XFILES:NEAR

	PUBLIC	RESMAN
RESMAN	PROC	NEAR
	CMP	NORESDNT,0	; Is residence allowed
	JZ	RES0

	MOV	SLVERR,SE$MEM	; Too many screens to go resident
	RET

RES0:	CMP	RESFLG,0	; Is nothing already resident?
	JZ	RES1		; Not yet, go ahead

	MOV	SLVERR,NF$AR	; Already resident error message

	RET			; Return with nothing done

RES1:	CMP	PREFLG,0	; Is there already one resident emulator?
	JZ	RES2		; No, all is well

	MOV	SLVERR,SE$N2	; Attempt to make number 2 resident.
	RET			;

; Update OKBSRV with address of 'NEW' keyboard service routine so that
;   when KYRLSE is called the new routine will replace the original 
;   routine...But don't destroy the original

RES2:	MOV	AX,WORD PTR OKBSRV[0]
	MOV	WORD PTR BKBSVR[0],AX

	MOV	AX,WORD PTR OKBSRV[2]
	MOV	WORD PTR BKBSVR[2],AX

	MOV	WORD PTR OKBSRV[0],OFFSET KFAKE
	MOV	WORD PTR OKBSRV[2],CS

	IF	SKFLAG

; [sk]  Copy previous interrupt header into spot just before KFAKE
; [sk]  So that SKSAVE/LOAD can find their parts of SKDRIVER

	PUSH	ES		; [sk] Save the segments
	PUSH	DS		; [sk]
	XOR	AX,AX		; [sk] ES points to INT vectors
	MOV	ES,AX		; [sk]
	MOV	AX,CS		; [sk] DS points to code seg data
	MOV	DS,AX		; [sk]

	LES	SI,DWORD PTR ES:[16H*4] ; [sk] Point to existing header
	MOV	DI,OFFSET KFAKE	     	; [sk] And to new header

	MOV	CX,256		; [sk] Number of bytes in the header

RES2A:	DEC	SI		; [sk] Point to next source
	DEC	DI		; [sk] Destination

	MOV	AL,ES:[SI]	; [sk] Move one byte
	MOV	[DI],AL		; [sk]
	LOOP	RES2A		; [sk] Until all moved

	POP	DS		; [sk] Restore changed segments
	POP	ES		; [sk]

	ENDIF

	CMP	IBMEGA,1	; Is an EGA installed
	JZ	INIT_SAV
	JMP	R1

INIT_SAV:
	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX
	MOV	BX,04A8H	; BIOS pointer to save area of pointers
	LES	BX,DWORD PTR ES:[BX]	; Make ES:BX point to actual save area...load pointer
	LES	BX,DWORD PTR ES:[BX+4]	; Load the dynamic save area pointer into ES:BX
	MOV	AX,ES		; Get the segment value into AX
	OR	AX,BX		; Is ES:BX setup for any value
	JNZ	R1A		; Jump if ES:BX is setup for something

	PUSH	DS		; Save the "PUBLICS" DS on the stack
	MOV	CX,16		; We will be moving 8 DWORDS...16 DW's

	XOR	AX,AX		; Point ES to the BIOS ram segment
	MOV	ES,AX

	MOV	BX,04A8H	; BIOS pointer to save area of pointers
	LES	BX,DWORD PTR ES:[BX]	; Make ES:BX point to actual save area...load pointer

	PUSH	ES		; Move ES into DS
	POP	DS

	MOV	SI,BX		; Point DS:[SI] to the Source of the move
				; ie...old save area pointers

	POP	ES		; Get "PUBLICS" DS into ES
	PUSH	ES		; Put it back on the stack

	MOV	DI, OFFSET SAVE_AREA	; ES:[DI] points to the "PUBLICS" SAVE_AREA
	REP	MOVSW			; Move all the words into area

	XOR	AX,AX		; Point ES to the BIOS ram segment
	MOV	ES,AX

	MOV	DI,04A8H	; BIOS pointer to save area of pointers

	LEA	AX,SAVE_AREA	; Get the displacement of save area

	CLI			; Don't disturb 
	STOSW			; Put this into BIOS save pointer
	
	POP	DS		; Get the "PUBLICS" DS Segment value in AX
	MOV	AX,DS

	STOSW			; Put this into BIOS save pointer

	PUSH	DS		; Copy the DS into the ES
	POP	ES

	LEA	DI,SAVE_AREA+4	; ES:[DI] points to dynamic save area pointer	
	LEA	AX,DYNAMIC_SA	; AX is displacement of our save area
	STOSW			; Update our dynamic save area pointer

	MOV	AX,DS		; Get the "PUBLICS" DS Segment value in AX
	STOSW			; Update our dynamic save area pointer
R1A:	POP	ES
	STI			; Turn them on for an instruction

; replace old int 10 if EGA, to trap a couple of different calls
; to be able to restore the right character font

	PUSH	ES
	XOR	AX,AX
	MOV	ES,AX
	MOV	DX,ES:[10H*4]	        ; offset address of INT10 vector
	MOV	WORD PTR JMPADR,DX	; save it
	MOV	DX,ES:[10H*4+2]	        ; segment address of INT10
	MOV	WORD PTR JMPADR+2,DX	; save it

	CLI			; no interrupts, please
	MOV	DI,[10H*4]	; address of int10 vector, offset
	LEA	AX,INT10E	; offset of new routine
	STOSW 			; save in int 10 vector
	MOV	AX,CS		; segment
	STOSW			; save in int 10 vector
	STI
	POP	ES

R1:	MOV	RESFLG,1	; I am here!
	MOV	SLVERR,SE$RR	; Resident at last!
	RET			; Should never get here...

; the new int 10
INT10E:	PUSH	DS

	PUSH	AX
	MOV	AX,DATA
	MOV	DS,AX
	POP	AX

       	CMP	EMULSW,1	; are we emulation
	JE	IN10E2		; bypass if yes

       	CMP	AH,0		; is this a set_mode call
	JNE	IN10E1		; jmp if not

	MOV	CHAR_SEL,0	; reset char_select
IN10E1:	CMP	AH,11H		; is this a char gen rtn
	JNE	IN10E2		; jmp if not

	CMP	AL,3		; is it set block
	JNE	IN10E2		; jmp if not
	MOV	CHAR_SEL,BL	; save block specifier

IN10E2:	POP	DS
       	JMP	CS:JMPADR	; goto standard int 10

RESMAN	ENDP
	PAGE
;
; The following structure must be immediately before the KFAKE entry
; point to allow direct access to E78 from file transfer & screen I/O
; routines.  Do not modify the basic structure of this data area.
; If additions are to be made they should preceed this block of data.
;
	DW	OFFSET CODE:XFILES	; Offset of file transfer servers
	PUBLIC	IOK, GREVNO, AUXREV	; 
IOK	LABEL	WORD			; Magic numbers used to verify res.
	DW	"IR"			;
	DW	"MA"			;
	DW	"Ok"			;
GREVNO	LABEL	WORD			;
	DW	0147H			; Revision number
AUXREV	LABEL	WORD
	DW	0000H			; Aux Revision Number

	IF	SKFLAG

; [sk]  This block filled with previous interrupt segment header from
; [sk]  SKDRIVER

	DB	256 DUP(0)		; [sk] Allocate some space

; [sk] End of interrupt header block


	ENDIF

;
	PUBLIC	KFAKE
KFAKE	PROC	FAR
	STI

	PUSH	DS
	PUSH	AX

	MOV	AX,DATA		; Set up data segment
	MOV	DS,AX		;

				; Test for residency
	CMP	RESFLG,2	; Are we already running the emulator?
	JZ	KF1		; Yes, not much to do...

	IF	SKFLAG

 	CMP	RESLOCK,1	; [sk] Are we turned off?
	JZ	KF1		; [sk] Yes, skip the shift in stuff

	ENDIF

	MOV	AH,2		; Get current shift status
	CALL	BIOSKY		; BIOS keyboard call

	AND	AL,0FH		; Are these my shift keys?
	CMP	AL,HOTKEY	;
	JNZ	KF1		; No, nothing fancy now...

EMU2:	MOV	RESFLG,2	; Set the emulator active status

	XOR	AX,AX		; Get current stack pointer
	ADD	AX,SP		; Execute E78I with internal not
	MOV	OSTACK[0],AX	; user supplied stack!
	MOV	AX,SS		;
	MOV	OSTACK[2],AX	;

	CLI			; Disable interrupts during stack munch

	MOV	AX,CSTACK	; Set local stack segment
	MOV	SS,AX		;
	MOV	AX,OFFSET INSP	; Initial stack pointer
	MOV	SP,AX		;

	STI			; Interrupts away!

	CALL	E78I		; EMULATE!

	CLI			; Reset stack to outside parameters

	MOV	AX,OSTACK[2]	; Segment
	MOV	SS,AX		;
	MOV	AX,OSTACK[0]	; Offset
	MOV	SP,AX		;

	STI			; Interrupts again, outer stack

	MOV	RESFLG,1	; Emulator is not active now...

KF1:	POP	AX		; Restore call value

	CMP	A_INT16,1	; Is pass through enabled
	JNE	KFMOD
	CMP	AH,0		; get key request?
	JNE	KFMOD
	PUSH	AX
	CALL	BIOSKY

	CMP	AL,A4SCANC	; Hot-shift from INT 16 PASS-THROUGH?
	JE	SHORT EMU2	; Execute Emulator now!!!!!!

	ADD	SP,2		; Get rid of unwanted AX on the stack
	POP	DS		; Restore the data segment
	RET	2

KFMOD:	CMP	AH,0		; Is this a sit and wait call?
	JZ	KF2		; Yes, fake it.

	CMP	AH,4		; Is this supposed to be illegal?
	JZ	IRMAOK		; Yes, send out the message

	CMP	AH,5		; Is this an emulator request?
	JZ	EMU		; Yes, do it!

	CMP	AH,6		; Is this for a memory table pointer?
	JZ	MPTR		; 

	CMP	AH,8		; Is this a DISABLE Emulator Request ?
	JZ	DISABLE

	CMP	AH,9		; Is this an ENABLE Emulator Request ?
	JZ	ENABLE	

	IF	SKFLAG

	CMP	AH,7		; [sk] Turn on/off resident lockout
	JZ	QLOCK		; [sk]

	ENDIF

	CMP	AH,2		; Is this a shift status test ??
	JNE	KFKA

	CALL	BIOSKY
	POP	DS
	IRET

KFKA:	CALL	BIOSKY		; Unmodified BIOS keyboard routine

	JMP	SHORT KFC	; Return to caller, flags intact.

KF2:	MOV	AH,1		; Get key state (zero if key pending)
	INT	RXIVC		; With escape state test...
	JZ	KF2		; Loop here until key arrives

	MOV	AH,0		; Get the key
	CALL	BIOSKY		;

KFC:	POP	DS		; Restore internal registers
	RET	2		; And return the answer

IRMAOK:	MOV	AX,CS:IOK[0]	; Send a coded message back...
	MOV	BX,CS:IOK[2]	;
	MOV	CX,CS:IOK[4]	; Note: lower case K
	MOV	DI,WORD PTR OKBD[0] ; Pointer to primitive keyboard
	MOV	SI,WORD PTR OKBD[2] ;
	JMP	SHORT KFC	; Exit.

EMU:	MOV	AH,1		; Return w/ keyboard status just for fun..
	PUSH	AX		; 
	JMP	EMU2		; And pretend the shift keys just pressed.

MPTR:	MOV	AX,SEG MEMTAB	; Setup ES
	MOV	ES,AX		;

	MOV	BX,OFFSET MEMTAB; Make the pointer to memory allocation block
	JMP	SHORT KFC	;
	
ENABLE:	MOV	ENADIS, 0	; Allow the emulator to work again
	JMP	KFC

DISABLE: MOV	ENADIS, 0FFH	; Disallow the from running 
	JMP	KFC
	
	IF	SKFLAG

QLOCK:	TEST	AL,AL		; [sk] Set Z flag
	MOV	AL,0		; [sk]
	JZ	QLOCK1		; [sk]

	INC	AL		; [sk] Non-zero becomes 1

QLOCK1:	MOV	RESLOCK,AL	; [sk] Save the lock flag
	JMP	SHORT KFC	; [sk]

	ENDIF

KFAKE	ENDP

CODE	ENDS

	END
