	NAME	PUBLICS
	INCLUDE	PAGESIZE.INC
	TITLE	.PUBLICS - Public variables for E78 1.40

;
; 5-01-85	Added IBM EGA Switches to replace code patches
; 4-27-85	Added support for Hercules Monochrome Graphics card
; 4-27-85	Added in byte to disable light pen see LPEN.ASM 
; 3-20-85	Int 16 Passthrough
; 3-1-85	Added Ericsson PC
; 2-5-85	Final IRMAvision changes
; 1-22-85	IRMAvision addition
; 9-24-84	Final PC fix
; 9-5-84	LPEN fix
; 8-23-84	PC fix
; 7-18-84	1st pc fix
;

DATA	SEGMENT	PUBLIC BYTE
	INCLUDE	PUBLICS.EQU
	PUBLIC	CURSOR,	CURLIN,	BGLIN,	BGCNT0,	BGCNT1,	BGCNT2,	BGCNT3,
	PUBLIC	STATUS,	AUXST,	SLVERR,	CRTBASE,MONOFLG,REDO,	ATTRIB,
	PUBLIC	COLROW,	PRVATR,	EQPFLG,	KERING,	CTTCUR,	LPOFS,	LPBNC,
	PUBLIC	LSADDR,	BSADDR,	ATRSAV,	OPSC,	OKBD,	FCB0,	FCB1,
	PUBLIC	PREFLG,	FILEBUF,NOFILE,	RESFLG,	VMODE,	CMODES,	FKEYS,
	PUBLIC	SCANCK,	SFKEY1,	SFKEY2,	SFKEY3,	SFKEY4,	SFKEY5,	SFKEY6,
	PUBLIC	SFKEY7,	SFKEY8,	SFKEY9,	SFKEY10, FKEY1,	FKEY2,	FKEY3,
	PUBLIC	FKEY4,	FKEY5,	FKEY6,	FKEY7,  FKEY8,	FKEY9,	FKEY10,
	PUBLIC	COMLIN,	COMARP,	SWITCH,	MAXMEM,	CACPOS,	CACTYP,	CAVMOD,
	PUBLIC	CACPAG,	CACHE,	CASIZE,	VPARM,	OTICK,	TIMEOD,	TIMMAX,
	PUBLIC	TICTIM,	STATSW,	NBUF,	RBUF,	SELMEM,	MEMTAB,	OSTACK,
	PUBLIC	EAGLE,	TTYPE,	CHARST,	TOPLIN,	PCURSR,	TOPSET,	MAGIC1,
	PUBLIC	MAGIC2,	HORB26,	NONEVR,	COMRUN,	COMCLIK,RESQIK, NOATRS,
	PUBLIC	OLDLIN,	SIMAGE,	LPDLY,	MODSIZ,	MONB26, CACSHP, ILETTE, 
	PUBLIC	SFKEYS,	SFKBUF,	SFKPRES,	LINOFF,	FILEBF1,LINECNT,
	PUBLIC	ALTMOD1,ALTMOD2,ALTM21, ALTM22, ERICCRT,ERICKEY
	PUBLIC	ALTVMD, SAVEMD, FILE_READ_FLAG, LASTFD
	PUBLIC  LPENFG, ATFLAG,	MACHINE, ALTEXIT,STLINE,BUFEND,	SCRNMOD
	PUBLIC	INITMOD,STATLIN,CMODES2, DISLIN, SCRN_SEG
	PUBLIC	A_INT16,A4SCANC,DISABLP, DISAPL, DISEAB, HORZBAR, STLNAT
	PUBLIC	ALTMOD3, ALTM31, HEPAGE1, HEMOD, HEMOD2, IBMEGA,  IBMEGAM


MAGIC1	DW	3141H		; Magic number used by E78GEN

OSTACK	DD	0		; Place to save incoming stack pointer/seg

FCB0	DB	48 DUP(0)	; Main file control block

FCB1	DB	48 DUP(0)	; IRMA.RMA file control block

FILEBUF	DB	512 DUP(0)	; File transfer area
FILEBF1	DB	10 DUP(0)	; IRMA.RMA file transfer area

COMLIN	DB	128 DUP(0)	; Command line arguments

COMARP	DW	0		; Pointer into command used by GETCOM

SWITCH	DW	2 DUP(0)	; Switches associated with current argument

MAXMEM	DW	0		; Maximum address in data segment

PREFLG	DB	0		; Non-zero if resident emulator is active
RESFLG	DB	0		; Non-zero if program has gone resident.
				;  1 if program is resident but not exec
				;  2 if program is in control
	PAGE
NOFILE	DB	0		; Zero if a file name was supplied on start
				; One if no file, or resident
OPSC	DD	0		; Print screen INT vector save
OKBD	DD	0		; Keyboard     INT vector save
OTICK	DD	0		; Clock tick   INT vector save

TIMEOD	DD	99900000H	; Current time accumulation register
TIMMAX	DD	0		; Maximum key click disable time
TICTIM	DD	00000549H	; Each tick of the clock is .0550 second

PCURSR	DW	0		; Physical display cursor (Buffer rel)
CURSOR	DW	0		; Current cursor byte position (Screen rel)
CURLIN	DB	0		; Current display line (0-24)
OLDLIN	DB	0		; Last 'current' line actually updated

STLINE	DW	1920		; Status line start
BUFEND	DW	2000		; Buffer end location
STATLIN	DW	25		; Status line in units of character rows

;  GENX option byte must be set to non-1 for OLD WAY.
LPENFG  DB      1		; GENX. If 1, then protected fields ignored
LASTFD  DB	0		; Storage for lpen attribute character
LPOFS	DB	2,2,4,4,2,2,3	; Light pen processing offsets per VMODEs
LPBNC	DB	0		; Light pen debounce control byte
LPDLY	DB	0		; Used by TIMER for LPEN debounce delay
DISABLP	DB	0		; Used by LPEN.ASM to disable this routine [4-85]

CHARST	DB	0		; Current character set number
TOPLIN	DW	0		; Offset to top screen line in IRMA buffer
MODSIZ	DW	0		; Size of SCREEN DOWN key offset
TOPSET	DB	0		; Countdown of SCRNFX launch 

BGLIN	DB	0		; Current background line
 BGCNT0	DB	0		; Background activity counter 0
 BGCNT1	DB	0		;                             1
 BGCNT2	DB	0		;                             2
 BGCNT3	DB	0		;                             3

STATSW	LABEL	WORD		; Get the whole status as one word
STATUS	DB	0		; Main controller status bits
AUXST	DB	0		; Auxilliary status word

SLVERR	DB	0		; Slave processor error code

SCRN_SEG DW	?		; Screen segment storage
CRTBASE	DW	0		; Base address of current CRT controller
ILETTE	DB	0		; Set non-zero to disable timeouts

	PAGE
; The following five flags control the video process routines
; 
; These variables are AUTOMATICALLY properly initialized if E78 is run
; in an IBM PC or PC XT.  The user may be required to pre-initialize the
; state of these variables if E78 is used in a non-IBM enviroment such
; as the EAGLE 1600 series or other machines with 8086 CPUs or different
; display adapter requirements (INCLUDING IRMAvision).
;
; SCRNMOD is initialized to zero to indicate standard display adapter
; cards.  With IRMAvision SCRNMOD can be set to 2,3,4,or 5, indicating
; 3278 mod 2,3,4, or 5 emulation with the approptiate screen size
; displayed.
;
; INITMOD is set to the value of SCRNMOD in module INIT.ASM.  INITMOD
; will remain constant while SCRNMOD can be changed during operation
;
; SCANCK when non-zero forces screen updates to wait for horizontal
; sync time.  This is required for IBM color adapters and some non-IBM
; display adapters.
; 
; MONOFLG when changes the attribute selection table used 
; depending on display adapter present.  This entry is set based
; on the BIOS EQUIPFLG word and cannot be pre-initialized.
;
; EAGLE forces certain routines which on 8088 machines use word access
; to the screen or IRMA to use byte access modes.  This cures anomalys
; caused by using an 8086 with the 8 bit IBM-PC I/O buss.
; If your machine is an EAGLE 1600 or other such 8086 machine this flag
; *MUST* be pre-initialized to 1 for proper operation of E78.
; This particularly affects screen attributes and save/restore of screens
; when E78 is operated as a resident task.

SCRNMOD DB	0	; Non-zero to use special features of IRMAvision
INITMOD	DB	0	; INITMOD set to the value of SCRNMOD on entry
SCANCK	DB	0	; Non-zero if scan line sync required
MONOFLG	DB	0	; Display status flag (Monochrome flag)
EAGLE	DB	0	; Set this to 1 if EAGLE 1600 special code 
ALTMOD1	DB	0	; sperry
ALTMOD2	DB	0	; oliv
ALTMOD3	DB	0	; Hercules board in use Select flag [KA]
HEPAGE1	DB	0	; Switch to Hercules page 1 toggle [KA]
HEMOD	DB	0	; Save area for Hercules Video mode [KA]
HEMOD2	DB	0	; Save area for Hercules Video Mode [KA]
ERICCRT	DB	0	; Ericsson cursor fix
ERICKEY	DB	0	; Ericsson keyboard LED fix
ALTEXIT DB	0	; 0 if init, 1 if exit. 
ALTVMD	DB	0	; If 1, save current video mode below
SAVEMD	DB	0	; Original video mode
A_INT16	DB	0,0	; If 1, then allow INT 16 passthrough.
			;  If 2nd byte=1, do Hot_Shift entry/exit.
A4SCANC	DB	28,00	; Alternate Hot-Shift key for INT 16,  cntl \
			;   Only first byte is valid, is PC scan code.

; Alternate modes for crt setup
ALTM21	DB	0,1,2,3,24H,25H,26H,27H,8,29H,10,11,12,13,14,15
ALTM22	DB	71H,50H,5AH,0CH,9BH,8CH,1AH,9BH,02,8EH,0,0,0,0,0,0

; Alternate mode of setup for Hercules Monochrome Graphics 
ALTM31	DB	61H,50H,52H,0FH,19H,06H,19H,19H,02H,0DH,0BH,0CH	; Text [KA]
	DB	35H,2DH,2EH,07H,5BH,02H,57H,57H,02H,03H,00H,00H	; Graphics [KA]

; The following flags are noramlly zero, but may be set non-zero by user 
; preference.   HORB26 when non-zero causes the initialization code for
; color screens to not display the horizontal bar, and forces the status
; line back up to line 25.  This may be neccessary on some non-IBM display
; or display/adapter combinations to make the status line appear properly.
; NONEVR when set to a non-zero value causes non-display fields to be 
; never displayed even if 'display attributes' is selected.  This flag
; should be set non-zero when privledged information may be placed in non-
; display fields and the terminal is not in a physically secured location.
; COMRUN, when set non-zero enables the interrupt service driver for COM1:
; to allow input from RS-232 devices.  E78 assumes that COM1: has been 
; initialized to the desired state (baud,parity,etc.) by a user supplied
; MODE command issued to DOS.  COMCLIK enables keyboard 'clicker' to sound
; on characters entered through COM1:.  Setting RESQIK non-zero causes E78
; to become resident immediately on execution and exit

HORB26	DB	0		; Disable horizontal bar & line 26 (color )
MONB26	DB	1		; Request fake horizontal bar for monochrome
NONEVR	DB	0		; Never display Nondisplay type fields
COMRUN	DB	0		; Enable COM1: data input code
COMCLIK	DB	1		; Enable keyboard clicker for COM1: chars
RESQIK	DB	0		; Make E78 auto-resident
	PAGE
REDO	DB	0		; Background update control byte....

TTYPE	TTREC	<TKTPR,TMMOD2,0>; Mod 2 w/ APL KEYBOARD

SFKEYS	LABEL	WORD		; Used as indexed entry to function key table

SFKEY1	FKDEF	<0,2>		;    shifted	1 user defined function key
SFKEY2	FKDEF	<0,2>		; Function keys	2 user defined function key
SFKEY3	FKDEF	<0,2>		;		3 user defined function key
SFKEY4	FKDEF	<0,2>		;		4 user defined function key
SFKEY5	FKDEF	<0,2>		;		5 user defined function key
SFKEY6	FKDEF	<0,2>		;		6 user defined function key
SFKEY7	FKDEF	<0,2>		;		7 user defined function key
SFKEY8	FKDEF	<0,2>		;		8 user defined function key
SFKEY9	FKDEF	<0,2>		;		9 user defined function key
SFKEY10	FKDEF	<0,2>		;		10 user defined function key

SFKBUF	DB 700 DUP (0)		; Buffer to read user defined function keys into
SFKPRES	DB	0		; Flag to tell which shift function key was pressed
LINOFF	DW	0		; Position in user defined key we left off in
LINECNT	DB	0		; Counter of lines in IRMAFIL module
FILE_READ_FLAG	DB	0	; Flag to let the program know not to read the IRMA.RMA file again

FKEYS	LABEL	WORD		; Used as indexed entry to function key table

FKEY1	FKDEF	<0,3>		; Function key	1 color modes
FKEY2	FKDEF	<0,2>		; 		2 attribute display on/off
FKEY3	FKDEF	<0,2>		;		3 null fill unprot  on/off
FKEY4	FKDEF	<>		;		4
FKEY5	FKDEF	<>		;		5
FKEY6	FKDEF	<>		;		6
FKEY7	FKDEF	<>		;		7
FKEY8	FKDEF	<>		;		8
FKEY9	FKDEF	<>		;		9
FKEY10	FKDEF	<0,2>		;		10 response clock on/off

ATTRIB	DB	0		; Current display attribute
COLROW	DW	80		; 'Constant' for columns per row
DISLIN	DB	25		; 'Constant' for lines displayed on screen
	PAGE
NOATRS	DB	0		; Flag used to check for attribute-less screen
PRVATR	DB	45 DUP(7)	; Previous attribute storage
ATRSAV	DB	45 DUP(0C0H)	; Raw attribute save
				; Used to make NON-DISPLAY type characters
VPARM	VIDEOP	<>		; Video parameters stolen from BIOS (40x25c)
	VIDEOP	<>		; 80x25 color
	VIDEOP	<>		; Graphics
 	VIDEOP	<>		; 80x25 monochrome,also 80x26 IRMAvision
	IV3OP   <>		; 80x34 IRMAvision monochrome
	IV4OP   <> 		; 80x45 IRMAvision monochrome
	IV5OP   <> 		;132x29 IRMAvision monochrome

CMODES	DB	2CH,28H,2DH,29H,2AH,2EH,1EH,29H ; Used to setup CRT ctrl
	DB	2CH,28H,2DH,29H	; 4 extra for ALT pc

CMODES2 DB	00H,00H,04H,14H,14H,64H  ; Used to set CRT mode 2 on IRMAvision

VMODE	DB	0		; Current display mode (BIOS type number)

EQPFLG	DW	0		; Equipment check flag

NBUF	DB	0		; Number of buffer active
				; Used as a temporary in init of buffers
RBUF	DB	0		; Number of active buffers
;
; The MEMTAB label identifies the base address of the structure table
; used to hold availability, address, and screen type information for
; each of the possible nine screen save memory buffers.  Structure 0
; is used to hold the current screen's MSMODE and MSRMOD only.
; Structures 1-9 hold all of the screen recall buffer information
; associated with the MEMTE structure definition (see PUBLICS.EQU).
;
MEMTAB	LABEL	BYTE		; Once per each possible memory
	REPT	MAXBUF+1	;   Memory table entry structure
	MEMTE	<>		;   plus 1 for normal screen
	ENDM

SELMEM	DB	0		; Memory/buffer currently selected
	PAGE
KERING	LABEL	WORD		; Scan code buffer
  	DW	0		;   Input pointer
	DW	0		;   Output pointer
KERSIZ	EQU	32		;     Maximum key ring size (bytes)
	DW	KERSIZ		;   Ring size
	DB	KERSIZ DUP(-1)	;   Actual data area
	PAGE
; CTTCUR is overwritten with current cursor control table by init code

CTTCUR	CTREC	<CTN,CPBOT,CPBOT> ; Normal cursor    (Underscore)
	CTREC	<CTN,CPTOP,CPTOP> ; Blinking cursor  (Overscore )
	CTREC	<CTN,CPTOP,CPBOT> ; Reverse cursor   (Block     )
 	CTREC	<CTN,CPBOT,CPMID> ; Reverse blinking (Half block)
	CTREC	<CTX>		  ; Inhibited cursors
	CTREC	<CTX>		  ;
	CTREC	<CTX>		  ;
	CTREC	<CTX>		  ;
	PAGE
LS	MACRO	LNO		; Line start address macro
	DW	(LNO-1)*80	;
	ENDM			;

	.SALL			; Suppress macro contents listing
LSADDR	LABEL	WORD		; Visible line start address table
	LS	25		;   Status line 
	LS	1		;
	LS	2		;
	LS	3		;
	LS	4		;
	LS	5		;
	LS	6		;
	LS	7		;
	LS	8		;
	LS	9		;
	LS	10		;
	LS	11		;
	LS	12		;
	LS	13		;
	LS	14		;
	LS	15		;
	LS	16		;
	LS	17		;
	LS	18		;
	LS	19		;
	LS	20		;
	LS	21		;
	LS	22		;
	LS	23		;
	LS	24		;
	LS	25		;
	LS	26		;
	LS	27		;
	LS	28		;
	LS	29		;
	LS	30		;
	LS	31		;
	LS	32		;
	LS	33		;
	LS	34		;
	LS	35		;
	LS	36		;
	LS	37		;
	LS	38		;
	LS	39		;
	LS	40		;
	LS	41		;
	LS	42		;
	LS	43		;
	LS	44		; Last LSADDR entry

	.XALL			; Turn macro contents back on

BS	MACRO	LN 		; Line start address macro
	DW	(LN-1)*80	;
	ENDM			;

	.SALL			; Suppress macro contents listing
BSADDR	LABEL	WORD		; Actual buffer start
	BS	1 		;   Status line
	BS	2		;
	BS	3		;
	BS	4		;
	BS	5		;
	BS	6		;
	BS	7		;
	BS	8		;
	BS	9		;
	BS	10		;
	BS	11		;
	BS	12		;
	BS	13		;
	BS	14		;
	BS	15		;
	BS	16		;
	BS	17		;
	BS	18		;
	BS	19		;
	BS	20		;
	BS	21		;
	BS	22		;
	BS	23		;
	BS	24		;
	BS	25		;
	BS	26		;
	BS	27		;
	BS	28		;
	BS	29		;
	BS	30		;
	BS	31		;
	BS	32		;
	BS	33		;
	BS	34		;
	BS	35		;
	BS	36		;
	BS	37		;
	BS	38		;
	BS	39		;
	BS	40		;
	BS	41		;
	BS	42		;
	BS	43		;
	BS	44		;
	BS	45		;

	.XALL			; Turn macro contents back on

	PAGE
CACPOS	DW	0		; Cursor position
CACTYP	DW	0		; Start and end cursor position

CAVMOD	DB	0		; Video mode

CACPAG	DB	0		; Active page

CASIZE	DW	0		; Current screen length (words)

CACHE	DB	26*80*2 DUP(?)	; Screen save cache & update check

SIMAGE	DB	29*132*2 DUP(0)	; Largest screen possible (color adapter)

CACSHP	DB	0		; Force cursor shape fix if non-zero

MACHINE	DB	0		; Machine ID byte

ATFLAG	DB	0		; Is This an IBM PC/AT    NZ=yes

DISEAB	DB	0		; Flag byte to disable EAB
DISAPL	DB	0		; Flag byte to disable APL character set
HORZBAR	DB	0		; Flag byte to disable horz bar
STLNAT	DB	07H		; Status line attribute...default white line
IBMEGA	DB	0		; Is IBM EGA attached
IBMEGAM	DB	0		; Is IBM EGA attached with Enhanced Monitor
MAGIC2	DW	5926H		; Magic number used by E78GEN

DATA	ENDS

	END
