/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	ldfcn.h,v $
 * Revision 4.2.2.2  91/12/05  14:14:39  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  17:09:22  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 4.2  91/09/20  05:16:20  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *       @(#)$RCSfile: ldfcn.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 91/12/05 14:14:39 $
 */
/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: /usr/sde/osf1/rcs/src/./usr/include/ldfcn.h,v 4.2.2.2 91/12/05 14:14:39 Jim_McHale Exp $ */

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 *	The following two declarations appear in the IH versions of
 *	"stdio.h" but do not appear in the normal 1.2 versions.
 */
#ifdef __mips__
long ftell();
char *fgets();
#endif /* __mips__ */

#ifndef _LDFILE
struct	ldfile {
	int		_fnum_;	/* so each instance of an LDFILE is unique */
	FILE		*ioptr;	/* system I/O pointer value */
	long		offset;	/* absolute offset to the start of the file */
	FILHDR		header;	/* the file header of the opened file */
#ifdef __mips__
	pCHDRR		pchdr;  /* pointer to the symbol table */
	long		lastindex; /* index of last symbol accessed */
	unsigned short	type;	/* indicator of the type of the file */
	unsigned	fswap : 1;	/* if set, we must swap */
	unsigned	fBigendian : 1;	/* if set, we must swap aux for the
					 * last retrieved symbol
					 */
#else
	unsigned short	type;		/* indicator of the type of the file */
#endif /* __mips__ */
};


/*
	provide a structure "type" definition, and the associated
	"attributes"
*/

#define	LDFILE		struct ldfile
#define IOPTR(x)	x->ioptr
#define OFFSET(x)	x->offset
#define TYPE(x)		x->type
#define	HEADER(x)	x->header
#define LDFSZ		sizeof(LDFILE)
#ifdef __mips__
#define PSYMTAB(x)	x->pchdr
#define SYMTAB(x)	(ldreadst(x, -1), x->pchdr)
#define SYMHEADER(x)	x->pchdr->hdr
#define PFD(x)		x->pchdr->pfd
#define LDSWAP(x)	x->fswap
#define LDAUXSWAP(x,ifd) (PFD(x)[ifd].fBigendian != x->fBigendian)
#define LDERROR(x,y,z)  fprintf(stderr,"libmld: x:"); fprintf (stderr, y, z);
#endif /* __mips__ */

/*
	define various values of TYPE(ldptr)
*/

#define ARTYPE 	0177545
#define ISARCHIVE(x) ((x) == ARTYPE)

/*
	define symbolic positioning information for FSEEK (and fseek)
*/

#define BEGINNING	0
#define CURRENT		1
#define END		2

/*
	define a structure "type" for an archive header
*/

typedef struct
{
	char ar_name[16];
	long ar_date;
	int ar_uid;
	int ar_gid;
	long ar_mode;
	long ar_size;
} archdr;

#define	ARCHDR	archdr
#define ARCHSZ	sizeof(ARCHDR)


/*
	define some useful symbolic constants
*/

#define SYMTBL	0	/* section nnumber and/or section name of the Symbol Table */

#define	SUCCESS	 1
#define	CLOSED	 1
#define	FAILURE	 0
#define	NOCLOSE	 0
#define	BADINDEX	-1L

#define	OKFSEEK	0

/*
	define macros to permit the direct use of LDFILE pointers with the
	standard I/O library procedures
*/

#include "obj.h"

typedef struct {
  LDFILE ldfile;
  pOBJ obj;
  int arfd;
  off_t aroffset;               /* offset to next archive header */
  ARCHDR archdr;
} elf32_LDFILE;

elf32_LDFILE *ldopen();
elf32_LDFILE *ldaopen();

#ifdef __mips__
/*LDFILE *ldinitheaders();*/
#endif   /* __mips__ */

#if 0
#define GETC(ldptr) getc(IOPTR(ldptr))
#define GETW(ldptr) getw(IOPTR(ldptr))
#define FEOF(ldptr) feof(IOPTR(ldptr))
#define FERROR(ldptr)   ferror(IOPTR(ldptr))
#define FGETC(ldptr)    fgetc(IOPTR(ldptr))
#define FGETS(s,n,ldptr)    fgets(s,n,IOPTR(ldptr))
#define FILENO(ldptr)   fileno(IOPTR(ldptr))
#endif
#ifdef ultrix
# ifdef FREAD
#  undef FREAD
# endif /* FREAD */
# define FREAD LDFREAD
#define LDFREAD(p,s,n,ldptr)    ldfread(p,s,n,ldptr)
#else  /* ! ultrix */
#define FREAD(p,s,n,ldptr)  ldfread(p,s,n,ldptr)
#endif /* ultrix */
#define FSEEK(ldptr,o,p)    ldfseek(ldptr,o,p)
/*fseek(IOPTR(ldptr),(p==BEGINNING)?(OFFSET(ldptr)+o):o,p)*/

#if 0
#define FTELL(ldptr)	ftell(IOPTR(ldptr))
#define FWRITE(p,s,n,ldptr)       fwrite(p,s,n,IOPTR(ldptr))
#define REWIND(ldptr)	rewind(IOPTR(ldptr))
#define SETBUF(ldptr,b)	setbuf(IOPTR(ldptr),b)
#define UNGETC(c,ldptr)		ungetc(c,IOPTR(ldptr))
#endif
#ifndef __mips__
#define STROFFSET(ldptr)	(HEADER(ldptr).f_symptr + HEADER(ldptr).f_nsyms * 18) /* 18 == SYMESZ */
#else /* __mips__ */
#define STROFFSET(ldptr)	(SYMHEADER(ldptr).cbSsOffset)
#endif /* __mips__ */
#endif
