/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	nan.h,v $
 * Revision 4.2.2.2  91/12/05  15:01:32  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:53:11  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 4.2  91/09/20  05:07:59  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/*
 *       @(#)$RCSfile: nan.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 91/12/05 15:01:32 $
 */
/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: /usr/sde/osf1/rcs/src/./usr/include/PMAX/nan.h,v 4.2.2.2 91/12/05 15:01:32 Jim_McHale Exp $ */
/* $Log:	nan.h,v $
 * Revision 4.2.2.2  91/12/05  15:01:32  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:53:11  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 3000.5.1.1  91/05/31  18:25:37  bettina
 * fix DFARS in copyright
 * 
 * Revision 3000.5  91/04/08  17:39:58  bettina
 * fix copyright
 * 
 * Revision 3000.4  91/04/08  13:53:13  bettina
 * update copyright
 * 
 * Revision 3000.3  91/02/17  14:44:46  karen
 * SVR4 changes
 * 
 * Revision 3000.2  90/12/10  13:52:42  zaineb
 * Ansi Changes
 * 
 * Revision 2020.2  90/03/12  17:04:20  bettina
 * 2.20 - add legend
 * 
 * Revision 2010.1  89/09/26  20:47:56  lai
 * updated to 2.10
 * 
 * Revision 1.3  89/09/21  14:46:36  bettina
 * updating copyright
 * 
 * Revision 1.2  89/07/19  15:10:33  lai
 * fix bug 4448
 * 
 * Revision 1.1  89/07/19  15:03:56  lai
 * Initial revision
 *  */

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _NAN_H
#define _NAN_H

/* Handling of Not_a_Number's (only in IEEE floating-point standard) */
#if _IEEE
typedef union 
{
         struct	
	 {
#ifdef __MIPSEL__
	    unsigned fraction_low:32;
            unsigned bits:20;
	    unsigned exponent :11;
	    unsigned sign     : 1;
#else
	    unsigned sign     : 1;
	    unsigned exponent :11;
            unsigned bits:20;
	    unsigned fraction_low:32;
#endif
         } inf_parts;
	 struct 
	 {
#ifdef __MIPSEL__
	    unsigned fraction_low: 32;
	    unsigned bits     :19;
	    unsigned qnan_bit : 1;
            unsigned exponent :11;
	    unsigned sign     : 1;
#else
	    unsigned sign     : 1;
            unsigned exponent :11;
	    unsigned qnan_bit : 1;
	    unsigned bits     :19;
	    unsigned fraction_low: 32;
#endif
         } nan_parts;
         double d;

} dnan; 

	/* IsNANorINF checks that exponent of double == 2047 *
	 * i.e. that number is a NaN or an infinity	     */
	
#define IsNANorINF(X)  (((dnan *)&(X))->nan_parts.exponent == 0x7ff)

	/* IsINF must be used after IsNANorINF		*
 	 * has checked the exponent 			*/

#define IsINF(X)  (((dnan *)&(X))->inf_parts.bits == 0 &&  \
                    ((dnan *)&(X))->inf_parts.fraction_low == 0)

	/* IsPosNAN and IsNegNAN can be used 		*
 	 * to check the sign of infinities too		*/

#define IsPosNAN(X)  (((dnan *)&(X))->nan_parts.sign == 0)

#define IsNegNAN(X)  (((dnan *)&(X))->nan_parts.sign == 1)

	/* GETNaNPC gets the leftmost 32 bits 		*	
	 * of the fraction part				*/

#define GETNaNPC(dval)   (((dnan *)&(dval))->inf_parts.bits << 12 | \
			  ((dnan *)&(dval))->nan_parts.fraction_low>> 20) 

#define KILLFPE()       (void) kill(getpid(), 8)
#define NaN(X)  (((dnan *)&(X))->nan_parts.exponent == 0x7ff)
#define KILLNaN(X)      if (NaN(X)) KILLFPE()

#else

typedef double dnan;
#define IsINF(X)   0
#define IsPINF(X)  0
#define IsNegNAN(X)  0
#define IsPosNAN(X)  0
#define IsNAN(X)   0
#define GETNaNPC   0L

#define Nan(X)  0
#define KILLNaN(X)
#endif

#endif /* _NAN_H */
