/*
 * @DEC_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log:	reloc.h,v $
 * Revision 4.2.2.2  91/12/05  15:02:21  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:38:12  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 4.2  91/09/20  05:07:07  devbld
 * 	Adding ODE Headers
 * 
 * $EndLog$
 */
/* sccsid = @(#)$RCSfile: reloc.h,v $ $Revision: 4.2.2.2 $ (DEC) $Date: 91/12/05 15:02:21 $  ULTRIX/OSF 1   */
/*
 * |-----------------------------------------------------------|
 * | Copyright (c) 1991, 1990 MIPS Computer Systems, Inc.      |
 * | All Rights Reserved                                       |
 * |-----------------------------------------------------------|
 * |          Restricted Rights Legend                         |
 * | Use, duplication, or disclosure by the Government is      |
 * | subject to restrictions as set forth in                   |
 * | subparagraph (c)(1)(ii) of the Rights in Technical        |
 * | Data and Computer Software Clause of DFARS 252.227-7013.  |
 * |         MIPS Computer Systems, Inc.                       |
 * |         950 DeGuigne Avenue                               |
 * |         Sunnyvale, California 94088-3650, USA             |
 * |-----------------------------------------------------------|
 */
/* $Header: /usr/sde/osf1/rcs/src/./usr/include/PMAX/reloc.h,v 4.2.2.2 91/12/05 15:02:21 Jim_McHale Exp $ */
#ifndef _RELOC_H
#define _RELOC_H

/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#if __mips__

#ifdef __LANGUAGE_C__
struct reloc {
    long	r_vaddr;	/* (virtual) address of reference */
    unsigned	r_symndx:24,	/* index into symbol table */
		r_reserved:3,
    		r_type:4,	/* relocation type */
		r_extern:1;	/* if 1 symndx is an index into the external
				   symbol table, else symndx is a section # */
    };
#endif /* __LANGUAGE_C__ */

#ifdef __LANGUAGE_PASCAL__
type
  reloc = packed record
      r_vaddr : long;			/* (virtual) address of reference    */
      r_symndx : 0..lshift(1, 24)-1;	/* index into symbol table	     */
      r_reserved : 0..7;
      r_type : 0..15;			/* relocation type		     */
      r_extern : 0..1;			/* if 1, symndx is an index into the */
					/* external symbol table, else	     */
					/* symndx is a section		   # */
      end {record};
#endif /* __LANGUAGE_PASCAL__ */

/*
 * Section numbers for symndex for local relocation entries (r_extern == 0).
 * For these entries the starting address for the section referenced by the
 * section number is used in place of an external symbol table entry's value.
 */
#define	R_SN_NULL	0
#define	R_SN_TEXT	1
#define	R_SN_RDATA	2
#define	R_SN_DATA	3
#define	R_SN_SDATA	4
#define	R_SN_SBSS	5
#define	R_SN_BSS	6
#define	R_SN_INIT	7
#define	R_SN_LIT8	8
#define	R_SN_LIT4	9
#define	R_SN_XDATA	10
#define	R_SN_PDATA	11
#define R_SN_FINI       12
#define MAX_R_SN        12

#else /* !defined(__mips__) */

struct reloc {
	long	r_vaddr;	/* (virtual) address of reference */
	long	r_symndx;	/* index into symbol table */
	unsigned short	r_type;	/* relocation type */
	};
#endif /* __mips__ */

/*
 *   relocation types for all products and generics
 */

/*
 * All generics
 *	reloc. already performed to symbol in the same section
 */
#define  R_ABS		0

/*
 * Mips machines
 *
 *	16-bit reference
 *	32-bit reference
 *	26-bit jump reference
 *	reference to high 16-bits
 *	reference to low 16-bits
 *	reference to global pointer reletive data item
 *	reference to global pointer reletive literal pool item
 */
#define	R_REFHALF	1
#define	R_REFWORD	2
#define	R_JMPADDR	3
#define	R_REFHI		4
#define	R_REFLO		5
#define	R_GPREL		6
#define	R_LITERAL	7
#define R_REL32         8
#define R_REFHI_64      9
#define R_REFLO_64      10
#define R_REFWORD_64    11
#define R_PC16	        12
#ifdef __osf__
#define	R_RELHI		13
#define	R_RELLO		14
#endif /* __osf__ */
#define R_REFSHFT       15
#define MAX_R_TYPE      15

/*
 * X86 generic
 *	8-bit offset reference in 8-bits
 *	8-bit offset reference in 16-bits 
 *	12-bit segment reference
 *	auxiliary relocation entry
 */
#define	R_OFF8		07
#define R_OFF16		010
#define	R_SEG12		011
#define	R_AUX		013

/*
 * B16 and X86 generics
 *	16-bit direct reference
 *	16-bit "relative" reference
 *	16-bit "indirect" (TV) reference
 */
#define  R_DIR16	01
#define  R_REL16	02
#define  R_IND16	03

/*
 * 3B generic
 *	24-bit direct reference
 *	24-bit "relative" reference
 *	16-bit optimized "indirect" TV reference
 *	24-bit "indirect" TV reference
 *	32-bit "indirect" TV reference
 */
#define  R_DIR24	04
#define  R_REL24	05
#define  R_OPT16	014
#define  R_IND24	015
#define  R_IND32	016

/*
 * 3B and M32 || u3b15 || u3b5 || u3b2 generics
 *	32-bit direct reference
 */
#define  R_DIR32	06

/*
 * M32 || u3b15 || u3b5 || u3b2 generic
 *	32-bit direct reference with bytes swapped
 */
#define  R_DIR32S	012

/*
 * DEC Processors  VAX 11/780 and VAX 11/750
 *
 */

#define R_RELBYTE	017
#define R_RELWORD	020
#define R_RELLONG	021
#define R_PCRBYTE	022
#define R_PCRWORD	023
#define R_PCRLONG	024

/*
 * Motorola 68000
 *
 * ... uses R_RELBYTE, R_RELWORD, R_RELLONG, R_PCRBYTE and R_PCRWORD as for
 * DEC machines above.
 */

#define	RELOC	struct reloc
#define	RELSZ	sizeof(RELOC)

	/* Definition of a "TV" relocation type */

#if _N3B
#define ISTVRELOC(x)	((x==R_OPT16)||(x==R_IND24)||(x==R_IND32))
#endif
#if _B16 || _X86
#define ISTVRELOC(x)	(x==R_IND16)
#endif
#if _M32 || __u3b15 || __u3b5 || __u3b2
#define ISTVRELOC(x)	(x!=x)	/* never the case */
#endif

/* $Log:	reloc.h,v $
 * Revision 4.2.2.2  91/12/05  15:02:21  Jim_McHale
 * 	"Integrate with AG pool"
 * 
 * Revision 4.2.1.2  91/11/22  18:38:12  Jim_McHale
 * 	Merge with mips 3.0
 * 
 * Revision 3000.7.1.1  91/05/31  18:26:07  bettina
 * fix DFARS in copyright
 * 
 * Revision 3000.7  91/04/08  17:40:06  bettina
 * fix copyright
 * 
 * Revision 3000.6  91/04/08  13:53:36  bettina
 * update copyright
 * 
 * Revision 3000.5  91/02/17  14:45:54  karen
 * SVR4 changes
 * 
 * Revision 3000.4  91/01/07  14:27:40  chan
 * 2.40 3.0 merge
 * 
 * Revision 3000.2  90/12/10  13:53:02  zaineb
 * Ansi Changes
 * 
 * Revision 2020.3.1.1  90/11/05  17:36:53  zaineb
 * 2.21 merge
 * 
 * Revision 2021.4  90/07/10  08:59:02  shin
 * added exception handling related literals
 * 
 * Revision 2021.3  90/06/20  10:21:25  shin
 * updated added exception handling related definitions
 * 
 * Revision 2015.1.2.1  90/04/30  09:52:31  chan
 * *** empty log message ***
 * 
 * Revision 2020.3  89/12/07  17:45:40  lilian
 * add R_REFWORD_64
 * 
 * Revision 2020.2  89/12/04  13:08:12  chan
 * new relocation type
 * 
 * Revision 2020.1  89/10/06  15:06:31  bettina
 * 2.20
 * 
 * Revision 2010.2  89/09/26  23:33:32  lai
 * added wrapper
 * 
*/
#endif
