#include <stdlib.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <mem.h>
#include <string.h>

int main (int argc, char **argv)
{
	int
		blkcount = 0,
		mapword = 0,
		mapindex = 3,
		platters = 1,
		bstatus,

		sat[256],
		blk[256];

	FILE
		*tape;

	fprintf (stderr, "DOSSAVE version 2.0, 12 February 2003\n");

	argv++;
	if ((argc > 2) && isdigit (**argv))
		platters = **argv++ - '0';

	if ((platters < 1) || (platters > 8))
	{
		fprintf (stderr, "Platters must be in range 1 to 8\n");
		exit (1);
	}

	tape = fopen (*argv, "rb");

	if (tape == NULL)
	{
		fprintf (stderr, "Cannot open tape file '%s'\n", *argv);
		exit (1);
	}

	setmode (fileno(stdout), O_BINARY);

	fread (sat, 4, 256, tape);

	fprintf (stderr, "SAT T : %6o %6o %6o ... %6o %6o\n",
		sat[0], sat[1], sat[2], sat[0376], sat[0377]);

	while (blkcount < sat[1])
	{
		if ((blkcount++ % 18) == 0)
			mapword = sat[mapindex++];

		if (bstatus = ((mapword <<= 1) & 01000000))
		{
			if (256 > fread (blk, 4, 256, tape))
			{
			   char
					*p = strchr (*argv, '1');

				if (!p)
				{
					fprintf (stderr, "Cannot make 2nd tape name '%s'", *argv);
					exit (1);
				}

				*p = '2';
				fclose (tape);
				tape = fopen (*argv, "rb");

				if (tape == NULL)
				{
					fprintf (stderr, "Cannot open 2nd tape file '%s'", *argv);
					exit (1);
				}

				fread (blk, 4, 256, tape);
			}
		}
		else
			memset (blk, 0, 256 * 4);

		if ((blkcount == 01776) && (platters > 4))
		{
			if (bstatus)
			{
				fprintf (stderr, "Second SAT block unavailable - program aborted\n");
				exit (2);
			}

			/* Write SAT2 at block 01775 */

			blk[0] = platters * 02000;		/* Number of blocks on disk */
			blk[1] = blk[0] - 4518;			/* Blocks in this SAT */
			blk[0376] = 0001777;				/* Pnt to previous  SAT */
			blk[0377] = 0777777;				/* Pntr to next SAT */

			fprintf (stderr, "SAT 2 : %6o %6o %6o ... %6o %6o\n",
				blk[0], blk[1], blk[2], blk[0376], blk[0377]);
		}

		else if (blkcount == 01777)		/* Primary SAT block */
		{
			if (! bstatus)
			{
				fprintf (stderr, "Primary SAT block not allocated - program aborted\n");
				exit (2);
			}

	   	blk[0] = platters * 02000;		/* Set total disk size */

			if (platters > 4)
			{
				blk[1] = 4518;			/* Set blocks in this SAT */
				blk[073] |= 020;  	/* Mark SAT 2 block in use */
				blk[2]++;				/* Increment blocks used (for SAT 2) */
				blk[0377] = 01775;	/* Pointer to 2nd SAT */
			}
			else
				blk[1] = blk[0];

			fprintf (stderr, "SAT 1 : %6o %6o %6o ... %6o %6o\n",
				blk[0], blk[1], blk[2], blk[0376], blk[0377]);
		}

		fwrite (blk, 4, 256, stdout);
	}

	memset (blk, 0, 256 * 4);

	while (blkcount++ < platters * 02000)
		fwrite (blk, 4, 256, stdout);

	return 0;
}
