/* picture.h */

/*
 * Structure and macros used to read and write from and to the graphic
 * memory.
 */

typedef struct { 
	unsigned short	p_magic;    /* type of generator (value: 0xfffe) */
	unsigned short	p_stat;	    /* flags                             */
	unsigned short	p_xaddr;    /* from/to x address (aligned pixel) */
	unsigned short	p_yaddr;    /* from/to y address (pixel)         */
	unsigned short	p_width;    /* width of area in pixels           */
	unsigned short	p_height;   /* height of area in pixels          */
	unsigned char	p_pad[38];  /* pad block to 50 bytes, future use */
} pictblk;



#define PPICTLD 	(('p' << 8) | 2)
#define PPICTRD 	(('p' << 8) | 3)

#define pread(fd, bp, size)	dnix(F_IOCR, fd, bp, size, PPICTRD, 0, 0, 0)
#define pwrite(fd, bp, size)	dnix(F_IOCR, fd, bp, size, PPICTLD, 0, 0, 0)
