/*
 *	Copyright 1984 Dataindustrier AB
 *
 *	Structure defining an error log record
 */

/*
 *	Every record has a header with the following format:
 */
struct errhdr {
	short	e_type;		/* Record type */
	short	e_sever;	/* Severity */
	short	e_pid;		/* Process id */
	short	e_uid;		/* User id */
	short	e_len;		/* Size of record (inc hdr) */
	unsigned short	e_cnt;	/* Message count */
	time_t	e_time;		/* Time of the day */
	char	e_cmd[8]	/* Command name */
};
/*eject*/
/*
 *	Definition of e_type
 */
#define E_ROOT		0	/* Unable to mount root device */
#define E_USERMESS	1	/* Message from user */
#define E_START		2	/* System start */
#define E_STOP		3	/* System stop  */
#define E_TCHG		4	/* Time change  */
#define E_BLK		5	/* Block device error */
#define E_ILLINT	6	/* Illigal interrupt */
#define E_MEMLOCK	7	/* Memory lock error */
#define E_CMEMERR	8	/* Corrected memory error */
#define E_ONLINE	9	/* Device on line */
#define E_PFAULT	10	/* Unexpected page fault */
#define E_SYSSTKOVF	11	/* System stack overflow */
#define E_NONODES	12	/* End of nodes */
#define E_NOTNODES	13	/* End of tcb's */
#define E_INITKILL	14	/* Init process killed */
#define E_CALLOUT	15	/* Overflow in callout table */
#define E_OSSTRUC	16	/* Invalid os data structures */
#define E_OSMAP		17	/* Error at memory mapping */
#define E_NOINIT	18	/* No init process */
#define E_OSCOPY	19	/* Error at data copy */
#define E_OSTRAP	20	/* Trap in system mode */
#define E_PAGESWAP	21	/* Error at page swapping */
#define E_NOSWAP	22	/* End of swap area */

/*
 *	Definition of e_sever
 */
#define E_INFO		0	/* Information - no action needed        */
#define E_WARNING	64	/* Warning - no immediate action needed  */
#define E_ERROR		128	/* Error - corrective action needed      */
#define E_HALT		192	/* Fatal error - system should be halted */
#define E_PANIC		255	/* Panic - halt os                       */
/*eject*/
/*
 *	E_USERMESS
 */

/*
 *	User error string follows
 */
/*eject*/
/*
 *	E_START
 */
struct e_start {
	long	e_memsz;		/* Total size of memory */
	long	e_ossz;			/* Size of os */
	struct	dutsname e_name;		/* System names */
	struct	osconfig e_cfig;	/* Configuration parameters */
};
/*
 *	E_STOP
 *
 *	Currently only header
 */

/*
 *	E_TCHG
 */
struct e_tchg {
	time_t	e_newtim;		/* New time */
};
/*eject*/
/*
 *	E_BLK
 */
struct e_blk {
	dev_t	e_dev;			/* Device */
	laddr_t	e_ioadr;		/* Io address */
	unsigned long	e_ioact;	/* Other io activity */
	long	e_ops;			/* Number of read/write operations */
	long	e_misc;			/* Number of other operations */
	unsigned short	e_unlog;	/* Number of unlogged errors */
	short	e_bflags;		/* Status of operation */
	short	e_cyloff;		/* Logical dev start cyl */
	daddr_t	e_blknr;		/* Logical block number */
	unsigned long	e_bytes;	/* Number of bytes to transfer */
	laddr_t	e_memadr;		/* Buffer memory address */
	unsigned short	e_retry;	/* Number of retries */
	unsigned short	e_ctlcmd;	/* Controller command, device dep. */
	unsigned short	e_ctlstat;	/* Controller status, device dep. */
};
/*
 *	Definition of e_bflags
 */
#define	E_WRITE		0	/* non-read pseudo-flag */
#define	E_READ		01	/* Read when io occurs */
#define	E_DONE		02	/* Transaction finished */
#define	E_IOERR		04	/* Transaction aborted */
#define E_BUSY		010	/* Device is busy */
#define E_SOFTERR	020	/* Soft error - corrected if not B_ERROR */
#define E_TIMEOUT	040	/* Time out on command */
#define	E_WANTED 	0100	/* Issue wakeup when busy goes off */
#define	E_TAPE		02000	/* This is magtape */
/*eject*/
/*
 *	E_ILLINT
 */
struct e_illint {
	daddr_t	e_vector;		/* Unexpected interrupt, vector addr */
	unsigned long	e_ioact;	/* Other io activity */
};

/*
 *	E_MEMLOCK
 */

/*
 *	Only header
 */

/*
 *	E_CMEMERR
 */
struct e_cmemerr {
	laddr_t e_fadr;			/* Correted error address */
	unsigned long	e_mapstat;	/* Mapper status */
};
/*eject*/
/*
 *	E_ONLINE
 */
struct e_online {
	dev_t	e_dev;			/* Device */
	unsigned long	e_ioact;	/* Mask for device active */
};

/*
 *	E_PFAULT
 */
struct e_pfault {
	laddr_t	e_fad;			/* Faulted logical address */
	short	e_phpage;		/* Physical page number */
	short	e_context;		/* Value of context register */
	short	e_pgrp;			/* Page group */
	short	e_preg;			/* Value of page register */
	unsigned long	e_ssr;		/* Special status register */
};
/*eject*/
/*
 *	E_SYSSTKOVFL
 */

/*
 *	Only header
 */
/*
 *	E_NONODES
 */

/*
 *	Only header
 */

/*
 *	E_NOTNODES
 */

/*
 *	Only header
 */
/*
 *	E_PAGESWAP
 */
struct e_pageswap {
	laddr_t e_lad;			/* Logical address */
	daddr_t	e_dad;			/* Disk address */
	int	e_sz;			/* Size of transfer */
	int	e_rpar;			/* Error parameter */
};
