/*
 *	Error codes
 *	===========
 *
 *	UNIX Compatible
 */

#ifdef ns32000
#define	EPERM	-1		/* Not owner */
#define	ENOENT	-2		/* No such file or directory */
#define	ESRCH	-3		/* No such process */
#define	EINTR	-4		/* Interrupted system call */
#define	EIO	-5		/* I/O error */
#define	ENXIO	-6		/* No such device or address */
#define	E2BIG	-7		/* Arg list too long */
#define	ENOEXEC	-8		/* Exec format error */
#define	EBADF	-9		/* Bad file number */
#define	ECHILD	-10		/* No children */
#define	EAGAIN	-11		/* No more processes */
#define	ENOMEM	-12		/* Not enough core */
#define	EACCES	-13		/* Permission denied */
#define	EFAULT	-14		/* Bad address */
#define	ENOTBLK	-15		/* Block device required */
#define	EBUSY	-16		/* Mount device busy */
#define	EEXIST	-17		/* File exists */
#define	EXDEV	-18		/* Cross-device link */
#define	ENODEV	-19		/* No such device */
#define	ENOTDIR	-20		/* Not a directory */
#define	EISDIR	-21		/* Is a directory */
#define	EINVAL	-22		/* Invalid argument */
#define	ENFILE	-23		/* File table overflow */
#define	EMFILE	-24		/* Too many open files */
#define	ENOTTY	-25		/* Not a typewriter */
#define	ETXTBSY	-26		/* Text file busy */
#define	EFBIG	-27		/* File too large */
#define	ENOSPC	-28		/* No space left on device */
#define	ESPIPE	-29		/* Illegal seek */
#define	EROFS	-30		/* Read-only file system */
#define	EMLINK	-31		/* Too many links */
#define	EPIPE	-32		/* Broken pipe */
#define	EDOM	-33		/* Argument too large */
#define	ERANGE	-34		/* Result too large */
#define	ENOMSG	-35		/* No message of desired type */
#define	EIDRM	-36		/* Identifier removed */
#define	ECHRNG	-37		/* Channel number out of range */
#define	EL2NSYNC -38		/* Level 2 not syncronized */
#define	EL3HLT	-39		/* Level 3 halted */
#define	EL3RST	-40		/* Level 3 reset */
#define	ELNRNG	-41		/* Link number out of range */
#define	EUNATCH	-42		/* Protocol driver not attached */
#define	ENOCSI	-43		/* No CSI structure availible */
#define	EL2HLT	-44		/* Level 2 halted */
#define	EDEADLK	-45		/* Record locking deadlock */
#define	EUCLEAN	-99		/* File structure not clean */
/*
 *	DNIX Specials
 */
#define	EBADLU	-9		/* Bad lu */
#define	ENONODES -100		/* No more nodes */
#define	EREQAB	-101		/* Request aborted */
#define	EBADFC	-102		/* Illegal function code */
#define	ESWAP	-104		/* Refered process is swapped */
#define	ECANCL	-103		/* Refferred request is canceled */
#define EDRVNF	-104		/* Device driver not found */
#define	ETIMOUT	-105		/* Timeout on driver */
#define ELOCKOK -106		/* Locking is ok - no open node needed */
#define ENOLOCK	-107		/* No locks for this process any more */

#define	EWAIT	-128		/* Request waiting for termination */


#else
/* M68000 */

#define	EPERM	-1		/* Not owner */
#define	ENOENT	-2		/* No such file or directory */
#define	ESRCH	-3		/* No such process */
#define	EINTR	-4		/* Interrupted system call */
#define	EIO	-5		/* I/O error */
#define	ENXIO	-6		/* No such device or address */
#define	E2BIG	-7		/* Arg list too long */
#define	ENOEXEC	-8		/* Exec format error */
#define	EBADF	-9		/* Bad file number */
#define	ECHILD	-10		/* No children */
#define	EAGAIN	-11		/* No more processes */
#define	ENOMEM	-12		/* Not enough core */
#define	EACCES	-13		/* Permission denied */
#define	EFAULT	-14		/* Bad address */
#define	ENOTBLK	-15		/* Block device required */
#define	EBUSY	-16		/* Mount device busy */
#define	EEXIST	-17		/* File exists */
#define	EXDEV	-18		/* Cross-device link */
#define	ENODEV	-19		/* No such device */
#define	ENOTDIR	-20		/* Not a directory */
#define	EISDIR	-21		/* Is a directory */
#define	EINVAL	-22		/* Invalid argument */
#define	ENFILE	-23		/* File table overflow */
#define	EMFILE	-24		/* Too many open files */
#define	ENOTTY	-25		/* Not a typewriter */
#define	ETXTBSY	-26		/* Text file busy */
#define	EFBIG	-27		/* File too large */
#define	ENOSPC	-28		/* No space left on device */
#define	ESPIPE	-29		/* Illegal seek */
#define	EROFS	-30		/* Read-only file system */
#define	EMLINK	-31		/* Too many links */
#define	EPIPE	-32		/* Broken pipe */
#define	EDOM	-33		/* Argument too large */
#define	ERANGE	-34		/* Result too large */
#define	EUCLEAN	-35		/* Structure needs cleaning */
#define EDEADLK	-36		/* Resource deadlock would occur */
#define EIDRM	-37		/* Identifier removed */
#define ENOMSG	-38		/* No such message */

/*
 *	DNIX Specials
 */
#define	EBADLU	-9		/* Bad lu */
#define	ENONODES -50		/* No more nodes */
#define	EREQAB	-51		/* Request aborted */
#define	EBADFC	-52		/* Illegal function code */
#define	ESWAP	-54		/* Refered process is swapped */
#define	ECANCL	-53		/* Refferred request is canceled */
#define EDRVNF	-54		/* Device driver not found */
#define	ETIMOUT	-55		/* Timeout on driver */
#define ELOCKOK -56		/* Locking is ok - no open node needed */
#define ENOLOCK	-57		/* No locks for this process any more */

#define	EWAIT	-128		/* Request waiting for termination */

#endif
