/*					*/
/*	Swappable tcb definition	*/
/*					*/
/*	One for each user		*/
/*	Contains the system per user	*/
/*	stack.				*/
/*					*/
/*					*/
/*	Structure of swappable tcb	*/
/*					*/


struct	core	{	/* Info used by ADB at inspection of core dump */
	struct core *c_addr;	/* Address of upage */
	short	c_utwist;	/* Part of upage before c_addr */
	short	c_ubytes;	/* Total upage size before and after c_addr */
	short	c_signum;	/* Signal causing core dump */
	long	c_txtsiz;	/* Text size in bytes */
	long	c_datsiz;	/* Impure size in bytes */
	long	c_stksiz;	/* Stack size in bytes */
	laddr_t	c_stktop;	/* First address after stack top */
	int	*c_ar0;		/* Pointer to saved R0 */
};
 
struct user {
	struct	core u_core;	/* Info used by ADB at core dump - first in U-page */
	short	u_uid;		/* effectiv user id */
	short	u_gid;		/* Effectiv group id */
	short	u_ruid;		/* real user id		*/
	short	u_rgid;		/* Real group id	*/
	char	u_mxpri;	/* Max priority */
	char	u_mipri;	/* Minimum priority */
	short	u_cmask;	/* Mask for file creation */
	char	u_sep;		/* Separate I and D flag */
	int	*u_ap;		/* Pointer to argument list */
	laddr_t	u_signal[NSIG];	/* Dispositions of signals */
	time_t	u_utime;	/* This process user time */
	time_t	u_stime;	/* This process system time */
	time_t	u_cutime;	/* Sum of child's utimes */
	time_t	u_cstime;	/* Sum of child's stimes */
	label_t	u_rsav;		/* Register save area on process switch */
	label_t	u_qsav;		/* Register save area */
	label_t	u_ssav;		/* Register save area */
	struct {
		short	*pr_base;	/* Buffer base */
		unsigned pr_size;	/* Buffer size */
		unsigned pr_off;	/* Pc offset */
		unsigned pr_scale;	/* Scale */
	} u_prof;
	int	u_rval2;		/* Second returned value */
	char	u_error;		/* Error codes from some drivers */
	char	u_profa;		/* Profiling activ */
	short	u_arglu;	/* Lu of argument file if used */
	unsigned long	u_apidh;
	unsigned long	u_apidl;	/* Alternative pid */
	short	u_auid;
	short	u_agid;
	long	u_fillim;		/* File limit (ulimit) */
	short	u_fpflags;	/* Flags associated to floating point */
	long	u_fpregs[9];	/* where fpregs are saved. */
	char	u_stmbuf[STMBSIZE];	/* Stream buffer */
};
#define	U_FPSAVED	0x8000	/* float registers saved flag */
#define	U_FPUSED	0x0001	/* float used flag. */

#ifdef	DS90NS32000
#define u (*(struct user *) (UPAGEA+PAGESIZE- sizeof(struct user)))
#else
extern struct user u;
#endif
