/*
 *	Copyright 1984 Dataindustrier AB
 */
/*
 * This include file describes requests and arguments to "fcntl(2)"
 * and "open(2)" :
 */
/*
 * Flag values accessible to both "open(2)" and "fcntl(2)"
 * The first three can only be set by "open(2)"
 */
#define	O_RDONLY	0000
#define	O_WRONLY	0001
#define	O_RDWR		0002
#define	O_NDELAY	0004	/* Non-blocking I/O */
#define	O_APPEND	0010	/* append (writes guaranteed at the end) */
#define O_SYNC		0020	/* Synchronous write option */

/*
 *	Flag values accessible only to open(2)
 */
#define	O_CREAT	00400	/* open with file create (uses third open arg)*/
#define	O_TRUNC	01000	/* open with truncation */
#define	O_EXCL	02000	/* exclusive open */

/*
 *	fcntl(2) request
 */
#define	F_DUPFD	0	/* Duplicate fildes */
#define	F_GETFD	1	/* Get fildes flags */
#define	F_SETFD	2	/* Set fildes flags */
#define	F_GETFL	3	/* Get file flags */
#define	F_SETFL	4	/* Set file flags */

#define	F_GETLK	5	/* Get file lock */
#define	F_SETLK	6	/* Set file lock */
#define	F_SETLKW 7	/* Set file lock and wait */
/*
 *	File segment locking types
 */

#define	F_RDLCK	1	/* Read lock */
#define	F_WRLCK	2	/* Write lock */
#define	F_UNLCK	3	/* Remove lock(s) */

struct flock {
	short	l_type;		/* F_RDLCK, F_WRLCK, F_UNLCK */
	short	l_whence;	/* Flag to choose offset */
	long	l_start;	/* relativ offset in bytes */
	long	l_len;		/* If 0 then until EOF */
	int	l_pid;		/* Return with F_GETLK */
};

#define	F_SETCT	97	/* Set controlling terminal */
#define	F_CLRCT	98	/* Clear controlling terminal */
#define	F_GETFP	99	/* Get prev. flags - special D-nix request */
