/*  bm# 0000001769
/*  typ C
/*  ver generic
/*  mod generic
*/ 
/*
 *	SCCSID(@(#)stdio.h	1.1);
 */
/***	stdio.h
 *
 *	MODIFICATION HISTORY
 *	M000	07 Apr 83	andyp	3.0 upgrade
 *	- Changed getc(), putc() to deal with sign extension problems.
 *	  Added documentation headers.
 *	- Propagated () to macro args to avoid precedence problems.
 *	- Removed 3.0 vax-specific code.
 */

#define	BUFSIZ	512
#define	_NFILE	20
#ifndef	FILE
extern	struct _iobuf {
	char	*_ptr;
	int	_cnt;
	char	*_base;
	char	_flag;
	char	_file;
} _iob[_NFILE];
#endif

#define	_IOREAD	01
#define	_IOWRT	02
#define	_IONBF	04
#define	_IOMYBUF	010
#define	_IOEOF	020
#define	_IOERR	040
#define	_IOSTRG	0100
#define	_IORW	0200

#define	NULL	0
#define	FILE	struct _iobuf
#define	EOF	(-1)

#define	stdin	(&_iob[0])
#define	stdout	(&_iob[1])
#define	stderr	(&_iob[2])

/***	getc -- get character from a stream.
 *
 *	return character on success.  return EOF on end of file or
 *	error.
 *
 *	int getc(stream)
 *	FILE  *stream;
 */
#ifndef	M_LINT

#define	getc(p)		(			\
	--(p)->_cnt >= 0 ?			\
	(0xff & (int) (*(p)->_ptr++)) :		\
	_filbuf(p)				\
)
#define	getchar()	getc(stdin)

/***	putc -- put character on a stream.
 *
 *	return character on success.  return EOF on error.
 *
 *	int putc(ch, stream)
 *	char  ch;
 *	FILE  *stream;
 */
#define	putc(c, p)	(			\
	--(p)->_cnt >= 0 ?			\
	(0xff & (int) (*(p)->_ptr++ = (c))) :	\
	_flsbuf(c, p)				\
)
#define	putchar(c)	putc(c, stdout)

#define	feof(p)		(((p)->_flag&_IOEOF)!=0)
#define	ferror(p)	(((p)->_flag&_IOERR)!=0)
#define	fileno(p)	(p)->_file

#endif	M_LINT

extern	FILE	*fopen();
extern	FILE	*fdopen();
extern	FILE	*freopen();
extern	long	ftell();
extern	char	*fgets();
extern	char	*gets();

#define	L_ctermid	9
#define	L_cuserid	9
#define	L_tmpnam	19
#define	LFNMAX		15		/* max len for filename */
#define	LPNMAX		128		/* (practical) max len for pathname */
