/*
 *	Copyright 1985 Dataindustrier AB
 *
 *	IPC access structure
 */

struct ipc_perm {
	ushort	uid;	/* Owners user id */
	ushort	gid;	/* Owners group id */
	ushort	cuid;	/* creator's user id */
	ushort	cgid;	/* creator's group id */
	ushort	mode;	/* access mode */
};

#define IPC_CREAT	0x1000	/* create entry if key doesn't fit */
#define IPC_EXCL	0x2000	/* fail if key doesn't fit */
#define IPC_NOWAIT	0x4000	/* error if request must wait */

#define IPC_PRIVATE	(key_t)0x00	/* private kye */

#define IPC_RMID	0x10	/* remove identifier */
#define IPC_SET		0x11	/* set options */
#define IPC_STAT	0x12	/* get options */

