

/*
 * Location of the users' stored
 * registers relative to R0.
 * Usage is u.u_ar0[XX].
 * EVERYTHING HERE IS DEPENDENT ON trap: in lowz.s and trap.c
 * AND THE HARDWARE
 */

#define	D0	0
#define	D1	1
#define	D2	2
#define	D3	3
#define	D4	4
#define	D5	5
#define	D6	6
#define	D7	7

#define	A0	8
#define	A1	9
#define	A2	10
#define	A3	11
#define	A4	12
#define	A5	13
#define	A6	14
#define	A7	15			/* only holds user's a7 */
#define	USP	15

#define SR	16
#define UPC	17
#define	SSR	18	/* 68010 - vector offset and ssr */
#define	FAD	19	/* 68010 - Fault address */

#define	FREG	D0		/* First register to clear on exec */
#define	LREG	A6		/* Last register to clear on exec */
#define	NREG	18		/* Number of registers +1 to set in trace */

/* Status reg values (used in trap.c) */

#define	SR_MASK		0xffff		/* Bits for sr in ar0[SR] */
#define	SR_MAGIC	0x400000	/* Bit really in SEGMAP but stored */
#define SR_TRACE	0x8000		/* Trace Mode Bit */
#define	SR_SUPER	0x2000		/* SUpervisor State Bit */
#define SR_IMASK	0x0700		/* Interrupt Mask */

#define SR_USER		0x00ff		/* User byte of SR */
#define SR_EXTEND	0x0010		/* Extend Condition Bit */
#define SR_NEGATIVE	0x0008		/* Negative Condition Bit */
#define SR_ZERO		0x0004		/* Zero Condition Bit */
#define SR_OVERFLOW	0x0002		/* Overflow Condition Bit */
#define SR_CARRY	0x0001		/* Carry Condition Bit */
