/***	relsym.h
 *
 *	<sys/relsym.h> - Declarations for symbol table
 *		and relocation record structures.
 *
 *	MODIFICATION HISTORY
 *	M000	14 Apr 83	andyp
 *	- 3.0 upgrade.  XENIX source picked up, unchanged.
 */

/*
 *	Symbol table for x.out.
 *	The "sym" structure replaces the old "asym" (nlist)
 *	structure used by a.out.  Each symbol in the table has
 *	the below structure, followed immediately by its name
 *	in the form of a null terminated string.
 *	Note that no effort is made to word align subsequent
 *	"sym" structures in the symbol table.
 */

struct sym {		/* symbol management */
	unsigned short	s_type;
	unsigned short	s_pad;		/* padded for portability */
	long		s_value;
};


#define	SYMLENGTH	50	/* max symbol name length */


/*
 *	Definitions for sym.s_type:
 *
 *	xxxxxxxxxx          extra
 *	          e         external
 *	           ttttt    type
 */

#define	S_UNDEF		0x0000
#define	S_ABS		0x0001
#define	S_TEXT		0x0002
#define	S_DATA		0x0003
#define	S_BSS		0x0004
#define	S_COMM		0x0005	/* for internal use only */
#define	S_REG		0x0006
#define	S_COMB		0x0007	/* for internal use only */
#define	S_TYPE		0x001f	/* mask */
#define	S_FN		0x001f
#define	S_EXTERN	0x0020

#define	FORMAT	"%08lx"	/* symbol value format */
#define	FWIDTH	8	/* symbol value width  */


/*
 *	Symbol table for a.out.
 *
 *	Modified from nlist for portability.
 */

struct asym {
	char		sa_name[8];	/* symbol name */
	unsigned short	sa_type;	/* type flag */
	unsigned short	sa_value;	/* value */
};


/*	Definitions for asym.sa_type and nlist.n_type.	*/

#define	N_UNDF	0	/* undefined */
#define	N_ABS	01	/* absolute */
#define	N_TEXT	02	/* text symbol */
#define	N_DATA	03	/* data symbol */
#define	N_BSS	04	/* bss symbol */
#define	N_TYPE	037
#define	N_REG	024	/* register name */
#define	N_FN	037	/* file name symbol */
#define	N_EXT	040	/* external bit, or'ed in */


/*
 *	Symbol table for b.out.
 *
 *	The same as x.out, except that it uses 6 bytes
 *	on most machines.
 */

struct bsym {
	char	sb_type;	/* use definitions for sym.s_type */
	long	sb_value;
};




/*
 *	Relocation table entry for x.out, long form.
 *	This form is normally attached to ".o" files.
 *	Should be bit-wise compatible with the b.out
 *	format on machines that allocate bitfields
 *	from the high end of a word. (68k)
 */

struct reloc {
	unsigned short	r_desc;		/* descriptor */
	unsigned short	r_symbol;	/* symbol id for external reloc */
	long		r_pos;		/* position of reloc in segment */
};


/*
 *	Definitions for reloc.r_desc (short).
 *
 *	ss                  segment
 *	  ss                size
 *	    d               displacement
 *	     xxx            extra
 *	        xxxxxxxx    extra
 */

#define	RD_TEXT	0x0000
#define	RD_DATA	0x4000
#define	RD_BSS	0x8000
#define	RD_EXT	0xc000
#define	RD_SEG	0xc000

#define	RD_BYTE	0x0000
#define	RD_WORD	0x1000
#define	RD_LONG	0x2000
#define	RD_SIZE	0x3000

#define	RD_DISP	0x0800
#define RD_SWAP	0x0400		/* ADDED FOR NS32000 (PAF) */

/*
 *	Definitions for reloc.r_desc, compatible with bitfield
 *		allocation from the low end of a word (pdp11).
 */

#define	RD_BTEXT	0x0000
#define	RD_BDATA	0x0001
#define	RD_BBSS		0x0002
#define	RD_BEXT		0x0003
#define	RD_BSEG		0x0003

#define	RD_BBYTE	0x0000
#define	RD_BWORD	0x0004
#define	RD_BLONG	0x0008
#define	RD_BSIZE	0x000c

#define	RD_BDISP	0x0010


/*
 *	Relocation table entry for x.out, short form.
 *	This form is normally attached to executable files.
 *	Currently used on the 68k.
 */

struct xreloc {
	long	xr_cmd;		/* reloc command */
};


/*
 *	Definitions for xreloc.xr_cmd (long).
 *
 *	c                                   set if code segment
 *	 l                                  set if long operand
 *	  oooooooooooooooooooooooooooooo    offset
 */

#define	XR_CODE	0x80000000	/* code/data segment */
#define	XR_LONG	0x40000000	/* long/short operand */
#define	XR_OFFS	0x3fffffff	/* 30 bit offset mask */
