/*  bm# 0000001750
/*  typ C
/*  ver generic
/*  mod generic
*/ 
/*
 *	SCCSID(@(#)relsym86.h	1.1);
 */
/*
 *	@(#) relsym86.h 1.1 84/10/08 
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE SPECIFIC TO THE INTEL CPUS.
 * IT MAY REQUIRE MODIFICATION WHEN MOVING XENIX TO
 * DIFFERENT MACHINE ARCHITECTURES OR CONFIGURATIONS.
 */


/*
 *	<sys/relsym86.h> - Declarations for 8086 symbol
 *		table and relocation record structures.
 *
 *	Combined symbol and relocation for relocatable files,
 *		(XR_R86REL | XR_S86REL).
 *
 *	This format is a series of distinct records.  Each record
 *	is made up of:
 *		1) 1 byte record type
 *		2) 2 byte record length (low byte first)
 *		3) record contents
 *		4) 1 byte checksum
 *
 *	The record length is the number of bytes in 3 & 4.
 *	When ALL of the bytes in the record are summed, the
 *	the low byte of the result should be zero.
 *	The record contents depend on the record type.
 *	Records containing symbol names have a one byte name
 *	length followed by the name itself.  The name is not
 *	terminated by a special character.
 */


/*
 *	Defines for record type:
 */
#define MRHEADR	0x6e	/* rel module header */
#define MREGINT	0x70	/* register initialization */
#define MREDATA	0x72	/* explicit (enumerated) data image */
#define MRIDATA	0x74	/* repeated (iterated) data image */
#define MOVLDEF	0x76	/* overlay definition */
#define MENDREC	0x78	/* block or overlay end record */
#define MBLKDEF	0x7a	/* block definition */
#define MBLKEND	0x7c	/* block end */
#define MDEBSYM	0x7e	/* debug symbols */
#define MTHEADR	0x80	/* module header, usually first in a rel file */
#define MLHEADR	0x82	/* link module header */
#define MPEDATA	0x84	/* absolute data image */
#define MPIDATA	0x86	/* absolute repeated (iterated) data image */
#define MCOMENT	0x88	/* comment record */
#define MMODEND	0x8a	/* module end record */
#define MEXTDEF	0x8c	/* external definition */
#define MTYPDEF	0x8e	/* type definition */
#define MPUBDEF	0x90	/* public definition */
#define MLOCSYM	0x92	/* local symbols */
#define MLINNUM	0x94	/* source line number */
#define MLNAMES	0x96	/* name list record */
#define MSEGDEF	0x98	/* segment definition */
#define MGRPDEF	0x9a	/* group definition */
#define MFIXUPP	0x9c	/* fix up previous data image */
#define MNONE1	0x9e	/* none */
#define MLEDATA	0xa0	/* logical data image */
#define MLIDATA	0xa2	/* logical repeated (iterated) data image */
#define MLIBHED	0xa4	/* library header */
#define MLIBNAM	0xa6	/* library names record */
#define MLIBLOC	0xa8	/* library module locations */
#define MLIBDIC	0xaa	/* library dictionary */

/*
 *	The maximum length of an identifier.
 */
#define NAMELENGTH	40


/*
 *	Defines for segment descriptor.
 */
	/* type of alignment required */

#define SD_ABS		0x0000		/* absolute */
#define SD_BYTE		0x0020		/* byte */
#define SD_WORD		0x0040		/* word */
#define SD_PARA		0x0060		/* paragraph */
#define SD_PAGE		0x0080		/* page */
#define SD_ALIGN	0x00e0		/* segment alignment mask */

	/* ways in which segments can be combined */

#define SD_SEP		0x0000		/* can't be combined */
#define SD_HIMEM	0x0004		/* should reside in high mem */
#define SD_SEQ		0x0008		/* sequential, concatenated */
#define SD_BAD		0x000c		/* undefined */
#define SD_C4		0x0010
#define SD_C5		0x0014
#define SD_COMM		0x0018		/* common segment */
#define SD_RCOMM	0x001c		/* reverse common segment */
#define SD_COMBO	0x001c		/* combination mask */


/*
 *	Relocation for absolute (executable) files, XR_R86ABS.
 *	
 *	This relocation must be attached to middle and large
 *	model executables to be run on an 8086.  Relocation is
 *	performed on all segment references when the file is
 *	loaded into memory.
 *
 *	This relocation must start on an even sizeof(struct srel86)
 *	boundary.  The size of this structure MUST BE an even
 *	power of 2.  In order to accomplish the padding, the
 *	appropriate number of null bytes should be written at the
 *	start of the relocation, and the relocation size in the
 *	header bumped up to reflect the padding.
 */

struct srel86 {
	char    srtyp;          /* type of segment relocation  */
	char    srhib;          /* high byte of reloc address  */
	unsigned short srlow;	/* low  word of reloc address  */
};


/*
 *	Defines for srel86.srtyp
 */

#define R86_CTC 0               /* code reference to code */
#define R86_CTD 1               /* code reference to data */
#define R86_DTC 2               /* data reference to code */
#define R86_DTD 3               /* data reference to data */


/*
 *	Macros applicable to XR_R86ABS relocation padding:
 *
 *	SRELPOS() must be given a pointer to an x.out header;
 *	    it returns the seek position of the first relocation
 *	    structure in an object file, skipping any padding.
 *	SRELPAD() is also given an x.out header pointer; it
 *	    returns the number of bytes of padding required
 *	    to properly align the relocation records.  The
 *	    x_reloc field in the header is not used in the
 *	    computation; it need not be accurate.
 *	SRELSIZE() should be given a long value, usually the
 *	    x_reloc field of an x.out header; it returns the
 *	    size of actual relocation records in an object file,
 *	    compensating for any padding.
 */

#define SRELMSK		((long) (sizeof(struct srel86) - 1)) /* 2^n-1 */
#define SRELPOS(xp)	((XRELPOS(xp) + SRELMSK) & ~SRELMSK)
#define SRELPAD(xp)	((int) ((~XRELPOS(xp) + 1) & SRELMSK))
#define SRELSIZE(x)	((long) x & ~SRELMSK)


/*
 *	Symbol table for absolute files, XR_S86ABS.  This
 *	format is the same as that used in the standard
 *	x.out symbol table: struct "sym" with trailing
 *	symbol name.  The only difference is that the
 *	segment is stored in the high 16 bits of sym.s_value,
 *	and the offset within the segment is stored in the
 *	low 16 bits.
 *
 *	There also exists a temporary form which is put out
 *	by the linker and is usually converted to XR_S86ABS
 *	symbol form when attached to an 8086 executable file.
 *
 *	The temporary format contains 5 fields:
 *		1) 2 byte segment (low byte first)
 *		2) 2 byte offset (low byte first)
 *		3) 1 byte type flag
 *		4) 1 byte name length
 *		5) symbol name
 *
 *	The low bit of the type flag is set if the symbol
 *	is a code symbol, otherwise it is a data symbol.
 *	The second bit is set if the symbol's segment is
 *	initialized.
 */
