/*
 *	Copyright 1985 Dataindustrier AB
 *
 *	Semaphore structures
 */

#define SEM_UNDO	1	/* set up adjust on exit */

#define GETNCNT		3	/* get semncnt */
#define GETPID		4	/* get sempid */
#define GETVAL		5	/* get semval */
#define GETALL		6	/* get all semval's */
#define GETZCNT		7	/* get semzcnt */
#define SETVAL		8	/* set semval */
#define SETALL		9	/* set all semval's */

struct semid_ds {
	struct ipc_perm	sem_perm;	/* permission */
	ushort		sem_nsems;	/* # of semaphores in set */
	time_t		sem_otime;	/* last semop time */
	time_t		sem_ctime;	/* last change time */
};

struct sem {
	ushort	semval;		/* semaphore tex map address */
	sema_t	semnwait;	/* to wait for non-zero value */
	sema_t	semzwait;	/* to wait for zero value */
	short	sempid;		/* pid of last operation */
	short	semncnt;	/* # awaiting semval > cval */
	short	semzcnt;	/* # awaiting semval = cval */
};

struct sembuf {
	short	sem_num;	/* semaphore # */
	short	sem_op;		/* semaphore operation */
	short	sem_flg;	/* operation flags */
};

