/*
 *	84/10/29 Copyright (c) Dataindustrier DIAB AB, 1984
 */


/*
 * Structure returned by stat and fstat system calls
 */
struct	stat
{
	short	st_dev;		/* ID of a file handler managing this file */
	ino_t	st_ino;		/* File serial number */
	unsigned short st_mode;	/* File mode; see #defines below */
	short	st_nlink;	/* Number of links */
	short  	st_uid;		/* User ID of the file's owner */
	short  	st_gid;		/* User ID of the file's group */
	short	st_rdev;	/* ID of device */
				/* This entry is defined only for */
				/* special files */
	daddr_t	st_size;	/* File size in bytes */
	time_t	st_atime;	/* Time of last access */
	time_t	st_mtime;	/* Time of last data modification */
	time_t	st_ctime;	/* Time of last file status change */
				/* Times measured in seconds since */
				/* 1970-01-01 00:00:00 GMT */
};

#define S_ISDIR(m)	(((m) & S_IFMT) == S_IFDIR)
#define S_ISCHR(m)	(((m) & S_IFMT) == S_IFCHR)
#define S_ISBLK(m)	(((m) & S_IFMT) == S_IFBLK)
#define S_ISREG(m)	(((m) & S_IFMT) == S_IFREG)
#define S_ISFIFO(m)	(((m) & S_IFMT) == S_IFIFO)

#define S_ENFMT		S_ISGID	/* record locking enforcement flag */
#define	S_ISUID		04000	/* set user id on execution */
#define	S_ISGID		02000	/* set group id on execution */
#define S_ISVTX		01000	/* this bit is reserved for future use */
#define S_IRWXU		00700	/* read,write,execute permission: owner */
#define S_IRUSR		00400	/*   read permission: owner */
#define S_IWUSR		00200	/*   write permission: owner */
#define S_IXUSR		00100	/*   execute permission: owner */
#define S_IRWXG		00070	/* read,write,execute permission: group */
#define S_IRGRP		00040	/*   read permission: group */
#define S_IWGRP		00020	/*   write permission: group */
#define S_IXGRP		00010	/*   execute permission: group */
#define S_IRWXO		00007	/* read,write,execute permission: other */
#define S_IROTH		00004	/*   read permission: other */
#define S_IWOTH		00002	/*   write permission: other */
#define S_IXOTH		00001	/*   execute permission: other */

#define	S_IFMT		0170000		/* file type mask */

#define S_IFIFO		0010000		/* FIFO special file */
#define	S_IFCHR		0020000		/* character special file */
#define S_IFMPC		0030000		/* reserved */
#define	S_IFDIR		0040000		/* directory */
#define S_IFNAM		0050000		/* reserved */
#define	S_IFBLK		0060000		/* block special file */
#define S_IFMPB		0070000		/* reserved */
#define	S_IFREG		0100000		/* regular file */
/*
 * Old type definitions
 */
#define	S_IEXEC		S_IXUSR		/* execute permission, owner */
#define	S_IWRITE	S_IWUSR		/* write permission, owner */
#define	S_IREAD		S_IRUSR		/* read permission, owner */
