/*  bm# 0000000024
/*  typ C
/*  ver generic
/*  mod generic
*/ 
/*
 *	SCCSID(@(#)systm.h	1.1);
 */
/*
 *	@(#) h/systm.h 1.1 83/09/22 Copyright Microsoft Corporation, 1983
 *
 *	@(#)systm.h	1.1
 */

/*
 * Random set of variables used by more than one routine.
 */

struct inode *rootdir;		/* pointer to inode of root directory */
struct proc *runq;		/* head of linked list of running processes */
struct proc *Hogproc;           /* if non-NULL, schedule only this process */
short   cputype;                /* type of cpu */
time_t	lbolt;			/* time in HZ since last boot */
time_t	time;			/* time in sec from 1970 */
int     Hz;                     /* configurable clock speed */
int     Timezone;               /* configurable timezone */
int     Dstflag;                /* configurable DST flag  */

int	mpid;			/* generic for unique process id's */
char	runin;			/* scheduling flag */
char	runout;			/* scheduling flag */
char	runrun;			/* scheduling flag */
char    runtxt;                 /* scheduling flag */
char	curpri;			/* more scheduling */
int	maxmem;			/* actual max memory per process */
int     Maxmem;                 /* configurable max memory per process */
int	physmem;		/* physical memory on this CPU */
daddr_t	swplo;			/* block number of swap space */
int	nswap;			/* size of swap space */
int	updlock;		/* lock for sync */
daddr_t	rablock;		/* block to be read ahead */
int     Cmask;                  /* default creation mask */
char	regloc[];		/* locs of saved user registers (trap.c) */
short   reglocc;                /* size of regloc array */
dev_t	rootdev;		/* device of the root */
dev_t	swapdev;		/* swapping device */
dev_t	pipedev;		/* pipe device */
short   icode[];                /* user init code */
ushort  szicode;                /* its size */
int	blkacty;		/* active block devices */

/* machine dependent part */

extern short etext, edata, end;

extern char *umem;		/* address of first page of user memory	*/
extern char *exenix;		/* address of end of xenix		*/
extern char *mapsize;		/* #bytes mapped in memory		*/
extern char *memsize;		/* total memory size in bytes		*/

/* function defs */

dev_t getmdev();
daddr_t	bmap();
struct inode *ialloc();
struct inode *iget();
struct inode *owner();
struct inode *maknode();
struct inode *namei();
struct buf *alloc();
struct buf *getblk();
struct buf *getablk();
struct buf *bread();
struct buf *breada();
struct filsys *getfs();
struct file *getf();
struct file *falloc();
int	uchar();

/*
 * Structure of the system-entry table
 */
struct sysent {
	char	sy_narg;		/* total number of arguments */
	char	sy_nrarg;		/* number of args in registers */
	int	(*sy_call)();		/* handler */
};
