/*		Filecopy Utility Program		*/
/*			SUBROUTINES			*/

#define	ver	0
#define rev	0
#define mod    'c'
#define asm    'g'
 
/* File Change History:

    Last change:    6 December 1983	tpl

	0.0c 11/08/83	Moved subroutines needed by ASSIGN into mikesubs.c
	0.0b 10/20/83	Generalize certain functions to facilitate 
			OS independence.
	0.0a 10/10/83	Moved subroutines from filecopy.c
*/

#include "filecopy.os"
#include "switch.os"
#include "filecopy.inc"
#undef	 debug
/*=================================================================*/
/*page*/
makfrgnfcb( fcb, fname, ftype)
forgnfcb *fcb;
CHAR	*fname;
CHAR	*ftype;
{
	fill( fcb, 0, LENfcb);
	moven( fcb -> fname, fname, LENfname);
	moven( fcb -> ftype, ftype, LENftype);
}
/*=================================================================*/

maknatvfcb( fcb, fname, ftype)
nativfcb *fcb;
CHAR	*fname;
CHAR	*ftype;
{
	fill( fcb, 0, LENfcb);
	moven( fcb -> fname, fname, LENfname);
	moven( fcb -> ftype, ftype, LENftype);
}
/*=================================================================*/
#ifdef DEFERED
frompart( part)
CHAR	part[ LENpart];
{
	printf( "Copy FROM which %s driveletter or which ", native);
	printf( "%s partition name?\n", foreign);
	input( part, LENpart);
}
/*=================================================================*/

frompath( path)
CHAR	path[ LENpath];
{
	printf( "Specify optional source path name:\n");
	sinput( path, LENpath);
}
/*=================================================================*/

fromname( fname, ftype)
CHAR	fname[ LENfname];
CHAR	ftype[ LENftype];
{
CHAR	inputbuff[ 15];

	printf( "Copy which files FROM this partition?\n");
	sinput( inputbuff, 15);
	makewild( inputbuff, fname, ftype);
}
/*=================================================================*/
/*page*/
topart( part)
CHAR	part[ LENpart];
{
	printf( "Copy these files TO which %s driveletter or which ", native);
	printf( "%s partition name (or DIR or TREE)?\n", foreign);
	input( part, LENpart);
}
/*=================================================================*/

topath( path)
CHAR	path[ LENpath];
{
	printf( "Specify optional destination path name:\n");
	sinput( path, LENpath);
}
/*=================================================================*/

toname( fname, ftype)
CHAR	fname[ LENfname];
CHAR	ftype[ LENftype];
{
CHAR	inputbuff[ 15];

	printf( "Copy TO which file names in this partition?\n");
	sinput( inputbuff, 15);
	makewild( inputbuff, fname, ftype);
}

/*=================================================================*/
/*page*/
int whichway(part1,part2)
CHAR	*part1;
CHAR	*part2;
{
#ifdef debug
	printf( "determine copy direction: "); disp( part1,LENpart);
	disp( part2, LENpart);
	printf( "letter %d, letter %d\n",
			driveletter(part1),driveletter(part2));
#endif

	if (!driveletter(part1) && driveletter(part2))
		{
		openpart( ((*part2-1) ^ 1) + 1, part1);
		return tonative;
		}
	if (driveletter(part1) && !driveletter(part2))
		{
		openpart( ((*part1-1) ^ 1) + 1, part2);
		return toforeign;
		}
	return error;
}
/*==================================================================*/
#endif
int driveletter( part)
CHAR	*part;
{
#ifdef dbg
	printf("check "); disp( part, LENpart);
#endif
	if ( *part >= 'A' && *part <= 'H' && *(part+1) == ' ')
		return true;
	return false;
}
/*=================================================================*/

overlay( d, s, l)
CHAR	*d, *s;
int	l;
{
	while( l--)
		{ if ( *d == '?') *d = *s;
		++d; ++s;
		}
}
/*===============================================================*/

copymsg( f1, fp1, fn1, ft1 )
CHAR	*f1, *fp1, *fn1, *ft1;
{
CHAR	f1temp[ 20];
CHAR	*end;

	makename( f1temp, fn1, ft1);
	end = copytiln( f1, fp1, ' ', LENpart);
	*end++ = ':';
	copytil( end, f1temp, 0);
#ifdef dbg1
	printf(" copymsg made this: %s.\n", f1);
#endif
}

/*=================================================================*/
/*page*/
int chkoption (file2)
CHAR 	*file2;
{
#ifdef debug
	printf ( "check second parameter: %s\n",file2);
#endif
	if (strcmp( file2, "DIR") found) return dir;
	if (strcmp( file2, "TREE") found) return tree;
	return tofile;
}

/*==================================================================*/

makename( dest, fname, ftype)
CHAR	*dest;
CHAR	*fname;
CHAR	*ftype;
{
CHAR	*period;

#ifdef debug
	printf ("makename:<%-8.8s.%-3.3s>\n", fname, ftype);
#endif
	period = copytiln( dest, fname, ' ', LENfname);
	if ( ftype != ' ')
		*period++ = '.';
	period = copytiln( period, ftype, ' ', LENftype);
	*period = 0;
}

/*=================================================================*/

openpart( drive, part)
CHAR	*part;
CHAR	drive;

{
#ifdef debug
	printf( "open partition %-8.8s", part);
#endif
	if ( !Assign( drive, part)) {
		printf("*** Error: Partition assignment failed.\n");
		return false;
		}
#ifdef debug
	else
		printf("assign succeeded\n");
#endif

	return true;
	}
/*==================================================================*/
#ifdef test
assign (drive, part)
CHAR	drive;
CHAR	*part;
{
#ifdef debug
	printf( "assign drive %c\n", drive);
#endif
	bdos(14,drive-'A');
	printf( "current drive is now %d\n",bdos(25));
	dummy();
	}
/*==================================================================*/


getdpb () {
#ifdef debug
	printf("get %s drive parameter block\n",foreign);
#endif
	notyet();
}

/*==================================================================*/

makealloctab()
{
#ifdef debug
	printf("make %s file allocation table\n",foreign);
#endif
	notyet();
}
/*==================================================================*/

int readfile()
{
#ifdef debug
	printf("read %s record\n",foreign);
#endif
	notyet();
	return(fail);
}
/*==================================================================*/

writefile(record)
CHAR	*record;
{
#ifdef debug
	printf("write record %s\n", record);
#endif
	notyet();
}
/*==================================================================*/
int	FirstDir( mask)
forgnfcb *mask;
{
cpmdir  *cpmmask;
CHAR	curdrive;
int	where;
CHAR	*here;
char	*zapp;
#ifdef debug
	printf( "find first occurrence of directory entry\n");
#endif
	moven( cpmmask -> fname, mask->fname, 8);
	moven( cpmmask -> ftype, mask ->ftype, 3);
	disp( cpmmask->fname,8);
	disp( cpmmask->ftype,3);

	cpmmask -> user = 0;
	cpmmask -> extent = 0;
	here = cpmmask;
	for(where=1; where<12; ++where) 
		putchar(here[where]);
	dummy();
	where =  bdos(17,cpmmask);
	dmasect = GetDMA();
	zapp = dmasect+where;   *zapp = 'X';
	printf( "bdos 17 returns %d\n",where);
	return where;
}
/*==================================================================*/


int	NextDir( mask)
forgnfcb *mask;
{
cpmdir	*cpmmask;
int	where;
char	*zapp;

#ifdef debug
	printf( "scan for next directory entry\n");
#endif
	moven( cpmmask -> fname, mask->fname, 8);
	moven( cpmmask -> ftype, mask ->ftype, 3);
	dummy();
	where = bdos(18,cpmmask);
	printf("bdos 18 returns %d\n",where);
	dmasect = GetDMA();
	zapp = dmasect+where;   *zapp = 'X';
	return where;
}
#endif
/*==================================================================*/

int	posnextdir( fcb, mask, direction)
CHAR	*fcb;
CHAR	*mask;
CHAR	direction;
{
static serchCount = 1;
int	dmapos;
CHAR	i;

#ifdef debugP
	printf( "p..posnextdir     position to previous dir & scan to next\n");
#endif
	switch (direction) {
		case FROMforeign:
			FirstDir( fcb);
			return NextDir( mask);

		case FROMnative:
			SrchFrst( mask );
#ifdef dbg1
	printf( "        serchCount: %x hex\n", serchCount);
#endif
			for ( i=0; i<serchCount; ++i)
			    dmapos = SrchNext();
			++serchCount;			
			return dmapos;
		default:
			printf(" Fatal error in 'posnextdir'. Direction unknown.\n");
			zabort();
	} /* switch*/

	}/*posnextdir*/

/*==================================================================*/

curdir(clust)
int	clust;
{
#ifdef debug
	printf("set current directory at cluster %d\n", clust);
#endif
	/* set new current directory */
	notyet();
}
#ifdef debug
presskey () {
	printf ("Press any key to continue"); 
	getchar (); 
	putchar ('\n'); 
	} 
#endif
/*= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = */

