
/*======================================================================*/
/*	SQUASH.C	- main routine and user interface for the 	*/
/*			  SQUASH program.				*/
/*======================================================================*/

#include "c:libc.h"
#include "standard.inc"

#define Banner "Squash 0.1a *** IN-HOUSE TEST PROGRAM NOT FOR RELEASE ***\n"
#define	NODEBUG	0

#define beep()		putchar ('\n');

#define NoHD		"The Hard Disk is not operative.\n"

/*======================================================================*/
/*	init_hard_disk	-	initialize hard disk			*/
/*======================================================================*/
init_hard_disk () {

	if (!hd_init ()) {
		beep ();
		printf (NoHD);
		return FALSE;
		}
	return TRUE;
	}


/*======================================================================*/
/*				MAIN					*/
/*======================================================================*/
main () {
	printf (Banner);
	if (init_hard_disk ()) {
		initialize ();
		MoveParts ();
		printf ("Done!");
		return (0);
		}
	else
		return (1);
	}


/*page*/
#include "alloctbl.dat"
#include "hardio.h"

#define	SECTSIZE	128
#define	DATtrack	0x00
#define DATsector	0x79
#define	DATlength	8

/*======================================================*/
/*	Things related to disk and partition size	*/
/*======================================================*/
#define PartDelete(p)	((p)->name [0] == 'd')
#define PartExists(p)	((p)->size != 0 && (p)->size != 0xE5)
/* indexed by DAT size byte */
#define SIZEMAX		7

#define SizeName(s)	(sizename [(s)])
CHAR	*sizename [SIZEMAX] = {
	"Unknown",
	"256K",
	"512K",
	"1M",
	"2M",
	"4M",
	"8M"
	};

/*page*/
/*======================================================================*/
/*			Disk I/O stuff					*/
/*======================================================================*/
#define getDAT(b)	hd_xfer (READ, DATtrack, DATsector, b, DATlength)
#define putDAT(b)	hd_xfer (WRITE, DATtrack, DATsector, b, DATlength)

/*======================================================================*/
/*			GLOBAL VARIABLES				*/
/*======================================================================*/
struct a_entry	alloc_table [NallocEntries];	/* disk allocation table	     */

/*page*/
/*======================================================================*/
/*	initialize	- initialization				*/
/*======================================================================*/
initialize () {
struct a_entry	*p;

#ifndef NODEBUG
	printf ("======== INITIALIZE =======\n");
#endif

	
	getDAT (alloc_table);
	}

/*======================================================================*/
/*	dump_alloc	- debugging dump of alloc table			*/
/*======================================================================*/
dump_alloc (tbl, msg)
struct	a_entry	*tbl;
CHAR		*msg;
{
struct	a_entry	*p;
int	i;

	printf ("===============================================================================\n");
	printf ("%s\n", msg);
	printf ("===============================================================================\n");
	for (p = tbl, i = 0; p != &tbl [NallocEntries] && PartExists (p); 
			++p, ++i) {
		printf ("\t%d:%8.8s %s\n", i, p->name, SizeName (p->size));
		}
	printf ("===============================================================================\n");
	}

/*page*/
/*======================================================================*/
/*	MoveParts	- Move partitions if necessary.			*/
/*======================================================================*/
MoveParts () {
struct	MoveEntry	*m;
struct	a_entry	*p;
int				i;

	dump_alloc (alloc_table, "Before SQUASH");
	if (alloc_table [0].size <= 1) {
		printf ("Partition Zero already is the smallest partition size.\n");
		return FALSE;
		}
	if (alloc_table [0].size == alloc_table [1].size
		&& PartExists (&alloc_table [0])) {
		--alloc_table [0].size;
		++alloc_table [1].size;
		}
	else if (!PartExists (&alloc_table [NallocEntries])) {
		printf ("Can't do squash.\nThere is no room in Disk Allocation Table for another Partition\n");
		return FALSE;
		}
	else {
		--alloc_table [0].size;
		for (i = NallocEntries-1; i >= 1; --i)
			blockmv (&alloc_table [i], &alloc_table [i - 1], 
				sizeof (struct a_entry));
		blockmv (&alloc_table [1].name, "deleted ", 8);
		}
		
	dump_allloc (alloc_table, "After SQUASH");
	putDAT (alloc_table);

	}

/*======================================================================*/

