
/*==============================================================*/
/*			SYSUP Utility				*/
/*			Module 1 - Main program			*/	
/*==============================================================*/

#include "sysup.os"
#include "switch.os"
#include "sysup.h"

#define Banner1	"SYSUP1 12/27/83 11:26\n"
#define isprint(c) (c > 0x19 && c < 0x7F)
#define SUBFILE	"$$$.SUB"

BOOLEAN FindColdBoot ();
BOOLEAN	ColdBoot_Upgrade ();


#ifdef cpm80
#define USERNO	(*(CHAR *) 0x47)
#else
#define USERNO	WHAT?, I don't know!
#endif

#define beep()	putchar ('\7')

#define SINGLE	0
#define MASTER	2

/*page*/
/*==============================================================*/
/*		ONE LINE MESSAGES				*/
/*==============================================================*/
#define Blank		"                                                "
#define BadBIOStype	"Invalid BIOS selection\n"
#define CaseBiosErr	"ERROR - Invalid case in BIOS selection\n"
#define DoBkupMsg	"\nPlease backup your disk before running SYSUP.\n"
#define DoMachMsg	"\nPlease run machine before running SYSUP.\n"
#define ExitMsg	"Exiting SYSUP, upgrade aborted.\n"
#define FinishedSysup	"SYSUP completed sucessfully.\n" 
#define NoHardDisk	"\nThe Hard Disk is not operational.\n"
#define NotaChoice	"      Sorry, that command is not in the menu."
#define SubmitError	"Error trying to start INSTALL\n"
#define YesNoPlease	"      Please type Y or N."                    

/*==============================================================*/
/*		STATUS MESSAGES					*/
/*==============================================================*/
#define DoColdBoot	" Upgrading the Cold Boot Loader.           "
#define DoneColdBoot	" The Cold Boot Loader is Upgraded.         \n"

#define	DoFWT		" Upgrading the First Write Table.          "
#define DoneFWT		" The First Write Table is Upgraded.        \n"

#define DoOST		" Upgrading the Operating System Table.     "
#define DoneOST		" The Operating System Table is Upgraded.   \n"

#define DoPT		" Upgrading the Product Type Table.         "
#define DonePT		" The Product Type Table is Upgraded.	    \n"

#define DoSD		" Upgrading the System Directory.           "
#define DoneSD		" The System Directory is Upgraded.         \n"

#define DoUCT		" Upgrading the User Configuration Table.   "
#define DoneUCT		" The User Configuration Table is Upgraded. \n"

#define DoUNT		" Upgrading the User Name Table.            "
#define DoneUNT		" The User Name Table is Upgraded.          \n"

#define DoDAT		" Upgrading the Partition Alloc Table.   "
#define DoneDAT		" The Partition Alloc Table is Upgraded.    \n"

/*page*/
/*==============================================================*/
/*		MENUS AND LONG MESSAGES				*/
/*==============================================================*/


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*bios_menu [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"CONFIGURATION SELECTION MENU\n",
"----------------------------\n",
"M - MASTER             Configure your disk as a HiNet master.\n",
"S - SINGLE USER        Configure your disk as a single user system.\n", 
"Q - QUIT               Leave this program.\n",
"\n",
"\n",
"Menu Choice   --->",
NULL
};

CHAR	bios_cmds [] = "qms";

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*CantBeMaster [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"===================================================================\n",
"=        This program will not work on a running master.          =\n",
"=        You can run SYSUP if you boot from a floppy disk.        =\n", 
"===================================================================\n",
"\n",
NULL
};


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*FailedToCopyNewColdBoot [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
" copy failed!\n",
"SYSUP failed to copy the new cold boot loader into the system partition.\n",
"	**** POSSIBLE ERROR ON UPGRADE FLOPPY DISK ****\n",
"\n",
NULL 	
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*MasterUpgrade [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"Your disk is now a Separated Boot HiNet Master.\n",
"\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*NoColdBootLoader [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
" not found!\n",
"No cold boot loader was found on the upgrade floppy disk!\n",
"Your upgrade disk should contain the files:\n\n",
"\tHBOOT5.SYS - Single user cold boot loader for 5\" hard disks.\n",
"\tHBOOT8.SYS - Single user cold boot loader for 8\" and 12\" hard disks.\n",
"\tMBOOT5.SYS - Master cold boot loader for 5\" hard disks.\n",
"\tMBOOT8.SYS - Master cold boot loader for 8\" or 12\" hard disks\n",
"\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*SingleUpgrade [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"Your disk is now a CPM single user system.\n",
"\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*SysupAlready [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"===============================================================================\n",
"=       This system has already been upgraded to seperated boot,              =\n",
"=       SYSUP has been run once and does not need to be run again.            =\n",
"===============================================================================\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*warn1_msg [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"===============================================================================\n",
"=         HAVE YOU MADE A BACKUP OF THE DISK YOU WISH TO UPDATE?              =\n",
"===============================================================================\n",
"This program upgrades your HiNet disks to the new HiNet system.\n",
"It must be run once to install the new system, and should be run ONLY ONCE.\n",
"\n",
"Before running this program you must do two things:\n",
"\n",
"1. Make a backup of the disk you wish to upgrade.  Be sure to backup the\n",
"   whole disk, including partition zero.  Failure to take this precaution\n",
"   may result in the loss of your data\n",
"\n",
"2. Run the MACHINE utility and write the the model codes and serial\n",
"   numbers for the machines at your installation to the machine table\n",
"   in partition zero.\n",
"\n",
"Have you made a backup of the disk you wish to upgrade, including partition 0?\n",
"(Y or N) -->",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*warn2_msg [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"Have you run the MACHINE utility?\n",
"(Y/N) -->",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
CHAR	*WontWriteMaster [] = {
/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
"\n",
"=================================================================\n",
"=           This program cannot be run on a network,            =\n",
"=          please boot from a floppy disk to run SYSUP.         =\n",
"=================================================================\n",
"\n",
NULL
};

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
/*page*/
/*==============================================================*/
/*	GLOBAL VARIABLES					*/
/*==============================================================*/
extern CHAR	*cbname;	/* inported Cold Boot Loader file name	*/
				/* from SYSUP2 module			*/
int	BIOStype;
CHAR	*SubMaster [] = {
		"INSTALL GENERIC",
		NULL
		};

CHAR	*SubSingle [] = {
		"INSTALL ALONE",
		NULL
		};

/*page*/
/*==============================================================*/
/*	backup_warning	- issue a warning about the importance	*/
/*			  backups and give the user a chance to	*/
/*			  back out of doing the upgrade		*/
/*==============================================================*/
backup_warning () {
CHAR	c;

	show_menu (warn1_msg);
	if (!get_yesno (YesNoPlease)) {
		printf (DoBkupMsg);
		exit_sysup ();
		}
	else
		putchar ('\n');
	 
	show_menu (warn2_msg);
	if (!get_yesno (YesNoPlease)) {
		printf (DoMachMsg);
		exit_sysup ();
		}
	else
		putchar ('\n');
	 
	}


/*page*/
/*==============================================================*/
/*	exit_sysup	- exit the sysup program		*/
/*==============================================================*/
exit_sysup () {
	printf (ExitMsg);
	exit (0);
	}
zabort () {exit_sysup();}

/*page*/
/*==============================================================*/
/* initialize	- initialize hard disk drivers			*/
/*==============================================================*/
initialize () {
#ifndef NODEBUG
	printf ("\t**** DEBUGGING ENABLED ****\n");
#endif
	if (!USERNO) {
		beep ();
		show_menu (CantBeMaster);
		exit_sysup ();
		}

	if (USERNO != 0xFF) {
		beep ();
		show_menu (WontWriteNet);
		exit_sysup ();
		}

	if (!hd_init ()) {
		beep ();
		printf (NoHardDisk);
		exit_sysup ();
		}
	if (SepBoot ()) {
		show_menu (SysupAlready);
		exit_sysup ();
		}
#ifndef NODEBUG
	printf ("\n--Hard Disk Initialized\n");
#endif
	}

/*page*/
/*==============================================================*/
/* select_bios	- user select which BIOSs to have on the new	*/
/*		  system partition				*/
/*==============================================================*/
select_bios () {
CHAR	c;

	c = do_menu (bios_menu, bios_cmds, NotaChoice);
	putchar ('\n');
	switch (c) {
	case 'q':
		exit_sysup ();
		break;
	case 's':
		BIOStype = SINGLE;
		break;
	case 'm':
		BIOStype = MASTER;
		break;
	default :
		beep ();
		printf (CaseBiosErr);
		exit_sysup ();
		break;		 
	}

	}

/*page*/
/*==============================================================*/
/*	update_tables	- read in tables and convert them to	*/
/*			  the new format, and write them out	*/
/*			  write out tables that never existed	*/
/*			  before.				*/
/*==============================================================*/
update_tables () {
#ifndef NODEBUG
	printf ("--Updating Tables\n");
#endif
	PWT_upgrade ();	/* Password Table (Shhh!)		*/

	printf (DoUNT);
	UNT_upgrade (); /* User Name Table 			*/
	backup (strlen (DoUNT));
	printf (DoneUNT);

	printf (DoUCT);
	UCT_upgrade (); /* User Configuration Table		*/
	backup (strlen (DoUCT));
	printf (DoneUCT);

	printf (DoFWT);
	FWT_upgrade (); /* First Write Table			*/
	backup (strlen (DoFWT));
	printf (DoneFWT);

	printf (DoPT);
	PT_upgrade (); /* Product Type Table			*/
	backup (strlen (DoPT));
	printf (DonePT);

	printf (DoOST);
	OST_upgrade (); /* Operating System Table		*/
	backup (strlen (DoOST));
	printf (DoneOST);

	printf (DoSD);
	SD_upgrade  (); /* System Directory			*/
	backup (strlen (DoSD));
	printf (DoneSD);

	printf (DoDAT);
	DAT_upgrade  (); /* Disk Allocation Table		*/
	backup (strlen (DoDAT));
	printf (DoneDAT);
	}

/*page*/
/*==============================================================*/
/*			MAIN					*/ 
/*==============================================================*/
main (argc, argv)
int	argc;
CHAR	*argv[];
{
	printf (Banner);

	initialize ();
	backup_warning ();

/*	select_bios ();

#ifndef NODEBUG
	printf ("--");
	if (BIOStype == MASTER) printf ("Master BIOS\n");
	else if (BIOStype == SINGLE) printf ("Single BIOS\n");
	else printf ("Unknown Bios Selection!!\7\7\n");
#endif

	if (FindColdBoot ()) {
		putchar ('\n');
		beep ();
		printf (cbname);
		show_menu (NoColdBootLoader);
		exit_sysup ();
		}
	printf (DoColdBoot);
	if (ColdBoot_Upgrade ()) {
		putchar ('\n');
		beep ();
		printf (cbname);
		show_menu (FailedToCopyNewColdBoot);
		exit_sysup ();
		}
	backup (strlen (DoColdBoot));
	printf (DoneColdBoot);
*/
	update_tables ();
	printf (Blank); /* blank last status message */
	backup (strlen (Blank));
	printf (FinishedSysup);
/*	if (BIOStype == MASTER) {
		show_menu (MasterUpgrade);
		submit (SUBFILE, SubMaster);
		}
	else if (BIOStype == SINGLE) {
		show_menu (SingleUpgrade);
		submit (SUBFILE, SubSingle);
		}
	else {
		beep ();
		printf (BadBIOStype);
		}
*/
#ifndef NODEBUG
	printf ("--Done!");
#endif
	return (0); /* for submit file stuff */
	}

