/*			USERS		module 3
						Read_Assignments
    "us3.c"
*/
/*=============================================================================
			INCLUDES
*/
/*
#define		debug3		FALSE
*/

#include	"users.os"
#include	"standard.inc"

#define		EXTERNal	0

#include	"users.dat"


/*=============================================================================
			HISTORY

date		5 February 1984
person		tpl

ver	0
rev	0
mod	b
patch	5

 ver / rev
"""""""""""
    0/0

     mod  patch
    """"""""""""
	a10		30 January 1984		tpl
		.RELEASED TO SOFTWARE TEST.

	a0		19 December 1983	tpl
		.Create this module from last half of us2a.c
*/
/*page*/
/*=============================================================================
			ROUTINES
*/
/*---------------------------------------------------------------------------*/

Read_Assignments( u_entry, c_entry, entry_num, accept_return )
  struct users_entry	*u_entry;
  struct config_entry	*c_entry;
  int	entry_num;
  int	accept_return;
{
  register CHAR		j, length, *cur_assignment;
  CHAR	partition, status, valid_assignment;

    putz("\n\
Enter the default partition assignments.\n\
Only local floppy or master hard disk partition assignments allowed.\n\
Enter U: for 'unassigned', except for drive A which \n\
must have a default assignment.\n");

    for ( j=0; j<Nassignments; ++j)
    {
	cur_assignment = c_entry->assignment[j];	/* To save code. */
	partition = NallocEntries;	/* Set to no partition.	*/
	valid_assignment = FALSE;
	do	/* while( !valid_assignment ) */
	{
	    printz("\n    %c:  --> ", 'A' + j );
	    clear( input_buffer, Lname, SPACE );
	    while ( (( length = Tintostring(input_buffer, Lname, FALSE) ) == 0)
		    && (!accept_return) )
		ptch( BELL );	/* if just RETURN not acceptable, just beep. */

	/* Just a RETURN input (length = 0) means use old assignment if */
	/* accept_return is true, which we know it is if we reach here. */
	    if (length == 0)
	    {
		blockmv( cur_assignment,
			 &config_table[ entry_num ].assignment[j], Lname );
		printz("%.8s", cur_assignment);
		valid_assignment = TRUE;
		continue;
	    }

	    strUpper( input_buffer );
   /* Clear '\0' so later compares with partition names work with 'strncmp'. */
	    input_buffer[length] = SPACE;

	    if ( length == 2)
	    {
		if ( strncmp( input_buffer, "U:", 2) == 0 )
		{
		    if ( j == 0 )	/* Can't have drive A be unassigned. */
		    {
			printz("%c     Drive A must be assigned.\n", BELL);
			continue;
		    }
		    else
		    {
			blockmv( cur_assignment, input_buffer, Lname);
			valid_assignment = TRUE;
			continue;
		    }
		} /* if U: input */
	    }

	    if ( length == LflopNames )
		if ( Is_Floppy( input_buffer ) )
	        {	/* If is a floppy name then assign the floppy. */
		    blockmv( cur_assignment, input_buffer, Lname);
		    valid_assignment = TRUE;
		    continue;
		}


	    switch( Is_OK_Partition( input_buffer, u_entry, &partition) )
	    {
		case OK:
		/* if status == OK then assign partition.	*/
			blockmv( cur_assignment, input_buffer, Lname);
			valid_assignment = TRUE;
			break;

		case WRONGos:
			printz("%c    That is not a", BELL);
			switch( u_entry->op_sys & 0xf0 )
			{
			    case CPMsys:
					putz(" CPM");
					break;
			    case MSDOSsys:
					putz("n MSDOS");
					break;
			    default:
					putz(" ? ");
					break;
			}
			putz(" type partition.\n");
			break;

		case NOTexisting:
			printz("%c    There is no partition by that name.\n",
							BELL);
			break;

		case CANTshare:
			printz("%c\n    That is a shared partition.\n", BELL);
			putz("This user is not using HiDos and can not\
 assign to shared partitions.\n");
			break;

	    } /* switch */

	} while( !valid_assignment );

	if ( (partition != NallocEntries)
		&& (alloc_table[ partition ].control & PRTCTMASK) == OWNABLE )
	{
	    putz("\n\
    This is an Ownable partition.\n\
    Do you want immediate ownership\n\
    upon login? (y/n) :");

	    if ( Get_Yes_No(RETNOTOK) )
		*cur_assignment |= OWNonLogin;
	}

    } /* for all assignments */

    putz("\n");


} /* Read_Assignments */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Is_Floppy( name )
  CHAR	*name;
{
  register CHAR		i;

#ifdef debugP
	printz("p...Is_Floppy\n");
#endif

    for ( i=0; i<NflopNames; ++i )
	if ( strncmp( name, floppy_names_table[i], LflopNames ) == 0)
	    return TRUE;

    return FALSE;

} /* Is_Floppy */

/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Is_OK_Partition( name, u_entry, partition )
  CHAR	*name;
  struct users_entry	*u_entry;
  CHAR *partition;

{
/* Check if partition exists and check if OS types agree ( CPM or MSDOS ).   */

#ifdef debugP
	printz("p...Is_OK_Partition\n");
#endif

    if ( (*partition = Get_Partition( name )) == NallocEntries )
/*	return NOTexisting;
	Get_Partition should check all volumes --- for now if we can't find a
	 partition, then we will assume it's OK */
	return OK; 


    switch( alloc_table[ *partition ].control & OSMASK )
    {
	case MSDOS:

		if ( (u_entry->op_sys & 0xf0) != MSDOSsys )
		{
		    *partition = NallocEntries;
		    return WRONGos;
		}
		else
		    return OK;
		break;

	case CPM:

		if ( (u_entry->op_sys & 0xf0) != CPMsys )
		{
		    *partition = NallocEntries;
		    return WRONGos;
		}
		else
		    break;
	default:
		{
		    *partition = NallocEntries;
		    return WRONGos;
		}
    } /* switch */

/* To get here, the users os type is CPM and the partitions is too.	     */
/* Next check for trying to assign a shared partition to a non-hidos system. */

    if ( ((alloc_table[ *partition ].control & SHARED) == SHARED)
	&& ((u_entry->op_sys & 0x0f) != HIDOSsys) )
    {
	*partition = NallocEntries;
	return CANTshare;
    }
    else
	return OK;

} /* Is_OK_Partition */


/*---------------------------------------------------------------------------*/
/*page*/

CHAR
Get_Partition( partName )
  CHAR *partName;
{
  register CHAR		i = 1;		/* Don't check Control Area. */

    while ( ( alloc_table[i].size != 0) && (i<NallocEntries) )
    {
	if (strncmp( partName, alloc_table[i].name, Lname) == 0)
	    return(i);
	++i;
    }

    return ( NallocEntries );

} /* Get_Partition */

/*---------------------------------------------------------------------------*/

/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
