.title	'Copy hard disk partition to partition'
	.sbttl	'COPYPART'
version	==	1
revision==	2	;last change 10-June-82
	.pabs
	.phex
	.loc	100h
;----------
; This program copies one hard disk partition to
; another hard disk partition.  The format of the
; COPYPART command is:
;
;		COPYPART x = y
;
; x is the destination drive (A-D).
; y is the source drive (A-D).
; 
; COPYPART verifies that both drives are assigned to 
; hard disk or network partitions, and that both
; partitions are the same size.  It also verifies that
; that the same drive is not specified as the sending
; and receiving drive.  If all is ok, the copy
; operation begins.  One CP/M track (128 sectors = 16K)
; is read from the source drive, then written to the
; destination drive.  A dot is printed on the screen
; after each track is copied.  After all tracks have
; been copied, a message is printed and the program
; terminates.
;
; revision 1: 	Convert the program to work on both
; 	     	CP/M 1 and 2.  Les Wilson and
; 	      	Doug Brentlinger 12/22/81
;
; revision 2:	utilize new cpmmap for multi
;		hard disk bios
;---------------
.page
	.sbttl	'equates'
;
;	device types as returned by cpmmap
;
sd	==	0<5	;single density 8 inch floppy
dd	==	1<5	;double dens 8 inch flop
hard	==	2<5	;hard disk map
net	==	3<5	;network map
mini1	==	4<5	;1 sided mini(5inch) floppy
mini2	==	5<5	;2 sided mini floppy
.page
.sbttl	'MACRO DEFINITIONS'
;---------------
;	jump if de not equal to register hl
;	(note: register a destroyed by compares
;
	.define	jumpdenothl[location]=[
	mov	a,e
	cmp	l
	jnz	location
	mov	a,d
	cmp	h
	jnz	location	]
;---------------
;	floptest, see if disk is a floppy and set up
;	for determining size
;
	.define floptest[%ok]=[
	pop	PSW	;get the accum back
	mov	C,A
	call	SELDSK
	call	CPMMAP
	dcx	h	;point to media type
	mov	a,m
        lxi	D,flopmsg
	cpi	hard	;is a hard disk partition
	jrz	%ok
	cpi	net	;is a net partition
	jnz	error	
%ok:
	inx	h	;make h as returned 
			;from cpm map
		]
.page
.sbttl "MAIN"
;---------------
; Greet the user
	lxi	SP,100h
	lxi	D,logmsg
	mvi	C,prtstrg ;CP/M 9, Print String
	call	BDOS
;---------------
; Check com line for source and destination partitions
;
	call	BLANKS	; zero or more blanks
	call	GETDSK	; destination disk
	sta	dstdsk
	call	BLANKS	; zero or more blanks
	cpi	'='	; equals sign
	lxi	D,synmsg ;syntax error messge
	jnz	error
	call	BLANKS	; zero or more blanks
	call	GETDSK	; source partition
	sta	srcdsk
	lxi	H,dstdsk ;compare source and
	cmp	m	 ;destination partition
	jrnz    ..ok
	lxi	D,sammsg ;same source and destination
	jmp     error    ;print error message and die
..ok:	lhld	comchr
	lda	cmdlin  
	adi	80h
	cmp	L
	jrz	..0	
        lxi	D,synmsg ;error if extra command chars
	jmp	error
;---------------
; Determine disk size
..0:	lda	dstdsk
	call	GETSIZE	; destination size
	sded	numtrk
	lda	srcdsk
	call	GETSIZE	; source size
	lhld	numtrk
	jumpdenothl sizerr 
.page
;---------------
; Copy from track 0 to numtrk - 1
	sub	A
	sta	curtrk
;---------------
; Read 16K from source disk
readloop:
	lda	srcdsk
	sta	curdsk
	lxi	H,iobuff
	shld	curdma
	mvi	A,1
	sta	cursec
..1:
	call	SETUP
	call	READ
	call	NEXTSEC
        jrnz	..1
;---------------
; Write 16K to destination disk
;
	lda	dstdsk
	sta	curdsk
	lxi	H,iobuff
	shld	curdma
	mvi	A,1
	sta	cursec
..2:	
        call	SETUP
	call	WRITE
	call	NEXTSEC
	jrnz	..2
;---------------
; Advance to next track
;
	mvi	E,'.'
	mvi	C,conout
	call	BDOS	; print a dot after 16K copied
	lhld	curtrk
	inx	h
	shld	curtrk	; increment track number
	lded	numtrk
	jumpdenothl readloop
	lxi	D,donemsg
	mvi	C,prtstrg
	call	BDOS    ; print "Partition copied OK"
	jmp	0	; warm boot
.page
.sbttl "ERROR ROUTINES"
;---------------
sizerr: lxi	D,sizmsg ;partitions are not same size
;
error:
	mvi	C,prtstrg
	call	BDOS	; print error message
	jmp	0	; warm boot
;
.page
.sbttl "SUBROUTINES"
;---------------
; Skip zero or more blanks on command line
;  Regs out:  A = next non-blank char
BLANKS:
	lhld	comchr
	inx	H
	shld	comchr	; increment command line pointr
	lda	cmdlin
	adi	81h
	cmp	L
	lxi	D,synmsg 
	jz	error	; error if end of command line
	mov	A,M	; get current command line char
	cpi	' '	
	jrz	BLANKS	; if blank, then scan some more
	ret		; if non-blank, then return
;---------------
; Extract disk number from command line
;  Regs in:  A = disk selection (A-D) from command line
;  Regs out: A = legal disk number (0-3)
GETDSK:
	sui	'A'	; convert uppercase A-D to 0-3
	cpi	0
	jnc	..1	; error if < 0
	lxi	D,dskmsg
	jmp	error
..1:	cpi	4
	rc		; return if legal disk selector
	sui	'a'-'A'	; convert lowercase a-d to 0-3
	cpi	0
	jnc	..2
	lxi	D,dskmsg ;error if < 0
	jmp	error
..2:	cpi	4
	jc	..3
	lxi	D,dskmsg ;error of > 3
	jmp	error
..3:	ret
.page
;---------------
; Extract disk size from disk parameter table in BIOS
;  Regs in:  A = disk to be sized (0-3)
;  Regs out: de = disk size (in CP/M tracks, 16-512)
GETSIZE:
	push	PSW	;save the accum
	mvi	C,setdsk ;CP/M 13, Reset Disk System
	call	BDOS
	mov	A,L	;if version # = 0, don't jump
	ora	A
	jrnz	CPM2	;we have a 2 version of CP/M
	floptest
	inx	H
	inx	H
	inx	H
	inx	H
	mov	A,M	; get "sectors per block - 1"
	inr	A
	slar	A	; compute tracks per disk
	jc	d1
	mvi	d,0
	jmpr	dset
d1:	mvi	d,1
dset:	mov	e,a
	ret
; Subroutine Getsize continues on the next page
.page
CPM2:	
	floptest
	inx	H
	inx	H
	inx	H
	mov	A,m	;HL address + 2 memory
	cpi	3	;implied block size of 1k
	jrz	siz256	;used only for 256K partition
	cpi	5	;implied block size of 4k
	jrz	siz8meg ;used only for 8 meg partition
        lxi     D,3
	dad	D	;HL addr + 5
	mov	E,m
	inx	H	;DE = L and L + 1
	mov	D,m	;DE = blocks
 	inx	D
	srlr	E
	srlr	E
	srlr	E	;divide low order of blocks by 8
	mov	a,d
	slar	a	;divide high order of blocks by
			;8 getting bits to go into 
                        ;low order byte (remainder)
	slar	a
	slar	a
	slar	a	;shift low bits to hi bits
	slar	a	;and then to the hi bits of
	ora	e	;E
	mov	e,a
	srlr	d
	srlr	d
	srlr	d	;divide high order bytes by 8
	ret
siz256:	lxi	D,16	;# of tracks on 256 K part
	ret
siz8meg:lxi	D,200h  ;# of tracks on 8 meg partition
	ret
.page
;--------------
; Advance to next sector
;  Regs out:  Z flag set if end of track
NEXTSEC:
	lda	cursec
	cpi	128
	rz
	inr	A	
	sta	cursec  ; increment sector number
	lhld	curdma
	lxi	D,128
	dad	D
	shld	curdma	; increment DMA address
	ret
;--------------
; Setup a CP/M disk operation
SETUP:
	lda	curdsk
	mov	C,A
	call	SELDSK	; set disk number
	lbcd	curtrk
	call	SETTRK	; set track number
	lda	cursec
	mov	C,A
	call	SETSEC	; set sector number
	lbcd	curdma
	call	SETDMA	; set DMA address
	ret
.page
;----------
; CP/M BIOS interface
SELDSK:	lxi	D,18h	; set disk number
	jmpr	BIOS
SETTRK:	lxi	D,1Bh	; set track number
	jmpr	BIOS
SETSEC: lxi	D,1Eh	; set sector number
	jmpr	BIOS
SETDMA:	lxi	D,21h	; set DMA address
	jmpr	BIOS
READ:	lxi	D,24h	; read
	jmpr	BIOS
WRITE:	lxi	D,27h	; write
	jmpr	BIOS
CPMMAP:	lxi	D,60h	; get disk parameter table
BIOS:
	lhld	1
	dad	D
	pchl
.page
.sbttl "CONSTANTS"
;---------------
; Constants
;
iobuff	==	4000h	; 16K I/O buffer
cr	==	0Dh	; return
lf	==	0Ah	; line feed
cmdlin  ==	80h	; user command line
BDOS	==      5h
conout	==	2h	; CP/M 2,  Console Out
prtstrg ==	9h	; CP/M 9,  Print String
setdsk  ==	0ch	; CP/M 13, Reset Disk System
comchr:	.word	80h	; command line pointer
dstdsk:	.byte	0	; destination disk (0-3)
srcdsk:	.byte	0	; source disk (0-3)
numtrk:	.word	0	; CP/M tracks on disk (16-512)
curdsk:	.byte	0	; current disk (0-3)
curtrk:	.word	0	; current track (0-511)
cursec:	.byte	0	; current sector (1-128)
curdma:	.word	0	; current DMA address
;---------------
;
logmsg: .ascii	'COPYPART version '
	.byte	version+'0','.',revision+'0',cr,lf,'$'
dskmsg:	.ascii	'Must select drive A,B,C, or D in '
	.ascii  'command line $'
synmsg:	.ascii	'Copypart command line syntax is: '
	.ascii  'Copypart (rec drive) = (send drive) $'
flopmsg:.ascii	'Source or destination disk is '
	.ascii	'assigned to a floppy disk drive $'
sizmsg: .ascii	'Source and destination disk partition'
	.ascii	' sizes do not match$'
sammsg: .ascii  'Source and destination drives are '
 	.ascii  'the same $'
donemsg:.ascii	[cr][lf]'Partition copy completed$'
;
	.end
