	.page
	.sbttl	'equates'
equversion	==	0
equrevision	==	2	;last change 4-Oct-82

;
;	the following are equates used in both rom
;	and ram firmware
;
	
true	== 0ffh
false	== 0

maxvol	==	3	;largest valid volume number

;
;
FLTCLRBIT	==	40H

INPORT		==	0FBH
OUTPORT		==	0FBH

COMMAND		==	0FCH	;COMMAND	PORT OUT
PSTATUS		==	0FCH	;host status port

CSTATUS		==	0FDH	;controller status internal_
				;w/r complete, header read complete

clearindex	==	0feh	;clear index status 
				;flip flop

HSTATUS		==	0FFH	;DISK STATUS PORT
FCCOMD		==	0FFH
HEADSPORT	==	0FFH	;HEAD SEL PORT
				;ALSO STEP AND DIR PORT
;
;
; COMM PORT COMMANDS
;
bootunit	==	0ffh	;(-1) boot unit no
			;for multiple drive systems
			;unit passed in phytrack parameter
INITUSER	==	0
ABSRDCOMM	==	1
ABSWRTCOMM	==	2
LDUSER		==	3
FWRITE		==	4
GMEMCOM		==	5	;LAST OF ROM COMMANDS.

TSTINT		==	6	;special commands
RREAD		==	7
MTEST		==	8
FRMATCOM	==	9

warmboot	==	10h	;standard firmware commands
cpmread		==	11h
cpmwrite	==	12h
cpmselect	==	13h
flush		==	14h
netread		==	15h
netwrite	==	16h
assign		==	17h
unitinfo	==	18h

oasisread	==	21h
oasiswrite	==	22h

;
COMMSIZE	==	8	;SIZE OF COMMAND BUFFER
;
; HAND SHAKING
;
REQTOSEND	==	51H
CLEAR		==	52H
NOCLEAR		==	0A1H
;
;


;
;	error returns from hard disk controller
;
hdewritefault	== 11h	;write fault
hdenotready	== 12h	;drive not ready
hdetimeout	== 13h	;internal timeout
hdereadafterwrite == 14h ;
hdeunprocessederr == 15h ;firmware not present
			;to try error correction/
			;processing
hdeunitnotpresent == 16h ;failure from select 
			;unit/partition
hdenoindex	== 17h	;unable to find index mark
			;on disk
hdeseektimeout	== 18h	;timeout in seeking track
hdehometimeout	== 19h	;timeout in seeking track 0
hdeinit		== 20h	;error in firmware init
			;process
hdepreviousgone == 21h	;could not find sector-1 
hdeheaderbad	== 22h	;bad track,head,or sector
			;in header
hdechecksum	== 23h	;header checksum error
hdebdtrack	== 24h	;track invalid (too big)
hdebdhead	== 25h	;head invalid for drive
hdebdsector	== 26h	;sector invalid (too big)
hdebdvolume	== 27h	;invalid volume selected
hdeversionbad	== 28h	;firmware version on drive other
			;than zero is different than version
			;on zero
hdeduplicatevollabel == 29h ;volume label is duplicate
			;of volume zero label
hdecpmmapping == 30h	;unable to map cpm track,sector
			;to harddisk track,head,sector
hdedatacrc	== 40h	;data crc error, no correction
			;attempted
hdefixedcrc	== 41h	;data crc error, correction
			;successful
hdenocrc	== 42h	;data crc error, correction
			;failed

hdebadcommand	== 80h	;unrecognised command

hdesave		== 91h	;error saving 17k in 
			;format (hardhelp)
hderestore	== 92h	;error restoring 17k
			;in format (hardhelp)

;
;	the following paramaters describe
;	device dependent constants for the
;	drives supported
;
memtracks	==	244	;memorex tracks
shutracks	==	202	;shugart tracks

memsectors	==	11	;memorex sectors/track
mem46sectors	==	23	;memorex sectors/track 
				;for 46 meg drive
shusectors	==	17	;shugart sectors/track

mem11headmask	==	3	;head mask for 11 meg memorex
mem23headmask	==	7	;head mask for 23 mes memorex

shu14headmask	==	3	;head mask for 14 meg shugart
shuf14headmask	==	0bh	;head mask for 14 meg
				;shugart with fixed heads
shu28headmask	==	7	;head mask for 28 meg shugar
shuf28headmask	==	0fh	;head mask for 28 meg
				;shugart with fixed heads

;FIXEDH		==	0	;NUMBER OF FIXED HEADS
STRACKS		==	2	;NUMBER OF SUBSTITUTE TRACKS
				;FOR BAD SECTORS


;
;	the following locations in rom contain
;	the rom version and revision in versions
;	later than 2.0
;
lcromversion == 64h
lcromrevision == 65h

;	.XLIST
;
;THE FOLLOWING EQUATES MUST NOT BE CHANGED.   THEY
;REFERENCE A JUMP TABLE INTO THE ROM (LEVEL 1)
;FIRMWARE
;
;
romjump		==	03eeh	;location of jump table
goGETCOMMAND	==	03EEH	;GET 8 BYTES FROM HOST
goREADSEC	==	03F1H	;READ ABS SECTOR
goWRITESEC	==	03F4H	;WRITE ABS SECTOR
goPREAD		==	03F7H	;READ BLOCK FROM HOST
goPWRITE	==	03FAH	;WRITE BLK TO HOST
goPUTCOMD	==	03FDH	;SEND STATUS TO HOST
;
;
;
;THE FOLLOWING RAM LOCATIONS ARE ASSUMED BY THE
;ROM FIRMWARE AND MUST NOT BE USED OTHERWISE
;
;
;
;THE STACK WILL BE SET TO 4080H BY ROM FIRMWARE AND
;IS USABLE DOWN TO 4000H (BOTTOM OF RAM)
;
STACK		==	4080H	;STACK AREA
;
;THE NEXT 8 LOCATIONS ARE USED FOR THE 8 BYTE COMMAND
;BLOCK, RETURNING STATUS, AND HOLD TRACK, HEAD, AND
;SECTOR FOR THE CURRENT OPERATION
;
;
COMMBUFF	==	4080H	;COMMAND BYTE
PHYTRACK	==	4081H	;PHYSICAL TRACK
PHYHEAD		==	4082H	;HEAD
PHYSEC		==	4083H	;SECTOR
TAG0		==	4084H	;TAG AVAILABLE TO USER
TAG1		==	4085H
CON0		==	4086H	;TAG RESERVED FOR HDC
CON1		==	4087H
;
;
;THE FOLLOWING RAM LOCATIONS ARE USED FOR VARIABLE
;STORAGE BY ROM FIRMWARE
;
TRKD0		==	4088H	;CURRENT TRACK
RDAFTW		==	4089H	;MSB ==1 FOR READ AFTER
				;WRITE OR IF HOST WANTS
				;CRC ERROR CORRECTION
				;ATTEMPTED
unitno		==	408Ah	;unit no of multiple disks
badloc		==	408bh	;four word table of 
				;bad sector table ptrs
				;one for each disk
;
;
;
;   THE FOLLOWING 
;VARIABLES AND ENTRY POINTS ARE USED BY ROM FIRMWARE
;AND ARE INITIALIZED TO "SAFE" VALUES.   THEY SHOULD
;BE SET BY LEVEL 2 FIRMWARE WHEN IT IS FIRST ENTERED.
;NOTE THAT 1K BYTES OF LEVEL 2 FIRMWARE IS READ FROM
;TRACK 0 HEAD 0 SECTOR 1 INTO 4100H DURING INITIAL-
;IZATION, BUT NOT EXECUTED.
;
;
disktracks	==	40efh	;number of tracks on disk
				;244 for fujitsu 
				;10/21 megabyte
				;204 for shugart 
				;14/28 meg
VERS		==	40F0H	;AND 40F1H
DISKTYPE	==	40F2H	;SA400X==17,M101==11
				;effectively sectors per track
DISKSIZE	==	40F3H	;LEGAL VALUES ARE:
;				;14/10 MBYTE - 3
;				;28/21 MBYTE - 7
;				;14 M WITH FIX HDS - B
;				;28 M WITH FIX HDS - F
;				;INITIALIZED TO 3
				;effectively heads mask
;
;THE FOLLOWING JUMP TABLE IS ASSUMED BY LEVEL 1
;FIRMWARE.   IT IS INITIALIZED TO IMMEDIATE RETURNS
;(EXCEPT JMP USRPROG AT 4100H) AND WILL BE OVERLAYED
;BY CODE IN THIS TEMPLATE WHEN USRPROG IS FIRST 
;CALLED (HOST COMMAND >3).   NOTE THAT THE FIRST
;FOUR ROUTINES ARE CALLED AND SHOULD RETURN WHEN
;FINISHED, WHILE USERPROG SHOULD JMP TO GETCOMMAND.
;
;	.LOC	40F4H	;LEVEL 2 JUMP TABLE
;	JMP	DUMMY0	;RESERVED FOR EXPANSION
;	JMP	dummy1	;reserved for expansion
;	JMP	IDLE	;CALLED BY LEVEL 1 AFTER
;			;APPROX I SEC OF NO DISK
;			;REQUESTS FROM HOST.  USED
;			;TO WRITE DIRTY BUFFERS,
;			;SAVE STATISTICS, ETC
;	JMP	rderr	;process read error and do
			;error correction if
			;possible, LOG ERRORS
;	JMP	USRPROG	;JMPED TO FROM LEVEL 1 IF
;			;HOST COMMAND > 3
;
;
godum0 ==	40f4h	;used by rom
godum1 ==	40f7h
goidle	 ==	40fah
gorderr ==	40fdh

;
;	user programs start at location defined below
;
usrprog	==	4100h

;
;	the following three buffers are used
;	for additional badsector tables for
;	multiple drives.  they have the same
;	layout as is discribed for badtable
;
bad1table ==	0d400h	;bad sector table drive 1
bad1dirty ==	0d7ffh	;dirty flag for bst drive 1

bad2table ==	0d800h	;bad sector table drive 2
bad2dirty ==	0dbffh	;dirty flag for bst drive2

bad3table ==	0dc00h	;bad sector table drive 3
bad3dirty ==	0dfffh	;dirty flag for bst drive 3
;
;
;THE FOLLOWING LOCATIONS REFERENCE THE ACTUAL READ
;AND WRITE BUFFERS
;
;
;
WRTBUFF	==	0E000H
BUFSYNC	==	WRTBUFF+14
BUFCYL	==	BUFSYNC+1
BUFHEAD	==	BUFCYL+1
BUFSEC	==	BUFHEAD+1
BUFCK1	==	BUFSEC+5
BUFDATA	==	BUFCK1+1
BUFECC	==	BUFDATA+1024
;
RDBUFF	==	0F000H
RDCYL	==	RDBUFF+1
RDHEAD	==	RDCYL+1
RDSEC	==	RDHEAD+1
RDCK	==	RDSEC+5
RDDATA	==	RDCK+1
RDECC	==	RDDATA+1024
RDCOR	==	RDECC+4
RDEND	==	RDCOR+1054
;
;
;THE 400H BYTES FROM ECOOH TO EFFFH ARE USED AS A
;DEFECTIVE SECTOR TABLE.  TABLE ENTRIES ARE THREE
;BYTES EACH (SECTOR, HEAD, TRACK) AND EACH POSITION
;IN THE TABLE IMPLIES A UNIQUE SUBSTITUTE SECTOR ON
;TRACKS 200 OR 201.   128 ENTRIES ARE ALLOWED FOR A
;14 MBYTE SYSTEM AND 256 ENTRIES FOR A 28 MBYTE
;SYSTEM.
;
;THE REMAINDER OF THE 1K BLOCK WILL BE USED AS A CRC
;ERROR LOG, BUILDING DOWN FROM BADTABLE + 3FEH (+3FFH
;WILL BE USED AS A 'DIRTY' FLAG)  THE FORMAT WILL BE
;SECTOR, HEAD, TRACK, ERR COUNT, GOING DOWN FROM THE
;TOP OF THE BLOCK
;
BADTABLE	==0EC00H	;TO 0EC00H+256*3
BSTDRTY	==	BADTABLE + 3FFH
BSTSEC	==	16		;BLOCK NUM FOR BST
DTABLE	==	15		;BLOCK NUM FOR 
				;PARTITION TABLE
;


;
;	the following offsets into firmware code
;	for disk type parameters, for stuffing
;	during hardhelp initialisation and
;	checking during firmware init
;
offtracks ==	15h	;offset of tracks on disk
offversion ==	16h	;firmware version
offrevision ==	17h	;firmware revision
offtype ==	18h	;disk type (sec/trk)
offsize ==	19h	;disk size (head mask)
offvollabel ==	29h	;volumne label
vlabsize ==	10	;volumne label length


;
;	the following equates are for use with
;	the volumne info tables, as offsets
;	into them
;
vlipresent == 0	;is volumne present (true or false)
vlicurtrack == 1 ;current track for volumne
vlitracks == 2	;tracks on volumne
vlitype == 3	;sectors/track
vlisize == 4	;head mask
vlibiastable == 5 ; location of partition offset table
vlibadtable == 7 ;location of bad sector table for volumne
vlidirty == 9	;location of bad table dirty flag
vliopenerr == 11 ;failure in volumne open(init)
vlivollable == 12 ; 10 byte volumne name
vlibufsiz == 32	;size of info in volumne table entry


