	title	'Network Disk Operating System'

;***************************************************************
;***************************************************************
;**                                                           **
;**                  C P / N E T   1.0                        **
;**                                                           **
;** N e t w o r k   D i s k   O p e r a t i n g   S y s t e m **
;**                                                           **
;***************************************************************
;***************************************************************

;/*
;  Copyright (C) 1980
;  Digital Research
;  P.O. Box 579
;  Pacific Grove, CA 93950
;
;  Revised:
;    01 October 80  by Thomas Rolander
;*/

false	equ	0
true	equ	not false

NDOSbase:

;	Jump vector for NDOS entry points
serial:
	jmp	NDOS
	jmp	ndosinit
NDOS$jmp$tbl:
	jmp	NDOS		; NDOS entry point
	jmp	ndosinit	; NDOS initialization

copyright:
	db	'COPYRIGHT (C) 1980,'
	db	' DIGITAL RESEARCH '
serial$no:
	db	'654321'


;	BDOS equate table
console$in   equ	3
console$out  equ	4
print$string equ	9
console$stat equ	11
rtn$ver$nmb  equ	12
reset$disk   equ	13
set$get$user equ	32

;	Configuration Table Offsets (relative to Master ID)
disk$device    equ	1
console$device equ	33
list$device    equ	35
list$buffer$index equ	37
list$msg	equ	38

;	Message Equate Table
FMT	equ	0	; message format code
DID	equ	1	; destination processor ID
SID	equ	2	; source processor ID
FNC	equ	3	; CP/M function code
SIZ	equ	4	; message size - 1
MSG	equ	5	; acutual message

;	General Equates
ctlz	equ	1ah	; control Z


;	NDOS Data Segment

config$tbl$adr:
	dw	$-$
BDOS:	dw	$-$
dslct:	db	1
DMAadr:	dw	0080H
user:	db	0
CPM$Version:
	dw	$-$
search$ntwrk:
	db	$-$
search$FCB:
	dw	$-$

con$msg:	; console message
ack$msg:	; acknowledge message
Msg$to$mstr:	; message to master
	ds	1	; FMT
	ds	1	; DID
	ds	1	; SID
	ds	1	; FNC
	ds	1	; SIZ
	ds	256	; MSG

NDOS$stk:
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h,0c7c7h,0c7c7h
old$stk$ptr:
	dw	$-$
Func:	db	$-$
Param:	dw	$-$
Actual$msg$ptr:
	dw	$-$
List$number:
	db	$-$

;	BIOS jump vector intercept table
BIOS$jmp$vctr:
	dw	0		; cold start
@wboot:	dw	wboot		; warm start
@const:	dw	const		; console status
@conin:	dw	conin		; console character in
@conout:dw	conout		; console character out
@list:	dw	list		; list character out
	dw	0		; punch character out
	dw	0		; reader character in
	dw	0		; move head to home
	dw	0		; select disk
	dw	0		; select track
	dw	0		; secelct sector
	dw	0		; set DMA address
	dw	0		; read disk
	dw	0		; write disk
@listst:dw	listst		; return list status
	dw	0		; sector translate
nmb$BIOS equ	($-BIOS$jmp$vctr)/2

CCPFCB:
	db	1,'CCP     ','SPR',0
;	ds	23		;overlays the initialization code

;	NDOS Initialization
NDOS$init:
	call ntwrkinit  ;initialize the network
	ora a! jnz NDOS$init$err  ;jump if init unsuccessful

	; patch the BIOS jump table
	mvi c,nmb$BIOS! lhld 0001h! dcx h
	lxi d,BIOS$jmp$vctr  ;C = #, HL = BIOS, DE = tbl
	init$BIOS$loop:
		push b  ;save the loop counter
		ldax d! mov c,a! inx d
		ldax d! mov b,a! inx d
		ora c  ;table entry empty ?
		jz no$BIOS$change
		mov a,m! dcx d! stax d
		dcx h! mov a,m! dcx d! stax d
		inx d! inx d
		mov m,c! inx h! mov m,b
	    no$BIOS$change:
		inx h! inx h! inx h
		pop b! dcr c
		jnz init$BIOS$loop

	;get configuration table address from SNIOS
        call cnfgtbladr! inx h! shld config$tbl$adr
	;save BDOS entry point address
	lhld 0006! shld BDOS
	lxi d,serial+6! mvi b,6
	srlmov:
		dcx d! dcx h
		mov a,m! stax d
		dcr b! jnz srlmov
	mvi c,rtn$ver$nmb! call 0005h
	shld CPM$Version

	;print message
	mvi c,print$string! lxi d,okmsg! call 0005h
	;return to CCP
	jmp wboot

NDOS$init$err:
	;print error message: Failed to initialize network
	mvi c,print$string! lxi d,errmsg! call 0005h
	;cold start
	jmp 0000h

errmsg:
	db	'Failed to initialize network.',0dh,0ah
	db	'Cold Starting.','$'
okmsg:
	db	'NDOS initialization complete.'
	db	0dh,0ah,'$'


NDOS:		;NDOS entry point
	lxi h,0! mov a,c! cpi nmb$NDOS
	jc function$in$range
	dcx h! mov a,h ;HL = ffff, A = ff
	ret  ;return error of function out of range
    function$in$range:
	dad sp! shld old$stk$ptr
	lxi sp,old$stk$ptr! lxi h,NDOS$restore! push h
	;special exception handling for search function
	mvi a,18! sub c! jnz try$func$17
	lhld search$FCB! shld Param
	lda search$ntwrk! ora a! jnz search$next$network
	lhld BDOS! pchl
    try$func$17:
	dcr a! jnz NDOS$contd
	sta search$ntwrk  ;clear flag on all function 17's
    NDOS$contd:
	xchg! shld Param  ;save the passed parameter
    search$next$network:
	mov a,c! sta Func  ;save the function code
	sta Msg$to$mstr+FNC  ;place func code in msg to mstr
	lxi h,Msg$to$mstr+SIZ! mvi m,0
	inx h! shld Actual$msg$ptr
	mvi b,0! lxi h,NDOS$function$tbl
	mov a,c! cpi nmb$BDOS
	jc in$BDOS$range
	sui 64 ;offset by base of NDOS functions
	jnc in$NDOS$range
	lxi h,0ffffh! mov a,h! ret ;error return
    in$NDOS$range:
	adi nmb$BDOS! mov c,a
    in$BDOS$range:
	dad b! dad b! dad b! dad b
	mov a,m! mov e,a! inx h! mov d,m! ora d
	jz no$intercept
	xchg! pchl  ;jump directly to intercept procedure
    no$intercept:
	inx h! inx h! mov a,m
	ani Slave$BDOS
	jnz LCL$Slave$BDOS  ;jmp if Slave$BDOS bit set
	;determine if drive is on the network or local
	xchg! call lcl$or$ntwrk! xchg
	dcx h! dcx h
	mvi b,2! lxi d,control$byte$procs
	byte$loop:
		inx h! mvi c,8! mov a,m
		bit$loop:
			rar! jnc no$proc
			push h! push psw
			ldax d! mov l,a! inx d
			ldax d! mov h,a! dcx d
			pop psw! xthl
		    no$proc:
			inx d! inx d! dcr c
			jnz bit$loop
		dcr b
		rz  ;begin executing subroutines from the stack
		push h! lxi h,receive$mstr$msg! xthl
		push h! lxi h,send$mstr$msg! xthl
	jmp byte$loop

send$mstr$msg:
	lhld config$tbl$adr! xchg
	lxi h,msg$to$mstr+FMT! mvi m,0  ;FMT set to 0
	ldax d! inx h! inx h! mov m,a
	inx h! mov a,m! cpi 17  ;search first to network ?
	jnz not$search$first
	mvi a,0ffh! sta search$ntwrk
	xchg! lhld Param! shld search$FCB! xchg
    not$search$first:
	inx h! inx h! xchg
	lhld Actual$msg$ptr
	xra a! sub e! mov c,a
	mvi a,0! sbb d! mov b,a
	dad b! mov a,l! ora h
	jnz data$in$msg! inx h
    data$in$msg:		;make sure 0 length for no data in msg
	dcx h! xchg! dcx h! mov m,e  ;SIZ is set
	lxi b,msg$to$mstr
	jmp @sendmsg
;	ret

receive$mstr$msg:
	lxi b,ack$msg
	call @receivemsg
	lxi h,ack$msg+MSG! shld Actual$msg$ptr
	ret

control$byte$procs:	;table of procedures for control byte bits
	dw	from$Rtncode		;0000$0001
	dw	from$FCB$33$to$35	;0000$0010
	dw	from$Srch$Rtn		;0000$0100
	dw	from$DMA$0$to$127	;0000$1000
	dw	from$FCB$12$and$32	;0001$0000
	dw	return			;0010$0000
	dw	return			;0100$0000
	dw	return			;1000$0000

	dw	return			;0000$0001
	dw	to$FCB$33$to$35		;0000$0010
	dw	to$FCB$0$to$31		;0000$0100
	dw	to$DMA$0$to$127		;0000$1000
	dw	to$FCB$12$and$32	;0001$0000
	dw	to$FCB$0$to$12		;0010$0000
	dw	to$FCB$adr		;0100$0000
	dw	LCL$Slave$BDOS		;1000$0000

return:
	ret

from$FCB$33$to$35:
	lhld Param! lxi d,33
	dad d! mvi b,3
	jmp from$mstr$msg

from$Srch$Rtn:
	lhld Actual$msg$ptr! xchg! ldax d! inx d
	cpi 0ffh! rz ;return on error condition
	lhld DMA$adr! lxi b,32
	push psw! ani 0000$0011b! inr a
	Srch$Rtn$Setup:
		dcr a! jz Srch$Rtn$loop
		dad b! jmp Srch$Rtn$Setup
	Srch$Rtn$loop:
		ldax d! mov m,a
		inx d! inx h
		dcr c! jnz Srch$Rtn$loop
	pop psw! ret

from$DMA$0$to$127:
	lhld DMAadr! mvi b,128
	jmp from$mstr$msg

from$FCB$12$and$32:
	lhld Actual$msg$ptr! xchg
	lhld Param! lxi b,12! dad b
	ldax d! mov m,a! inx d
	lxi b,32-12! dad b
	ldax d! mov m,a! inx d
	xchg! shld Actual$msg$ptr
	ret

from$Rtncode:
	lhld Actual$msg$ptr
	mov e,m! inx h! mov d,m! inx h
	shld Actual$msg$ptr
	xchg! mov a,l
	ret

to$FCB$33$to$35:
	lhld Param! lxi d,33
	dad d! mvi b,3
	jmp to$mstr$msg

to$FCB$0$to$31:
	lhld Actual$msg$ptr! push h
	mvi b,32
	call Param$to$mstr$msg
	call lcl$or$ntwrk  ;get master physical drive
	dcx h! mov a,m! ani 0fh! inr a
	pop h! mov m,a  ;put into drive of first entry
	lxi d,16! dad d! mov m,a  ;put into drv of 2nd entry
	ret

to$DMA$0$to$127:
	lhld DMAadr! mvi b,128
	jmp to$mstr$msg
	ret

to$FCB$12$and$32:
	lhld Actual$msg$ptr! xchg
	lhld Param! lxi b,12! dad b
	mov a,m! stax d! inx d
	lxi b,32-12! dad b
	mov a,m! stax d! inx d
	xchg! shld Actual$msg$ptr
	ret

to$FCB$0$to$12:
	lhld Actual$msg$ptr! push h
	mvi b,13
	call Param$to$mstr$msg
	call lcl$or$ntwrk  ;get master physical drive
	dcx h! mov a,m! ani 0fh! inr a
	pop h! mov m,a  ;put into drive field of mstr msg
	ret

to$FCB$adr:
	lxi h,Param! mvi b,2
	jmp to$mstr$msg

Param$from$mstr$msg:
	lhld Param
from$mstr$msg:	;Copy data from master message
		; HL = destination address
		;  B = count
	xchg! lhld Actual$msg$ptr
	loop$from$mstr$msg:
		mov a,m! stax d
		inx d! inx h! dcr b
		jnz loop$from$mstr$msg
	shld Actual$msg$ptr
	ret

Param$to$mstr$msg:
	lhld Param
to$mstr$msg:	;Copy data to master message
		; HL = source address
		;  B = count
	xchg! lhld Actual$msg$ptr
	loop$to$mstr$msg:
		ldax d! mov m,a
		inx d! inx h! dcr b
		jnz loop$to$mstr$msg
	shld Actual$msg$ptr
	ret

disk$device$entry$addr:
	lhld config$tbl$adr
	dcx h! add a! add l! mov l,a
	mov a,h! aci 0! mov h,a
	ret

lcl$or$ntwrk:	; determine whether disk device is on network
	lhld Param! mov a,m
	ora a! jnz lcl$or$ntwrk$drive$specified
	lda dslct! inr a  ;get default disk
     lcl$or$ntwrk$drive$specified:
	call disk$device$entry$addr
	mov a,m! ral
	jnc drive$local
	ral
    drive$network:
	inx h! mov a,m! sta msg$to$mstr+DID  ;set master ID
	rc! dcx h
	;send set user function to master & set bit
	mvi a,0100$0000b! ora m! mov m,a
	push h! push d
	mvi a,set$get$user! sta msg$to$mstr+FNC
	lda user! sta msg$to$mstr+MSG
	call send$mstr$msg
	call receive$mstr$msg
	lda func! lxi h,msg$to$mstr+FNC! mov m,a
	inx h! mvi m,0! inx h! shld actual$msg$ptr
	pop d! pop h! stc
	jmp drive$network

    drive$local:
	pop h  ;discard return address
;	jmp LCL$Slave$BDOS

LCL$Slave$BDOS:
	lhld Param! xchg! lda Func! mov c,a
BDOS$contd:
	lhld BDOS! pchl

@sendmsg:
	call sendmsg
	inr a! rnz
	jmp Abort$Func

@receivemsg:
	call receivemsg
	inr a! rnz
	;jmp Abort$Func

Abort$Func:
	lxi h,0ffffh! mov a,h

NDOS$restore:
	xchg! lhld old$stk$ptr! sphl! xchg
	ret

;	NDOS Function Table Equates
;
Slave$BDOS	equ	1000$0000b  ; pass through to slave BDOS
FCB$adr		equ	0100$0000b  ; FCB address
FCB$0$to$12	equ	0010$0000b  ; FCB(0) to FCB(12)
FCB$12$and$32	equ	0001$0000b  ; FCB(12) and FCB(32)
DMA$0$to$127	equ	0000$1000b  ; DMA(0) to DMA(127)
FCB$0$to$31	equ	0000$0100b  ; FCB(0) to FCB(31)
FCB$33$to$35	equ	0000$0010b  ; FCB(33) to FCB(35)
Rtncode		equ	0000$0001b  ; rtn code from mstr

Srch$Rtn	equ	0000$0100b  ; search return

NDOS$function$tbl:

; Table organization-
;
;   0-1 = Intercept procedure address, 0000h if none present
;   2-2 = Message control byte data from master
;   3-3 = Message control byte data to master
;
; 0=system reset
	dw	func0
	db	0
	db	0
; 1=console input
	dw	0
	db	0
	db	Slave$BDOS
; 2=console output
	dw	0
	db	0
	db	Slave$BDOS
; 3=reader input
	dw	0
	db	0
	db	Slave$BDOS
; 4=punch output
	dw	0
	db	0
	db	Slave$BDOS
; 5=list output
	dw	0
	db	0
	db	Slave$BDOS
; 6=direct console I/O
	dw	0
	db	0
	db	Slave$BDOS
; 7=get I/O byte
	dw	0
	db	0
	db	Slave$BDOS
; 8=set I/O byte
	dw	0
	db	0
	db	Slave$BDOS
; 9=print string
	dw	0
	db	0
	db	Slave$BDOS
;10=read console buffer
	dw	0
	db	0
	db	Slave$BDOS
;11=get console status
	dw	0
	db	0
	db	Slave$BDOS
;12=return version number
	dw	func12
	db	0
	db	0
;13=reset disk system
	dw	0
	db	0
	db	Slave$BDOS
;14=select disk
	dw	func14
	db	0
	db	0
;15=open file
	dw	0
	db	Rtncode
	db	FCB$adr or FCB$0$to$12
;16=close file
	dw	0
	db	Rtncode
	db	FCB$adr
;17=search for first
	dw	0
	db	Srch$Rtn
	db	FCB$0$to$12
;18=search for next
	dw	0
	db	Srch$Rtn
	db	0
;19=delete file
	dw	0
	db	Rtncode
	db	FCB$0$to$12
;20=read sequential
	dw	0
	db	Rtncode or FCB$12$and$32 or DMA$0$to$127
	db	FCB$adr or FCB$12$and$32
;21=write sequential
	dw	0
	db	Rtncode or FCB$12$and$32
	db	FCB$adr or FCB$12$and$32 or DMA$0$to$127
;22=make file
	dw	0
	db	Rtncode
	db	FCB$adr or FCB$0$to$12
;23=rename file
	dw	0
	db	Rtncode
	db	FCB$0$to$31
;24=return login vector
	dw	0
	db	0
	db	Slave$BDOS
;25=return current disk
	dw	func25
	db	0
	db	0
;26=set DMA address
	dw	func26
	db	0
	db	0
;27=get addr (alloc)
	dw	0
	db	0
	db	Slave$BDOS
;28=write protect disk
	dw	func28
	db	0
	db	0
;29=get R/O vector
	dw	0
	db	0
	db	Slave$BDOS
;30=set file attributes
	dw	0
	db	Rtncode
	db	FCB$0$to$12
;31=get disk param addr
	dw	0
	db	0
	db	Slave$BDOS
;32=set/get user code
	dw	func32
	db	0
	db	0
;33=read random
	dw	0
	db	Rtncode or FCB$12$and$32 or DMA$0$to$127
	db	FCB$adr or FCB$33$to$35
;34=write random
	dw	0
	db	Rtncode or FCB$12$and$32
	db	FCB$adr or DMA$0$to$127 or FCB$33$to$35
;35=compute file size
	dw	0
	db	Rtncode or FCB$12$and$32 or FCB$33$to$35
	db	FCB$adr
;36=set random record
	dw	0
	db	Rtncode or FCB$33$to$35
	db	FCB$adr or FCB$12$and$32
;37=reset drive
	dw	func37
	db	0
	db	0
;38=access drive
	dw	func38
	db	0
	db	0
;39=free drive
	dw	func39
	db	0
	db	0
;40=write random zero fill
	dw	0
	db	Rtncode or FCB$12$and$32
	db	FCB$adr or DMA$0$to$127 or FCB$33$to$35
;41=	(not used)
	dw	func41
	db	0
	db	0
;42=	(not used)
	dw	func42
	db	0
	db	0
;43=	(not used)
	dw	func43
	db	0
	db	0
;44=	(not used)
	dw	func44
	db	0
	db	0
;45=	(not used)
	dw	func45
	db	0
	db	0
;46=	(not used)
	dw	func46
	db	0
	db	0
;47=	(not used)
	dw	func47
	db	0
	db	0

nmb$BDOS equ	($-NDOS$function$tbl)/4

start$NDOS:
;64=login
	dw	func64
	db	0
	db	0
;65=logoff
	dw	func65
	db	0
	db	0
;66=send message on ntwrk
	dw	func66
	db	0
	db	0
;67=receive message from ntwrk
	dw	func67
	db	0
	db	0
;68=get network status
	dw	func68
	db	0
	db	0
;69=get configuration table adr
	dw	func69
	db	0
	db	0
;70=	(not used)
	dw	func70
	db	0
	db	0
;71=	(not used)
	dw	func71
	db	0
	db	0
;72=	(not used)
	dw	func72
	db	0
	db	0
;73=	(not used)
	dw	func73
	db	0
	db	0
;74=	(not used)
	dw	func74
	db	0
	db	0

nmb$NDOS equ	($-NDOS$function$tbl)/4 + (64-(start$NDOS-NDOS$function$tbl)/4)

;	Intercepted BDOS Functions

func0:		; system reset
wboot:		; warm boot entry point
	lxi sp,old$stk$ptr
	lxi h,NDOS$jmp$tbl! shld 0006h
	;reset to user 0
	mvi e,0! call intr$func32
	;load the CCP
	xra a! sta CCPFCB+32 ;clear current record
	lxi d,CCPFCB! lxi h,NDOSbase! call ldrel
	ora a
	jnz CCPlderr
	lda 0004h! mov c,a  ;get selected disk
	sphl! push h! push b ;stack is below CCP
	;restore user #
	lda user! mov e,a! call intr$func32
	call ntwrkwboot ;execute the snios wboot procedure
	pop b! ret ;branch to start of CCP

CCPlderr:
	mvi c,print$string! lxi d,CCPlderrmsg! call 0005h
	jmp $

CCPlderrmsg:
	db 'Failed to load the CP/Net CCP','$'

func12:		; Return Version Number
	lhld CPM$Version
	mvi a,02h! ora h! mov h,a! mov a,l
	ret

func14:		; Select Disk
	lda Param! sta dslct
disk$common:
	lda param
	inr a! call lcl$or$ntwrk$drive$specified
	dcx h! mov a,m! ani 0fh
	sta msg$to$mstr+MSG
	call send$mstr$msg
	call receive$mstr$msg
	jmp from$Rtncode

func25:		; Return current disk
	lda dslct
	ret

func26:		; Set DMA address
	lhld Param! shld DMAadr
	jmp LCL$Slave$BDOS

;func28:		; Write Protect Disk
func28	equ	disk$common

func32:		; Set/Get User Code
	lda param! cpi 0ffh
	mov b,a! lda user
	rz  ;return if get user code
	cmp b! rz  ;return if not changed
	mov a,b! ani 0fh! sta user
	;clear all user code set bits for disk devices
	lhld config$tbl$adr! mvi c,16
	clear$bits:
		inx h! mov a,m! ani 1011$1111b! mov m,a
		inx h! dcr c
		jnz clear$bits
	lhld Param! xchg

    intr$func32:
	lda CPM$Version! cpi 20h
	rc
	mvi c,32! jmp BDOS$contd

func37:		; reset drive
func38:		; access drive
func39:		; free drive

	lhld config$tbl$adr! lxi d,15*2+1! dad d! xchg
	lxi h,0000h! mvi c,16
	drv$vctr$loop:
		dad h
		ldax d! dcx d! dcx d
		ral! jnc no$bit$set
		inx h
	    no$bit$set:
		dcr c! jnz drv$vctr$loop
	;HL = vector of drives on master
	xchg! lhld Param
	mov a,e! ana l! mov l,a
	mov a,d! ana h! mov h,a
	ora l! jnz some$master$drives

    some$local$drives:
	mov a,e! cma! mov e,a
	mov a,d! cma
	lhld Param
	ana h! mov h,a
	mov a,l! ana e! mov l,a
	shld Param
	lda CPM$Version! cpi 20h
	jnc LCL$Slave$BDOS
	lda func! cpi 37
	mvi c,reset$disk! jz BDOS$contd
	ret

    some$master$drives:
	push h! call some$local$drives
	mvi c,16! lhld config$tbl$adr
	lxi d,15*2+1! dad d! pop d! xchg
 	vector$loop:
		dad h! jnc bit$not$set
		push b! push d! push h
		xchg! mov a,m! ani 0fh! mov c,a! inr c
		inx h! mov a,m! lxi h,0001h
		shift$bit:
			dcr c! jz shift$done
			dad h! jmp shift$bit
		shift$done:
		xchg! lxi h,msg$to$mstr+DID! mov m,a
		inx h! inx h! lda func! mov m,a
		lxi h,Msg$to$mstr+MSG
		mov m,e! inx h! mov m,d! inx h
		shld Actual$msg$ptr
		;Separate sendmsg's required for each bit
		; because they may have different masters
		; for each drive.
		call send$mstr$msg
		call receive$mstr$msg
		call from$Rtncode
		pop h! pop d! pop b
		cpi 0ffh! rz ;return on any error condition
	bit$not$set:
		dcx d! dcx d! dcr c
		jnz vector$loop
		xra a! ret

func41:		; (not used)
func42:		; (not used)
func43:		; (not used)
func44:		; (not used)
func45:		; (not used)
func46:		; (not used)
func47:		; (not used)
	lxi h,0ffffh! mov a,h! ret	;bad function

func64:		; login to network
login	equ	func64
	lhld param! push h! inx h
	mvi b,8! call to$mstr$msg
	pop h! mov a,m! mvi b,64
	jmp log$common

func65:		; logoff the network
logoff	equ	func65
	mvi b,65! lda Param
    log$common:
	lxi h,msg$to$mstr+DID! mov m,a
	inx h! inx h! mov m,b  ;set FNC
	call send$mstr$msg
	call receive$mstr$msg
	jmp from$Rtncode
;	ret

func66:		; send message to network
sndmsg	equ	func66
	lhld Param! mov b,h! mov c,l
	jmp sendmsg

func67:		; receive messge from network
rcvmsg	equ	func67
	lhld Param! mov b,h! mov c,l
	jmp receivemsg

;func68:	; get network status
;	ret

;func69:	; get config table addr
;	ret

func70:		; (not used)
func71:		; (not used)
func72:		; (not used)
func73:		; (not used)
func74:		; (not used)

	lxi h,0ffffh! mov a,h! ret	;bad function

;
;	BIOS jump vector intercept procedures

const:
	lhld @const
	lxi d,0000h + console$stat ;D = 0, SIZ  E = 11, FNC
	jmp con$common ;test for local or network
conin:
	lhld @conin
	lxi d,0000h + console$in ;D = 0, SIZ  E = 1, FNC
	jmp con$common ;test for local or network

conout:
	lhld @conout
	lxi d,0100h + console$out ;D = 1, SIZ  E = 2, FNC
;	jmp con$commmon ;test for local or network

con$common:
	push h! push b
	lhld config$tbl$adr! lxi b,console$device
	dad b! pop b! mov a,m! ral
	rnc ;jump to local BIOS
	mov a,m! ani 0fh! mov b,a ;mstr con # into B
	inx h! mov a,m! lxi h,con$msg
	mvi m,0 ;con$msg.FMT = 0
	inx h! mov m,a ;con$msg.DID = configtbl.conmstrID
	xthl! lhld config$tbl$adr! mov a,m
	pop h! inx h! mov m,a ;con$msg.SID = configtbl.slaveID
	inx h! mov m,e ;con$msg.FNC = consolefunction
	inx h! mov m,d ;con$msg.SIZ = size
	inx h! mov m,b ;con$msg.MSG(0) = mstr con #
	inx h! mov m,c ;con$msg.MSG(1) = output character
	lxi b,con$msg! call @sendmsg
	lxi b,ack$msg! call @receivemsg
	lda ack$msg+MSG
	ret

list:
	lhld config$tbl$adr! lxi d,list$device
	dad d! mov a,m! ral
	jc network$list  ;jump if list on network
	lhld @list! pchl
network$list:
	mov a,m! ani 0fh! sta List$number
	push b! mov b,c  ;save the character to be output
	inx h! inx h! mov c,m  ;C = index
	inr m  ;increment the list$buffer$index
	mvi a,128! cmp m  ;index = buffer$size ?
	jz end$list$buffer
	mov a,b! cpi ctlz  ;control Z ?
	jnz not$full
    end$list$buffer:
	mvi m,0  ;set index=0
    not$full:
	lxi d,7! dad d  ;HL = .list.MSG(1)
	mvi b,0! dad b  ;HL = .list.MSG(index)
	pop d! mov m,e  ;put character input buffer
	rnz  ;return if buffer is not full
	;send list buffer message on network
	lhld config$tbl$adr! lxi d,list$device+1
	dad d! mov a,m! inx h! inx h ; HL = .listmsg
	mov e,c  ;save index in E
	mov b,h! mov c,l
	inx h! mov m,a ; listmsg.DID
	inx h! inx h! inx h
	inr e! mov m,e  ;list$msg.SIZ = index+1
	inx h! lda List$number! mov m,a
	call @sendmsg
	lxi b,ack$msg
	jmp @receivemsg
;	ret

listst:
	lhld config$tbl$adr! lxi d,list$device
	dad d! mov a,m! ral
	jc network$listst  ;jump if list on network
	lhld @listst! pchl
network$listst:
	ret

;
;	Procedure to Load and Relocate an SPR, RSP, or PRL file
;
LdRel:
	;    Entry:
	;	DE = FCB of file to be relocated
	;	HL = Top address, relocate below this address

	;    Exit:
	;	 A = 00 if OK, FF if error encountered
	;	HL = New Top address

	shld	top
	xchg
	shld	FCB
	mvi	c,26
	lxi	h,-0080h
	dad	d
	shld	buffer
	xchg
	call	BDOS$contd	;set DMA address to buffer
	lhld	FCB
	xchg
	mvi	c,15
	call	BDOS$contd	;open the file
	cpi	0ffh
	rz		;return with error if open failed
	call	read	;read header record
	;compute base = top - prgsiz - datsiz
	lhld	buffer
	inx	h
	mov	e,m
	inx	h
	mov	d,m
	inx	h
	inx	h
	mov	c,m
	inx	h
	mov	b,m
	xchg
	shld	prgsiz
	dad	b
	xchg
	lhld	top
	xchg
	xra	a
	sub	l
	mov	l,a
	mvi	a,0
	sbb	h
	mov	h,a
	dad	d
	mvi	l,0	;HL = base address
	shld	base
	xchg
	lxi	h,-0080h
	dad	d
	shld	buffer
	call	read	;read second header record
	;compute number of sectors to be read
	lhld	prgsiz
	lxi	d,007fh
	dad	d
	mov	a,l
	ral		;carry = high order bit
	mov	a,h
	ral		;A = # sectors
	lhld	base
rdloop:
	sta	cnt
	shld	DMA
	xchg
	mvi	c,26
	call	BDOS$contd	;set DMA address for next sector
	call	read	;read next sector
	lhld	DMA
	lxi	d,0080h
	dad	d
	lda	cnt
	dcr	a
	jnz	rdloop

	lhld	buffer
	xchg
	mvi	c,26
	call	BDOS$contd	;set DMA address to buffer
;
	;file loaded, ready for relocation
	lhld	prgsiz
	mov	b,h
	mov	c,l	;BC = program size
	xchg
	lhld	base
	xchg		;DE = base of program
	dad	d	;HL = bit map base
	push	h	;save bit map base in stack
	mov	h,d	;D = relocation bias
pgrel0:
	mov	a,b	;bc=0?
	ora	c
	jnz	pgrel1	;not done
	pop	h
	lhld	base
	ret		;done
;
;	not end of the relocation, may be into next byte of bit map
pgrel1:
	dcx	b	;count length down
	mov	a,e
	ani	111b	;0 causes fetch of next byte
	jnz	pgrel3
;	fetch bit map from stacked address
	xthl
	mov	a,l
	ani	7fh
	jnz	pgrel2
	push	b
	push	d
	push	h
	lhld	FCB
	xchg
	mvi	c,20
	call	BDOS$contd
	pop	h
	pop	d
	pop	b
	lhld	buffer
	ora	a
	jnz	errtn	;return with error condition
pgrel2:
	mov	a,m	;next 8 bits of map
	inx	h
	xthl		;base address goes back to stack
	mov	l,a	;l holds the map as we process 8 locations
pgrel3:
	mov	a,l
	ral		;cy set to 1 if relocation necessary
	mov	l,a	;back to l for next time around
	jnc	pgrel4	;skip relocation if cy=0
;
;	current address requires relocation
	ldax	d
	add	h	;apply bias in h
	stax	d
pgrel4:
	inx	d	;to next address
	jmp	pgrel0	;for another byte to relocate
;
;	Local Procedures
;
read:
	lhld	FCB
	xchg
	mvi	c,20	;read sequential
	call	BDOS$contd
	ora	a
	rz
errtn:
	mvi	a,0ffh
	pop	h	;discard return address
	ret		;return with error condition
;
;	Local Data Segment
;
buffer:	ds	2	;buffer address
prgsiz:	ds	2	;program size
FCB:	ds	2	;FCB address
top:	ds	2	;initial top for relocation
base:	ds	2	;base for relocation
cnt:	ds	1	;counter
DMA:	ds	2	;DMA address

Patch$Area:
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
;
last:
	org	((last-NDOSbase)+255) and 0ff00h
;
;	SNIOS access table
ntwrkinit	equ	$
ntwrksts	equ	ntwrkinit+3
cnfgtbladr	equ	ntwrksts+3
sendmsg		equ	cnfgtbladr+3
receivemsg	equ	sendmsg+3
ntwrkerror	equ	receivemsg+3
ntwrkwboot	equ	ntwrkerror+3

func68		equ	ntwrksts
func69		equ	cnfgtbladr

	end
