/*	WMCOLOR.C	09/07/83-10/26/83	LEE JAY LORENZEN	*/

/*** INCLUDE FILES ******************************************************/

#include <portab.h>
#include <caparm.h>


/*** DEFINES ***********************************************************/

#define VS_TOP_LEFT 2
#define VS_BOT_RIGHT 4
#define VS_VC_SEG 22
#define VS_ATTRIB 28

#define IO_NEW_WINDOW 0x14


/*** STRUCTURES DECLARATIONS ******************************************/


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID GENCOPY();				/* in WMCA.A86		*/
EXTERN VOID GENALT();

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();
EXTERN VOID WM_MXQ();

EXTERN VOID wm_sync();				/* in UTIL.C		*/


/*** GLOBAL VARIABLES *************************************************/


/*** SUB FUNCTIONS ****************************************************/

/*** Window Manager COLOR routine *******************************************/

	VOID
wm_color(number, fgorbg, color)
	WORD		number;
	WORD		fgorbg,
			color;
{
	WORD		ret;
	WORD		ax,bx,cx,dx;
	WORD		attr;
	BYTE		attrbyte,
			newattrbyte;
	struct ca_parm	dest;
	BYTE		*ptemp;
	WORD		ds;
	BYTE		junkbyte;

						/* get current attribute*/
	WM_PK(0, number, VS_ATTRIB, &attr);
	attrbyte = attr & 0x00ff;
						/* calculate new 	*/
						/*   byte		*/
	if ( fgorbg == 0 )
	  newattrbyte = (attrbyte & 0xf8) | color;
	else
	  newattrbyte = (attrbyte & 0x8f) | (color << 4);
						/* if need change then	*/
						/*   make it		*/
	if ( newattrbyte != attrbyte )
	{
						/* set attr. in vc	*/
						/*   structure		*/
	  attr = (attr & 0xff00) | newattrbyte;
	  WM_PK(1, number, VS_ATTRIB, &attr);
						/* change attributes	*/
						/*   for whole window	*/
	  ptemp = 9;
	  ds = *ptemp++ + (*ptemp << 8);

	  dest.ca_choffset = &junkbyte;
	  dest.ca_chsegment = ds;
	  dest.ca_atoffset = 0x0001;
	  WM_PK(0, number, VS_VC_SEG, &dest.ca_atsegment);
	  dest.ca_chcoladj = 0;
	  dest.ca_atcoladj = 2;
	  dest.ca_chrowadj = 0;
	  dest.ca_atrowadj = 0;
						/* if vc is full	*/
						/*   screen and on top	*/
						/*   make sure image and*/
						/*   screen are in sync	*/
	  wm_sync(number);
						/* get mxq for window	*/
	  WM_MXQ(0, number);
						/* change the window	*/
	  GENALT(&dest, 24, 80, 0xff00, (0x0000 | newattrbyte)); 
						/* give up mxq		*/
	  WM_MXQ(1, number);
						/* cause window to be	*/
						/*   updated		*/
	  WM_PK(0, number, VS_TOP_LEFT, &cx);
	  WM_PK(0, number, VS_BOT_RIGHT, &bx);
	  ax = IO_NEW_WINDOW;
	  dx = number;
	  IO_CALL(&ax, &bx, &cx, &dx);
	}

	return;
}


                                                                                                                                                                                                                                                                                                                                                                                        