/*	WMENU.C		9/08/83-12/08/83	LEE JAY LORENZEN	*/

/*  Modified 7/10/84 							*/
/*    Changes: accepts windows (1-4) instead of (0-3)			*/
/*	       writes to file WSETUP.BAT instead of WSETUP.SUB		*/	

/*** INCLUDE FILES ******************************************************/

#include <portab.h>


/*** DEFINES ***********************************************************/

#define P_TERMCPM 0x00
#define C_WRITESTR 0x09
#define C_DETACH 0x93
#define DRV_GET 0x19

#define MAIN 0
#define PLACE 1
#define SIZE 2
#define SCROLL 3
#define TRACK 4
#define DISPLAY 5
#define COLOR 6
#define WRITE 7
#define ABORT 8
#define FGCOLOR 9
#define BGCOLOR 10

#define VS_ATTRIB 28
#define VS_CUR_TRACK 30
#define VS_CRT_SEG 24
#define VS_TOP_LEFT 2
#define VS_WIN_SIZE 12

#define RETURN 0x000d
#define ESCAPE 0x001b
#define BACKSPACE 0x0008
#define BACKTAB 0x000c
#define SPACEBAR 0x0020
#define TAB 0x0009
#define WINDOW1 0xff70
#define WINDOW2 0xff71
#define WINDOW3 0xff72
#define WINDOW4 0xff73
#define FULLKEY 0xff7e
#define UP 0xff0b
#define DOWN 0xff10
#define LEFT 0xff0d
#define RIGHT 0xff0e
#define NUMUP 0x0038
#define NUMDOWN 0x0032
#define NUMLEFT 0x0034
#define NUMRIGHT 0x0036

#define IO_STATLINE 0x08
#define IO_KEY 0x11
#define IO_NSTATLINE 0x12
#define IO_NEW_WINDOW 0x14
#define IO_CURSOR_VIEW 0x15


/*** STRUCTURES DECLARATIONS ******************************************/


/*** EXTERNAL FUNCTION DECLARATIONS ***********************************/

EXTERN VOID WM_PK();				/* in WWCALL.A86	*/
EXTERN VOID WM_CALL();
EXTERN VOID IO_CALL();

EXTERN WORD wm_window();			/* in WMWINDOW.C	*/

EXTERN VOID wm_color();				/* in WMCOLOR.C		*/

EXTERN WORD wm_write();				/* in WMWRITE.C		*/

EXTERN WORD wrap();				/* in WMUTIL.C		*/
EXTERN VOID udlr_adjust();
EXTERN WORD arrow();
EXTERN WORD between();
EXTERN VOID d2_format();
EXTERN VOID wm_nrnc();
EXTERN VOID wm_vrvc();
EXTERN WORD version_chk();

EXTERN WORD wm_install();			/* in WMEXEX.C		*/
EXTERN VOID wm_exit();
EXTERN VOID wm_abort();

EXTERN VOID wm_full();				/* in WMFTD.C		*/
EXTERN WORD wm_top();
EXTERN WORD wm_display();


/*** GLOBAL VARIABLES *************************************************/

BYTE	*pmessages[] = 
{
"Window Manager already installed.\r\n$",
"Window Manager installed.\r\n$",
"WMENU requires Concurrent CP/M system that supports window management.\r\n$", 
"Error while writing file, check disk.             (Press any key to continue)",
"COPYRIGHT (C) 1983, DIGITAL RESEARCH INC., 12/08/83"
};


BYTE	*pmenus[] =
{
"N=n:  Place Size Scroll Tracking Display Color Write Abort         [ESC]->Exit",
"WINDOW CHANGE N=n PRow=xx,PCol=xx             (Pressing \030,\031,\032,\033 places window)",
"WINDOW CHANGE N=n NRows=xx,NCols=xx            (Pressing \030,\031,\032,\033 sizes window)",
"WINDOW CHANGE N=n VRow=xx,VCol=xx            (Pressing \030,\031,\032,\033 scrolls window)",
"WINDOW CHANGE N=n Tracking=xxx    (Pressing \030,\031 changes cursor tracking style)",
"WINDOW CHANGE N=n Display=xxxxx            (Pressing \030,\031 changes display used)",
"dummy",
"WINDOW WRITE N=n Type=x,File=d:filename.typ        (Pressing \030,\031 changes type)",
"N=n:        (Press [RETURN] to abort WMENU, [ESC] to go back to previous menu)",
"WINDOW CHANGE N=n FG=xxxxxxx,BG=xxxxxxx      (Pressing \030,\031,\032,\033 changes colors)",
"WINDOW CHANGE N=n FG=xxxxxxx,BG=xxxxxxx      (Pressing \030,\031,\032,\033 changes colors)"
};


BYTE	n_spot[] =
{
	2,16,16,16,16,16,0,15,2,16,16
};


BYTE	menu_cnt[] =
{
	8,0,0,0,2,2,0,3,0,8,8
};


BYTE	*pitems[] =
{
	"Place","Size","Scroll","Tracking","Display","Color","Write","Abort",
	"No ","Row",
	"B&W  ","Color",
	"d:WINDOWn.TXT ","d:CONSOLEn.TXT","d:WSETUP.BAT  ",
	"Black  ","Blue   ","Green  ","Cyan   ","Red    ",
		"Magenta","Yellow ","White  ",
	"Black  ","Blue   ","Green  ","Cyan   ","Red    ",
		"Magenta","Yellow ","White  "
};


BYTE	menu_start[] =
{
	6,12,17,24,33,41,47,53,
	27,27,
	26,26,
	29,29,29,
	21,21,21,21,21,21,21,21,
	32,32,32,32,32,32,32,32
};


GLOBAL WORD	place_mode;
GLOBAL WORD	scroll_mode;
GLOBAL WORD	size_mode;
GLOBAL WORD	color_mode;
GLOBAL WORD	menu_mode;

	
/*** SUB FUNCTIONS *******************************************************/

/*** COPY ITEM routine ***************************************************/

	VOID
copy_item(menu_number, selection, hibits, pworkmenu)
	WORD		menu_number;
	WORD		selection;
	WORD		hibits;
	BYTE		*pworkmenu;
{
	WORD		i,
			item,
			start,
			size;

						/* calculate menu item	*/
						/*   index		*/
	item = 0;
	for (i=0; i<menu_number; i++)
	  item += menu_cnt[i];
	item += selection - 1;
						/* find start of string	*/
						/*   in menu		*/
	start = menu_start[item];
						/* find size of menu	*/
						/*   item		*/
	size = strlen(pitems[item]);
						/* copy item into menu	*/

	strncpy(&pworkmenu[start], pitems[item], size);
						/* set high bit of	*/
						/*   characters to	*/
						/*   display reverse	*/
						/*   video		*/
	if ( hibits == 1 )
	  for (i=start; i<=(start + size - 1); i++)
	    pworkmenu[i] |= 0x80;

	return;
}


/*** INITialize MENU routine ********************************************/

	WORD
init_menu(menu_number, selection, pworkmenu)
	BYTE		menu_number;
	BYTE		selection;
	BYTE		*pworkmenu;
{
	WORD		ret;
	WORD		i;
	WORD		ax,bx,cx,dx;
	WORD		imhere,
			nvc,
			top;
	WORD		value;
	BYTE		item;
	BYTE		size;
	BYTE		start;
	WORD		r,c;
						/* figure out who's on	*/
						/*   top		*/
	WM_CALL(&imhere, &nvc, &top);
						/* copy in menu 	*/
						/*   template		*/
	strcpy(pworkmenu, pmenus[menu_number]);
						/* write in current	*/
						/*   window number	*/
	pworkmenu[n_spot[menu_number]] = '1' + top;
						/* change selection to	*/
						/*   match current value*/
	switch ( menu_number )
	{
	  case FGCOLOR:				/* FGColor		*/
		WM_PK(0, top, VS_ATTRIB, &value);
		selection = (value & 0x0007) + 1;
						/* copy in BGCOLOR	*/
		value = ((0x0070 & value) >> 4) + 1;
		copy_item(BGCOLOR, value, 0, pworkmenu);
		break;
	  case BGCOLOR:				/* BGColor		*/
		WM_PK(0, top, VS_ATTRIB, &value);
		selection = ((0x0070 & value) >> 4) + 1;
						/* copy in FGCOLOR	*/
		value = (value & 0x0007) + 1;
		copy_item(FGCOLOR, value, 0, pworkmenu);
		break;
	  case TRACK:				/* Track		*/
		WM_PK(0, top, VS_CUR_TRACK, &value);
		selection = (value & 0x00ff) + 1;
		break;
	  case DISPLAY:				/* Display		*/
		WM_PK(0, top, VS_CRT_SEG, &value);
		selection = (value == 0xb000) ? 1 : 2;
		break;
	}  /* switch */
						/* if there are menu	*/
						/*   items then 	*/
						/*   copy in the	*/
						/*   selected one	*/
						/*   and make it high-	*/
						/*   highlighted	*/
	if ( menu_cnt[menu_number] != 0 )
	  copy_item(menu_number, selection, 1, pworkmenu);

	switch ( menu_number )
	{
	  case PLACE:
		WM_PK(0, top, VS_TOP_LEFT, &value);
		d2_format( ((value & 0xff00) >> 8) + 1, &pworkmenu[23]);
		d2_format( (value & 0x00ff) + 1, &pworkmenu[31]);
		break;
	  case SIZE:
		wm_nrnc(top, &r, &c);
		d2_format( r, &pworkmenu[24]);
		d2_format( c, &pworkmenu[33]);
		break;
	  case SCROLL:
		wm_vrvc(top, &r, &c);
		d2_format( r, &pworkmenu[23]);
		d2_format( c, &pworkmenu[31]);
		break;
	  case WRITE:
		value = __BDOS(DRV_GET, 0x00);
		pworkmenu[29] = (0x0080) | ('A' + value);
		switch( selection )
		{
		  case 1:
	 	    pworkmenu[37] = (0x0080) | ('1' + top);
		    pworkmenu[22] = (0x0080) | 'W';
		    break;
		  case 2:
		    pworkmenu[38] = (0x0080) | ('1' + top);
		    pworkmenu[22] = (0x0080) | 'C';
		    break;
		  case 3:
		    pworkmenu[22] = (0x0080) | 'S';
		    break;
		}
		break;
	}  /* switch */

	return(selection);
}


/*** DISPlay MENU routine **********************************************/

	VOID
disp_menu(pworkmenu)
	BYTE		*pworkmenu;
{
	WORD		i;
	WORD		ax,bx,cx,dx;
	BYTE		*ptemp;
	BYTE		pcharattr[161];

						/* io_statline call 	*/
						/*   using the new 160	*/
						/*   chars. and attrs.	*/
						/*   version		*/
	ax = IO_NSTATLINE;
						/* build char. attr.	*/
						/*   string		*/
	i = 0;
	while ( *pworkmenu )
	{
	  if ( (*pworkmenu & 0x80) != 0 )
	  {
	    *pworkmenu &= 0x7f;
	    pcharattr[i++] = *pworkmenu++;
	    pcharattr[i++] = 0x70;
	  }
	  else
	  {
	    pcharattr[i++] = *pworkmenu++;
	    pcharattr[i++] = 0x07;
	  }  
	}
						/* finish off string	*/
						/*   with spaces	*/
	while ( i < 160 )
	{
	  pcharattr[i++] = 0x20;
	  pcharattr[i++] = 0x07;
	}
	pcharattr[i] = NULL;
						/* point at string	*/
	cx = &pcharattr[0];
						/* get data segment	*/
	ptemp = 0x0009;
	dx = *ptemp++;
	dx += (*ptemp << 8);
						/* call xios		*/
	IO_CALL(&ax, &bx, &cx, &dx);
	return;
}


/*** DO MENU routine ****************************************************/

	BYTE
do_menu(menu_number, selection)
	WORD		menu_number;
	WORD		selection;
{
	WORD		ax,bx,cx,dx;
	WORD		imhere,
			nvc,
			top;
	WORD		return_hit,
			escape_hit;
	BYTE		pworkmenu[83];
	WORD		menu_change;
	WORD		window_change;
	WORD		x_amnt,
			y_amnt;
	WORD		old_selection;
	WORD		r, c;

						/* figure out who's on	*/
						/*   top		*/
	WM_CALL(&imhere, &nvc, &top);
						/* set up for while loop*/
	x_amnt = 0;
	y_amnt = 0;
	window_change = FALSE;
	menu_change = TRUE;	
	return_hit = FALSE;
	escape_hit = FALSE;
						/* read keys until	*/
						/*   return or escape	*/
						/*   keys are hit	*/
	while ( ( !return_hit ) &&
	        ( !escape_hit )   )
	{
						/* get character	*/
	  ax = IO_KEY;
	  cx = 0x00ff;
	  IO_CALL(&ax, &bx, &cx, &dx);
						/* fix up in case NUM-	*/
						/*   LOCK key is down	*/
	  ax = ( ax == NUMUP ) ? UP : ax;
	  ax = ( ax == NUMDOWN ) ? DOWN : ax;
	  ax = ( ax == NUMLEFT ) ? LEFT : ax;
	  ax = ( ax == NUMRIGHT ) ? RIGHT : ax;
						/* save old selection	*/
	  old_selection = selection;
						/* do character action	*/
	  switch ( ax )
	  {
	    case 0x0000:			/* no char. ready	*/
			if ( window_change )
			{
			  if ( place_mode )
			    menu_change = wm_window(0, x_amnt, y_amnt);
			  if ( scroll_mode )
			    menu_change = wm_window(1, x_amnt, y_amnt);
			  if ( size_mode )
			    menu_change = wm_window(2, x_amnt, y_amnt);
			  x_amnt = 0;
			  y_amnt = 0;
			  window_change = FALSE;
			}
			if ( menu_change )
			{
			  selection = init_menu(menu_number, 
						selection, pworkmenu);
			  disp_menu(pworkmenu);
			  menu_change = FALSE;
			}
			break;
	    case RETURN:			/* carriage return	*/
			return_hit = TRUE;
			break;
	    case ESCAPE:			/* escape key		*/
			escape_hit = TRUE;
			break;
	    case BACKSPACE:			/* back space 		*/
	    case BACKTAB:			/* back tab 		*/
			selection = wrap(1, --selection, 
						menu_cnt[menu_number]);
			break;
	    case SPACEBAR:			/* space bar		*/
	    case TAB:				/* tab			*/
			selection = wrap(1, ++selection, 
						menu_cnt[menu_number]);
			break;
	    case WINDOW1:			/* Window 0		*/
	    case WINDOW2:			/* Window 1		*/
	    case WINDOW3:			/* Window 2		*/
	    case WINDOW4:			/* Window 3		*/
			top = ax & 0x000f;
			menu_change = wm_top(top);
			break;
	    case FULLKEY:			/* Full key		*/
			WM_CALL(&imhere, &nvc, &top);
			wm_full(top);
			menu_change = TRUE;
			break;
	    case UP:				/* Up arrow key		*/
	    case DOWN:				/* Down arrow key	*/
	    case LEFT:				/* Left arrow key	*/
	    case RIGHT:				/* Right arrow key	*/
			if ( ( place_mode ) ||
			     ( scroll_mode ) ||
			     ( size_mode )     )
			{
			  udlr_adjust(ax, &y_amnt, &y_amnt, &x_amnt, &x_amnt);
			  window_change = TRUE;
			}
			if ( menu_mode )
			{
			  selection = arrow(ax, selection);
			  selection = wrap(1, selection, 
						menu_cnt[menu_number]);
			}
			if ( color_mode )
			{
			  udlr_adjust(ax, &selection, &selection, 
					&menu_number, &menu_number);
			  menu_number = wrap(FGCOLOR, menu_number, BGCOLOR);
			  selection = wrap(1, selection,
						menu_cnt[menu_number]);
			  menu_change = TRUE;
			}
			break;
	  }  /* switch */
	  if ( selection != old_selection )
	  {
	    menu_change = TRUE;
	    switch ( menu_number )
	    {
	      case DISPLAY:
			WM_CALL(&imhere, &nvc, &top); 
			menu_change = wm_display(top, selection - 1);
			break;
	      case FGCOLOR:
			WM_CALL(&imhere, &nvc, &top);
			wm_color(top, 0, selection - 1 );
			break;
	      case BGCOLOR:
			WM_CALL(&imhere, &nvc, &top);
			wm_color(top, 1, selection - 1 );
			break;
	      case TRACK:
			ax = IO_CURSOR_VIEW;
			wm_vrvc(top, &r, &c);
			cx = ( ((r-1) & 0x00ff) << 8 ) + ( (c-1) & 0x00ff );
			dx = (((selection - 1) << 8) & 0xff00) + top;
			IO_CALL(&ax, &bx, &cx, &dx);
			break;
	    }  /* switch */
	  }  /* if */
	}  /* while */

	if ( return_hit )
	  return(selection);
	else
	  return(0);
}


/*** MAIN MENU routine *************************************************/

	WORD
main_menu()
{
	WORD		ret;
	WORD		exited,
			aborted;
	WORD		ax,bx,cx,dx;
	WORD		imhere,
			nvc,
			top;
	WORD		prev_selection;
	BYTE		*pfname;
						/* set up for while loop*/
	exited = FALSE;
	aborted = FALSE;
						/* do menus until exit	*/
						/*   or abort options	*/
						/*   are chosen		*/
	prev_selection = 1;
	while ( ( !exited ) &&
		( !aborted )  )
	{
	  place_mode = FALSE;
	  scroll_mode = FALSE;
	  size_mode = FALSE;
	  color_mode = FALSE;

	  menu_mode = TRUE;
	  ret = do_menu(MAIN, prev_selection);
	  menu_mode = FALSE;

	  prev_selection = ret;
	  switch ( ret )
	  {
	    case 0:				/* escape hit		*/
			wm_exit();
			exited = TRUE;
			break;
	    case PLACE:				/* Place		*/
			place_mode = TRUE;
			ret = do_menu(PLACE, 1);
			break;
	    case SIZE:				/* Size			*/
			size_mode = TRUE;
			ret = do_menu(SIZE, 1);
			break;
	    case SCROLL:			/* Scroll		*/
			scroll_mode = TRUE;
			ret = do_menu(SCROLL, 1);
			break;
	    case COLOR:				/* Color		*/
			color_mode = TRUE;
			ret = do_menu(FGCOLOR, 1);
			break;
	    case TRACK:				/* Track		*/
	    case DISPLAY:			/* Display		*/
			menu_mode = TRUE;
			ret = do_menu(ret, 1);
			break;
	    case WRITE:				/* Write		*/
			menu_mode = TRUE;
			ret = do_menu(WRITE, 1);
			if ( ( ret == 1 ) ||
			     ( ret == 2 ) ||
			     ( ret == 3 )   )
			{
						/* figure out who's on	*/
						/*   top		*/
		  	  WM_CALL(&imhere, &nvc, &top);
						/* do write based on	*/
						/*   whether it is	*/
						/*   window or console	*/
						/*   or set up		*/
			  switch( ret )
			  {
			    case 1:
			      pfname = "d:WINDOWn.TXT";
			      pfname[0] = 'A' + __BDOS(DRV_GET, 0x00);
			      pfname[8] = '1' + top;
			      break;
			    case 2:
			      pfname = "d:CONSOLEn.TXT";
			      pfname[0] = 'A' + __BDOS(DRV_GET, 0x00);
			      pfname[9] = '1' + top;
			      break;
			    case 3:
			      pfname = "d:WSETUP.BAT";
			      pfname[0] = 'A' + __BDOS(DRV_GET, 0x00);
			      break;
			  }
						/* do the write		*/
			  ret = wm_write(ret - 1, top, pfname);
						/* handle error case	*/
			  if ( ret != 0 )
			  {
						/* put up message and 	*/
						/*   wait for any key	*/
			    disp_menu(pmessages[3]);
			    ax = IO_KEY;
			    cx = 0x00fd;
			    IO_CALL(&ax, &bx, &cx, &dx);
			  } 	
			}
			break;
	    case ABORT:				/* Abort		*/
			ret = do_menu(ABORT, 1);
			if ( ret == 1)
			{
			  wm_abort();
			  aborted = TRUE;
			}
			break;
	  }  /* switch */
	}  /* while */
						/* turn on normal	*/
						/*   status line display*/
	ax = IO_STATLINE;
	cx = 0xffff;
	IO_CALL(&ax, &bx, &cx, &dx);
						/* exit with abort flag	*/
	return(aborted);
}


/*** MAIN FUNCTION ******************************************************/

main()
{
	WORD		ret;
	WORD		i;
	WORD		ax,bx,cx,dx;
	WORD		aborted;

						/* do OS version check	*/
	ret = version_chk();
						/* handle error case	*/
						/*   if not right	*/
						/*   version		*/
	if ( !ret )
	{
	  __BDOS(C_WRITESTR, pmessages[2]);
	  return;
	}
						/* try to install	*/
						/*   window manager	*/
	ret = wm_install();
						/* handle error case	*/
						/*   when a manager is	*/
						/*   already resident	*/
	if ( !ret )
	{
	  __BDOS(C_WRITESTR, pmessages[0]);
	  return;
	}
						/* print success	*/
						/*   message 		*/
	__BDOS(C_WRITESTR, pmessages[1]);
						/* detach from console	*/
	__BDOS(C_DETACH, 0x0000);
						/* loop until aborted	*/
	aborted = FALSE;
	while ( !aborted )
	{
						/* wait for window key	*/
	  ax = IO_KEY;
	  cx = 0x00fd;
	  IO_CALL(&ax, &bx, &cx, &dx);
						/* do main menu		*/
	  aborted = main_menu();
	}  /* while */
}


/*** _MAIN routine *******************************************************/

_main()
{
						/* this minimizes which	*/
						/*   part of the run-	*/
						/*   time library is	*/
						/*   linked in		*/
	main();
	__BDOS(P_TERMCPM, 0);
}

                                                                                                                                                                                                             