/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.1        EVB.H                                    *
 *                      Event Block definition.			 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.0     ??/??/?? 		Original			 *
 *    1.1     06/10/86  mei	Prepended this header, added e_dh*
 *				and e_root to match struct.h def.*
 *    1.2     08/05/86  mei	struct evb, not struct evbstruct *	
 *                                                               *
 *===============================================================*
 *								 */


#define EVB	struct evb

EVB		/* event block structure */
{
	EVB	*e_nextp;	/* link to next event on PD event list */
	EVB	*e_link;	/* link to next block on event chain */
	EVB	*e_pred;	/* link to prev block on event chain */
	BYTE	*e_pd;		/* owner PD (data for fork) */

	LONG	e_swi;		/* swi address (code for fork) */
	LONG	e_parm;		/* parm for request -> event comm */
	WORD	e_flag;
	LONG	e_mask;		/* mask for event notification */
	WORD	e_syserr;	/* returned syserr	*/

	LONG	e_return;
	BYTE 	e_type;
	BYTE	e_prior;
	LONG	e_dh;
	EVB	**e_root;
};

