/*===============================================================*
 *   Version 1.2        YDKMD.C                                  *
 *                      Machine dependent subroutines for the    *
 *                      PC/AT hard disk driver.                  *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *    1.01     4-2-85   pjp    ygetssn was using cyl/sec/head    *
 *                             instead of head/sec/cyl format    *
 *    1.1      8/13/86  mei    Metaware port			 * 	
 *    1.2      12/27/86 KPB    Removed bad cast of hohs          *
 *                                                               *
 *===============================================================*
 *  INCLUDES:                                                    */

#include	"portab.h"
#include	"system.h"
#include	"ymd.h"
#include	"yio.h"
#include	"ydk.h"

/****************************************************
*  externals
*/

/***************************************************
*  local code macros
*/

/***************************************************
*  local defines
*/

SSN	yGetSsn() ;		/* calc ssn form hsc address	*/
VOID	yGetHscAddr() ;		/* calc hsc from ssn address	*/
VOID	dkybp2ld() ;		/* mdb from bpb			*/
VOID	movie() ;		/* byte wide string move	*/


/************************************************************************
 *									*
 *			Media Dependent Code				*
 *									*
 ************************************************************************/

/***************************************************
 * yGetHscAddr -
 *	Get the Head Sector and Cylinder Address
 *	from the Sequential Sector Number.
 *
 *	NOTE:  This is dependent on disk formats.  WILL
 *	NOT WORK on CPM media or hard disks with track
 *	numbers in sector id's instead of cylinder numbers.
 */

VOID	yGetHscAddr( hsc, StSsn , l )
HSCADDR	*hsc ;			/*  ptr to head sector cylinder addr	*/
SSN	StSsn ;			/*  Starting Sequential Sector Number	*/
LDD	*l ;			/*  ptr to log disk descr		*/
{
	UWORD	LogTrkNo ;	/*  Nbr logical trks before start */

	hsc->hsc_sector = 
		( StSsn % l->ld_mdb.md_sectrk ) + (UBYTE) 1 ;	/* 1,2,... */
	LogTrkNo = StSsn / l->ld_mdb.md_sectrk ;		/* 0,1,... */
	hsc->hsc_head = LogTrkNo % l->ld_mdb.md_nheads ;	/* 0,1,... */
	hsc->hsc_cyl = LogTrkNo / l->ld_mdb.md_nheads ;		/* 0,1,... */

}


/***********************************************************************
*  yGetSsn -
*	calculate an ssn from an hsc addr.
*/
SSN	yGetSsn( hsc , u )
HSCADDR	*hsc ;				/*  disk addr in HSC format	*/
LUTE	*u ;				/*  ptr to Log Unit Table entry	*/
{
	MDB	*m ;
	UWORD	sector, head ;
	ULONG	cyl ;

	m = &u->lu_lddp->ld_mdb ;

	head = (UWORD) hsc->hsc_head ;
	sector = (UWORD) hsc->hsc_sector ;
	cyl = (ULONG) hsc->hsc_cyl ;

	return( ( cyl * (m->md_sectrk * m->md_nheads)  )  +
		( head * m->md_sectrk ) + sector - 1 ) ;
}


/************************************************************************
*	DK_BP2LD
*
*	Convert a Boot Parameter Block to an LDD.
*************************************************************************/

VOID dkybp2ld(tldd,tbpb)
LDD *tldd;
BPB *tbpb;
{
    MDB *tmdb;

    tmdb = &(tldd->ld_mdb);
    tmdb->md_secsiz = (SECTOR)(tbpb->bpb_bps);
    tmdb->md_1sec = (SECTOR)(tbpb->bpb_rs);

    if( (tmdb->md_nsecs = (ULONG)(tbpb->bpb_nsli) ) == NULLPTR )
    {	tmdb->md_nsecs = tbpb->bpb_nslx ;	}		

    tmdb->md_sectrk = (SECTOR)(tbpb->bpb_spt);
    tmdb->md_secblk = (SECTOR)(tbpb->bpb_spau);
    tmdb->md_mdb = (UBYTE)(tbpb->bpb_md);	
    tmdb->md_nfats = (UBYTE)(tbpb->bpb_nof);
    tmdb->md_nfrecs = (SECTOR)(tbpb->bpb_nsobsf);
    tmdb->md_dirsize = (WORD)(tbpb->bpb_nrde);
    tmdb->md_nheads = (UBYTE)(tbpb->bpb_noh);
    tmdb->md_hidden = (tbpb->bpb_nohs) ;	
    tmdb->md_syssize = (ULONG) 0 ;
    movie(&(tldd->ld_mdb) , tmdb , sizeof(MDB));
}


/**************************************************************************
*	movie - string move routine
*/

VOID movie( d , s , length )
BYTE	*s ;
BYTE	*d ;
WORD	length ;
{
	while ( length-- ) *d++ = *s++ ;
}
