/*======================================================================*
 *   Version 1.01       MOUSE Driver					*
 *			Header defines					*
 *----------------------------------------------------------------------*
 * VERSION   DATE    TIME  BY   CHANGE/COMMENTS				*
 *----------------------------------------------------------------------*
 *   1.00   01/13/87  8:12 KJ   Started with change the serial driver	*
 *   1.01   03/25/87  5:30 KJ   reorganized the MOUSE_TBL structure  	*
 *======================================================================*/


/****************************************************************/
/*  first some data structures used by any driver		*/
/****************************************************************/

#define	ERROR		LONG	/* type of error code returns	*/
#define EMASK		LONG
#define E_IllUnitno	-1020
#define	DPF_UADDR	0x8000	/* addresses are from user space*/


/************************************************************************/
/*  Driver Parameter Block  definition                                  */
/************************************************************************/
#define DPB     struct DrvrParmBlock
DPB
{
        BYTE    dp_unitno;      /* unit number for this request */
        BYTE    dp_option;      /* some options */
        UWORD   dp_flags;       /* flags */
        LONG    dp_swi;         /* address of software interrupt 
				   or pointer to subdriver header    */
        LONG    dp_pdaddr;      /* address of callers process discriptor */
        BYTE    *dp_buffer;     /* pointer to the data buffer */
        LONG    dp_bufsiz;      /* size of this buffer */
        LONG    dp_offset;      /* offset for I/O */
        LONG    dp_parm7;       /* some parameter */
        LONG    dp_parm8;       /* another parameter */
};

/* Port Type Defines */

#define	PTT_UNDEFINED	0x00	/*  not used				*/
#define	PTT_SERIAL	0x01	/*  typical serial i/o device		*/
#define	PTT_CHAR	0x02	/*  fixed char i/o dev			*/
#define	PTT_PARALLEL	0x04	/*  typical parallel port i/o device	*/

/* Port Mode Defines */

#define	PTM_LENGTH		0x03
#define		PTM_L5		0x00
#define		PTM_L6		0x01
#define		PTM_L7		0x02
#define		PTM_L8		0x03

#define	PTM_STOP		0x0c
#define		PTM_XSTOP	0x00
#define		PTM_1STOP	0x04
#define		PTM_12STOP	0x08
#define		PTM_2STOP	0x0c

#define PTM_PARITY	        0x30		/* mask */
#define	PTM_NOPAR		0x00
#define PTM_PENAB		0x10
#define	PTM_PEVEN		0x20

/* port control defines */

#define	PTC_DTR			0x01	/* rw: data term ready	   */
#define	PTC_RTS			0x02	/* rw: req to send	   */
#define	PTC_TXENAB	    	0x04	/* rw: 1 = enable transmit */
#define	PTC_RXENAB		0x08	/* rw: 1 = enable receive  */
#define	PTC_XONXOFF		0x10	/* rw: 1 = enable ^s^q log */
#define	PTC_DSR			0x20	/* r:  1 = data set ready  */
#define	PTC_DCD			0x40	/* r:  1 = dcd active	   */


/************************************************************************/
/* NOTE: Change these values in order to Modify the new PORT TABLE	*/
/* values for the serial MOUSE you are using.  When the port subdriver  */
/* is linked to the mouse driver, it sets the baudrate to this new	*/
/* value.								*/
/* For MOUSE SYSTEMS MOUSE  1200 Baud, no parity,  1 stopbit		*/
/************************************************************************/

#define PT0_TYPE   PTT_SERIAL	/* Set the new TYPE of port for port 0 */
#define PT0_BAUD   7		/* Set the new baud rate for port 0 */ 
				/* Set new MODE for port 0 */
#define PT0_MODE   PTM_NOPAR + PTM_1STOP + PTM_LENGTH 
				/* Set new PORT CONTROL for port 0*/
#define PT0_CTRL   PTC_TXENAB + PTC_RXENAB + PTC_DTR + PTC_RTS


/***************************************************
 *  Port Get/Set Structure for baudrate
 ***************************************************/
#define	PORT_TBL	struct PortInfoTable
PORT_TBL
{
	WORD	pt_type ;		/*  type of port - see below	*/
	WORD	pt_state ;		/*  not used			*/
	BYTE	pt_baud ;		/*  see BD defines below	*/
	BYTE	pt_mode ;		/*  serial mode of operation	*/
	BYTE	pt_control ;
	BYTE	pt_1fill ;
} ;


/****************************************************************/
/*  MOUSE Driver  dependent type definitions 			*/
/****************************************************************/

/*----------------------------
 *  Mouse Get/Set Structure  *
 ----------------------------*/
#define	MOUSE_TBL	struct MouseInfoTable
MOUSE_TBL
{
	int	y_max;		/*  max y value, normaly screen y-resolution */
	int	x_max;		/*  max x value, normaly screen x-resolution */
	WORD	reserve;	/*  reserved                                 */
	WORD	buttons;	/*  number of mouse buttons                  */
	WORD	scale_y;	/*  mouse points per pixel, normaly = 1, 2   */
	WORD	scale_x;	/*  mouse points per pixel, normaly = 1      */
	WORD	double_y;	/*  if (delta_y > double_y) delta y * = 2    */
	WORD	double_x;	/*  if (delta_x > double_x) delta x * = 2    */
	int	y;		/*  current mouse y value 	*/
	int	x;		/*  current mouse x value 	*/
	WORD	but;		/*  current mouse button state	*/
	WORD	reserv;		/*  reserved			*/
};

