
/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/
/* ----------------------- creatmsg.c --------------------------------- */
/* error handle for all possible s_creat message                        */
/* 6/25/85								*/
/* ------------------------------------------------------------------- */
/*
 *  09/30/86  PKB
 *  references to CDOS, Concurrent, or Concurrent DOS changed to FlexOS
 */
#include "portab.h"
#include "concur.h"
#include "ccutls.h"

EXTERN	BYTE	cc0513[],cc0533[];
EXTERN	BYTE	*cc0500[];
EXTERN	BYTE	cc0464[],cc0465[],cc0466[],cc0468[],cc0414[];
EXTERN	BYTE	cc0460[],cc0490[],cc0467[];

BYTE	crtm01[] = "\n\rThe disk drive %1 does not exist. \
\n\rMake sure you specified the correct device name.";
BYTE	crtm03[] = "\n\rThis file name already exists.";
BYTE	crtm04[] = "\n\rFlexOS cannot access the device and/or the \
directory.";
BYTE	crtm05[] = "\n\rThe disk drive is not ready.\
\n\rMake sure the door of your disk drive is closed.";
BYTE	crtm06[] = "\n\rFlexOS cannot create the specified directory.\
\n\rIt does not recognize the type of media you are using.";

VOID creatmsg(mp,dc)
MCB	*mp;
LONG	dc;
{
	mp->pptr[PARM5] = cc0513;
	mp->pptr[PARM6] = cc0533;
	/* --- mp->pptr[PARM7] = file name --- */
	mp->pptr[PARM8] = cc0500[HLVL3];
	switch ((WORD)dc) {
	  case E_SPACE:
		mp->pptr[PARM9] = cc0460;
		mp->pptr[PARM4] = cc0490;
		break;
	  case E_PATH:
		mp->pptr[PARM9] = cc0464;
		break;
	  case E_CONFLICT:
	  case E_DEVLOCK: 
	  case E_PENDLK:
		mp->pptr[PARM9]= cc0465;
		break;
	  case E_WPROT:
		mp->pptr[PARM9] = cc0466;
		break;
	  case E_READONLY:
		mp->pptr[PARM9] = cc0467;
		break;
	  case E_NO_FILE:   
		mp->pptr[PARM9] = crtm01;
		break;
	  case E_EXISTS: 
		mp->pptr[PARM9] = crtm03; /* file exists */
		break;
	  case E_NAME:
		mp->pptr[PARM9] = cc0468;
		break;
	  case E_ACCESS:
		mp->pptr[PARM9] = crtm04;
		break;
	  case E_POOL:
		mp->pptr[PARM9] = cc0414;
		break;
	  case E_READY:
		mp->pptr[PARM9] = crtm05;
		break;
	  case E_UNKNOWNMEDIA:
		mp->pptr[PARM9] = crtm06;
		break;
	  default:
		mp->pptr[PARM9] = "";
		break;
	}
}
