/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*======================================================================*
 *   Version 1.7        FD.H                                            *
 *                      Header file for disk drivers                    *
 *----------------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                         *
 *----------------------------------------------------------------------*
 *      1.1     07/26/84 ktb    added type field to PUT structure       *
 *      1.2     07/31/84 ktb    added option field to DKPBLK            *
 *      1.3     08/01/84 ktb    added definition of DKSPPB - Disk Spec  *
 *                                parm block                            *
 *      1.4     08-29-84 ktb    new field in mdb: md_nhidden            *
 *      1.5     06/12/85 reb    rewritten/added to system               *
 *      1.6     06/20/85 reb    change LUTE structure Elim PUD & PUT    *
 *	1.7	12/03/85 gat	Expect floppy interrupt at 0x6e now	*
 ************************************************************************/


/***********************************************************************
*  structure macros
*
*/

#define IOPB    struct DiskIopb
#define UTE     struct FDUnitTableEntry
#define FDTF    struct FDTaskFile
#define DK_CURPDADDR    (*fd_dh.dkh_pdaddr)

/***********************************************************************
*  code macros
*/

#define HYPERDRIVE(x)   ( xval[x] != DD360 )
#define GOTO            goto
#define DKASR(a,b,c)    DOASR(a,b,c,DKASRPRI)
#define DKNASR(a,b,c,d) NEXTASR(a,b,c,d,DKASRPRI)
#define MAXDKUT         sizeof(DKUT) / sizeof(FDLUTE)

/* checks status of FDC, floppy controler chip  */
#define FDCBUSY                 (INP( FSTPORT ) & FSTFBSY)

/*  calculates number of bytes per sector given bytsec indicator */
#define BYTPERSEC(x)    (x == 3 ? 1024 : x << 8)


/***********************************************************************
*  conditional compile switches
*/


#define DEBUG                   TRUE
#define TIMEOUTS                TRUE

/***********************************************************************
*
*  driver parameter defines & constants
*
*/


#define ON              1
#define OFF             0

#define NULLASR         0L
#define NULLISR         0L
#define NULLSWI         0L

#define NOT_TRK0        0x80000000L

#define RELTIME                 0
#define ABSTIME                 1

#define FDASRPRI        200
                        /*  priority for asr's                          */

#define FDMAXUNITS      2
                        /*  max number of units supported               */

#define FDFLAGVAL       1
                        /*  dh flag value                               */

#define FDFILLVAL       0L
                        /*  DH fill value for control words             */

#define FDLOWBPS        128
                        /*  smallest nbr of bytes per sector this FDC   */
                        /*  can handle                                  */

#if     (MACHINE == XMACHINE)
#define FDMAXFRECS      7
#endif
#if     (MACHINE == COMPUPRO)
#define FDMAXFRECS      6
#endif

#define FDFATSSN        1
                        /*  ssn nbr for FATS on floppies                */

/***********************************************************************
*   retry counts
*/

#define FDRECRTC        2
                        /*  recal retry count                           */

#define FDIORTC         2
                        /*  max i/o retry count                         */

#if     (MACHINE == XMACHINE)
#define FDMAXREC        512 /*  max record size for floppies            */
#endif

#if     (MACHINE == COMPUPRO)
#define FDMAXREC        1024/*  max record size                         */
#endif



/***********************************************************************
*  interrupt numbers
*/

#if     (MACHINE == COMPUPRO)
#define FDINTNO         0x44
#endif

#if     (MACHINE == XMACHINE)
#define FDINTNO         0x6e
#endif


/******************************************************************************
*  timeout time counts
*       (in seconds)
*/

#define FDMOTORTIME     250L            /* (reb) 750L reduced to 250L */
                        /*  time for motor spinup:  750 ms              */

#define FDPOLLTIME      (LONG)(3*1000)  /* (reb) 10 reduced to 3 */
                        /*  millesecs for motor polling                 */

#define FDRECALTIME     5
                        /*  timeout for recals                          */

#define FDSEEKTIME      FDRECALTIME
                        /*  timeout for sikhs                           */

#define FDFORMATTIME    5
                        /*  timeout for track formats                   */

#define FDIOTIME        2
                        /*  timeout for normal i/o                      */

/******************************************************************************
*  floppy drive specify defaults -
*       From the Intel Data Book:  
*         ...The HUT (Head Unload Time) defines the time from the end of the 
*       execution phase of one of the Read/Write commands to the head unload 
*       state.  This timer is programmable from 16 to 240 ms. in increments of 16 ms:
*               01:  16ms
*               02:  32ms
*               :
*               0f: 240ms
*         The SRT (Step Rate Time)  defines the time interval between adjacent 
*       step pulses.  This timer is programmable from 1 to 16 ms in increments
*       of 1 ms:
*               f:  1ms
*               e:  2ms
*               d:  3ms
*                  :
*         The HLT (Head Load Time) defines the time between when the Head Load
*       signal goes high and when the Read/Write operation starts.  This timer is 
*       programmable from 2 to 254 ms in increments of 2ms:
*                1:  2ms
*                2:  4ms
*                3:  6ms
*                  :
*               fe: 254ms
*         ... The SRT should be programmed for 1ms longer than time required
*       by the drive...  Times indicated are for an 8 MHz clock... (We are 
*       using a 6 MHz clock.
*
*/

#if (MACHINE == XMACHINE)
#define DEFSRT  0x0b                    /*  default step rate           */
#define DEFHUT  0x0f                    /*  default hd unld time *slow* */
#define DEFHLT  0x14                    /*  default hd load time        */
#define DEFND   0                       /*  default in dma mode         */

/***********************************************************************
 *
 *  FDC defines
 */

/*
 *  port definitions
 */

#define FDCPORT 0x3f2
#define FSTPORT 0x3f4
#define FCMPORT 0x3f4
#define FDAPORT FCMPORT+1

#endif  /* end if xmachine */

#if (MACHINE == COMPUPRO)
#define DEFSRT  0x0d                    /*  default step rate           */
#define DEFHUT  0x0f                    /*  default hd unld time *slow* */
/* (gam) this head load time may need some "" tuning ""                 */
#define DEFHLT  0x70                    /*  default hd load time        */
#define DEFND   0                       /*  default in dma mode         */

/***********************************************************************
 *
 *  FDC defines
 */

/*
 *  port definitions
 */
#define FDCPORT 0xc0
#define FDAPORT FDCPORT+1
#define FSTPORT FDCPORT
#define FCMPORT FDCPORT+1

#endif /* end if machine compupro */


#define FDCMMASK        0xf0
                        /*  motor mask                                  */

#define FDCINTENAB      0x0c
                        /*  interrupt enable and dma request            */



/*
 *  status port values
 */

#define FST0BSY         0x01
                        /*  1 = drive zero is busy                      */

#define FST1BSY         0x02
                        /*  1 = drive one is busy                       */

#define FST2BSY         0x04
                        /*  1 = drive two is busy                       */

#define FST3BSY         0x08
                        /*  1 = drive three is busy                     */

#define FSTFBSY         0x10
                        /*  1 = fdc is busy                             */

#define FSTDIO          0x40
                        /*  1 = fdc wants input, 0 = fdc wants read     */

#define FSTRQM          0x80
                        /*  1 = fdc master request active               */

                        /*  FSTRQM & FSTDIO =  fdc ready for command    */
                        /*  FSTRQM & !FSTDIO = fdc ready for status rd  */



/*
 *  command port values (command codes)
 */

#define FCMRTRK         0x02
                        /*  read track                                  */

#define FCMSPEC         0x03
                        /*  specify                                     */

#define FCMSDS          0x04
                        /*  sense drive status                          */

#define FCMWR           0x05
                        /*  write data                                  */

#define FCMRD           0x06
                        /*  read data                                   */

#define FCMRECAL        0x07
                        /*  recalibrate                                 */

#define FCMSIS          0x08
                        /*  sense interrupt status command              */

#define FCMWRDD         0x09
                        /*  write deleted data                          */

#define FCMRDID         0x0a
                        /*  read id                                     */

#define FCMRDD          0x0c
                        /*  read deleted data                           */

#define FCMFMT          0x0d
                        /*  format track                                */

#define FCMSEEK         0x0f
                        /*  seek                                        */

/*
 *  additional bits in command codes
 */

#define FCMMT           0x80
                        /*  multi track bit                             */

#define FCMMFM          0x40
                        /*  mfm bit (0 = fm format)                     */

#define FCMSKIP         0x20
                        /*  skip deleted data address mark              */




/*************************************************************************
 *
 *  task file defines
 */

#define FDRERROR        0xc0
                        /*  result error mask                           */

#define FDRRDY          0x08
                        /*  result ready mask                           */

#define FDRDRV          0x03
                        /*  result drive mask                           */

#define FGENDRVNO       04
                        /*  fdc general drive number...                 */

#define FCOMPLETE       03
                        /*  code meaning the input status indicates     */
                        /*  the fdc's desire for it's status to be read */
                        /*  has been fulfilled.                         */



/***********************************************************************
*  FDTF -
*       Floppy Disk Task File.  Control BLock (similar to INTEL's DOCB)
*       for Floppy I/O.
*
*/

#define CFMAX   9
                /*  max number of command bytes in command file         */
#define RFMAX   7
                /*  max number of result bytes in result file           */


FDTF
{
        BYTE    fd_cmd[CFMAX] ; /*  disk command file                   */
        BYTE    fd_res[RFMAX] ; /*  disk result file                    */
        WORD    fd_curcyl ;     /*  last cyl successfully reached       */
} ;

/*
 *  fd_misc values 
 */

#define FDMOK            0
#define FDMERROR        -1


/***********************************************************************
*  pic equates
*/

#if     (MACHINE == XMACHINE)
#define PICOCWPORT      0x20
#define PICSEOICMD      0x66

/************************************************************************
*  data rate port
*/

#define XPORT   0x3f7
#define H12     00
#define H360    01
#define DD360   02

#endif


#if (MACHINE == COMPUPRO)

/***********************************************************************
*  pic equates
*/
#define PICOCWPORT      0x50
#define PICSEOICMD      0x64
/***********************************************************************
*  dma equates
*/
#define DMAPORT         0xC2
#endif


/**********************************************************************
*  disk driver configuration constants
*/

#define DKASRPRI        200

#define SWAP            FALSE


#if     SWAP
#define FLOPPY0         1               /*  1st flop is phys unit 1     */
#define FLOPPY1         0               /*  2nd flop is phys unit 0     */
#else
#define FLOPPY0         0               /*  1st flop is phys unit 0     */
#define FLOPPY1         1               /*  2nd flop is phys unit 1     */
#endif

#define HARD0           0
#define HARD1           1
#define HARD2           2


/**********************************************************************
*  disk driver constants
*/

#define DKREAD          1
#define DKWRITE         2
#define DKRECAL         3
#define DKRDID          4
#define DKRDTRK         5
#define DKFMT           6
#define DKFMTLST        7
#define DKSEEK          8
/* (reb) add verify and write verify function code defines */
#define DKVFY           9
#define DKWVFY          10


/************************************************************************
 *  disk driver type definitions
 ************************************************************************/

#define SSN     LONG            /*  Sequential Sector Number            */
#define SECTOR  WORD            /*  Sector Number                       */




/*
 *  structure name defines
 */

#define FDLUTE  struct _FdLUTEntry
#define DKPBLK  struct _DkIoParmBlock
#define DKSPPB  struct _DkSpecParmBlock
#define DKSELPB struct _DkSelParmBlock
#define DKGETPB struct _DkGetParmBlock
#define DKSDPB  struct _DkSubDrvPBlock
#define DKSDSPB struct _DkSubSelPBlock
#define PUD     struct _PUnitDescr
#define PUT     struct _PUnitTable
#define LDD     struct _LogDiskDescr
#define BPB     struct _BiosPartBlock
#define BTREC   struct _BootRecord
#define MDB     struct DK_Media_Descriptor
#define HSCADDR struct _DiskAddress
#define IORB    struct _IoReqBlock
#define DKH     struct _DkDriverHeader
#define FPBUF   struct _FmtParmBuff


/************************************************************************
 *  disk driver structure type definitions
 ************************************************************************/

/***********************************************************************
*  DKH -
*       Disk Driver Header.  
*
*/

DKH
{       
        UWORD   dkh_dtype       ;/* type of driver                      */
        UBYTE   dkh_nbrunits    ;/* max number of units supported       */
        UBYTE   dkh_flags       ;/* flag word                           */

        ERROR   (*dkh_init)()   ;/* pointer to init code                */
        ERROR   (*dkh_recal)()  ;/* pointer to recalibrate code         */
        ERROR   (*dkh_seek)()   ;/* pointer to init code                */
        ERROR   (*dkh_select)() ;/* pointer to select code              */
        ERROR   (*dkh_flush)()  ;/* pointer to flush code               */
        ERROR   (*dkh_io)()     ;/* pointer to read code                */

        ERROR   (*dkh_res1)()   ;/*  reserved                           */

        ERROR   (*dkh_get)()    ;/* pointer to get code                 */
        ERROR   (*dkh_set)()    ;/* pointer to set code                 */
        ERROR   (*dkh_format)() ;/* pointer to special code             */

        /*
         *   all items below are filled in by the o/s and should be 
         *   initialized to 0L
         */

        LONG    dkh_ctl0        ;/* reserved                            */
        LONG    dkh_ctl1        ;/* reserved                            */
        LONG    dkh_sync        ;/*  mxid for syncing on driver         */
        PD      **dkh_pdaddr    ;/*  pointer to current pd pointer      */
        LONG    dkh_sysfunc     ;/*  ptr to os function table           */
} ;

/**************************************************
 * FPBUFF - format parameter buffer
 *
 */

FPBUF
{
        BYTE    fp_head ;       /* head #                       */
        BYTE    fp_res ;        /* reserved                     */
        WORD    fp_cyl ;        /* cylinder #                   */
        BYTE    fp_ddens ;      /* density                      */
        BYTE    fp_fill ;       /* fill character               */
        WORD    fp_bytsec ;     /* bytes/sector                 */
        WORD    fp_sectrk ;     /* sectors/track                */
        WORD    fp_stsec ;      /* starting sector              */
        BYTE    fp_list ;       /* list of sectors              */
} ;




/***************************************************
 *  DKPBLK -
 *      Disk Parm Block.  Parameter block given to disk drivers
 *      for reads and writes.
 *
 */

DKPBLK
{
        UBYTE   dk_unitno ;     /*  unit number                         */
        UBYTE   dk_option ;     /*  option byte         *//*  M0002     */
        UWORD   dk_flags ;      /*  flag word                           */
        LONG    dk_swi ;        /*  software interrupt routine address  */
        LONG    dk_pdaddr ;     /*  address of Process Descriptor       */
        BYTE    *dk_buffer ;    /*  address of caller's  buffer         */
        LONG    dk_nsecs ;      /*  number of records for i/o           */
        LONG    dk_record ;     /*  disk address to start i/o           */
                                /*  (either hh,ss,cccc or log sec nbr)  */
} ;

/*
 *  option values for the Special call
 */

#define DKO_RDSYS       0
#define DKO_WRSYS       1
#define DKO_FMSYS       2
#define DKO_FMTRK       3
#define DKO_INFMT       8
#define DKO_GDPB    9

/*
 *  flags in dk_flags
 */

#define DKF_UADDR       0x8000
#define DKF_HSCADDR     0x02            /* record number is head,sector,cylinder */ 
#define VFYBIT          0x04            /* verify not read bit */

/***************************************************
*  DKSPPB -
*       Disk Special Parm BLock.  Parm Block for 
*       special i/o calls.
*/

DKSPPB
{
        BYTE    dsp_unitno ;    /*  logical unit number                 */
        BYTE    dsp_funcno ;    /*  special function code               */
        WORD    dsp_flags ;     /*  flags -  see DKF_  flags in DKPBLK  */
        BYTE    *dsp_sbaddr ;   /*  reserved                            */
        LONG    dsp_pdaddr ;    /*  process descriptor address          */
        BYTE    *dsp_buffer ;   /*  ptr to i/o buffer                   */
        LONG    dsp_bufsiz ;    /*  number of bytes in i/o buffer       */
        FPBUF   *dsp_prbuf ;    /*  ptr to format parm buffer           */
        LONG    dsp_prsiz ;     /*  size of format parm buffer          */
} ;



/*******************************************************************
 *  MDB -
 *      Media Descriptor Block.
 *
 */

MDB
{
        SECTOR  md_secsiz ;
        SECTOR  md_1sec ;
        LONG    md_nsecs ;
        SECTOR  md_sectrk ;
        SECTOR  md_secblk ;
        BYTE    md_nfats ;
        BYTE    md_mdbyte ;
        SECTOR  md_nfrecs ;
        WORD    md_dirsize ;
        UBYTE   md_nheads ;
        UBYTE   md_format ;
        LONG    md_nhidden;
        LONG    md_syssize ;
} ;

#define MDFCPM          0       /*  format byte, cpm media              */
#define MDFPC           1       /*  format byte, pc  media              */
#define MDFPC30         2       /*  format byte, pc  media, 2 byte fats */


/***************************************************
*  DKSELPB -
*       Disk Select Parameter Block.  Parm Block for
*       Select Calls to disk drivers.
*/

DKSELPB
{
        BYTE    dks_unitno ;            /*  hi level logical unit nbr   */
        BYTE    dks_reserved ;          /*  unused                      */
        MDB     *dks_mdbp ;             /*  ptr to dsk man's med descr  */
} ;

/***************************************************
*  DKGETPB -
*       disk get parm block.
*/

DKGETPB
{
        UBYTE   fgt_unitno ;            /*  unit nbr being "gotten"     */
        UBYTE   fgt_res[3] ;            /*  not used                    */
        UWORD   fgt_dtype ;             /*  driver type [1]             */
        UWORD   fgt_maxrs ;             /*  max record size             */
        UBYTE   *fgt_addr ;             /*  addr of door open swtch [2] */
        UWORD   fgt_maxfatrecs ;        /*  max fat record size (bytes) */
        UWORD   fgt_mxfsize ;           /*  max fat size (bytes)        */
        UWORD   fgt_mxdsize ;           /*  max nbr of root dir entries */
} ;

/*
*  [1]  DRIVER TYPE.    0 = removable w/o door open support.
*                       1 = removable w/  door open support.
*                       2 = memory disk.
*
*  [2]  DOOR OPEN SW.   If door open support is available, this should be the
*                       address of the switch (true = door open... file system
*                       will reset to zero).
*
*/


/***************************************************
*  DKSDPB -
*       disk subdrive parm block.
*/

DKSDPB
{
        UBYTE   dsd_unitno ;            /*  hi level logical unit nbr   */
        UBYTE   dsd_driveno ;           /*  low level phys drive nbr    */
        WORD    dsd_res ;
        DKH     *dsd_dh ;               /*  ptr to subdrive's DH        */
} ;


/****************************************************
*  DKSDSPB -
*       disk subdrive select parm block
*/

DKSDSPB
{
        UBYTE   ds_driveno ;    /*  sub drive's drive number            */
        UBYTE   ds_res[3] ;     /*  reserved                            */
        PROC    (*ds_reqcompl)() ;      /*  addr of master's int compl rtn */
        PROC    (*ds_dooropen)() ;      /*  addr of master's door open rtn */
} ;




/***************************************************
*  LDD -
*       Logical Disk Descriptor
*/

LDD
{
        SSN     ld_stssn ;      /*  starting ssn for the logical disk   */
        SSN     ld_endssn ;     /*  ending   ssn for the logical disk   */
        SSN     ld_lsnoffset ;  /*  nbr of sectors to start of log tk 0 */
        SSN     ld_syssecs ;    /*  nbr of sectors in system area [1]   */
        BYTE    ld_res ;        /*  reserved                            */
        BOOLEAN ld_ddens ;      /*  double density                      */
        MDB     ld_mdb ;        /*  mdb                                 */
} ;




/***************************************************
 *  HSCADDR -
 *      disk address.  Head, Sector, Cylinder
 *
 */

HSCADDR
{
        BYTE    hsc_head ;      /*  head number (0, 1, ... )            */
        BYTE    hsc_sector ;    /*  sector number (1, 2, ...)           */
        WORD    hsc_cyl ;       /*  cylinder number (0, 1, ...)         */
} ;


/***************************************************
*  IORB -
*       I/O Request Block.  Parms past to the lowest command level
*       routines.
*
*       The block is broken into three parts:
*               i/o parameters... The disk op field, the total number
*               of sectors, the starting seq sector number, the buffer
*               address (in system space), the proc descriptor address,
*               and the swi address... These fields are setup and passed
*               to the low level routines by the high level routines.
*
*               physical i/o paramaters... these fields are provided for
*               use by the low level drivers, who may need to break up
*               the request in to several requests, and may need head,
*               sector, cylinder addresses.
*
*               dma block... parms for the dma.  This also must be setup by
*               by the low level routines.
*/

IORB
{
        WORD    io_op ;         /*  opcode (read,write,format,etc)      */
        WORD    io_type ;       /*  type of i/o being requested         */
        LONG    io_totnsecs ;   /*  total number of sectors             */
        SSN     io_stssn ;      /*  starting sequential sector nbr      */
        SYSADDR io_buffer ;     /*  address of buffer in system space   */

        WORD    io_rtc ;        /*  retry count                         */
        WORD    io_pflgs ;      /* (reb) physical control flags         */
        HSCADDR io_dkaddr ;     /*  head sector cyl address             */
        WORD    io_nsecs ;      /*  current number of sectors           */

        PHYSADDR io_dmaddr ;    /*  dma address, setup by low level     */
        LONG    io_dmcount ;    /*  number of bytes, setup by low level */
        ERROR   io_error ;      /*  return code for request             */
} ;



/*
*  [1]  Note that lsnoffset and syssecs are not necessarily the same; when the
*       system (that area which is a different format than the rest of the
*       diskette, and which is usually reserved for the boot tracks) does not
*       end on the track preceding the track containing the first FAT, these
*       two will be different (e.g., only track 0 is single density, but the
*       (extended) boot tracks go on for another track or two;  after that, 
*       Logical Track 0 starts.  This would give a syssecs value equal to 
*       sectrk, and an lsnoffset value equal to ( n * sectrk ), where n is the
*       number of boot tracks.
*/



/***************************************************
*  FDLUTE -
*       disk logical unit table entry.
*/

FDLUTE
{
        IORB    fu_iorb ;               /*  i/o request block           */

        PD      *fu_f_pdaddr ;          /*  pdaddr for flagsetting      */
        PD      *fu_b_pdaddr ;          /*  pdaddr for buff addr stuff  */
        LONG    fu_swi ;                /*  address of req proc's swi   */

        LDD     *fu_lddp ;              /*  ptr to Log Disk Descriptor  */
        DKH     *fu_dkh ;               /*  pointer to phys driver's dh */

        FLAGNO  fu_ioflagno ;           /*  i/o flagnumber              */
        BYTE    fu_unitno ;             /*  logical unit number         */
        BYTE    fu_driveno ;            /*  physical unit number        */
        BOOLEAN fu_ods ;                /*  open door support           */
        BOOLEAN fu_fmt ;                /*  in format mode              */
        BOOLEAN fu_dooropen ;           /*  true:  door has been open   */
} ;



/***************************************************
*  BPB -
*       Bios Partition Block
*
*/

BPB
{
        BYTE    bp_njump[3] ;   /*  3 byte near jump to boot code       */
        BYTE    bp_id[8] ;      /*  8 byte ascii oem id and version     */
        WORD    bp_bytsec ;     /*  nbr of bytes per sector             */
        BYTE    bp_secblk ;     /*  nbr of sectors per block            */
        WORD    bp_nressec ;    /*  nbr of reserved sectors             */
        BYTE    bp_nfats ;      /*  nbr of File Alloc Tables            */
        WORD    bp_ndirents ;   /*  nbr of root directory entries       */
        WORD    bp_totsecs ;    /*  nbr of sectors per logical image    */
        BYTE    bp_md ;         /*  media descriptor byte               */
        WORD    bp_secfat ;     /*  nbr of sectors per fat              */
        WORD    bp_sectrk ;     /*  nbr of sectors per track            */
        WORD    bp_nheads ;     /*  nbr of heads                        */
        WORD    bp_nhidden ;    /*  nbr of hidden sectors               */
} ;

