###########################################################################
#
#   MKUTMSGS.
#
#   Make File for the utility messages......
#
#
#   Library Dependencies :
#			CCMSGS.L86
#			CCRTL.L86
#			CCUTLS.L86
#			UTOOLS.L86
#
#  Naming covention / definition abbreviatons :
#
#			utl: = where util source is located.
#			       ( define utl: = d:\utils\source\ )
#
#			cmn: = where system common source is located.
#			       ( define cmn: = d:\flexos\comsrc\ )
#
#			system: = system directory
#			       ( defined in config.bat )
#
#                	ipath = utl:;cmn:;
#
#############################################################################

CCMSGS  = ccmsgs.l86
CCRTL   = ccrtl.l86
CCUTLS  = ccutls.l86
UTOOLS  = utools.l86
COMMON  = $CCMSGS $CCRTL $CCUTLS $UTOOLS

exec.286  :	backup.286 restore.286 chkdsk.286 \
		comp.286 copy.286 date.286 diskcomp.286 diskcopy.286 \
		dir.286 diskset.286 find.286 fset.286 config.286 \
		logon.286 password.286 more.286 print.286 spool.286 \
		despool.286 process.286 recdir.286 \
		recfile.286 rename.286 sort.286 time.286 tree.286 \
		type.286 ver.286 vol.286 \
		command.286

##
## BACKUP and RESTORE...
##
backup.286 :	backup.inp bkresmsg.obj \
		$COMMON
 link backup[i]
 postlink backup.286

restore.286 :	restore.inp bkresmsg.obj \
		$COMMON
 link restore[i]
 postlink restore.286

bkresmsg.obj :	bkresmsg.c util.pro portab.h concur.h
  hc bkresmsg -pro util.pro

##
## CHKDSK
##
chkdsk.286 :	chkdsk.inp ckdskmsg.obj \
		$COMMON
 link chkdsk[i]
 postlink chkdsk.286

ckdskmsg.obj :	ckdskmsg.c util.pro portab.h concur.h
  hc ckdskmsg -pro util.pro

##
## COMP
##
comp.286 :	comp.inp compmsg.obj \
		$COMMON
 link comp[i]
 postlink comp.286

compmsg.obj :	compmsg.c util.pro portab.h
  hc compmsg -pro util.pro

##
## COPY
##
copy.286 :	copy.inp copymsg.obj \
		$COMMON
 link copy[i]
 postlink copy.286

copymsg.obj :	copymsg.c util.pro portab.h
  hc copymsg -pro util.pro

##
## DATE
##
date.286 :	date.inp datemsg.obj \
		$COMMON
  link date[i]
 postlink date.286

datemsg.obj :	datemsg.c util.pro portab.h
  hc datemsg -pro util.pro

##
## DISKCOMP
##
diskcomp.286 :	diskcomp.inp dcompmsg.obj \
		$COMMON
 link diskcomp[i]
 postlink diskcomp.286

dcompmsg.obj :	dcompmsg.c util.pro portab.h
  hc dcompmsg -pro util.pro

##
## DISKCOPY
##
diskcopy.286 :	diskcopy.inp dcopymsg.obj \
		$COMMON
 link diskcopy[i]
 postlink diskcopy.286

dcopymsg.obj :	dcopymsg.c util.pro portab.h
  hc dcopymsg -pro util.pro

##
## DIR
##
dir.286 :	dir.inp dirmsg.obj \
		$COMMON
 link dir[i]
 postlink dir.286

dirmsg.obj :	dirmsg.c util.pro portab.h
  hc dirmsg -pro util.pro

##
## DISKSET
##
diskset.286 :	diskset.inp dsetmsg.obj \
		$COMMON
 link diskset[i]
 postlink diskset.286

dsetmsg.obj :	dsetmsg.c util.pro portab.h
  hc dsetmsg -pro util.pro

##
## FIND 
##
find.286 :	find.inp findmsg.obj \
		$COMMON
 link find[i]
 postlink find.286

findmsg.obj :	findmsg.c util.pro portab.h
  hc findmsg -pro util.pro

##
## FSET
##
fset.286 :	fset.inp fsetmsg.obj \
		$COMMON
 link fset[i]
 postlink fset.286

fsetmsg.obj :	fsetmsg.c util.pro portab.h
  hc fsetmsg -pro util.pro

##
## CONFIG
##
config.286 :	konfig.inp konmsg.obj \
		$COMMON
 link konfig[i]
 postlink config.286

konmsg.obj :	konmsg.c util.pro portab.h concur.h
  hc konmsg -pro util.pro

##
## LOGON and PASSWORD...
##
logon.286 :	logon.inp logmsg.obj \
		$COMMON
 link logon[i]
 postlink logon.286

password.286 :	password.inp passmsg.obj \
		$COMMON
 link password[i]
 postlink password.286

logmsg.obj :	logmsg.c util.pro portab.h
  hc logmsg -pro util.pro

passmsg.obj :	passmsg.c util.pro portab.h
  hc passmsg -pro util.pro

##
## MORE 
##
more.286 :	more.inp moremsg.obj \
		$COMMON
 link more[i]
 postlink more.286

moremsg.obj :	moremsg.c util.pro portab.h
  hc moremsg -pro util.pro

##
## PRINT, SPOOL, and DESPOOL....
##
print.286 :	print.inp splmsg.obj \
		$COMMON
 link print[i]
 postlink print.286

spool.286 :	spool.inp splmsg.obj \
		$COMMON
 link spool[i]
 postlink spool.286

despool.286 :	despool.inp splmsg.obj \
		$COMMON
 link despool[i]
 postlink despool.286

splmsg.obj :	splmsg.c util.pro portab.h
  hc splmsg -pro util.pro

##
## PROCESS
##
process.286 :	process.inp procmsg.obj \
		$COMMON
 link process[i]
 postlink process.286

procmsg.obj :	procmsg.c util.pro portab.h concur.h
  hc procmsg -pro util.pro

##
## RECDIR
##
recdir.286 :	recdir.inp recdmsg.obj \
		$COMMON
 link recdir[i]
 postlink recdir.286

recdmsg.obj :	recdmsg.c util.pro portab.h
  hc recdmsg -pro util.pro

##
## RECFILE
##
recfile.286 :	recfile.inp recfmsg.obj \
		$COMMON
 link recfile[i]
 postlink recfile.286

recfmsg.obj :	recfmsg.c util.pro portab.h
  hc recfmsg -pro util.pro

##
## RENAME
##
rename.286 :	rename.inp renmsg.obj \
		$COMMON
 link rename[i]
 postlink rename.286

renmsg.obj :	renmsg.c util.pro portab.h
  hc renmsg -pro util.pro

##
## SORT
##
sort.286 :	sort.inp sortmsg.obj \
		$COMMON
 link sort[i]
 postlink sort.286

sortmsg.obj :	sortmsg.c util.pro portab.h concur.h
  hc sortmsg -pro util.pro

##
## TIME
##
time.286 :	time.inp timemsg.obj \
		$COMMON
 link time[i]
 postlink time.286

timemsg.obj :	timemsg.c util.pro portab.h
  hc timemsg -pro util.pro

##
## TREE
##
tree.286 :	tree.inp treemsg.obj \
		$COMMON
 link tree[i]
 postlink tree.286

treemsg.obj :	treemsg.c util.pro portab.h
  hc treemsg -pro util.pro

##
## TYPE
##
type.286 :	type.inp typemsg.obj \
		$COMMON
 link type[i]
 postlink type.286

typemsg.obj :	typemsg.c util.pro portab.h
  hc typemsg -pro util.pro

##
## VER
##
ver.286 :	ver.inp vermsg.obj \
		$COMMON
 link ver[i]
 postlink ver.286

vermsg.obj :	vermsg.c util.pro portab.h
  hc vermsg -pro util.pro

##
## VOL
##
vol.286 :	vol.inp volmsg.obj \
		$COMMON
 link vol[i]
 postlink vol.286

volmsg.obj :	volmsg.c util.pro portab.h
  hc volmsg -pro util.pro

##
## SHELL
##
command.286 :	shell.inp \
		shmsgs.obj asnmsgs.obj securmsg.obj \
		breakmsg.obj chdirmsg.obj defmsg.obj vfymsg.obj \
		eramsg.obj cancemsg.obj mkdirmsg.obj rmdirmsg.obj \
		$COMMON
 link shell[i]
 postlink command.286

shmsgs.obj :	shmsgs.c util.pro portab.h
 hc shmsgs -pro util.pro

breakmsg.obj :	breakmsg.c util.pro portab.h
 hc breakmsg -pro util.pro

chdirmsg.obj :	chdirmsg.c util.pro portab.h
 hc chdirmsg -pro util.pro

defmsg.obj :	defmsg.c util.pro portab.h
 hc defmsg -pro util.pro

vfymsg.obj :	vfymsg.c util.pro portab.h
 hc vfymsg -pro util.pro

eramsg.obj :	eramsg.c util.pro portab.h
 hc eramsg -pro util.pro

cancemsg.obj :	cancemsg.c util.pro portab.h
 hc cancemsg -pro util.pro

mkdirmsg.obj :	mkdirmsg.c util.pro portab.h
 hc mkdirmsg -pro util.pro

rmdirmsg.obj :	rmdirmsg.c util.pro portab.h
 hc rmdirmsg -pro util.pro

asnmsgs.obj :	asnmsgs.c util.pro portab.h concur.h
 hc asnmsgs -pro util.pro

securmsg.obj :	securmsg.c util.pro portab.h concur.h
 hc securmsg -pro util.pro

