/*****************************************************************
 * "Copyright (C) 1985, Digital Research, Inc.  All Rights       *
 * Reserved.  The Software Code contained in this listing is     *
 * proprietary to Digital Research Inc., Monterey, California    *
 * and is covered by U.S. and other copyright protection.        *
 * Unauthorized copying, adaptation, distribution, use or        *
 * display is prohibited and may be subject to civil and         *
 * criminal penalties.  Disclosure to others is prohibited.  For *
 * the terms and conditions of software code use refer to the    *
 * appropriate Digital Research License Agreement."              *
 *****************************************************************/

/*===============================================================*
 *   Version 1.3	utils.h					 *
 *	This file contains definitions shared between the shell	 *
 *	and utilities.  The defines are used for accessing	 *
 *	standard i/o and the define tables			 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *	1.0	01/??/84 KSO -	Created				 *
 *	1.1	04/26/85 KSO -	Delete STAND_ALONE flag		 *
 *	1.1	05/02/85 KSO -	Delte A_SHRO on access flags	 *
 *				for STDIN and STDCMD		 *
 *	1.2	05/10/85 KSO -	Integrated with LOGONs version	 *
 *				of utils.h			 *
 *	FCS1							 *
 *	1.3	09/17/85 JSR -	Added SHBUFSIZ, SHLBUFSIZ and	 *
 *				STDIO defines.			 *
 *	1.3	09/19/85 JSR -	Added ERCMASK, ERLMASK, ERMMASK	 *
 *				and ERRMASK.			 *
 *	1.4	08/06/86 ldt -  Added #ifndef ro O_DIR for HC    *
 *								 *
 *===============================================================*
 *  INCLUDES:                                                    */

#define	SHBUFSIZ	128
#define	SHLBUFSIZ	128L

#ifndef STDIN
#define	STDIN		0L	/* Standard input stream		*/
#endif

#ifndef STDOUT
#define	STDOUT		1L	/* Standard output stream		*/
#endif

#ifndef STDERR
#define	STDERR		2L	/* Standard error stream		*/
#endif

#define	OA_STDIN    A_SHARE+A_SHFP+A_READ+A_SET		/* STDIN access	*/
#define	OA_STDCMD   A_SHARE+A_SHFP+A_READ+A_SET		/* STDCMD access*/
#define	OA_STDOUT   A_SHARE+A_SHFP+A_WRITE+A_SET	/* STDOUT access*/
#define	OA_STDERR   A_SHARE+A_SHFP+A_WRITE+A_SET	/* STDERR access*/

#define	OA_COMMAND	0x0000		/* Locate command open access	*/

#define	WA_STDOUT	A_EOFOFF	/* STDOUT write access		*/
#define	WA_STDERR	A_EOFOFF	/* STDERR write access		*/

#define	RA_STDIN	A_FPOFF		/* STDIN read access		*/

#define	DEF_SYS		0x0001		/* DEFINE system table		*/
#define	DEF_PROC	0x0000		/* DEFINE process table		*/
#define	DEF_GET		0x0002		/* DEFINE get prefix		*/
#define	DEF_SET		0x0000		/* DEFINE set prefix		*/
#define	DEF_LIT		A_LIT		/* DEFINE get lit. prefix	*/

#ifndef O_DIR
#define	O_DIR		0x0001		/* CREATE dir type file		*/
#endif

#define	LOGOFF_RET	0x7fffffffL	/* LOGOFF return code		*/

	/* Misc. flags			*/
#define	ON		1	/* ON condition value		*/
#define	OFF		0	/* OFF condition value		*/

#define	SMODE		0	/* Screen mode field		*/
#define	KMODE		1	/* Keyboard mode field		*/

#define	CON_ABORT	0x0001	/* Disable ^C aborts		*/
#define	CON_ECHO	0x0020	/* Disable echo			*/

	/* Misc. masks			*/
#define	ERCMASK		0x0000ffffL	/* mask error code word clean	*/
#define	ERLMASK		0x40000000L	/* mask for loader err check	*/
#define	ERMMASK		0x00ff0000L	/* mask for error source module	*/
#define	ERRMASK		0x80000000L	/* mask for errors		*/
