#include	"portab.h"

/****************************************************************************
 * cc05xx series messages:						    *
 *    These messages are intended to report most DOS related errors.        *
 *    This series may require use of the entire parmptr block. The basic    *
 *    message is cc0500. The following shows the use of the parmptr inserts:*						  *
 ****************************************************************************/

/* Notes on F_SPECIAL errors: */
/* All use *cc0500 as the message base. */
/* All use cc0529 for %5 */
/* F_SPECIAL(RDSYS): %3 = cc0576, %6 = cc0542, & %7 = cc0561 */
/* F_SPECIAL(WTSYS): %3 = cc0576, %6 = cc0547, & %7 = cc0561 */
/* F_SPECIAL(FMSYS): %3 = cc0576, %6 = cc0536, & %7 = cc0561 */
/* F_SPECIAL(FMTRK): %3 = cc0572, %6 = cc0536, & %7 = cc0561 */
/* F_SPECIAL(MDCHK): %3 = cc0572, %6 = cc0549, & %7 = cc0559 */

/*	%0 = module name.
	%1 = device name.
	%2 = filename (if any).
	%3 = area name (if any), generally one of the cc057x series.
	%4 = may be used for extra help information.
	%5 = operation name, generally one of the cc051x/cc052x series.
	%6 = operation name, generally one of the cc053x/cc054x series.
	%7 = device/file/area string, generally of the cc055x series.
	%8 = level 3 help basic message, generally the cc0500[1] message.
	%9 = level 3 help message, generally one of the cc046x series.

	Example message for an S_WRITE that returns an E_SPACE error:

	%0 = "COPY"
	%1 = "a:"
	%2 = "testfile.txt"
	%3 = nullstr (not used).
	%4 = "\r\nYou can erase unneccessary files from your disk to
	      free up space." (cc0490).
	%5 = "WRITE" (cc0526).
	%6 = "WRITING" (cc0546).
	%7 = "%2 to %1" (cc0551).
	%8 = "\r\n%0: An error occurred %6 %7." (cc0500[1]).
	%9 = "\r\nThe disk %1 is full." (cc0461).

	HELPLVL 4:
	    COPY: An error occurred WRITING testfile.txt to a:.
	    The disk a: is full.
	    You can erase unneccessary files from your disk to free up space.

	HELPLVL 3:
	    COPY: An error occurred WRITING testfile.txt to a:.

	HELPLVL 2:
	    COPY: WRITE error.

	HELPLVL 1:
	    This level is reserved by the ERRMSG routine to provide
	    information such as RETURN CODE, ERROR SOURCE and FlexOS
	    FUNCTION. An example is shown below.

		Return code: -2145369344.
		Error source: DISKMAN.
		FlexOS function: F_WRITE.

*/
/* basic message format */
BYTE	*cc0500[] = {
	"\r\n%0: %5 error.",
	"\r\n%0: An error occurred %6 %7.",
	"%8%9"
};

/*******************************************
 * cc051x, 52x, 53x and 54x[] = operations * 
 * cc051x and 52x[] = %5 operations        *
 *******************************************/

BYTE	cc0510[] = "Allocate";		 /* F_MALLOC (special: %7 = cc0574)  */
BYTE	cc0511[] = "Cancel";	      /* F_ABORT (special: %1 = processname) */
BYTE	cc0512[] = "Close";					  /* F_CLOSE */
BYTE	cc0513[] = "Create";					 /* F_CREATE */
BYTE	cc0514[] = "Define";					 /* F_DEFINE */
BYTE	cc0515[] = "Delete";					 /* F_DELETE */
BYTE	cc0517[] = "Get";				/* F_GET or F_LOOKUP */
BYTE	cc0520[] = "Open";					   /* F_OPEN */
BYTE	cc0522[] = "Read";					   /* F_READ */
BYTE	cc0523[] = "Rename";					 /* F_RENAME */
BYTE	cc0524[] = "Search";					 /* F_LOOKUP */
BYTE	cc0525[] = "Set";					    /* F_SET */
BYTE	cc0526[] = "Verify";					   /* F_READ */
BYTE	cc0527[] = "Write";					  /* F_WRITE */
BYTE	cc0528[] = "Deallocate";				  /* F_MFREE */
BYTE	cc0529[] = "Special";					/* F_SPECIAL */

/*******************************************
 * cc051x, 52x, 53x and 54x[] = operations * 
 * cc053x and 54x[] = %6 operations        *
 *******************************************/
BYTE	cc0530[] = "allocating";	  /* F_MALLOC (special: %7 = cc0574) */
BYTE	cc0531[] = "canceling";	      /* F_ABORT (special: %1 = processname) */
BYTE	cc0532[] = "closing";					  /* F_CLOSE */
BYTE	cc0533[] = "creating";					 /* F_CREATE */
BYTE	cc0534[] = "defining";					 /* F_DEFINE */
BYTE	cc0535[] = "deleting";					 /* F_DELETE */
BYTE	cc0536[] = "formatting";		       /* F_SPECIAL (FMTTRK) */
BYTE	cc0537[] = "getting";				/* F_GET or F_LOOKUP */
BYTE	cc0540[] = "opening";					   /* F_OPEN */
BYTE	cc0542[] = "reading";					   /* F_READ */
BYTE	cc0543[] = "renaming";					 /* F_RENAME */
BYTE	cc0544[] = "searching";					 /* F_LOOKUP */
BYTE	cc0545[] = "setting";					    /* F_SET */
BYTE	cc0546[] = "verifying";					   /* F_READ */
BYTE	cc0547[] = "writing";					  /* F_WRITE */
BYTE	cc0548[] = "deallocating";	   /* F_MFREE (special: %7 = cc0574) */
BYTE	cc0549[] = "logging";				 /* F_SPECIAL(MDCHK) */

/***************************************************
 * cc055x & cc056x are %7 message modifier strings *
 ***************************************************/

BYTE	cc0550[] = "%1";				     /* device error */
BYTE	cc0551[] = "%2 on %1";			     /* file on device error */
BYTE	cc0552[] = "for %1";				     /* device error */
BYTE	cc0553[] = "for %2 on %1";		     /* file on device error */
BYTE	cc0554[] = "to %1";				     /* device error */
BYTE	cc0555[] = "to %2 on %1";		     /* file on device error */
BYTE	cc0556[] = "from %1";				     /* device error */
BYTE	cc0557[] = "from %2 on %1";		     /* file on device error */
BYTE	cc0559[] = "in the %3";				       /* area error */
BYTE	cc0560[] = "the %4 table";		       /* table access error */
BYTE	cc0561[] = "the %3";				  /* S_SPECIAL error */

/*******************************
 * cc057x/58x[] = areas (%3's) *
 *******************************/

BYTE	cc0570[] = "boot record";
BYTE	cc0571[] = "directory";
BYTE	cc0572[] = "disk";
BYTE	cc0573[] = "file allocation table";
BYTE	cc0574[] = "memory";
BYTE	cc0576[] = "sysarea";
BYTE	cc0578[] = "source";
BYTE	cc0579[] = "destination";
BYTE	cc0580[] = "format information";
BYTE	cc0581[] = "master boot partition record";

