/*===============================================================*
 *   Version 1.0	spltools.c				 *
 *	This file contains the spooler driver memory management	 *
 *	routines						 *
 *---------------------------------------------------------------*
 *    VERSION   DATE    BY      CHANGE/COMMENTS                  *
 *---------------------------------------------------------------*
 *	BETA							 *
 *	1.0	07/24/85 KSO -	Created				 *
 *	1.1	07/08/86 Lin    Modified for Metaware conversion *
 *	1.2	06/14/87 ldt	Added sysbuild.h		 *
 *===============================================================*
 *  INCLUDES:                                                    */
#include	"portab.h"
#include	"sysbuild.h"
#include	"pd.h"
#include	"spldrv.h"

EXTERN	BYTE	*salloc();
EXTERN	VOID	sfree();

	/* Shell heap management lists	*/
BYTE	**splroots[MAXROOTS];	/* Free list roots			*/
BYTE	*splpool;		/* Spool drvier memory pool		*/ 
WORD	splplen = MAXPOOL;	/* Memory currently available in pool	*/
WORD	splnpool;		/* Pointer to next available space	*/

 	/* global messages used */
BYTE ZERO	= '0';
BYTE DASH	= '-';
BYTE COLON	= ':';
BYTE SPACE 	= ' ';
BYTE BIGa	= 'A';

BYTE 	*namemsg[]= {		/* mail box(pipe file) names for everybody */
/*00*/	"local::pi:%spoolmx",
/*01*/	"local::pi:%sfe",
/*02*/	"local::pi:%spl",
/*03*/	"local::pi:%",
/*04*/	"spool",
/*05*/	"despool",
/*06*/	"system:spool.286",
/*07*/	"system:despool.286",
/*08*/	"system:%pld.spl",
/*09*/	"ABCDEFGH",
/*10*/	"&&&&&&&&",
/*11*/	"LOCAL::\0",		/* gurantee a trailing NULL for comparision */
	""
};

BYTE	*strmsg[] = {
/*00*/	"\r\n",
/*01*/	"*:",
/*02*/	"*",
/*03*/	" ",
/*04*/	"  ",
/*05*/	"prn:",
/*06*/	"bgprn:",
/*07*/	"name",
/*08*/	"pi:%spl",
/*09*/	"switchar",
/*10*/	"\r\014",			/* ASCII code for Form Feed 	*/
/*11*/  "\006",				/* ASCII code for Acknowledge	*/
/*12*/	"tempdir:",
/*13*/	"mx",
/*14*/	"null:",
/*15*/	"stdin",
/*16*/	"stdout",
/*17*/	"stderr",
/*18*/	"stdcmd",
/*19*/	".%",
/*20*/	"\377",
	""
};


WORD	splminit()
{
	if( (splpool = salloc((LONG) MAXPOOL)) == NULLPTR )
		return( -1 );	/* no memory available	*/
	return( 0 );
}

BYTE	*splalloc( len )
REG	WORD	len;
{
	REG	BYTE	*q;
	REG	WORD	*p;
	REG	WORD	i;
	REG	WORD	get;

	i = (len + 15) >> 4;
	len = i << 4;
	get = len + 2;		/* length + len			*/
	if( splroots[i] )	/* First try to get one from	*/
	{			/*     the unused list		*/
	    p = (WORD *)splroots[i];
	    splroots[i] = (BYTE **)(*splroots[i]);
	    --p;
	}
	else			/* Next try to allocate from	*/
	{			/*    the pool			*/
	    if( splplen < get ) return( NULLPTR );
	    splplen -= get;
	    p = (WORD *)(&splpool[splnpool]);
	    splnpool += get;
	}
	*p++ = len;	/* Store block length		*/
	for( q = (BYTE *)p; len; len--,q++ ) *q = NULL;
	return( (BYTE *) p );
}

VOID	splfree( p )
REG	WORD	*p;
{
	REG	WORD	len;

	len = (*(p-1)) >> 4;
	*((BYTE **) p) = (BYTE *)splroots[len];
	splroots[len] = (BYTE **)p;
}

VOID	splmuninit()
{
	sfree( splpool );
}
WORD	strlen( s )
BYTE	*s;
{
	WORD	i;

	for( i=0; *s; i++,s++ );
	return( i );
}

BYTE	*strcpy( d,s )
BYTE	*d;
BYTE	*s;
{
	BYTE	*p;

	for( p=d; (*p++ = *s++) != 0;  );
	return( d );
}

BYTE	*strncpy( d,s,l )
BYTE	*d;
BYTE	*s;
WORD	l;
{
	BYTE	*p;

	for( p=d; l; l-- ) 
		*p++ = *s++;
	return( d );
}

VOID	reverse( s )
BYTE	*s;
{
	WORD	i,j;
	BYTE	c;

	for( i=0,j=strlen(s)-1; i < j; i++,j-- )
	{
	    c = s[i];
	    s[i] = s[j];
	    s[j] = c;
	}
}

VOID	itoa( n,a )
WORD	n;
BYTE	*a;
{
	WORD	i,sign;

	sign = 1;
	if( n < 0L ) 
		n = -n;
	else 
		sign = 0;
	i = 0;
	do
	{
	    a[i++] = n % 10 + ZERO;
	}
	while( (n /= 10) > 0 );
	if( sign ) a[i++] = DASH;		/* That is, minus	*/
	a[i] = NULL;
	reverse(a);
}

