###########################################################################
#
#   CNFGUTL.MAK -
#
#       Pre-requisite to running this make file is run the batch file:
#
#             SETIPATH.BAT - define the following:
#
#		  utl: = where utility include files can be found.
#
#		  cmn: = where system include files can be found.
#
#		  hc:  = where Meta_Ware include files can be found.
#
#                 ipath = utl:;cmn:;hc:;
#
#############################################################################
##
##   Compact Model utility startup module and library dependencies...
##
STARTUP  = utstart.obj
CCRTL    = ccrtl.l86
CCUTLS   = ccutls.l86
UTOOLS   = utools.l86
CCMSGS   = ccmsgs.l86

##
##   Make it easy to include the Compact Model libraries by using
##   the following definition.
##
COMMON   = $STARTUP  $CCMSGS $CCRTL $CCUTLS $UTOOLS

##
##   Big Model utility startup module and library dependencies...
##
STARTUP1 = utstart1.obj
CNFGLIB  = cnfglib.l86
BIG      = c:\highc\big\hcbe.l86

##
##   Make it easy to include the Big Model libraries by using
##   the following definition.
##
BIGMODEL = $STARTUP1 $BIG $CNFGLIB

##
##   Check all the utilities everytime this make file
##   is executed.
##
exec :		utstart.obj utstart1.obj \
		wmex.286 format.286 sys.286 fdisk.286 loadflex.exe

##
## UTSTART - 	COMPACT model start up assembler module for WMEX.
##
utstart.obj :	utstart.a86
 rasm86 utstart $$pzsznc 286

##
## UTSTART1 - 	BIG model start up assembler module for FORMAT, SYS AND FDISK
##
utstart1.obj :	utstart1.a86
 rasm86 utstart1 $$pzsznc 286

##
## WMEX - Compact model utility.
##
wmex.286 :	wmex.inp wmex.obj wmutls.obj wmexmsg.obj \
		$COMMON
 link wmex[i]
 +-postlink wmex.286

wmex.obj:	wmex.c portab.h cmn:flags.h libproto.h \
		ccutls.h libproto.h wmex.h
 hc wmex -pro util.pro

wmutls.obj:	wmutls.c portab.h cmn:flags.h libproto.h \
		ccutls.h libproto.h wmex.h
 hc wmutls -pro util.pro

wmexmsg.obj:	wmexmsg.c portab.h wmex.h
 hc wmexmsg -pro util.pro


##
## FORMAT - Big model utility.
##
format.286 :	format.inp format.obj fmtlib.obj fmutls.obj \
		fmerhand.obj fmtmsgs.obj setfip.obj \
		trnfrsys.obj boot.obj hdboot.obj \
		$BIGMODEL
 link format[i]
 +-postlink format.286

format.obj:	format.c portab.h concur.h ccutls.h format.h libproto.h
 hc format -pro cnfgutl.pro

fmtlib.obj:	fmtlib.c portab.h concur.h format.h libproto.h
 hc fmtlib -pro cnfgutl.pro

fmutls.obj:	fmutls.c portab.h concur.h ccutls.h format.h libproto.h
 hc fmutls -pro cnfgutl.pro

fmerhand.obj:	fmerhand.c portab.h concur.h ccutls.h format.h libproto.h
 hc fmerhand -pro cnfgutl.pro

fmtmsgs.obj:	fmtmsgs.c portab.h
 hc fmtmsgs -pro cnfgutl.pro

##
## FDISK - Big model utility ( Uses the Meta-Ware startup and library ).
##
fdisk.286 :	fdisk.obj fdscreen.obj fdmsgs.obj \
		picode01.obj picode02.obj picode03.obj piglobal.obj \
		hdboot.obj boot.obj \
		$BIGMODEL
 link fdisk[i]
 +-postlink fdisk.286

fdisk.obj :	fdisk.c portab.h pistruct.h piglobal.h piprotos.h
 hc fdisk -pro cnfgutl.pro

fdscreen.obj :	fdscreen.c portab.h piglobal.h
 hc fdscreen -pro cnfgutl.pro

fdmsgs.obj :	fdmsgs.c portab.h
 hc fdmsgs -pro cnfgutl.pro

picode01.obj :	picode01.c hc:stdlib.h portab.h hc:string.h pistruct.h \
		piglobal.h piprotos.h
 hc picode01 -pro cnfgutl.pro

picode02.obj :	picode02.c hc:stdlib.h pistruct.h piglobal.h piprotos.h
 hc picode02 -pro cnfgutl.pro

picode03.obj :	picode03.c hc:stdio.h portab.h hc:string.h hc:stdlib.h \
		hc:time.h pistruct.h piprotos.h
 hc picode03 -pro cnfgutl.pro
		
piglobal.obj :	piglobal.c portab.h piglobal.h
 hc piglobal -pro cnfgutl.pro


##
## SYS - Big model utility.
##
sys.286 :	sys.inp sys.obj sysmsgs.obj boot.obj trnfrsys.obj \
		$BIGMODEL
 link sys[i]
 +-postlink sys.286

sys.obj:	sys.c portab.h concur.h ccutls.h libproto.h
 hc sys -pro cnfgutl.pro

sysmsgs.obj :	sysmsgs.c portab.h
 hc sysmsgs -pro cnfgutl.pro

##
## LOADFLEX.EXE
##
loadflex.exe :	loadflex.obj
 +-link86xb.exe  loadflex.exe = loadflex[noprefix]

loadflex.obj :	loadflex.a86
 +-rasm86	loadflex $$szlo286


##
## COMMON CNFG UTL MODULES
##
setfip.obj:	setfip.c portab.h concur.h libproto.h
 hc setfip -pro cnfgutl.pro

trnfrsys.obj :	trnfrsys.c portab.h concur.h ccutls.h libproto.h
 hc trnfrsys -pro cnfgutl.pro

boot.obj :	boot.a86
 rasm86 boot $$pzsznc 286

hdboot.obj :	hdboot.a86
 rasm86 hdboot $$pzsznc 286

