/*===============================================================
 *   Version 1.2	KONMSG.C
 *			Error Handling for Konfig
 *---------------------------------------------------------------
 *    VERSION	DATE      BY	CHANGE/COMMENTS
 *---------------------------------------------------------------
 *	1.0	04-03-85 ktb	creation
 *	1.01	10-04-85 jsr	added NEVER define
 *	1.2	04-16-86 DR-K	removed NEVER and CONFIRM and some
 *				bad vars, made portable.
 *===============================================================*/
#include	"portab.h"

EXTERN	BYTE cc0463[];

BYTE	pgmname[] = "CONFIG" ;	/* Program Name */

	/*
	**  ext -
	**	error xlate table
	**	used by xltec, indexed by the utility error code (slightly
	**	modified.  translates into the more generic utility error
	**	return code.
	*/

BYTE	*cmd_bdtable[] = 
{
	"50","75","110","134.5",		/*  0..1..2..3		*/
	"150","300","600","1200",		/*  4..5..6..7		*/
	"1800","2000","2400","3600",		/*  8..9..10..11	*/
	"4800","7200","9600","19200",		/*  12..13..14..15	*/
	(BYTE*)0L
} ;

/*
**  Error messages
*/

BYTE	*hlpmsg[] =
{
"%0: usage is\n\r\
\t%0 [dev:[ baud[ wordlen[ parity[ stopbits ] ] ] ] ]\n\r" ,

"%6\n\n\rwhere\n\r%2%3%4%5%9",

""				/*  no level 4 message		*/

} ;

BYTE	hldevmsg[] =
"\tdev\tis the name of the port controlling device to be modified,\n\r\
\t\tincluding the colon (:)\n\r" ;

BYTE	hlbdmsg[] =
"\tbaud\tis a valid baud rate indicator:\n\r\
\t\t50, 75, 110, 134.5, 150, 150, 300, 600,\n\r\
\t\t1200, 1800, 2000, 2400, 3600, 4800, 7200,\n\r\
\t\t9600, 19200\n\r\
\t\t(Note: Only the 1st two digits of baud are required\n\r";

BYTE	hlwlmsg[] = 
"\twordlen\tis a valid word length (bits per word) indicator:\n\r\
\t\t5, 6, 7, or 8\n\r" ;

BYTE	hlprmsg[] =
"\tparity\tis a valid indicator for the type of parity to use:\n\r\
\t\tEVEN (or E), ODD (or O), NONE (or N)\n\r" ;

BYTE	hlstmsg[] = 
"\tstopbits is a valid indicator of the number of stop bits to use:\n\r\
\t\t1, 1.5, or 2" ;

BYTE	*pemsg[] = 
{
"%0: Invalid %3 parameter was entered.\n\r",	/* %3 is pemxxx */
"%6",
""
} ;

BYTE	pembaud[]	=	"Baud Rate" ;
BYTE	pemword[]	=	"Word Length" ;
BYTE	pempar[]	=	"Parity" ;
BYTE	pemstop[]	=	"Stop Bit" ;

BYTE	*pe2many[] =
{
"%0: There are too many parameters on the command line.\n\r",
"%6",
""
} ;

BYTE	*iemssg[] =
{
	"%0: %3 has not been completely installed.\n\r",
						/* %3 is ie1msg or ie2msg  */
	"",					/* use iemssg[0]	   */

	"%6%8"
						/* %6 is iemssg[0]	   */
						/* %8 is trymsg		   */
} ;

BYTE	*nsdmsg[] =
{
	"%0: %3 is only partially installed.\n\r",
				/*  %3 is either ie1msg or ie2msg	*/
	"",			/*  use nsdmsg[0]			*/

	"%6%8",
				/*  %6 is nsdmsg[0]			*/
				/*  %8 is trymsg			*/
} ;

BYTE	ie1msg[] 	= 	"%1" ;		/* %1 is device name	 */
BYTE	ie2msg[]	=	"%2, a device which controls %1,";
						/* %2 is uninstalled dev */

BYTE	trymsg[] = "Try the command again.  If this message appears again, \
		then the\n\rDevice cannot be configured at this time.\n\r" ;

BYTE	*cflmsg[] =
{
	"%0: %3" ,		/*  %3 is one of cfl1msg or cfl2msg	*/
	"%0: %6%7",		/*  %6 is cflmsg. %7 is cc0465		*/
	""
} ;
BYTE	cfl1msg[] = "Device Conflict opening %1.\n\r" ;
BYTE	cfl2msg[] = "%1 Device is Locked.\n\r" ;
BYTE	*accmsg[] =
{
	"%0: Access Error %3 %1.\n\r",
		/*  %3 is "opening", %1 is open device name		*/
	"",

	"%6%8"
} ;
BYTE	*dnfmsg[] =
{
	"%0: Device Not Found\n\r",
	cc0463,
	""
} ;
BYTE	*typmsg[] =
{
	"%0: Bad Device Type",
	"%0: [%1] is not a Serial Device",
	"%7%3"
} ;
BYTE	*internmsg[] =
{
	"%0: Internal Error %9(hex)\n\r",
	"%3",
	""
} ;
BYTE	inter1msg[] =
	"\n\rInternal Error Code: %9(hex)\n\r" ;

BYTE	*curval1 = "Current Values for [";
BYTE	*curval2 = "] are:\n\n\r";
BYTE	*newval1 = "New Values for [";
BYTE	*newval2 = "] are:\n\n\r";
BYTE	*badbaud = " *Bad Baud Code* " ;
BYTE	*devmsg  = "\tDevice:\t\t";
BYTE	*brmsg   = "\tBaud Rate:\t";
BYTE	*wlmsg   = "\tWord Length:\t";
BYTE	*parmsg  = "\tParity\t\t";
BYTE	*stpmsg  = "\t# of Stop Bits:\t";


UBYTE	*SB[] = {"0" , "1" , "1 1/2" , "2" } ;
UBYTE	*Parity[] = { "None" , "Odd" , "None" , "Even" } ;

