/*#######################################################################
#									#
#				NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/

/*#######################################################################
#									#
#  Filename:  PIPROTOS.C						#
#									#
#   Purpose:  Contains all the prototypes used in the primitives library#
#	      as well as CHKDSK, FDISK, and FORMAT.			#
#									#
#  Maintenance Log:							#
#									#
#  Ver	Date	  Who  SPR/APR	Change/Comments				#
#  ---	--------  ---  -------	--------------------------------------	#
#  1.0	11/06/87  WeD	 N/A	Created.				#
#  1.1	11/09/87  YS	 N/A	Added FDISK screen prototypes		#
#  1.2	11/09/87  WeD	 N/A	Added system-call prototypes.		#
#  1.3	11/11/87  WeD	 N/A	Integrated more prototype changes.	#
#######################################################################*/


/*
    PICODE01:
*/

ULONG PCheckDiskArea(ULONG SectorOffset, ULONG Count, PDiskIDStruct *DiskID);
ULONG PConvertClusterToSector(UWORD ClusterIndex);
ULONG PDataStartingSector(void);
ULONG PDriveLock(PDiskIDStruct *DiskID, WORD LogicalLock, WORD ReadWrite);
UWORD PGetClusterSize(void);
ULONG PGetDefaultDrive(UBYTE *DiskName);
UWORD PGetFatSectors(void);
UWORD PGetSectorSize(void);
ULONG PGetRootDirEntries(void);
ULONG PReadLogicalSector(ULONG SectorOffset, UWORD Count, UBYTE *Buffr,
	PDiskIDStruct *DiskID);
ULONG PReadPhysicalSector(ULONG SectorOffset, UWORD Count, UBYTE *Buffr,
	PDiskIDStruct *DiskID);
ULONG PUnlockDrive(void);
ULONG PWriteLogicalSector(ULONG SectorOffset, UWORD Count, UBYTE *Buffr,
	PDiskIDStruct *DiskID);
ULONG PWritePhysicalSector(ULONG SectorOffset, UWORD Count, UBYTE *Buffr,
	PDiskIDStruct *DiskID);
ULONG ZeroLogicalSectors(LONG FirstSector, ULONG Count, PDiskIDStruct *DiskID);
ULONG PRootDirLogicalSector(void);
ULONG PCopySystem(BYTE *FileName, BYTE *DirName, WORD SysFileIndex,
	PDiskIDStruct *DiskIDPtr);
ULONG PCopyFat1ToFat2(PDiskIDStruct *DiskIDPtr);


/*
    PICODE02:
*/

ULONG PFatEntryOP(UWORD OperatID, UWORD ClusterIndex, UWORD Read,
	UWORD *Value, PDiskIDStruct *DiskID);
ULONG FatEntryOPInit(PDiskIDStruct *DiskID);
ULONG PInitFatCache(void);
ULONG GetBufCurrentEntry(UWORD ClusterIndex, PDiskIDStruct *DiskID);
void GetCacheCurrentEntry(UWORD ClusterIndex);
void WriteManip(UWORD *Value);
void ReadManip(UWORD *Value);
ULONG PFlushFatEntryData(UWORD FlushIndor, PDiskIDStruct *DiskID);
ULONG PFlushDirEntryData(PDiskIDStruct *DiskID);
ULONG PDataEntryOP(UWORD ClusterIndex, UWORD Read, UBYTE *Buffr,
	ULONG BytesCount, PDiskIDStruct *DiskID);
ULONG PDirEntryOP(UWORD Root, UWORD ClusterIndex, ULONG EntryIndex,
	UWORD Read, PDirEntryStruct *DirEntry, PDiskIDStruct *DiskID);
ULONG RootDirEntryOP(ULONG EntryIndex, UWORD Read, PDirEntryStruct *DirEntry,
	PDiskIDStruct *DiskID);
ULONG SubDirEntryOP(UWORD ClusterIndex, ULONG EntryIndex, UWORD Read,
	PDirEntryStruct *DirEntry, PDiskIDStruct *DiskID);
ULONG GetSectorOffset(UWORD ClusterIndex, ULONG EntryIndex, PDiskIDStruct *DiskID);
void ReadWriteOP(UWORD Read, PDirEntryStruct *DirEntry);
ULONG GetMask(void);
ULONG PConvertDiskAddr(DiskAddress *DiskAddr, UBYTE SectorsPerTrack,
	UBYTE NumberOfHeads);
void GetClusterSize(ULONG PartSizeInBytes, UWORD *FatBitNum,
	UWORD *ClusterSize);
UWORD PGetFatSize(ULONG PartSizeInBytes, UWORD ClusterSize, UWORD FatBitNum,
	PDiskIDStruct *DiskID);
ULONG PGetFatSizeInSectors(ULONG DataAreaSizeInSectors, UWORD FatBitNum,
	UWORD ClusterSize, UWORD SectorSize);
void PMakeOSBootRec(ULONG PartStartSect, ULONG PartEndSect,
	UWORD SectorOverRide, POSBootRec *OSBootRec, PDiskIDStruct *DiskID);


/*
    PICODE03:
*/

void PGoToXY(PLocation Where);
void PClearDisplay(void);
void PEraseDisplayToEnd(PLocation From);
void PEraseLineToEnd(PLocation From);
void PClearRectangle(void);
void PSaveCursorPosition(void);
void PRestoreCursorPosition(void);
ULONG PInitScreenMenu(void);
ULONG PUnInitScreenMenu(void);
ULONG PGetTimeDate(PTime *TimePtr, PDate *DatePtr);
int PGetString(char *StrPtr, int MaxCount, int Mode);
int PGetNum(int Min, int Max, int Default);
int PDisplay(PDisplayObject *ObjPtr, ...);
int PConfirm(PDisplayObject *ObjPtr, int Default);
int PGetSwitchChar(void);
ULONG PParseOptions(int argc, char **argv, PCommandLineOptions *argp);


/*
    CHKDSK:
*/

int DigestFAT(void);
int WalkDirectory(UWORD StartingCluster, UWORD NumDirEntries);
int DecendChain(UWORD FATIndex, int Mode);
int HandleLostChains(int Mode);
void Concatenate(char *DstPtr, char Infix, char *SrcPtr, WORD Count);
void Decatenate(char *StrPtr);
void DisplayError(char *String, ...);

/*
    FDISK:
*/

ULONG LevelOneOption(UWORD MenuDriven, PDiskIDStruct *DiskID,
	PCommandLineOptions *ParseTable);
ULONG CreatePartition(UWORD MenuDriven, PDiskIDStruct *DiskID, 
	PCommandLineOptions *ParseTable);
ULONG CreateAll32Meg(UWORD MenuDriven, PDiskIDStruct *DiskID);
ULONG FindDiskGaps(PDiskIDStruct *DiskID, GapEntry *CurrentGapEntry);
ULONG BuildGapEntry(MasterBootRec *MBR, GapEntry *CurrentGapEntry,
	DiskAddress FullDiskSize, LONG LastMBRAddr, UWORD CaseNum,
	PDiskIDStruct *DiskID);
void AssignAddr(DiskAddress *SourceAddr, DiskAddress *DestAddr,
	UWORD SourceType, PDiskIDStruct *DiskID);
ULONG CheckDisk(GapEntry *CurrentGapEntry, PDiskIDStruct *DiskID);
UWORD GetSectorCount(GapEntry *CurrentGapEntry, PDiskIDStruct *DiskID);
ULONG GetTrackCount(UWORD SectorCount, PDiskIDStruct *DiskID);
void  GetFatRootDirAreaSize(UWORD *OSBootRecSize, UWORD *FatSize,
	UWORD *RootDirSize, GapEntry *CurrentGapEntry, PDiskIDStruct *DiskID);
void  GetFatClusterSize(UWORD *FatSize, UWORD *ClusterSize, ULONG *PartSize,
	UWORD *FatBitNum, PDiskIDStruct *DiskID);
ULONG PartitionCreation(GapEntry *GapTable, PDiskIDStruct *DiskID);
void  LoadAddr(WellDoneDiskAddr *TargetAddr, DiskAddress *SourceAddr);
void  LoadAddrFromMBR(DiskAddress *TargetAddr, WellDoneDiskAddr *SourceAddr);
void  ModifyMBR(MasterBootRec *MBR, DiskAddress *PartStartAddr,
	DiskAddress *OSBootStartStartAddr, DiskAddress *PartEndAddr, 
	WORD BitIndex, ULONG Mode, PDiskIDStruct *DiskID);
ULONG MakeExtOSBootRec(MasterBootRec *MBR, MasterBootRec *ExtMBR,
	WellDoneDiskAddr *ExtMBRAddr, LONG MBRSectorOffset, LONG *ReturnAddr,
	PDiskIDStruct *DiskID);
ULONG CreateUserSizePart(UWORD MenuDriven, PDiskIDStruct *DiskID,
	PCommandLineOptions *ParseTable);
ULONG ConvertCylinderSizeToMeg(ULONG CylinderSize, PDiskIDStruct *DiskID);
ULONG CreateWholeDiskPart(PDiskIDStruct *DiskID);
ULONG DeletePartition(UWORD MenuDriven, PDiskIDStruct *DiskID,
	PCommandLineOptions *ParseTable);
void  ZeroMBR(UBYTE *MBRBuffer, UWORD BytesCount);
void  ZeroMBRSlot(MasterBootRec *MBR, WORD Index);
ULONG ConvertDiskAddrFromMBR(WellDoneDiskAddr *MBRAddr, PDiskIDStruct *DiskID);
ULONG ActivatePartition(UWORD MenuDriven, PCommandLineOptions *ParseTable, 
	PDiskIDStruct *DiskID);
ULONG DisplayPartition(PDiskIDStruct *DiskID);
WORD  MBRBitOwnerType(MasterBootRec *MBR);
WORD  MBRExtOwnerType(MasterBootRec *MBR);
WORD  MBRNonOwnerType(MasterBootRec *MBR);
void  ReverseConvertDiskAddr(ULONG SectorOffset, DiskAddress *DiskAddr, PDiskIDStruct *DiskID);
void  ReOrderMBR(int Array[], int *NumOfPart, MasterBootRec *MBR, PDiskIDStruct *DiskID);
void  ErrorHandler(ULONG ErroCode);
void  OnLineHelp(void);

/*
    FDisk Screen:
*/


ULONG FDiskScreen(UWORD ScreenNum, int InMsg[], UBYTE *DriveName,
	int OutMsg[], PDiskIDStruct *DiskID);
void  Screen1(UBYTE *DriveName);
void  Screen2(int InMsg[], UBYTE *DriveName);
void  Screen31(void);
void  Screen32(int InMsg[], UBYTE *DriveName, int OutMsg[]);
void  Screen40(UBYTE *DriveName);
ULONG Screen41(int InMsg[], PDiskIDStruct *DiskID);
void  Screen42(int InMsg[]);
void  Screen43(void);
ULONG Screen44(int InMsg[]);
ULONG Screen51(int InMsg[], UBYTE *DriveName, PDiskIDStruct *DiskID);
void  Screen52(int InMsg[]);
void  Screen53(void);
void  Screen54(void);
void  Screen55(void);
ULONG Screen61(int InMsg[], UBYTE *DriveName, PDiskIDStruct *DiskID);
void  Screen62(int InMsg[]);
void  Screen63(void);
void  Screen64(void); 
void  Screen65(void);
ULONG Screen7(UBYTE *DriveName, PDiskIDStruct *DiskID);

ULONG ViewDisplay(UWORD *Result, WORD Flag, PDiskIDStruct *DiskID);
void  InitialLine(void);
void  IncreaseLine(void);
UWORD CylinderAddrConvert(WellDoneDiskAddr *DiskAddr);


/*
    FORMAT:
*/

int DisplayScreen1(PDiskIDStruct *DiskID);
int DisplayScreen2(PDiskIDStruct *DiskID);
int DisplayScreen3(void);
int DisplayScreen4(PDiskIDStruct *DiskID);
ULONG LogicalFormat(UBYTE *BuffPtr, ULONG ByteCount, PDiskIDStruct *DiskID);
ULONG PhysicalFormat(UBYTE *BuffPtr, ULONG ByteCount, PDiskIDStruct *DiskID);
ULONG MarkBadCluster(ULONG BadTrack, UBYTE *BuffPtr, PDiskIDStruct *DiskID);
LONG GetCOption(void);
LONG GetPOption(void);
LONG GetVOption(PDiskIDStruct *DiskID);
ULONG StampFatID(PDiskIDStruct *DiskID);
void FmErrHand(LONG RtnCode);


/*
    System calls:
*/

LONG s_open( UWORD Flags, void *Name );
LONG s_close( UWORD Flags, ULONG Fnum );

LONG s_malloc( BYTE Option, void *MPBPtr );

LONG s_read( UWORD Flags, ULONG Fnum, void *Buff, ULONG BuffSize,
	ULONG Offset );
LONG s_write( UWORD Flags, ULONG Fnum, void *Buff, ULONG BuffSize,
	ULONG Offset );

LONG s_define( UWORD Flags, void *LogicalName, void *Prefix, ULONG PrefixSize );
LONG s_lookup( BYTE Table, UWORD Flags, void *Name, void *Buff,
	ULONG BuffSize, ULONG ItemSize, ULONG Key );
LONG s_get( BYTE Table, ULONG Id, void *Buff, ULONG BuffSize );
LONG s_set( BYTE Table, ULONG Id, void *Buff, ULONG BuffSize );

LONG s_special( BYTE Func, UWORD Flags, LONG Fnum, void *DataBuff,
	ULONG DBuffSize, ULONG Parm1, ULONG Parm2 );


/*#######################################################################
#									#
#				NOTICE:					#
#									#
#    The source code contained in this listing is a proprietary trade	#
#    secret of DIGITAL RESEARCH, INC., Pacific Grove, California and	#
#    is also subject to copyright protection as an unpublished work	#
#    pursuant to Section 104(a) of Title 17 of the United States Code.	#
#    Unauthorized copying, adaptation, distribution, use or display is	#
#    prohitibed by law and may be subject to civil and criminal		#
#    penalties.								#
#									#
#######################################################################*/
