#ifndef __portab_included
#define __portab_included
/****************************************************************************
*
*         FLEXOS UTILITY RUN TIME LIB HEADER FILE
*         --------------------------------------------
*       Copyright 1982 by Digital Research Inc.  All rights reserved.
*
*       This is an include file for assisting the user to write portable
*       programs for C.  All processor dependencies should be located here.
*
****************************************************************************/
/*
 *      Standard type definitions
 */
#ifndef PORTAB                                  /* Don't define if already */

#define PORTAB  1                               /* Portab is now done      */
#define CDOS4   1                               /* Operating System        */

typedef char BYTE;                              /* Signed byte             */
#ifdef  MC68000
typedef unsigned char UBYTE;          		/* Unsigned byte           */
#else                                           /* Other compilers complain*/
typedef char UBYTE;                             /* Unsigned byte           */
#endif
#define BOOLEAN short                           /* 2 valued (true/false)   */
#ifdef  MC68000
typedef short WORD;                             /* Signed word (16 bits)   */
#else
typedef int WORD;                               /* Signed word (16 bits)   */
#endif

typedef unsigned short UWORD;           /* unsigned word           */

typedef long LONG;                              /* signed long (32 bits)   */
typedef unsigned long ULONG;          /* Unsigned long           */
#define REG     register                        /* register variable       */
#define LOCAL   auto                            /* Local var on 68000      */
#define EXTERN  extern                          /* External variable       */
#define MLOCAL  static                          /* Local to module         */
#define GLOBAL  /**/                            /* Global variable         */
typedef void VOID;                              /* Void function return    */
#define DEFAULT int                             /* Default size            */
typedef float FLOAT;                            /* Floating Point          */
typedef double DOUBLE;                          /* Double precision        */

/****************************************************************************/
/*      Miscellaneous Definitions:                                          */
/****************************************************************************/
#define	VADDR	unsigned long
#define	LADDR	unsigned long
#define	PHADDR	unsigned long
#define	ADDR	unsigned long
#define	VALEN	unsigned long
#define	LALEN	unsigned long
#define	PALEN	unsigned long
#define	ALEN	unsigned long
#define BITNO	UWORD
#define NBITS	UWORD
#define	NPAGES	UWORD		/* Type for vars that hold counts of pages */

#define FAILURE (-1)                    /*      Function failure return val */
#define SUCCESS (0)                     /*      Function success return val */
#define YES     1                       /*      "TRUE"                      */
#define NO      0                       /*      "FALSE"                     */
#define FOREVER for(;;)                 /*      Infinite loop declaration   */

#ifndef NULL
#define NULL    0                       /*      Null character value        */
#endif

#define NULLPTR 0L      		/*      Null pointer value          */
#define EOF     (-1)                    /*      EOF Value                   */
#define TRUE    (1)                     /*      Function TRUE  value        */
#define FALSE   (0)                     /*      Function FALSE value        */


#endif
/****************************************************************************/

#endif

