/******************************************************************************
* CONFIG.C - OEM Configuration Module				Version 1.5.05
*******************************************************************************
* Copyright (c) 1985, Digital Research, Inc. All Rights Reserved. The Software
* Code contained in this listing is proprietary to Digital Research, Inc.,
* Monterey, California and is covered by U.S. and other copyright protection.
* Unauthorized copying, adaptation, distribution, use or display is prohibited
* and may be subject to civil and criminal penalties.  Disclosure to others is
* prohibited.  For the terms and conditions of software code use refer to the
* appropriate Digital Research License Agreement.
*******************************************************************************
* Version    Date   Who Description
* ======= ========= === =======================================================
* v1.5.05 88Feb17   AM	Converted real mode segment:offset of EGA and hard
*			disk tables in AT_code() to physical addresss, also
*			get EGA fonts from new loader-set locations.
* v1.5.04 01/21/88  ldt If command.286 cannot be found, display where FlexOS
*			expected to find it. Removed opportunity to attempt
*			to make partition 4 bootable.
* v1.5.03 01/19/87  ldt Changed dkyhd to dk_hd supporting hard disk driver
* 			changes. Moved RELDATE to sysbuild.h. Added copyright
*			signon, removed all references to NEWTEXT ( not used ).
* v1.5.02 12/30/87 AM	Moved sysaa() out of IAPX386 define.
* v1.5.01 12-17-87 AM	Put in AT-class subroutine AT_code() called from the
*			dispatcher to save EGA font and hard disk info.
* v1.5.00 13-Nov-87 glp	Added conditional code for support of debugging 286
*			style loadable drivers. Look for DRIVERSYMBOLS.
* v1.4.08 11/04/87 sgt	Install network requester & DLC driver if requested
* v1.4.07 09/08/87 AM	Eliminated use of last 128k of Compaq reserved RAM to
*			fix DMA read problem. NOTE: this is only a temporary
*			solution (hopefully).
* v1.4.06 08/24/87 ldt  Added support for the fourth partition.
* v1.4.05 08/04/87 AM	Added pre_page() which is called from disp386.a86
*			before paging is enabled.
* v1.4.04 07/15/87 ldt  removed extern _bzero
* v1.4.03 07/01/87 AM	Add memory bitmap entries for Compaq's extra 386 kb.
* v1.4.02 06/13/87 cpg	Added conditional erroe message in bootinit.
* v1.4.01 06/01/86 AM	Changed signon messages and did integration for IAPX386.
* v1.4.00 04/23/87 BVH	Conditionally (with NEWTEXT) add new text subdrivers.
* v1.3.02 01/29/87 KJ   added linked in MOUSE driver
* h386	  01/26/87 glp	Setup global virtual address variables
* h386	  01/22/87 glp	Created virtual address bitmap
* h386	  01/15/87 glp	Created physical memory bitmap
* v1.3.01 10/10/86 ldt  renamed file to config.c.
* v1.3.00 09/16/86 ldt  Changed 'Concurrent' references to 'FlexOS' 
* v1.2.03 06/12/86 RFW  GMAN is no longer a resource manager but a graphics
*			interface module called GIF.
*  1.2.02 06/09/86 mei	High C port.
* v1.2.01 06/02/86 tdm  Added network #ifs
* v1.2.00 04/16/86 FRH	If NEWTICK, places clock stuff in clock.c
*      20 01/07/86 bvh	added GMAN support
*      19 12/13/85 ldt	forced reldate/signon to even bufsize.
*      18 12/12/85 gat	Initial memory descriptors must come from mgetblk.
*      17 12/03/85 gat	Code cleanup. Complete PIC initialize.
*      16 11/18/85 gat	Added int_enable routine.  Enable 287 error interrupt
*			if 287 present.  Added dummy sethwclk routine.  Added
*                       int_enable routine. Removed tik_close.
******************************************************************************/

#include	"portab.h"
#include	"sysbuild.h"
#include	"system.h"
#include	"sup.h"
#include	"dh.h"
#include	"flags.h"
#include	"imc286.h"
#include	"struct.h"
#include	"baspag.h"
#include	"panic.h"
#include	"config.h"

/*
**	Define the Release Date and Version.
*/
#define	RELDATE	   "March 14, 1988.  "
#define RELVER	   "Version 1.42 \r\n"

#if IAPX386
#define SIGNON	"\033EDRI FlexOS 386 Compaq System\r\n"
#else
#define SIGNON	"\033EDRI FlexOS 286 PC/AT System\r\n"
#endif

#if (NETWORK == TRUE)
#define	NETON	"\n\rWith FlexNet V1.3A\n\r11/25/86\n\r"
#endif

#if METAWARE 
#define CONFIG
#include "protos.h"
#endif

#if NEWTICK
EXTERN	UWORD	rtcrd();
#endif

/************************
 * OS function calls	*
 ************************/
EXTERN	LONG	s_install();
EXTERN	LONG	s_open();
EXTERN	LONG	s_close();
EXTERN	LONG	s_define();
EXTERN	LONG	s_write();
EXTERN  LONG	s_read();
EXTERN  LONG	s_command();
EXTERN	LONG	install();
EXTERN	LONG	s_exit();

/******************
 * other OS calls *
 ******************/
EXTERN	LONG	codebase;
EXTERN	BYTE	*mgetblk();
EXTERN	VOID	nodisp(), okdisp(), outp();
EXTERN	WORD	_ssize(), hasnpx();
EXTERN	LONG	panic();
EXTERN	BYTE	inp();
EXTERN	VOID	sysaa();
#if IAPX386
EXTERN	VOID	pg_init();
EXTERN	VOID	va_init();
#endif
#ifdef	DRIVERSYMBOLS
EXTERN LONG salloc();
#endif

/******************
 * Driver Headers *
 ******************/
EXTERN	DH	c_dh;
EXTERN	DH	p_dh;
EXTERN	DH	null_dh;
EXTERN	DH	fd_dh;

#if HARD
EXTERN	DH	dk_dh;
#endif
/************************
 * forward declarations *
 ************************/
VOID 	bootinit(), pause(), message(), sysinit(), minit(), pic_init(), 
	int_enable(), gate_a20(), c8042(); 
WORD	cmosword();

#if IAPX386
MEMBITMAP	*fmembitmap();
GLOBAL	VOID	pre_page();
#endif

/************************
 *  Bootinit load info  *
 ************************/
#define	PINFO	struct	_pinfo
PINFO
{
	BYTE	pi_pname[10];	/* Process name				*/
	BYTE	pi_prior;	/* Process priority			*/
	BYTE	pi_fill;	/* Filler				*/
	LONG	pi_maxmem;	/* Max. mem. to give to the process	*/
	LONG	pi_reserve;	/* Reserved				*/
};

#define	BOOT_PRIOR    180	/* Default process priority		*/
#define	DFLT_MEM      0x20000L	/* Default process memory size		*/

/********************
 * Bootinit process *
 ********************/
BYTE	boottail[] = "-c boot:config.bat";
BYTE	bootcmd[] = "boot:command.286";

#define	TAILLEN	(LONG)sizeof(boottail)

/*****************************
 * Linked in network drivers.*
 *****************************/
#if (NETWORK == TRUE)
EXTERN LONG	netman();		/* Network resource manager 	*/
EXTERN DH	nm_dh;
#endif

#if (NETREQ == TRUE)
EXTERN	DH	nr_dh;			/* Requester driver		*/
#endif
#if (NETXPORT == TRUE)
EXTERN	DH	xp_dh;			/* Transport driver.		*/
#endif
#if (NETDLC == TRUE)
EXTERN	DH	dlc_DH;			/* DLC driver			*/
#endif
#if (NETNAMES == TRUE)
EXTERN	DH	ns_dh;			/* Name Server driver.		*/
#endif
#if (NETDEV == TRUE)
EXTERN	DH	nd_dh;			/* Net: Device driver.		*/
#endif
#if (NETSERV == TRUE)
EXTERN	DH	cs_dh;			/* Net Server driver.		*/
#endif

/****************************
 * Linked in printer driver *
 ****************************/
#if PRINTER
EXTERN	DH	prn_dh;
#endif

/****************************
 * Linked in mouse driver   *
 ****************************/
#if MOUSE
EXTERN	DH	mouse_dh;
#endif

/***********************
 * Driver access flags *
 ***********************/
#define ACC0	A_SET
#define	ACC	A_DEVLOCK+A_SHARE+A_READ+A_WRITE+A_SET
#define	ACC1	ACC+A_REMOVE
#define	ACC2	ACC1+A_PART


/***************************************
****************************************
** GLOBAL DEFINITIONS, INITIALIZATION **
****************************************
***************************************/

/****************
* kernel/memory *
****************/

GLOBAL LONG	defstk = DEFSTK;	/* size of process stack */
GLOBAL UWORD	maxldt = MAXLDT;	/* number LDT slots per process */
GLOBAL WORD	nmods;			/* number of resource modules */

/*****************************
 * primary memory descriptor *
 *****************************/

#if IAPX386

/*

	LINEAR/VIRTUAL address space

------------------------- <-- 0x100000000	v_pend
|			|
|			|
|			|
|      Page Tables	|
|-----------------------| <-- 0xffc00000	v_send, v_pstart
|			|
|      Saddr Space	|
|-----------------------| <-- 0xffxxx000	v_sstart, v_oend
|      FLEX386.SYS	|
|-----------------------| <-- 0xff800000	v_ostart, v_uend
|			|
|			|
	    .
	    .
	    .
|			|
|     User Space(TPA)	|
------------------------- <-- 0x00000000	


	FLEX386 needs 4 megabytes of virtual address space(VAS)
for accessing the current Page Directory and Page Tables.  The start of
this VAS is marked by 'v_pstart'.  There is no variable marking the
end of this VAS. 'v_pstart' MUST be on a 4 Megabyte boundary. 

	The variable 'v_ostart' marks the start of the VAS that
the load image(OS) will reside at.  FLEX386 startup code(_pstart in
disp386.a86) changes the orginal VAS of the load image (FLEX386.SYS)
to this new VAS.  It then calculates the size of the system and
stores this in 'v_osize' while storing the ending virtual address
in 'v_oend'.  Both 'v_oend' and 'v_osize' are on 4K boundarys, while
'v_ostart' MUST be on a 4 Megabyte boundary.

	_PSTART also initializes the variable 'v_sstart' to begin
immediately after the load image new VAS.  'v_sstart'
marks the start of the System Virtual Address Space(SVAS).  The
end of the SVAS is marked by 'v_send'.  All SALLOC virtual memory comes
from the SVAS.  All 'v_s' variables are on 4K boundarys.

	Finally, 'v_ustart' and 'v_uend' mark the start and end of
the User Virtual Address Space(UVAS).  All MALLOC virtual memory comes
from the UVAS.
Hx
IMPORTANT NOTES:
	All 'v_' variables that refer to the end of a VAS refer to
the byte AFTER the end.  The UVAS must be below the SVAS.
*/

/* Bitmap of free system virtual address space.  Bitmap is big enough
to describe all the virtual address space from the start of the OS to the
end of the virtual address space.   */

#define V_PEND		0x00000000L	/* 4M boundary */
#define V_PSTART	0xFFC00000L	/* 4M boundary */
#define	V_SEND		0xFFC00000L
#define V_SSTART	0xFF800000L	/* Minimum v_start */
#define V_OSTART	0xFF800000L	/* 4M boundary */
#define V_UEND		0xFF800000L
#define V_USTART	0x00000000L	/* DO NOT CHANGE */


GLOBAL	ULONG	v_pend =	V_PEND;
GLOBAL	ULONG	v_pstart =	V_PSTART;
GLOBAL	ULONG	v_send	 =	V_SEND;
GLOBAL	ULONG	v_sstart;		/* MINIT sets up	*/
GLOBAL	ULONG	v_oend;			/* MINIT sets up	*/
GLOBAL	ULONG	v_ostart =	V_OSTART;
GLOBAL	ULONG	v_ustart =	V_USTART;
GLOBAL	ULONG	v_uend	 =	V_UEND;

GLOBAL	ULONG	v_osize;		/* MINIT sets up	*/

	/* The following is for the SVAS Bit Map */

#define	SVAS		V_SEND - V_SSTART
#define SVAS_BM_SIZE	(SVAS >> 15) + 1

MLOCAL	BYTE	vir_bm[SVAS_BM_SIZE];

	/* The follow are filled in by _pstart in disp386.a86 */

GLOBAL	ULONG	p_syspd;	/* Physical address of SYStem Page Directory */
GLOBAL	ULONG	l_syspd;	/* Logical address of SYStem Page Directory  */


#else

GLOBAL MPB pmd = { (MD*) 0, (MD*) 0, (MD*) 0, 0x0100, (MD*) 0 } ;
/* free list has  md, allocated list, rover, */
/* max waste 256 bytes, thread root          */
#endif


/**********************
 * Debug aids	      *
 **********************/

#ifdef DRIVERSYMBOLS
GLOBAL	ULONG	*driver_symtab;		/* Address of buffer to store loadable
					drivers symbolic information.  This
					allows SASID to make sence of loadable
					drivers symbols.  		*/
#endif


/**********************
 * file system tuning *
 **********************/

GLOBAL LONG	dirfatsz = DIRFATSZ;
GLOBAL LONG	datasz = DATASZ;
GLOBAL UWORD	pathquota = PATHQUOTA;
GLOBAL UWORD	totalquota = TOTALQUOTA;
GLOBAL LONG	fsmemsize = FSMEMSIZE;

/*********************
 * file number table *
 *********************/
GLOBAL WORD	max_fnums = NUM_FNUMT;	/* Max file number table size */
EXTERN FNUMT	*fnumtab;		/* File number table entry    */


/*************
 * ASR Table *
 *************/
GLOBAL	ASR	asrtab[NUM_ASR];
GLOBAL	ASR	*asrfree;


/************************************
 * release date and signon messages *
 ************************************/
BYTE	reldate[30] = RELDATE;
BYTE	relver[30]  = RELVER;
BYTE	copyright[60] = COPYRIGHT;
BYTE	signon[40]  = SIGNON;
BYTE    *nocommand;

#if (NETWORK == TRUE)
BYTE	neton[40] = NETON;
#endif


/***************************************************
 * Resource Manager Entry Points and Modules Table *
 ***************************************************/
EXTERN	LONG	diskman();
EXTERN	LONG	kernman();
EXTERN	LONG	pipeman();
EXTERN	LONG	misman();
EXTERN	LONG	superman();
EXTERN	LONG	conman();
EXTERN	LONG	cmdentry();

/***********************
 * optional front ends *
 ***********************/
#ifdef DOSFE
EXTERN	LONG	dosman();
#endif

#ifdef GIF
EXTERN	LONG	gif();
#endif

/********************************************
 * Default resource manager for empty slots *
 ********************************************/
LONG noman(f,p)
    WORD f;
    LONG p;
{
	if (f <= I_PABORT)
	    return(E_SUCCESS);
	return(EM_SUP | E_IMPLEMENT);
}

/******************************
 * The resource manager table *
 ******************************/
typedef LONG (*PFL)();		/* Pointer to Function returning Long */
GLOBAL PFL modules[] = {
	kernman,		/* 0  - Kernel Module		*/
	pipeman,		/* 1  - Pipe Manager Module	*/
	diskman,		/* 2  - Disk Manager Module	*/
	conman,			/* 3  - Console Manager Module	*/
	cmdentry,		/* 4  - Command Module		*/
	noman,			/* 5  - Extra RM Slot		*/
	noman,			/* 6  - Network Manager Module	*/
	misman,			/* 7  - Misc. Manager Module	*/
	superman,		/* 8  - Supervisor Module	*/
#ifdef DOSFE
	dosman,			/* 9  - DOS Front End		*/
#else
	noman,
#endif
	noman,			/* 10 - CPM Front End		*/
#ifdef GIF
	gif			/* 11 - Graphics Interface 	*/
#else
	noman
#endif
};


/***************************************************************************
 * CONFIG - first process run by system at initialization, never completes *
 ***************************************************************************/
VOID CONFIG()
{
    REG	WORD i;
    REG	LONG ofn;


	/* initialize resource managers */

	for (i=0; i<nmods; i++)
	{
	    nodisp();
	    if ((*modules[i])(I_INIT,0L))
		panic(XX_INIT);			/* initialization failed */
	    okdisp();
	}

#ifdef DRIVERSYMBOLS
#define	DRSYMTABLEN	0x800		/* Size of buffer for symbol info */
	if (!codebase)
	{
		  /* We are a debugable system, form loadable driver symbol
		  buffer.  */
		driver_symtab = (ULONG *)salloc((ULONG)DRSYMTABLEN);
		if (driver_symtab)
		{
			
		     ULONG	*sasid = (ULONG *)0x0a000018;
		     		  /* a00:18 is the fixed location in SASID
				  to store the symtab pointer.		*/

			  /* clear the buffer */
			_bzero(driver_symtab,DRSYMTABLEN);
			  /* Initialize pointer to last byte */
			*driver_symtab = (ULONG)driver_symtab + DRSYMTABLEN - 1L;
			  /* Place ptr into SASID data area */
			sasid = (ULONG *)*sasid;	/* pts to symtab now */
			sasid = (ULONG *)((ULONG)sasid - 4L); /* DSYMTAB loc */
			*sasid = (ULONG)driver_symtab;
		}
	}
#endif

	/* install drivers */

		/* Null device driver    	*/

	install("null:",ACC,&null_dh);


		/* Floppy drivers         	*/

	install("fd0:",ACC,&fd_dh) ; 

		/* install port driver for mouse or serial Console */

	install("pt0:",ACC1,&p_dh) ;

		/* install mouse driver if required */
#if (MOUSE == 2) /* Linked in */
	if( install( "mouse:",ACC1,&mouse_dh ) == (EM_SUP | E_SUBDEV) )
	    s_install(3,0,"pt0:","mouse:");

		/* Console drivers with mouse  if reqiured	 */
	install( "con0:",ACC1,&c_dh );
	s_install(3,0,"mouse:","con0:");

#elif (MOUSE == 1) /* Loadable */

	install("con0:",ACC1,&c_dh);

#else  /* old way */
	/* Console drivers with serial driver if reqiured	 */
	if( install( "con0:",ACC1,&c_dh ) == (EM_SUP | E_SUBDEV) )
	    s_install(3,0,"pt0:","con0:");
#endif


		/* Hard disk driver		*/
#if	HARD
	install( "hd0:",ACC2,&dk_dh ) ;
#if	TWOHARD
	s_install( 2,ACC2,"hd1:","hd0:" ) ;
#if	THREEHARD
	s_install( 2,ACC2,"hd2:","hd0:" ) ;
#endif
#endif
#endif
		/* Printer driver		*/

#if	PRINTER
	install("prn:",ACC1,&prn_dh);
#endif

		/* Network Drivers.		*/

#if (NETWORK == TRUE)
	install("network:",ACC,&nm_dh);
#endif
#if (NETREQ == TRUE)
	install("netreq:",ACC,&nr_dh);
#endif
#if (NETXPORT == TRUE)
	install("xport:",ACC,&xp_dh);
#endif
#if (NETDLC == TRUE)
	install("dlc:",ACC,&dlc_DH);
	s_install(3,0,"dlc:","xport:");
#endif
#if (NETNAMES == TRUE)
	install("names:",ACC,&ns_dh);
#endif
#if (NETDEV == TRUE)
	install("net:",ACC,&nd_dh);
#endif
#if (NETSERV == TRUE)
	install("csrv:",ACC,&cs_dh);
#endif

		/* Set up REQUIRED defines	*/

	s_define( 0,"stdin","con",0L );
	s_define( 0,"stdout","con",0L );
	s_define( 0,"stderr","con",0L );
	s_define( 0,"stdcmd","con",0L );
	s_define( 0,"con","con:console",0L );
	s_define( 0,"con:","con0:",0L );

/*
**
**  Set up according to which partion WMEX.286 and COMMAND.286 are on
**  ( Should coincide with which partition, made ACTIVE by FDISK, to 
**    boot FlexOS from. )
**
*/

#if	HARD
#if	(DOSPART == 1)
	s_define( A_SYSTEM,"boot:","hd0:",0L );
	s_define( 0,"default:","hd0:",0L );
	nocommand = "FlexOS cannot find COMMAND.286 on HD0:/";
#endif
#if	(DOSPART == 2)
	s_define( A_SYSTEM,"boot:","hd1:",0L );
	s_define( 0,"default:","hd1:",0L );
	nocommand = "FlexOS cannot find COMMAND.286 on HD1:/";
#endif
#if	(DOSPART == 3)
	s_define( A_SYSTEM,"boot:","hd2:",0L );
	s_define( 0,"default:","hd2:",0L );
	nocommand = "FlexOS cannot find COMMAND.286 on HD2:/";
#endif
#else
	s_define( A_SYSTEM,"boot:","fd0:",0L );
	s_define( 0,"default:","fd0:",0L );
	nocommand = "FlexOS cannot find COMMAND.286 on FD0:/";
#endif
		/* Print startup banner		*/

	ofn = s_open( 0x0055,"stdout");
	s_write( 0,ofn,signon,(LONG)sizeof(signon),0L );
	s_write( 0,ofn,reldate,(LONG)sizeof(reldate),0L );
	s_write( 0,ofn,relver,(LONG)sizeof(relver),0L );
	s_write( 0,ofn,copyright,(LONG)sizeof(copyright),0L );
#if (NETWORK == TRUE)
	s_write( 0,ofn,neton,(LONG)sizeof(neton),0L );
#endif
	s_close(0,ofn);

		/* Start the bootinit process	*/

	bootinit();

		/* Terminate the config process	*/

	s_exit( 0L );
}

/* Load bootinit */
VOID bootinit()
{
	REG WORD	i;
	REG BYTE	*p;
	REG BYTE	*q;
	    PINFO	pi;

	pi.pi_prior = BOOT_PRIOR;
	pi.pi_maxmem = DFLT_MEM;
	pi.pi_reserve = 0L;
	p = "bootinit";
	for(q = pi.pi_pname,i = 0; (i < 10) && ((*q = *p) != NULLPTR); p++,q++);
	while (s_command(0, bootcmd, boottail, TAILLEN, &pi) < 0L)
	{
	    if( codebase )
	    {
		pause( nocommand );
	    }
	    else
		pause( 
		"Please insert Programmer's Toolkit disk #1 in the A: drive."
		     );
	}
}

/* pause - print a message, wait for user to strike key */

VOID pause(s)
BYTE *s;
{
	WORD c;			/* one word buffer for read */
	LONG ofn, ifn;

	ofn = s_open(0x0055, "stdout");
	ifn = s_open(0x0019, "stdin");
	message(ofn, "\r\n");
	message(ofn, s);
	message(ofn, "\r\nPress any key to continue...");
	s_read(0, ifn, &c,(LONG)sizeof(c), 0L);
	s_close(0, ofn);
	s_close(0, ifn);
}

/* message - print a message */

VOID message(f, s)
LONG	f;
BYTE	*s;
{
	s_write(0, f, s, (LONG)_ssize(s), 0L);
}

/* sysinit - initialize "cold" system.  Hardware dependent initialization
 * not handled by drivers should take place here */

VOID sysinit()
{
	WORD	i;
	LONG	ln;

		/* Initialize ASR List */

	asrfree = asrtab;
	for (i = 1; i < NUM_ASR; i++)
	    asrfree = asrfree->asr_link = asrfree + 1;
	asrfree->asr_link = 0;
	asrfree = asrtab;

		/* Zero the FNUM Table */

	ln = sizeof(FNUMT) * NUM_FNUMT;
	_bzero(fnumtab,ln);

	nmods = sizeof(modules)/sizeof(PFL);	/* # resource managers */

	pic_init();		/* clear any pending interrupts */
	gate_a20();		/* enable 24-bit linear addressing */
	minit();		/* initialize memory descriptors */
}

EXTERN LONG	codebase;
EXTERN LONG	codelen;
EXTERN LONG	database;
EXTERN LONG	datalen;

#define	FIRST_GDT	0x1000000

/************************************************************************
** AT_code() - special OEM subroutine called from the dispatcher at	*
**    system init in protected mode. Put any AT-class specific code	*
**    here. The purpose of the code here now is to move hardware	*
**    specific (EGA, hard disk, etc) data from real mode mailbox to	*
**    protected mode variables for drivers.				*
************************************************************************/

EXTERN	ULONG	font8x8, font8x14,
		hd_tab0, hd_tab1;

VOID	AT_code()		/* AT specific code (from dispx86)	*/
{
    MD	rom_info = { 0L, 0L, 0xffffL, FIRST_GDT };	/* short MD for rom */
    ULONG	*alias_ptr;

    sysaa(&rom_info, 0x92);	     /* Get addressability to ROM info	*/
    alias_ptr = (ULONG *)FIRST_GDT;  /* Set alias for easy access	*/

    /********************************************************************
    *  Get real mode address's from int vector mail boxes, and form	*
    *  physical address's in driver accesssable variables.		*
    ********************************************************************/

    font8x8 = 	(alias_ptr[0x42] & 0xffffL) |	/* EGA 8x8 font 	*/
		((alias_ptr[0x42] >> 12) & 0xf0000L);
					
    font8x14 = 	(alias_ptr[0x43] & 0xffffL) |	/* EGA 8x14 font 	*/
		((alias_ptr[0x43] >> 12) & 0xf0000L);
				    
    hd_tab0 =	(alias_ptr[0x41] & 0xffffL) |	/* Hard Disk table 0	*/
		((alias_ptr[0x41] >> 12) & 0xf0000L);
				    
    hd_tab1 =	(alias_ptr[0x46] & 0xffffL) |	/* Hard Disk table 1	*/
		((alias_ptr[0x46] >> 12) & 0xf0000L);
}

/* minit -  Size memory, fill in memory descriptors */

#if IAPX386

/*
**	OEM's should define other equates for their machines and set
**	machine_type to them if they have any machine specific code.
*/
#define	COMPAQ		1
#define	BIOS_TYPE	0xfffe8
#define	MEM_CTL		0x80c00000

MLOCAL	WORD	machine_type = 0;

/*************************************************************************
* pre_page() - special OEM subroutine executed before paging is enabled. *
*************************************************************************/

VOID	pre_page()
{
    WORD	*alias_ptr;
    MD	rom_bios = { 0L, BIOS_TYPE, 2L, FIRST_GDT };	/* short MD for rom */
    MD 	memctl   = { 0L, MEM_CTL, 1L, FIRST_GDT };	/* short for memory */

    sysaa(&rom_bios, 0x92);		/* Get addressability to ROM	*/
    alias_ptr = (WORD *)FIRST_GDT;	/* Set --> our GDT alias	*/
    if (*alias_ptr == 0x3330)		/* If Compaq's '03' 386 flag	*/
    {
	machine_type = COMPAQ;		/* Set compaq flag		*/
$	sysaa(&memctl, 0x92);		/* Set alias --> compaq mem ctl	*/
$	*(BYTE *)alias_ptr = 0xff;	/* Write enable and no relocate	*/
    }
}


VOID minit()
{
	ULONG		start;		/* Start of physical memory region */ 
	ULONG		end;		/* Size of physical memory region  */
	MEMBITMAP	*memhead;	/* First MEMBITMAP structure	   */
	MEMBITMAP	*mem;		/* Current MEMBITMAP structure	   */
	MEMBITMAP	*vir;		/* First VIRBITMAP structure	   */

	ULONG		bms;		/* Bit Map size	in bytes	*/
	ULONG		i;		/* Counter			*/
	BYTE		*p;
					/* Vars for Compaq memory map	*/

		/* get size of lower memory from CMOS (in bytes) */
	end = cmosword(0x15) * 1024L;
	if (codebase) {		/* booted system */
			/* find end of image */
		if (codebase > database)
			start = codebase + codelen;
		else
			start = database + datalen;
		v_osize = start + datalen + codelen;
	}
	else {			/* debug system */
			/* use memory from 1000x to load image */
		start = 0x1000L;
			/* We will say the OS resides from where it was loaded
			to the end of the lower memory of the machine	*/
		v_osize = end; /* - LOADADDR;*/
			/* The end of the physical TPA in the debug system
			is at the start of the OS load address		*/
		end = LOADADDR;
	}
	mem = memhead = fmembitmap((MEMBITMAP *)0,start,end); /* for Compaq */

	if (machine_type == COMPAQ)
	/*
	* NOTE:
	*	Eliminated use of last 128k of reserved Compaq RAM to fix
	*	DMA read problem. Awaiting a better fix so we can still
	*	make use of that memory.
	*/
$	    mem = fmembitmap(memhead,0xfa0000L,0x1000000L);
	    mem = fmembitmap(memhead,0xfa0000L,0xfe0000L);

		/* get size of upper memory */
	if (( end = cmosword(0x30) * 1024L) != NULLPTR) {
		fmembitmap(mem,0x100000L,end+0x100000L);
	}
	pg_init(memhead);	/* page init code of memory manager	*/

		/* Now form virtual address bitmap */

	vir = MGET(MEMBITMAP);
		/* Make OS size a page size size	*/
	v_osize = (v_osize + 4096L - 1L) & ~(4096L - 1L);
	vir->b_npages = (SVAS - v_osize)/4096L;
		/* First virtual address that this bitmap describes	*/
	v_sstart = V_OSTART + v_osize;	/* Global variable	*/
	vir->b_addr = v_sstart;
		/* Get bit map size	*/
	bms = (vir->b_npages + 8L - 1L)/8L;
		/* Get bitmap memory	*/
	vir->b_map = (UWORD *)vir_bm;	/* We have an array for the bitmap */
		/* Fill with 0's to indicate all virtual addresses are free */
	for (p=(BYTE *)vir->b_map , i=0 ; i < bms ; *(p++) = 0x00,i++);
	va_init(vir);

}

MEMBITMAP *fmembitmap(mem,start,end)

MEMBITMAP	*mem;		/* Current end of BM list		*/
ULONG		start;		/* Starting Physical address		*/
ULONG		end;		/* End Physical address			*/

{

ULONG		size;
ULONG		bms;		/* Bit Map size	in bytes		*/
ULONG		i;		/* Counter				*/
MEMBITMAP	*mem1,*ret;
BYTE		*p;

		/* Get MEMBITMAP structure */
	ret = mem1 = MGET(MEMBITMAP);
		/* Link it into current end of list */
	if (mem != NULLPTR) {
		mem->b_next = mem1;
	}
		/* put on 4k boundary	*/
	start = (start + 4096L - 1L) & ~(4096L - 1L);
	end = end & ~(4096L - 1L);
		/* Get number of bytes	*/ 
	size = end - start;
		/* Is a 320 byte bitmap big enough?	*/
		/* 320 as that is biggest block from mgetblk	*/
	if ( size > 320L*4096L*8L ) {
			/* NO, seperate region into parts and form
				bitmap for other region		*/ 
		size = 320L*4096L*8L;
		ret = fmembitmap(mem1,start+size,end);
	}
	mem1->b_npages = size/4096L;
	mem1->b_addr = start;
		/* Get bit map size	*/
	bms = (mem1->b_npages + 8L - 1L)/8L;
		/* Get bitmap memory	*/
	mem1->b_map = (UWORD *)mgetblk(bms);
	return(ret);
}
#else

VOID minit()
{
	LONG	b, l, u;
	MD	*m;		/* diagnostic */

	/* there is ALWAYS at least one memory descriptor */
	m = (MD*)mgetblk(sizeof(MD));
	m->m_flags = M_FREE;

	/* initialize primary memory descriptor to point to it */
	pmd.mp_mfl = m;				/* memory free list */
	pmd.mp_rover = m;			/* rover starts here */
	pmd.mp_thrdrt = m;			/* memory thread root */

	/* get size of lower memory from CMOS */
	l = cmosword(0x15) * 1024L;

	if (codebase) {			/* booted? */

		/* find end of image */
		if (codebase > database)
			b = codebase + codelen;
		else
			b = database + datalen;
		m->m_start = b;
		m->m_length = l - b;
	}
	else {           /* else use memory from 1000x to load image */

		m->m_start = 0x1000;
		m->m_length = LOADADDR - 0x1000;
	}

	/* get size of upper memory */
	if (( u = cmosword(0x30) * 1024L) != NULLPTR) {
		m = m->m_link = (MD*)mgetblk(sizeof(MD)); /* link in another */
		m->m_flags = M_FREE;
		m->m_start = 0x100000;	/* 1 Meg */
		m->m_length = u;
	}
}
#endif else IAPX386

/* cmosword - return a word (2 consecutive bytes) from CMOS */

WORD cmosword(n)
{
	return( rtcrd(n+1)*256 + rtcrd(n) );
}

/*****************************
******************************
** INTERRUPT INITIALIZATION **
******************************
*****************************/

#define		PIC_M0	0x20		/* MASTER PIC */
#define		PIC_M1	0x21
#define		ICW1_M	0x11		/* ICW1 for master */
#define		ICW2_M	0x68		/* start of master interrupt numbers */
#define		ICW3_M	0x04
#define		ICW4_M	0x01

#define		PIC_S0	0xa0		/* SLAVE PIC */
#define		PIC_S1	0xa1
#define		ICW1_S	0x11
#define		ICW2_S	0x70		/* slave interrupt numbers start here */
#define		ICW3_S	0x02
#define		ICW4_S	0x01

#define		NSEOI	0x20		/* Non-specific End-of-Interrupt */

/******************************************************************************
**************
** pic_init **		Initialize the PICs
**************
*************/

VOID pic_init() {

	/* Master */		/* Slave */
	outp(PIC_M0, ICW1_M);	outp(PIC_S0, ICW1_S);
	outp(PIC_M1, ICW2_M);	outp(PIC_S1, ICW2_S);
	outp(PIC_M1, ICW3_M);	outp(PIC_S1, ICW3_S);
	outp(PIC_M1, ICW4_M);	outp(PIC_S1, ICW4_S);
	outp(PIC_M1, 0xff);	outp(PIC_S1, 0xff);	/* mask ALL interrupts */

	if (hasnpx()) int_enable(13);		/* unmask NPX errors (irq13) */
}


/******************************************************************************
****************
** int_enable **	Enable particular interrupt on interrupt controller.
****************
***************/

VOID int_enable(irq_no)	/* Interrupt ReQuest Number on AT */
{
	if (irq_no < 8)					/* on the master */
		 outp(0x21, inp(0x21) & ~(1 << irq_no));
	else if (irq_no < 16) {				/* on the slave */
		int_enable(2);				/* enable master */
		outp(0xa1, inp(0xa1) & ~(1 << irq_no-8));	/* then slave */
	}
}

/******************************************************************************
**************
** gate_a20 **		Enable a20 address line.  Should be done before going
**************		to protected mode, but fortunately we start in lower
**************		memory. */

VOID gate_a20()		/* see page 5-155 in AT Tech Ref for insight */
{
	c8042();
	outp(0x64,0xd1);
	c8042();
	outp(0x60,0xdf);
	c8042();
}

VOID c8042()
{
	while (inp(0x64) & 2);
}

#if NEWTICK == 0	/* The following goes into CLOCK.C if NEWTICK */

/* Hardware-dependent tick routines */
 
/* Following is for the IBM AT real time clock */

EXTERN LONG tikcnt;
EXTERN WORD tickit(),sio_out();
EXTERN WORD tikflg;

EXTERN LONG curtime;
EXTERN LONG curdate;


tikcod()
{
	LONG n;
	tikcnt++;
	if (tikcnt % 4) n = 31L;
	else n = 32L;
	if (tikflg) doasr(&tickit,n,0L,150);	
	rtcrd(0x0c); /* clear int - read reg C */
	outp(PIC_M0, NSEOI); /* non-specific EOI */
	outp(PIC_S0, NSEOI);
	return(tikflg);
}

tik_open()
{
	UWORD	hour, minute, second, month, day, year, dayofweek;

	/* a trick to reference a long as structure elements */
	struct ts {WORD y; BYTE m,d;} *t = (struct ts*) &curdate;

/* set up tick vector (on timer 1) */
	setvec(&tikcod,0x70);
/* inhibit operation for a bit */
	rtcwrt(0x0b,0x80); /* inhibit operation */
/* read current time and date from RTC chip */
	hour = rtcrd_bcd(4);
	minute = rtcrd_bcd(2);
	second = rtcrd_bcd(0);
	month = rtcrd_bcd(8);
	day = rtcrd_bcd(7);
	year = rtcrd_bcd(9);
	dayofweek = rtcrd(6);
/* setup tick on MC146818 RTC cmos chip */
	rtcwrt(0x0a,0x2b); /* 32 Hz (0x2a is 64 Hz) */
	rtcwrt(0x0b,0x43); /* periodic int enable, 24-hour clock, dst feature */
/* enable tick on pic */
	int_enable(8);
/* set system date and time */
	curtime = (hour*3600L + minute*60L + second) * 1000L;
	t->y = year+1900;
	t->m = month;
	t->d = day;
}

rtcwrt(add,dat)
WORD add,dat;
{
	outp(0x70,add);
	outp(0x71,dat);
}

rtcrd(add)
WORD add;
{
	outp(0x70,add);
	return(inp(0x71));
}

rtcrd_bcd(add)		/* as above, with bcd to binary conversion */
WORD add;
{
	UWORD item;
	outp(0x70, add);
	item = inp(0x71);
	return ((item&0xf)+(item>>4)*10);
}


/******************************************************************************
**************
** sethwclk **		Set the hardware time of day clock
**************
*************/

sethwclk()
{
}
#endif		/* End of NEWTICK == 0 */
