/*******************************************************************************
 * icdrvwrt.c - C_WRITE function for console driver
 *******************************************************************************
 * Copyright (c) 1987 Digital Research Inc. All rights reserved. {proprietary} *
 * The Software Code contained in this listing is proprietary to Digital       *
 * Research Inc., Monterey, California, and is covered by U.S. and other       *
 * copyright protection. Unauthorized copying, adaption, distribution, use or  *
 * display is prohibited and may be subject to civil and criminal penalties.   *
 * Disclosure to others is prohibited. For the terms and conditions of software*
 * code use, refer to the appropriate Digital Research License Agreement.      *
 *		U.S. GOVERNMENT RESTRICTED RIGHTS			       *
 * This software product is provided with RESTRICTED RIGHTS.  Use, duplication *
 * or disclosure by the Government is subject to restrictions as set forth in  *
 * FAR 52.227-19 (c) (2) (June, 1987) when applicable or the applicable        *
 * provisions of the DOD FAR supplement 252.227-7013 subdivision (b) (3) (ii)  *
 * (May, 1981) or subdivision (c) (1) (ii) (May, 1987). Contractor/manufacturer*
 * is Digital Research Inc. / 70 Garden Court / BOX DRI / Monterey, CA 93940.  *
 *******************************************************************************
 * Revision History:
 * Date   Author SPR #	Comments
 * 880212 MA		Translate ESC-{r,s,t,u} to their equivalents on output *
 *			to Z-29 or equivalent terminals.		       *
 * 880108 DR-K		move check for curcol >= fncol higher in	       *
 *			delete_char.					       *
 * 880106 DR-K		removed curcol = fncol and do nothing if	       *
 *			no wraparound and at end of line.		       *
 * 870716 reb/DR-K	added early exit to the c_write if the  	       *
 *                      console is in IMGRAPHIC.                	       *
 * 870617 KJ		removed min() max() with _min() _max()		       *
 *			MetaWare intrinsics and removed _bmovt()	       *
 *			all defined in PORTAB.H	now 			       *
 ******************************************************************************/

/************************************************************************
 * File:		ICDRVWRT.C
 *
 * Description:		C_WRITE function for console driver
 *
 * Build Info:
 *
 * Overview:
 *
 ************************************************************************/

#include "portab.h"
#include "io.h"
#include "system.h" 
#include "icdrv.h"

#if METAWARE 
#define ICDRVWRT
#include "protos.h"
#endif

#define	ESC	0x001B

#if (COMPU == FALSE)
EXTERN	VOID	c2to2copy();
EXTERN	VOID	c2alter();
EXTERN	VOID	pos_cursor();
EXTERN	VOID	asrwait();
EXTERN	VOID	PCHScroll();
#endif

EXTERN	VCBLK	*pcb[];
EXTERN	BYTE	sd_units[] ;
EXTERN	DH	*sd_hdr[] ;
EXTERN	CTE	contab[];
EXTERN  BYTE    isgrph[] ;

EXTERN	DH	c_dh;		/* Our Driver Header */
EXTERN	LONG	c_rmflg[];
EXTERN	LONG	c_mxid[];

EXTERN	VOID	ch2fill();
EXTERN	VOID	cch2fill();
/** EXTERN	VOID	_bmovt(); defined in PORTAB.H */
EXTERN	LONG	s_return();	
EXTERN	VOID	b2to2copy();
EXTERN	VOID	b2alter();

EXTERN	VOID	off_pcursor();
EXTERN	VOID	on_pcursor();
EXTERN	VOID	beepbell();

	VOID	c_sdwrite();
	VOID	c_rewrite();			/* forward reference */
	VOID	eeol(), eeop(), ceeol(), ceeop();
	VOID	dirtyfig();

GLOBAL	CDWRITE	c_wpb[MAXcdUNIT] ;	/* array of pointers to pbs for CRM */
GLOBAL	BYTE	colorstack[256];	/* room for asrwait to save our stack */

LONG	c_write( pb )
	CDWRITE	*pb;
{
typedef	VOID	(*RPTR)();
	RPTR	copy,alter;
	VCBLK	*vcid;		/* flag and Virtual frame ptr */
	BYTE	unit;
	WORD	pframe,cpframe,sdop,*buff;
	WORD	ch16;
	WORD	bcnt,cnt,temp;
	FRAME	*fr;
	UWORD	currow,curcol,fncol,rsize ;
	WORD	dp,sp;
	BYTE	*d,ch8,att;
	LONG	e;			/* evnum from asrmx()		*/
	LONG	retc = E_SUCCESS;	/* default return code		*/
	DRECT	*dirt;			/* for returning the dirty area */

	unit = pb->cdw_unit ;

	dirt = (DRECT *) pb->cdw_dirty ;
	dirt->nrow = dirt->ncol = 0 ;		/*nothing yet*/
why_not:                                        /* turn off the optimizer */
	vcid = (VCBLK *)pb->cdw_vcid ;
	if(isgrph[vcid->v_imode])  return (E_SUCCESS) ; /* this line is a possible */
        /* fix for the write to graphic console problem */
	alter = (RPTR) b2alter;
	copy = (RPTR) b2to2copy ;
	pframe = sdop = cpframe = FALSE;
	if ( pb->cdw_flags & CW_PWflg )
	    {
		vcid = pcb[unit];
		sdop = pframe = TRUE;
#if (COMPU == FALSE)
			/* adjust alter and copy calls to do vme and pframe */
		if ( unit == BITMAP ) 
		  {
		    sdop = FALSE;
		    if ( contab[unit].CT_flags & COLOR )
			{
			alter = (RPTR) c2alter;
			copy = (RPTR) c2to2copy ;
			cpframe = TRUE;
			}
		  }
		else
#endif
		if( (pb != &c_wpb[unit]) && 
			((e = asrmx(c_mxid[unit]) ) != NULLPTR ) )
			{	/* if we are not re-entering via c_rewrite() */
				/* and if asrmx returned an evnum. then we need*/
				/* to wait for the sync block */
				/* else we already own the sync and can run */
					/* if we can't have the sync and    */
			if ( pb != &c_wpb[unit] )   /* this is a new call here*/	
						/*because the pb address is not */
						/*our save area address, so */
			      {			/* copy all info into safe area */
				_bmovt(pb,&c_wpb[unit],sizeof(CDWRITE) );
				pb = &c_wpb[unit];
			      }
					/* schedule to restart when we have mx region */
			nextasr(e,c_rewrite,e,pb,200);
				/* tell CRM that we'll do this write eventually */
			retc = flagevent(c_rmflg[unit], 0L);
			return (retc);
			}
	    }
	fr = (FRAME *) vcid ;
	fncol = fr->fr_ncol ;
	att = vcid->v_att;
	dirt = (DRECT *) pb->cdw_dirty ;
	dirt->nrow = dirt->ncol = 0 ;		/*nothing yet*/
	dirt->row = currow = pb->cdw_row ;
	dirt->col = curcol = pb->cdw_col ;

	buff = pb->cdw_buffer ;
	if( pb->cdw_flags & DPF_UADDR )
	   {
	    mapu(pb->cdw_pd);
	    buff = (WORD *) SADDR(buff) ;
	   }
	bcnt = pb->cdw_bufsiz >> 1 ;

	while ( bcnt-- )
	{
	    ch8 = ch16 = *buff++ ;

	    if ( (ch16 & 0xFF00) || (ch16 < 0x20) )
	    {		/* special character */

		switch ( (BYTE) (ch16 >>12) )
		{	/*special function char maybe*/

		case OC_ROWGOTO:
			if ((ch16 & 0x0FFF) < fr->fr_nrow)
			    currow = ch16 & 0xFFF ;
			if(sdop)
			  {
				c_sdwrite(unit,ESC);
				c_sdwrite(unit,0x0059);
				c_sdwrite(unit,currow+32);
				c_sdwrite(unit,curcol+32);
			  }
			continue;

		case OC_COLGOTO:
			 if ( (ch16 & 0x0FFF) < fncol )
				curcol = ch16 & 0xFFF ;
			if(sdop)
			  {
				c_sdwrite(unit,ESC);
				c_sdwrite(unit,0x0059);
				c_sdwrite(unit,currow+32);
				c_sdwrite(unit,curcol+32);
			  }
			continue;

		case OC_COLOR:
			switch ( ch16 & 0x0F00 )
			{
			case 0:		/* foreground color */
				{
				att &= ~0x0F;
				att |= ( ch8 & 0x0F );
				continue;
				}
			case 0x0100:	/* background color */
				{
				att &= ~0xF0;
				att |= (ch8 & 0x0F) << 4 ;
				}
			}
			continue;

		case OC_EDITFN:
			if(sdop)	/* send it to sub-driver */
			{
				/* ESC-{r,s,t,u} have to be translated
				 * to the proper Z-29 sequence.
				 */
				switch (ch16 & 0xff)
				{
				case 'r':	/* Enter Intensify Mode	*/
				case 'u':	/* Exit Intensify Mode	*/
					break;	/* not supported	*/

				case 's':	/* Enter Blink Mode	*/
					c_sdwrite(unit,ESC);
					c_sdwrite(unit,'s');
					c_sdwrite(unit,'2');
					break;
				case 't':	/* Exit Blink Mode	*/
					c_sdwrite(unit,ESC);
					c_sdwrite(unit,'s');
					c_sdwrite(unit,'0');
					break;
				default:
					c_sdwrite(unit,ESC);
					c_sdwrite(unit,ch16 & 0x00FF);
					break;
				}
			}
			switch(ch16 & 0xFF)
			{
			case OC_INDEXREV:   /*reverse lf needs more work*/
					/* fall through */
			case OC_UPCURSOR:
				if (--currow <0 ) currow = 0;
				continue;
			case OC_DOWNCURSOR:
				if (++currow == fr->fr_nrow) --currow;
				continue;
			case OC_RIGHTCURSOR:
				if (++curcol == fncol) --curcol;
				continue;
			case OC_LEFTCURSOR:
				if (--curcol <0 ) curcol = 0;
				continue;
			case OC_CLEAR:
				currow = curcol = 0;	/*fall thru*/
			case OC_EEOP:
				vcid->v_att = att;	/* put temp back */
				if(cpframe) ceeop(vcid,curcol,currow);
					else eeop(vcid,curcol,currow);
				if (pframe) continue;
				dirtyfig(dirt,curcol,currow);
				dirtyfig(dirt,fncol-1,fr->fr_nrow-1);
				continue;
			case OC_HOME:
				currow = curcol = 0;
				continue;
			case OC_EEL:
				curcol = 0;	/*fall thru*/
			case OC_EEOL:
				vcid->v_att = att;	/* put temp back */
				if(cpframe) ceeol(vcid,curcol,currow);
					else eeol(vcid,curcol,currow);
				if (pframe) continue;
				dirtyfig(dirt,curcol,currow);
				dirtyfig(dirt,fncol-1,currow);
				continue;
			case OC_DOCHINSERT:
				vcid->v_mode |= INSCHM;
				continue;
			case OC_NOCHINSERT:
				vcid->v_mode &= ~INSCHM;
				continue;
			case OC_SAVECURS:
				vcid->v_tempx = currow ;
				vcid->v_tempy = curcol ;
				continue;
			case OC_RESTORECURS:
				currow = vcid->v_tempx ;
				curcol = vcid->v_tempy ;
				continue;
			case OC_ENABLECURS:
				vcid->v_mode &= ~CURSOFFM;
				if(pb->cdw_flags & topVF) on_pcursor(unit);
				continue;
			case OC_DISABLECURS:
				vcid->v_mode |= CURSOFFM;
				if(pb->cdw_flags & topVF) off_pcursor(unit);
				continue;
			case OC_CHDELETE:	/*delete this char*/
					/* but not beyond screen */
				if (curcol >= fncol) continue;
					/* calculate position of cursor on VFRAME */
				d = (((((vcid->v_top + currow) % fr->fr_nrow) * fncol)
						+ curcol) *2) + fr->fr_pl[0];
				if (pframe)
					(*copy)(d+2,d,(fncol - curcol -1),0L );
				   else
				       {
					_bmovt(d+2,d,((fncol - curcol -1)<<1) );
					/* mark the rest of the line as dirty */
					dirtyfig(dirt,curcol,currow);
					dirtyfig(dirt,fncol-1,currow);
				       }
				*(d + ((fncol - curcol -1)<<1)) = 0x20;
				continue;
			case OC_INTENSIFY:
				att |= 0x08 ; continue;
			case OC_NOINTENSIFY:
				att &= ~0x08 ; continue;
			case OC_BLINK:
				att |= 0x80 ; continue;
			case OC_NOBLINK:
				att &= ~0x80 ; continue;
			case OC_REVERSE:
				if ( (vcid->v_mode & REVVIDM) ==0 )
				  {		/* enter reverse video */
				     temp = (att & 0x70) >> 4;
				     ch8  = (att & 0x07) << 4;
				     att = (att & 0x88) + temp + ch8 ;
				     vcid->v_mode |= REVVIDM;
				  }
				continue;
			case OC_NOREVERSE:
				if ( (vcid->v_mode & REVVIDM) != 0 )
				  {		/* exit reverse video */
				     temp = (att & 0x70) >> 4;
				     ch8  = (att & 0x07) << 4;
				     att = (att & 0x88) + temp + ch8 ;
				     vcid->v_mode &= ~REVVIDM;
				  }
				continue;
			case OC_WRAP:
				vcid->v_mode |= WRAPM  ; continue;
			case OC_NOWRAP:
				vcid->v_mode &= ~WRAPM ; continue;
			case OC_EBOP:	/* delete to beginning of display */
				vcid->v_att = att;	/* put temp back */
				for ( temp=0 ; temp<currow ; temp++)
					if(cpframe) ceeol(vcid,0,temp);
						else eeol(vcid,0,temp);
				if (!pframe) dirtyfig(dirt,fncol-1,0);
					/* fall thru */
			case OC_EBOL:	/* delete to beginning of line */
				temp=( ((vcid->v_top + currow) % fr->fr_nrow)
					* fncol) *2 ;
				(*alter)(fr->fr_pl[0]+temp,0,0x20,curcol,0L);
				(*alter)(fr->fr_pl[1]+temp,0,att,curcol,0L);
				if (!pframe) dirtyfig(dirt,0,currow);
				continue;
			case OC_LNINSERT:
					/* insert a blank line at cursor row */
				vcid->v_att = att;	/* put temp back */
				rsize = fncol *2;
				if (vcid->v_top != 0)
				  {
				   if((sp = vcid->v_top + currow) < fr->fr_nrow)
					{
						/* do it the hard way */
					dp = rsize;
					cnt = (vcid->v_top -1) * fncol;
					(*copy)(fr->fr_pl[0],fr->fr_pl[0]+dp,cnt,0L);
					(*copy)(fr->fr_pl[1],fr->fr_pl[1]+dp,cnt,0L);
					sp = (fr->fr_nrow -1) * rsize;
					cnt = fncol;
					(*copy)(fr->fr_pl[0]+sp,fr->fr_pl[0],cnt,0L);
					(*copy)(fr->fr_pl[1]+sp,fr->fr_pl[1],cnt,0L);
					sp = (currow + vcid->v_top) * rsize;
					dp = sp + rsize;
					cnt = (fr->fr_nrow - (vcid->v_top + currow +1)) * fncol;
					}
				     else {
					sp = sp % fr->fr_nrow ;
					cnt = ((vcid->v_top - sp) -1) * fncol;
					sp *= rsize;
					dp = sp + rsize;
					}
				  }
				else
				  {
				    sp = currow * rsize;
				    dp = sp + rsize;
				    cnt = ((fr->fr_nrow -1) - currow) * fncol;
				  }
				(*copy)(fr->fr_pl[0]+sp,fr->fr_pl[0]+dp,cnt,0L);
				if ( cpframe )	/* this is color monitor allow asr-resched*/
					asrwait(0L,colorstack);  
				(*copy)(fr->fr_pl[1]+sp,fr->fr_pl[1]+dp,cnt,0L);
				if(cpframe) ceeol(vcid,0,currow);
					else eeol(vcid,0,currow);
				curcol = 0;
				if (pframe)
				  {
				    if(sdop)
				       {
					c_sdwrite(unit,ESC);
					c_sdwrite(unit,0x006F);
				       }
				    continue;
				  }
				dirtyfig(dirt,0,currow);
				dirtyfig(dirt,fncol-1,fr->fr_nrow-1);
				continue;
			case OC_LNDELETE:   /* delete the line at cursor row */
				vcid->v_att = att;	/* put temp back */
				rsize = fncol *2;
				if (vcid->v_top != 0)
				  {
				    if((dp = vcid->v_top + currow) < fr->fr_nrow)
				      {
						/* do it the hard way */
					cnt = (fr->fr_nrow - (dp+1)) * fncol;
					dp *= rsize;
					sp = dp + rsize;
					if (cnt != fncol)
					{	/* silly last line copy */
					(*copy)(fr->fr_pl[0]+sp,fr->fr_pl[0]+dp,cnt,0L);
					(*copy)(fr->fr_pl[1]+sp,fr->fr_pl[1]+dp,cnt,0L);
					}
					dp = (fr->fr_nrow -1) * rsize;
					cnt = fncol;
					(*copy)(fr->fr_pl[0],fr->fr_pl[0]+dp,cnt,0L);
					(*copy)(fr->fr_pl[1],fr->fr_pl[1]+dp,cnt,0L);
					dp = 0;
					sp = rsize;
					cnt = (vcid->v_top -1) * fncol;
				      }
				  else {
					dp  = dp % fr->fr_nrow ;
					cnt = ((vcid->v_top -1) -dp) * fncol;
					dp *= rsize;
					sp  = dp + rsize;
				       }
				  }
				else
				  {
				     dp = currow * rsize;
				     sp = dp + rsize;
				     cnt = ((fr->fr_nrow - currow) -1) * fncol;
				  }
				(*copy)(fr->fr_pl[0]+sp,fr->fr_pl[0]+dp,cnt,0L);
				if ( cpframe )	/* this is color monitor allow asr-resched*/
					asrwait(0L,colorstack);  
				(*copy)(fr->fr_pl[1]+sp,fr->fr_pl[1]+dp,cnt,0L);
				if(cpframe) ceeol(vcid,0,fr->fr_nrow-1);
					else eeol(vcid,0,fr->fr_nrow-1);
				curcol = 0;
				if (pframe) continue;
				dirtyfig(dirt,0,currow);
				dirtyfig(dirt,fncol-1,fr->fr_nrow-1);
				continue;
			}
			break;
		case 0:		/* ASCII character */
			switch (ch16)
			{
			case 0:	  /* nulls filter to spaces */
				ch16 = ch8 = 0x0020;
				break;
			case 7:		/*bell*/
				beepbell(unit);
				continue;
			case 8:		/*bs*/
				if (curcol) curcol--;
				if(sdop) c_sdwrite(unit,8);
				continue;
			case 9:		/*tab*/
				do
				{  curcol++ ;
				} while(curcol & 7);
				if(sdop) c_sdwrite(unit,9);
				continue;
			case 13:	/*cr*/
				curcol = 0;
				if(sdop) c_sdwrite(unit,13);
				continue;

			case 10:	/*lf*/
				if(sdop) c_sdwrite(unit,10);
				if (++currow >= fr->fr_nrow) 
				{
					/* scroll the whole vc frame */
			   	    currow = fr->fr_nrow -1;
				    if ( vcid->v_mode & PCFRAME )
				    {	/* leave v_top=0 */

					temp = (currow * fncol );
					(*copy)(fr->fr_pl[1] + (fncol << 1)
						       ,fr->fr_pl[1], temp,0L);
					(*copy)(fr->fr_pl[0] + (fncol << 1)
						       ,fr->fr_pl[0], temp,0L);
					temp = temp << 1 ;
				    }
				    else
				    {	/* optimize by moving v_top */

					if ( pframe && !sdop )
						/* this is Physical BitMap */
						/* so do hardware scroll   */
					    {
					    PCHScroll(vcid);
				            temp = (currow * fncol *2);
					    }
					else 
					    {
				            temp = (vcid->v_top * fncol *2);
				            vcid->v_top =
						(vcid->v_top+1) % fr->fr_nrow;
					    }
				    }
					  /* blank the last line */
				    (*alter)((fr->fr_pl[0] + temp),0x00,0x20,fncol,0L);
				    (*alter)((fr->fr_pl[1] + temp),0x00,att,fncol,0L);

				    if (pframe) continue;
				    dirt->row = dirt->col = 0 ;
				    dirt->nrow = fr->fr_nrow ;
				    dirt->ncol = fncol ;
				}
				else
				{
				  if (!pframe)	/* Mark line dirty if dirty chars */
				    if ( dirt->ncol == 0 ) dirt->row++ ;
				     else dirt->nrow++ ;
				}
				continue;

			case 27:	/* ESC */
				if(sdop) c_sdwrite(unit,ESC);
				vcid->v_escflg = 1;
				continue;
			default:
				break;
	   		} /* end of case control: */
		} /* end of switch(special character) */
	    } /* End of if(special or control character) */


	    if (curcol >= fncol) 	/* if we're now beyond the limits of */
		{			/* this screen, then wraparound to   */
		if (vcid->v_mode & WRAPM) /* next line if mode is set. Else  */
			   {		/* leave doing nothing.		     */
			     curcol = 0;
			     if( ++currow == fr->fr_nrow )
				{
					/* scroll the whole vc frame */
			   	    currow--;
				    if ( vcid->v_mode & PCFRAME )
				    {	/* leave v_top=0 */

					temp = (currow * fncol );
					(*copy)(fr->fr_pl[0] + (fncol << 1)
							,fr->fr_pl[0], temp,0L);
					temp = temp << 1 ;
				    }
				    else
				    {	/* optimize by moving v_top */

					if ( pframe && !sdop )
						/* this is Physical BitMap */
						/* so do hardware scroll   */
					    {
					    PCHScroll(vcid);
				            temp = (currow * fncol *2);
					    }
					else 
					    {
				            temp = (vcid->v_top * fncol *2);
				            vcid->v_top =
						(vcid->v_top+1) % fr->fr_nrow;
					    }
				    }
					  /* blank the last line */
				    (*alter)((fr->fr_pl[0] + temp),0x00,0x20,fncol,0L);
				    (*alter)((fr->fr_pl[1] + temp),0x00,att,fncol,0L);

				    if (!pframe) {
					dirt->row = dirt->col = 0 ;
					dirt->nrow = fr->fr_nrow ;
					dirt->ncol = fncol ;
					}
				}
			   }
			else
			   continue;	/* no need to output this char */
		}

			/* update vc */

			/* Calculate position of cursor on VFRAME */

	    d = (((((vcid->v_top + currow) % fr->fr_nrow) * fncol)
			+ curcol) *2) + fr->fr_pl[0];
	    if (vcid->v_mode & INSCHM)	/* are we in insert char mode */
	    {
	      if (pframe) (*copy)(d,d+2,(fncol - curcol -1),0L );
		else
		{
		_bmovt(d,d+2,((fncol - curcol -1)<<1) );
		*d = 0x20;
			/* mark the rest of the line as dirty */
		dirtyfig(dirt,curcol,currow);
		dirtyfig(dirt,fncol-1,currow);
		}
	    }

		/* put the character and the attribute in next byte*/
	    if (pframe)
		  {
		  if(sdop) c_sdwrite(unit,ch16);
		  (*alter)(d,0x00,ch8,1,0L );
		  (*alter)(d+1,0x00,att,1,0L );
		  }
		else
		  {
		  *d++ = ch8;
		  *d = att;
		  dirtyfig(dirt,curcol,currow) ;
		  }
	    curcol++;

	} /* end for bufsiz loop*/

		/* release the sync block */
	if (sdop) mxrel(c_mxid[unit]);

	/* pass back the updated current cursor postions */
	dirt->currow = currow ;
	dirt->curcol = curcol ;
	vcid->v_att = att;

#if (COMPU == FALSE)
	if ( (pframe) && (!(sdop)) && ((vcid->v_mode & CURSOFFM) ==0) )
		pos_cursor(currow + vcid->v_ptop, curcol, fncol);
#endif
	if ( pb->cdw_flags & DPF_UADDR )  unmapu();
	return(E_SUCCESS);

} /*end of c_write*/

	/* Erase to End of Line */

VOID eeol(vcid,curcol,currow)
	VCBLK	*vcid ;
	UWORD	curcol,currow ;
{
	FRAME	*f ;
	WORD	temp,cnt;

	f = (FRAME *) vcid ;
	temp =((((vcid->v_top + currow) % f->fr_nrow) * f->fr_ncol)+ curcol)*2;
	cnt = f->fr_ncol - curcol ;
	ch2fill((f->fr_pl[0] + temp),cnt,0x20);
	ch2fill((f->fr_pl[1] + temp),cnt,vcid->v_att );
}

	/* Erase to End of Page */

VOID eeop(vcid,curcol,currow)
	VCBLK	*vcid ;
	UWORD	curcol,currow ;
{
	FRAME	*f ;
	UWORD	r ;

	f = (FRAME *) vcid ;
	eeol(vcid,curcol,r=currow);
	while ( f->fr_nrow != ++r )
		eeol(vcid,0,r);
}

	/* Erase to End of Line on the IBM color board */

VOID ceeol(vcid,curcol,currow)
	VCBLK	*vcid ;
	UWORD	curcol,currow ;
{
	FRAME	*f ;
	WORD	temp,cnt;

	f = (FRAME *) vcid ;
	temp =((((vcid->v_top + currow) % f->fr_nrow) * f->fr_ncol)+ curcol)*2;
	cnt = f->fr_ncol - curcol ;
	cch2fill((f->fr_pl[0] + temp),cnt,0x20);
	cch2fill((f->fr_pl[1] + temp),cnt,vcid->v_att );
}

	/* Erase to End of Page */

VOID ceeop(vcid,curcol,currow)
	VCBLK	*vcid ;
	UWORD	curcol,currow ;
{
	FRAME	*f ;
	UWORD	r ;

	f = (FRAME *) vcid ;
	ceeol(vcid,curcol,r=currow);
	while ( f->fr_nrow != ++r )
		ceeol(vcid,0,r);
}


VOID dirtyfig(r,curcol,currow)
	DRECT	*r;
	UWORD	curcol,currow ;
{
	UWORD	maxcol,maxrow ;

	maxcol = _max( r->col + r->ncol , curcol +1);
	r->col = _min( curcol,r->col );
	r->ncol = maxcol - r->col ;
	maxrow = _max( r->row + r->nrow , currow +1);
	r->row = _min( currow,r->row );
	r->nrow = maxrow - r->row ;
}

VOID c_sdwrite(unit,ch)
	WORD	unit;
	BYTE	ch;
{
      (*sd_hdr[unit]->dh_write)(sd_units[unit],ch);
}

VOID  c_rewrite(e,pb)
	LONG	e;
	CDWRITE	*pb;
{			/* cleans up events and restarts c_write() */
	s_return( e );
	c_write( pb );
		/* c_write will return to here, we flagset the CRM */
	flagset( c_rmflg[(pb->cdw_unit)], *(c_dh.dh_curpd), 0L);
}
